/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    public static final String COLUMN = "column";
    public static final String DEFAULT_COLUMN_NAME = "next_hi";
    public static final String TABLE = "table";
    public static final String DEFAULT_TABLE_NAME = "hibernate_unique_key";
    private static final Logger log = LoggerFactory.getLogger(TableGenerator.class);
    private Type identifierType;
    private String tableName;
    private String columnName;
    private String query;
    private String update;

    public void configure(Type type, Properties properties, Dialect dialect) {
        this.identifierType = type;
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        this.tableName = PropertiesHelper.getString(TABLE, properties, DEFAULT_TABLE_NAME);
        if (this.tableName.indexOf(46) < 0) {
            String string = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema"));
            String string2 = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog"));
            this.tableName = Table.qualify(dialect.quote(string2), dialect.quote(string), dialect.quote(this.tableName));
        }
        this.columnName = dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(PropertiesHelper.getString(COLUMN, properties, DEFAULT_COLUMN_NAME)));
        this.query = "select " + this.columnName + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, this.tableName) + dialect.getForUpdateString();
        this.update = "update " + this.tableName + " set " + this.columnName + " = ? where " + this.columnName + " = ?";
    }

    public synchronized Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return this.generateHolder(sessionImplementor).makeValue();
    }

    protected IntegralDataTypeHolder generateHolder(SessionImplementor sessionImplementor) {
        return (IntegralDataTypeHolder)this.doWorkInNewTransaction(sessionImplementor);
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.columnName + " " + dialect.getTypeName(4) + " )", "insert into " + this.tableName + " values ( 0 )"};
    }

    public String[] sqlDropStrings(Dialect dialect) {
        StringBuffer stringBuffer = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return new String[]{stringBuffer.toString()};
    }

    public Object generatorKey() {
        return this.tableName;
    }

    public Serializable doWorkInCurrentTransaction(Connection connection, String string) throws SQLException {
        int n;
        IntegralDataTypeHolder integralDataTypeHolder = this.buildHolder();
        do {
            AutoCloseable autoCloseable;
            string = this.query;
            SQL_STATEMENT_LOGGER.logStatement(string, FormatStyle.BASIC);
            PreparedStatement preparedStatement = connection.prepareStatement(this.query);
            try {
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) {
                    String string2 = "could not read a hi value - you need to populate the table: " + this.tableName;
                    log.error(string2);
                    throw new IdentifierGenerationException(string2);
                }
                integralDataTypeHolder.initialize((ResultSet)autoCloseable, 1L);
                autoCloseable.close();
            }
            catch (SQLException sQLException) {
                log.error("could not read a hi value", sQLException);
                throw sQLException;
            }
            finally {
                preparedStatement.close();
            }
            string = this.update;
            SQL_STATEMENT_LOGGER.logStatement(string, FormatStyle.BASIC);
            autoCloseable = connection.prepareStatement(this.update);
            try {
                integralDataTypeHolder.copy().increment().bind((PreparedStatement)autoCloseable, 1);
                integralDataTypeHolder.bind((PreparedStatement)autoCloseable, 2);
                n = autoCloseable.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error("could not update hi value in: " + this.tableName, sQLException);
                throw sQLException;
            }
            finally {
                autoCloseable.close();
            }
        } while (n == 0);
        return integralDataTypeHolder;
    }

    protected IntegralDataTypeHolder buildHolder() {
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
    }
}

