/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.AbstractUUIDGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UUIDHexGenerator
extends AbstractUUIDGenerator
implements Configurable {
    private static final Logger log = LoggerFactory.getLogger(UUIDHexGenerator.class);
    private static boolean warned = false;
    private String sep = "";

    public UUIDHexGenerator() {
        if (!warned) {
            warned = true;
            log.warn("Using {} which does not generate IETF RFC 4122 compliant UUID values; consider using {} instead", (Object)this.getClass().getName(), (Object)UUIDGenerator.class.getName());
        }
    }

    public void configure(Type type, Properties properties, Dialect dialect) {
        this.sep = PropertiesHelper.getString("separator", properties, "");
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) {
        return new StringBuffer(36).append(this.format(this.getIP())).append(this.sep).append(this.format(this.getJVM())).append(this.sep).append(this.format(this.getHiTime())).append(this.sep).append(this.format(this.getLoTime())).append(this.sep).append(this.format(this.getCount())).toString();
    }

    protected String format(int n) {
        String string = Integer.toHexString(n);
        StringBuffer stringBuffer = new StringBuffer("00000000");
        stringBuffer.replace(8 - string.length(), 8, string);
        return stringBuffer.toString();
    }

    protected String format(short s) {
        String string = Integer.toHexString(s);
        StringBuffer stringBuffer = new StringBuffer("0000");
        stringBuffer.replace(4 - string.length(), 4, string);
        return stringBuffer.toString();
    }
}

