/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.HibernateException;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerFactory {
    private static final Logger log = LoggerFactory.getLogger(OptimizerFactory.class);
    public static final String NONE = "none";
    public static final String HILO = "hilo";
    public static final String LEGACY_HILO = "legacy-hilo";
    public static final String POOL = "pooled";
    public static final String POOL_LO = "pooled-lo";
    private static Class[] CTOR_SIG = new Class[]{Class.class, Integer.TYPE};

    public static Optimizer buildOptimizer(String string, Class clazz, int n) {
        String string2 = NONE.equals(string) ? NoopOptimizer.class.getName() : (HILO.equals(string) ? HiLoOptimizer.class.getName() : (LEGACY_HILO.equals(string) ? LegacyHiLoAlgorithmOptimizer.class.getName() : (POOL.equals(string) ? PooledOptimizer.class.getName() : (POOL_LO.equals(string) ? PooledLoOptimizer.class.getName() : string))));
        try {
            Class clazz2 = ReflectHelper.classForName(string2);
            Constructor constructor = clazz2.getConstructor(CTOR_SIG);
            return (Optimizer)constructor.newInstance(clazz, n);
        }
        catch (Throwable throwable) {
            log.warn("Unable to instantiate specified optimizer [{}], falling back to noop", (Object)string);
            return new NoopOptimizer(clazz, n);
        }
    }

    public static Optimizer buildOptimizer(String string, Class clazz, int n, long l) {
        Optimizer optimizer = OptimizerFactory.buildOptimizer(string, clazz, n);
        if (InitialValueAwareOptimizer.class.isInstance(optimizer)) {
            ((InitialValueAwareOptimizer)((Object)optimizer)).injectInitialValue(l);
        }
        return optimizer;
    }

    public static class PooledLoOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;

        public PooledLoOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating pooled optimizer (lo) with [incrementSize=" + n + "; returnClass=" + clazz.getName() + "]");
            }
        }

        public Serializable generate(AccessCallback accessCallback) {
            if (this.lastSourceValue == null || !this.value.lt(this.lastSourceValue.copy().add(this.incrementSize))) {
                this.lastSourceValue = accessCallback.getNextValue();
                this.value = this.lastSourceValue.copy();
                while (this.value.lt(1L)) {
                    this.value.increment();
                }
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }
    }

    public static class PooledOptimizer
    extends OptimizerSupport
    implements InitialValueAwareOptimizer {
        private IntegralDataTypeHolder hiValue;
        private IntegralDataTypeHolder value;
        private long initialValue = -1L;

        public PooledOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating pooled optimizer with [incrementSize=" + n + "; returnClass=" + clazz.getName() + "]");
            }
        }

        public synchronized Serializable generate(AccessCallback accessCallback) {
            if (this.hiValue == null) {
                this.value = accessCallback.getNextValue();
                if (this.value.lt(1L)) {
                    log.info("pooled optimizer source reported [" + this.value + "] as the initial value; use of 1 or greater highly recommended");
                }
                if (this.initialValue == -1L && this.value.lt(this.incrementSize) || this.value.eq(this.initialValue)) {
                    this.hiValue = accessCallback.getNextValue();
                } else {
                    this.hiValue = this.value;
                    this.value = this.hiValue.copy().subtract(this.incrementSize);
                }
            } else if (!this.hiValue.gt(this.value)) {
                this.hiValue = accessCallback.getNextValue();
                this.value = this.hiValue.copy().subtract(this.incrementSize);
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.hiValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return true;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }

        public void injectInitialValue(long l) {
            this.initialValue = l;
        }
    }

    public static class LegacyHiLoAlgorithmOptimizer
    extends OptimizerSupport {
        private long maxLo;
        private long lo;
        private IntegralDataTypeHolder hi;
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder value;

        public LegacyHiLoAlgorithmOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating hilo optimizer (legacy) with [incrementSize=" + n + "; returnClass=" + clazz.getName() + "]");
            }
            this.maxLo = n;
            this.lo = this.maxLo + 1L;
        }

        public synchronized Serializable generate(AccessCallback accessCallback) {
            if (this.lo > this.maxLo) {
                this.lastSourceValue = accessCallback.getNextValue();
                this.lo = this.lastSourceValue.eq(0L) ? 1L : 0L;
                this.hi = this.lastSourceValue.copy().multiplyBy(this.maxLo + 1L);
            }
            this.value = this.hi.copy().add(this.lo++);
            return this.value.makeValue();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue.copy();
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value;
        }
    }

    public static class HiLoOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;
        private IntegralDataTypeHolder upperLimit;
        private IntegralDataTypeHolder value;

        public HiLoOptimizer(Class clazz, int n) {
            super(clazz, n);
            if (n < 1) {
                throw new HibernateException("increment size cannot be less than 1");
            }
            if (log.isTraceEnabled()) {
                log.trace("creating hilo optimizer with [incrementSize=" + n + "; returnClass=" + clazz.getName() + "]");
            }
        }

        public synchronized Serializable generate(AccessCallback accessCallback) {
            if (this.lastSourceValue == null) {
                this.lastSourceValue = accessCallback.getNextValue();
                while (this.lastSourceValue.lt(1L)) {
                    this.lastSourceValue = accessCallback.getNextValue();
                }
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
                this.value = this.upperLimit.copy().subtract(this.incrementSize);
            } else if (!this.upperLimit.gt(this.value)) {
                this.lastSourceValue = accessCallback.getNextValue();
                this.upperLimit = this.lastSourceValue.copy().multiplyBy(this.incrementSize).increment();
            }
            return this.value.makeValueThenIncrement();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }

        public IntegralDataTypeHolder getLastValue() {
            return this.value.copy().decrement();
        }

        public IntegralDataTypeHolder getHiValue() {
            return this.upperLimit;
        }
    }

    public static class NoopOptimizer
    extends OptimizerSupport {
        private IntegralDataTypeHolder lastSourceValue;

        public NoopOptimizer(Class clazz, int n) {
            super(clazz, n);
        }

        public Serializable generate(AccessCallback accessCallback) {
            IntegralDataTypeHolder integralDataTypeHolder = null;
            while (integralDataTypeHolder == null || integralDataTypeHolder.lt(1L)) {
                integralDataTypeHolder = accessCallback.getNextValue();
            }
            this.lastSourceValue = integralDataTypeHolder;
            return integralDataTypeHolder.makeValue();
        }

        public IntegralDataTypeHolder getLastSourceValue() {
            return this.lastSourceValue;
        }

        public boolean applyIncrementSizeToSourceValues() {
            return false;
        }
    }

    public static abstract class OptimizerSupport
    implements Optimizer {
        protected final Class returnClass;
        protected final int incrementSize;

        protected OptimizerSupport(Class clazz, int n) {
            if (clazz == null) {
                throw new HibernateException("return class is required");
            }
            this.returnClass = clazz;
            this.incrementSize = n;
        }

        public final Class getReturnClass() {
            return this.returnClass;
        }

        public final int getIncrementSize() {
            return this.incrementSize;
        }
    }

    public static interface InitialValueAwareOptimizer {
        public void injectInitialValue(long var1);
    }
}

