/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceStructure
implements DatabaseStructure {
    private static final Logger log = LoggerFactory.getLogger(SequenceStructure.class);
    private final String sequenceName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private final String sql;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public SequenceStructure(Dialect dialect, String string, int n, int n2, Class clazz) {
        this.sequenceName = string;
        this.initialValue = n;
        this.incrementSize = n2;
        this.numberType = clazz;
        this.sql = dialect.getSequenceNextValString(string);
    }

    public String getName() {
        return this.sequenceName;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public AccessCallback buildCallback(final SessionImplementor sessionImplementor) {
        return new AccessCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public IntegralDataTypeHolder getNextValue() {
                SequenceStructure.this.accessCounter++;
                try {
                    PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(SequenceStructure.this.sql);
                    try {
                        IntegralDataTypeHolder integralDataTypeHolder;
                        ResultSet resultSet = preparedStatement.executeQuery();
                        try {
                            resultSet.next();
                            IntegralDataTypeHolder integralDataTypeHolder2 = IdentifierGeneratorHelper.getIntegralDataTypeHolder(SequenceStructure.this.numberType);
                            integralDataTypeHolder2.initialize(resultSet, 1L);
                            if (log.isDebugEnabled()) {
                                log.debug("Sequence value obtained: " + integralDataTypeHolder2.makeValue());
                            }
                            integralDataTypeHolder = integralDataTypeHolder2;
                        }
                        catch (Throwable throwable) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return integralDataTypeHolder;
                    }
                    finally {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                }
                catch (SQLException sQLException) {
                    throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not get next sequence value", SequenceStructure.this.sql);
                }
            }
        };
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        int n = this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
        return dialect.getCreateSequenceStrings(this.sequenceName, this.initialValue, n);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return dialect.getDropSequenceStrings(this.sequenceName);
    }
}

