/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.id.enhanced.SequenceStructure;
import org.hibernate.id.enhanced.TableStructure;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceStyleGenerator
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(SequenceStyleGenerator.class);
    public static final String SEQUENCE_PARAM = "sequence_name";
    public static final String DEF_SEQUENCE_NAME = "hibernate_sequence";
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    public static final String FORCE_TBL_PARAM = "force_table_use";
    public static final String VALUE_COLUMN_PARAM = "value_column";
    public static final String DEF_VALUE_COLUMN = "next_val";
    private DatabaseStructure databaseStructure;
    private Optimizer optimizer;
    private Type identifierType;

    public DatabaseStructure getDatabaseStructure() {
        return this.databaseStructure;
    }

    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public Type getIdentifierType() {
        return this.identifierType;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.identifierType = type;
        boolean bl = PropertiesHelper.getBoolean(FORCE_TBL_PARAM, properties, false);
        String string = this.determineSequenceName(properties, dialect);
        int n = this.determineInitialValue(properties);
        int n2 = this.determineIncrementSize(properties);
        String string2 = this.determineOptimizationStrategy(properties, n2);
        n2 = this.determineAdjustedIncrementSize(string2, n2);
        if (dialect.supportsSequences() && !bl && "pooled".equals(string2) && !dialect.supportsPooledSequences()) {
            bl = true;
            log.info("Forcing table use for sequence-style generator due to pooled optimizer selection where db does not support pooled sequences");
        }
        this.databaseStructure = this.buildDatabaseStructure(type, properties, dialect, bl, string, n, n2);
        this.optimizer = OptimizerFactory.buildOptimizer(string2, this.identifierType.getReturnedClass(), n2, PropertiesHelper.getInt(INITIAL_PARAM, properties, -1));
        this.databaseStructure.prepare(this.optimizer);
    }

    protected String determineSequenceName(Properties properties, Dialect dialect) {
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        String string = PropertiesHelper.getString(SEQUENCE_PARAM, properties, DEF_SEQUENCE_NAME);
        if (string.indexOf(46) < 0) {
            string = objectNameNormalizer.normalizeIdentifierQuoting(string);
            String string2 = properties.getProperty("schema");
            String string3 = properties.getProperty("catalog");
            string = Table.qualify(dialect.quote(string3), dialect.quote(string2), dialect.quote(string));
        }
        return string;
    }

    protected String determineValueColumnName(Properties properties, Dialect dialect) {
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        String string = PropertiesHelper.getString(VALUE_COLUMN_PARAM, properties, DEF_VALUE_COLUMN);
        return dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(string));
    }

    protected int determineInitialValue(Properties properties) {
        return PropertiesHelper.getInt(INITIAL_PARAM, properties, 1);
    }

    protected int determineIncrementSize(Properties properties) {
        return PropertiesHelper.getInt(INCREMENT_PARAM, properties, 1);
    }

    protected String determineOptimizationStrategy(Properties properties, int n) {
        String string = PropertiesHelper.getBoolean("hibernate.id.optimizer.pooled.prefer_lo", properties, false) ? "pooled-lo" : "pooled";
        String string2 = n <= 1 ? "none" : string;
        return PropertiesHelper.getString(OPT_PARAM, properties, string2);
    }

    protected int determineAdjustedIncrementSize(String string, int n) {
        if ("none".equals(string) && n > 1) {
            log.warn("config specified explicit optimizer of [none], but [increment_size=" + n + "; honoring optimizer setting");
            n = 1;
        }
        return n;
    }

    protected DatabaseStructure buildDatabaseStructure(Type type, Properties properties, Dialect dialect, boolean bl, String string, int n, int n2) {
        boolean bl2;
        boolean bl3 = bl2 = dialect.supportsSequences() && !bl;
        if (bl2) {
            return new SequenceStructure(dialect, string, n, n2, type.getReturnedClass());
        }
        String string2 = this.determineValueColumnName(properties, dialect);
        return new TableStructure(dialect, string, string2, n, n2, type.getReturnedClass());
    }

    public Serializable generate(SessionImplementor sessionImplementor, Object object) throws HibernateException {
        return this.optimizer.generate(this.databaseStructure.buildCallback(sessionImplementor));
    }

    public Object generatorKey() {
        return this.databaseStructure.getName();
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlCreateStrings(dialect);
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return this.databaseStructure.sqlDropStrings(dialect);
    }
}

