/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableGenerator
extends TransactionHelper
implements PersistentIdentifierGenerator,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(TableGenerator.class);
    public static final String CONFIG_PREFER_SEGMENT_PER_ENTITY = "prefer_entity_table_as_segment_value";
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    private Type identifierType;
    private String tableName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private String valueColumnName;
    private int initialValue;
    private int incrementSize;
    private String selectQuery;
    private String insertQuery;
    private String updateQuery;
    private Optimizer optimizer;
    private long accessCount = 0L;

    public Object generatorKey() {
        return this.tableName;
    }

    public final Type getIdentifierType() {
        return this.identifierType;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public final String getSegmentValue() {
        return this.segmentValue;
    }

    public final int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public final String getValueColumnName() {
        return this.valueColumnName;
    }

    public final int getInitialValue() {
        return this.initialValue;
    }

    public final int getIncrementSize() {
        return this.incrementSize;
    }

    public final Optimizer getOptimizer() {
        return this.optimizer;
    }

    public final long getTableAccessCount() {
        return this.accessCount;
    }

    public void configure(Type type, Properties properties, Dialect dialect) throws MappingException {
        this.identifierType = type;
        this.tableName = this.determineGeneratorTableName(properties, dialect);
        this.segmentColumnName = this.determineSegmentColumnName(properties, dialect);
        this.valueColumnName = this.determineValueColumnName(properties, dialect);
        this.segmentValue = this.determineSegmentValue(properties);
        this.segmentValueLength = this.determineSegmentColumnSize(properties);
        this.initialValue = this.determineInitialValue(properties);
        this.incrementSize = this.determineIncrementSize(properties);
        this.selectQuery = this.buildSelectQuery(dialect);
        this.updateQuery = this.buildUpdateQuery();
        this.insertQuery = this.buildInsertQuery();
        String string = PropertiesHelper.getBoolean("hibernate.id.optimizer.pooled.prefer_lo", properties, false) ? "pooled-lo" : "pooled";
        String string2 = this.incrementSize <= 1 ? "none" : string;
        String string3 = PropertiesHelper.getString(OPT_PARAM, properties, string2);
        this.optimizer = OptimizerFactory.buildOptimizer(string3, this.identifierType.getReturnedClass(), this.incrementSize, PropertiesHelper.getInt(INITIAL_PARAM, properties, -1));
    }

    protected String determineGeneratorTableName(Properties properties, Dialect dialect) {
        boolean bl;
        String string = PropertiesHelper.getString(TABLE_PARAM, properties, DEF_TABLE);
        boolean bl2 = bl = string.indexOf(46) < 0;
        if (bl) {
            ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
            string = objectNameNormalizer.normalizeIdentifierQuoting(string);
            String string2 = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("schema"));
            String string3 = objectNameNormalizer.normalizeIdentifierQuoting(properties.getProperty("catalog"));
            string = Table.qualify(dialect.quote(string3), dialect.quote(string2), dialect.quote(string));
        }
        return string;
    }

    protected String determineSegmentColumnName(Properties properties, Dialect dialect) {
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        String string = PropertiesHelper.getString(SEGMENT_COLUMN_PARAM, properties, DEF_SEGMENT_COLUMN);
        return dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(string));
    }

    protected String determineValueColumnName(Properties properties, Dialect dialect) {
        ObjectNameNormalizer objectNameNormalizer = (ObjectNameNormalizer)properties.get("identifier_normalizer");
        String string = PropertiesHelper.getString(VALUE_COLUMN_PARAM, properties, DEF_VALUE_COLUMN);
        return dialect.quote(objectNameNormalizer.normalizeIdentifierQuoting(string));
    }

    protected String determineSegmentValue(Properties properties) {
        String string = properties.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty(string)) {
            string = this.determineDefaultSegmentValue(properties);
        }
        return string;
    }

    protected String determineDefaultSegmentValue(Properties properties) {
        boolean bl = PropertiesHelper.getBoolean(CONFIG_PREFER_SEGMENT_PER_ENTITY, properties, false);
        String string = bl ? properties.getProperty("target_table") : DEF_SEGMENT_VALUE;
        log.info("explicit segment value for id generator [" + this.tableName + '.' + this.segmentColumnName + "] suggested; using default [" + string + "]");
        return string;
    }

    protected int determineSegmentColumnSize(Properties properties) {
        return PropertiesHelper.getInt(SEGMENT_LENGTH_PARAM, properties, 255);
    }

    protected int determineInitialValue(Properties properties) {
        return PropertiesHelper.getInt(INITIAL_PARAM, properties, 1);
    }

    protected int determineIncrementSize(Properties properties) {
        return PropertiesHelper.getInt(INCREMENT_PARAM, properties, 1);
    }

    protected String buildSelectQuery(Dialect dialect) {
        String string = "select " + StringHelper.qualify("tbl", this.valueColumnName) + " from " + this.tableName + ' ' + "tbl" + " where " + StringHelper.qualify("tbl", this.segmentColumnName) + "=?";
        LockOptions lockOptions = new LockOptions(LockMode.PESSIMISTIC_WRITE);
        lockOptions.setAliasSpecificLockMode("tbl", LockMode.PESSIMISTIC_WRITE);
        Map<String, String[]> map = Collections.singletonMap("tbl", new String[]{this.valueColumnName});
        return dialect.applyLocksToSql(string, lockOptions, map);
    }

    protected String buildUpdateQuery() {
        return "update " + this.tableName + " set " + this.valueColumnName + "=? " + " where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
    }

    protected String buildInsertQuery() {
        return "insert into " + this.tableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ") " + " values (?,?)";
    }

    public synchronized Serializable generate(final SessionImplementor sessionImplementor, Object object) {
        return this.optimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)TableGenerator.this.doWorkInNewTransaction(sessionImplementor);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable doWorkInCurrentTransaction(Connection connection, String string) throws SQLException {
        int n;
        IntegralDataTypeHolder integralDataTypeHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.identifierType.getReturnedClass());
        do {
            Object object;
            AutoCloseable autoCloseable;
            SQL_STATEMENT_LOGGER.logStatement(this.selectQuery, FormatStyle.BASIC);
            PreparedStatement preparedStatement = connection.prepareStatement(this.selectQuery);
            try {
                preparedStatement.setString(1, this.segmentValue);
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) {
                    integralDataTypeHolder.initialize(this.initialValue);
                    object = null;
                    try {
                        SQL_STATEMENT_LOGGER.logStatement(this.insertQuery, FormatStyle.BASIC);
                        object = connection.prepareStatement(this.insertQuery);
                        object.setString(1, this.segmentValue);
                        integralDataTypeHolder.bind((PreparedStatement)object, 2);
                        object.execute();
                    }
                    finally {
                        if (object != null) {
                            object.close();
                        }
                    }
                } else {
                    integralDataTypeHolder.initialize((ResultSet)autoCloseable, 1L);
                }
                autoCloseable.close();
            }
            catch (SQLException sQLException) {
                log.error("could not read or init a hi value", sQLException);
                throw sQLException;
            }
            finally {
                preparedStatement.close();
            }
            SQL_STATEMENT_LOGGER.logStatement(this.updateQuery, FormatStyle.BASIC);
            autoCloseable = connection.prepareStatement(this.updateQuery);
            try {
                object = integralDataTypeHolder.copy();
                if (this.optimizer.applyIncrementSizeToSourceValues()) {
                    object.add(this.incrementSize);
                } else {
                    object.increment();
                }
                object.bind((PreparedStatement)autoCloseable, 1);
                integralDataTypeHolder.bind((PreparedStatement)autoCloseable, 2);
                autoCloseable.setString(3, this.segmentValue);
                n = autoCloseable.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error("could not updateQuery hi value in: " + this.tableName, sQLException);
                throw sQLException;
            }
            finally {
                autoCloseable.close();
            }
        } while (n == 0);
        ++this.accessCount;
        return integralDataTypeHolder;
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{new StringBuffer().append(dialect.getCreateTableString()).append(' ').append(this.tableName).append(" ( ").append(this.segmentColumnName).append(' ').append(dialect.getTypeName(12, this.segmentValueLength, 0, 0)).append(" not null ").append(",  ").append(this.valueColumnName).append(' ').append(dialect.getTypeName(-5)).append(", primary key ( ").append(this.segmentColumnName).append(" ) ) ").toString()};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return new String[]{stringBuffer.toString()};
    }
}

