/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TransactionHelper;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.jdbc.util.SQLStatementLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStructure
extends TransactionHelper
implements DatabaseStructure {
    private static final Logger log = LoggerFactory.getLogger(TableStructure.class);
    private static final SQLStatementLogger SQL_STATEMENT_LOGGER = new SQLStatementLogger(false, false);
    private final String tableName;
    private final String valueColumnName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private final String selectQuery;
    private final String updateQuery;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(Dialect dialect, String string, String string2, int n, int n2, Class clazz) {
        this.tableName = string;
        this.initialValue = n;
        this.incrementSize = n2;
        this.valueColumnName = string2;
        this.numberType = clazz;
        this.selectQuery = "select " + string2 + " as id_val" + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, string) + dialect.getForUpdateString();
        this.updateQuery = "update " + string + " set " + string2 + "= ?" + " where " + string2 + "=?";
    }

    public String getName() {
        return this.tableName;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public int getIncrementSize() {
        return this.incrementSize;
    }

    public int getTimesAccessed() {
        return this.accessCounter;
    }

    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    public AccessCallback buildCallback(final SessionImplementor sessionImplementor) {
        return new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)TableStructure.this.doWorkInNewTransaction(sessionImplementor);
            }
        };
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.valueColumnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( " + this.initialValue + " )"};
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return new String[]{stringBuffer.toString()};
    }

    protected Serializable doWorkInCurrentTransaction(Connection connection, String string) throws SQLException {
        int n;
        IntegralDataTypeHolder integralDataTypeHolder = IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.numberType);
        do {
            AutoCloseable autoCloseable;
            SQL_STATEMENT_LOGGER.logStatement(this.selectQuery, FormatStyle.BASIC);
            PreparedStatement preparedStatement = connection.prepareStatement(this.selectQuery);
            try {
                autoCloseable = preparedStatement.executeQuery();
                if (!autoCloseable.next()) {
                    String string2 = "could not read a hi value - you need to populate the table: " + this.tableName;
                    log.error(string2);
                    throw new IdentifierGenerationException(string2);
                }
                integralDataTypeHolder.initialize((ResultSet)autoCloseable, 1L);
                autoCloseable.close();
            }
            catch (SQLException sQLException) {
                log.error("could not read a hi value", sQLException);
                throw sQLException;
            }
            finally {
                preparedStatement.close();
            }
            SQL_STATEMENT_LOGGER.logStatement(this.updateQuery, FormatStyle.BASIC);
            autoCloseable = connection.prepareStatement(this.updateQuery);
            try {
                int n2 = this.applyIncrementSizeToSourceValues ? this.incrementSize : 1;
                IntegralDataTypeHolder integralDataTypeHolder2 = integralDataTypeHolder.copy().add(n2);
                integralDataTypeHolder2.bind((PreparedStatement)autoCloseable, 1);
                integralDataTypeHolder.bind((PreparedStatement)autoCloseable, 2);
                n = autoCloseable.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error("could not updateQuery hi value in: " + this.tableName, sQLException);
                throw sQLException;
            }
            finally {
                autoCloseable.close();
            }
        } while (n == 0);
        ++this.accessCounter;
        return integralDataTypeHolder;
    }
}

