/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.pretty.MessageHelper;

public abstract class AbstractReturningDelegate
implements InsertGeneratedIdentifierDelegate {
    private final PostInsertIdentityPersister persister;

    public AbstractReturningDelegate(PostInsertIdentityPersister postInsertIdentityPersister) {
        this.persister = postInsertIdentityPersister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Serializable performInsert(String string, SessionImplementor sessionImplementor, Binder binder) {
        Serializable serializable;
        PreparedStatement preparedStatement = this.prepare(string, sessionImplementor);
        try {
            binder.bindValues(preparedStatement);
            serializable = this.executeAndExtract(preparedStatement);
        }
        catch (Throwable throwable) {
            try {
                this.releaseStatement(preparedStatement, sessionImplementor);
                throw throwable;
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(sessionImplementor.getFactory().getSQLExceptionConverter(), sQLException, "could not insert: " + MessageHelper.infoString(this.persister), string);
            }
        }
        this.releaseStatement(preparedStatement, sessionImplementor);
        return serializable;
    }

    protected PostInsertIdentityPersister getPersister() {
        return this.persister;
    }

    protected abstract PreparedStatement prepare(String var1, SessionImplementor var2) throws SQLException;

    protected abstract Serializable executeAndExtract(PreparedStatement var1) throws SQLException;

    protected void releaseStatement(PreparedStatement preparedStatement, SessionImplementor sessionImplementor) throws SQLException {
        sessionImplementor.getBatcher().closeStatement(preparedStatement);
    }
}

