/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.uuid;

import java.util.UUID;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.id.UUIDGenerationStrategy;
import org.hibernate.id.uuid.Helper;
import org.hibernate.util.BytesHelper;

public class CustomVersionOneStrategy
implements UUIDGenerationStrategy {
    private final long mostSignificantBits;

    public int getGeneratedVersion() {
        return 1;
    }

    public CustomVersionOneStrategy() {
        byte[] byArray = new byte[8];
        System.arraycopy(Helper.getAddressBytes(), 0, byArray, 0, 4);
        System.arraycopy(Helper.getJvmIdentifierBytes(), 0, byArray, 4, 4);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x10);
        this.mostSignificantBits = BytesHelper.asLong(byArray);
    }

    public UUID generateUUID(SessionImplementor sessionImplementor) {
        long l = CustomVersionOneStrategy.generateLeastSignificantBits(System.currentTimeMillis());
        return new UUID(this.mostSignificantBits, l);
    }

    public long getMostSignificantBits() {
        return this.mostSignificantBits;
    }

    public static long generateLeastSignificantBits(long l) {
        byte[] byArray = new byte[8];
        short s = (short)(l >>> 32);
        int n = (int)l;
        System.arraycopy(BytesHelper.fromShort(s), 0, byArray, 0, 2);
        System.arraycopy(BytesHelper.fromInt(n), 0, byArray, 2, 4);
        System.arraycopy(Helper.getCountBytes(), 0, byArray, 6, 2);
        byArray[0] = (byte)(byArray[0] & 0x3F);
        byArray[0] = (byte)(byArray[0] | 0x80);
        return BytesHelper.asLong(byArray);
    }

    public static void main(String[] stringArray) {
        CustomVersionOneStrategy customVersionOneStrategy = new CustomVersionOneStrategy();
        for (int i = 0; i < 1000; ++i) {
            System.out.println("Generation # " + i + " ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            byte[] byArray = new byte[8];
            long l = System.currentTimeMillis();
            short s = (short)(System.currentTimeMillis() >>> 32);
            int n = (int)l;
            System.arraycopy(BytesHelper.fromShort(s), 0, byArray, 0, 2);
            System.arraycopy(BytesHelper.fromInt(n), 0, byArray, 2, 4);
            System.arraycopy(Helper.getCountBytes(), 0, byArray, 6, 2);
            System.out.println("    before bit setting ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            System.out.println("       loBits[0] : " + BytesHelper.toBinaryString(byArray[0]));
            System.out.println("             lsb : " + BytesHelper.toBinaryString(BytesHelper.asLong(byArray)));
            System.out.println("    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            byArray[0] = (byte)(byArray[0] & 0x3F);
            byArray[0] = (byte)(byArray[0] | 0x80);
            System.out.println("    after bit setting ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            System.out.println("       loBits[0] : " + BytesHelper.toBinaryString(byArray[0]));
            long l2 = BytesHelper.asLong(byArray);
            System.out.println("             lsb : " + BytesHelper.toBinaryString(l2));
            System.out.println("    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
            UUID uUID = new UUID(customVersionOneStrategy.mostSignificantBits, l2);
            System.out.println("  uuid : " + uUID.toString());
            System.out.println("  variant : " + uUID.variant());
            System.out.println("  version : " + uUID.version());
            if (uUID.variant() != 2) {
                throw new RuntimeException("bad variant");
            }
            System.out.println("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        }
    }
}

