/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.RowSelection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.property.Getter;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.SerializableType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.MarkerObject;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public abstract class AbstractQueryImpl
implements Query {
    private static final Object UNSET_PARAMETER = new MarkerObject("<unset parameter>");
    private static final Object UNSET_TYPE = new MarkerObject("<unset type>");
    private final String queryString;
    protected final SessionImplementor session;
    protected final ParameterMetadata parameterMetadata;
    private List values = new ArrayList(4);
    private List types = new ArrayList(4);
    private Map namedParameters = new HashMap(4);
    private Map namedParameterLists = new HashMap(4);
    private Object optionalObject;
    private Serializable optionalId;
    private String optionalEntityName;
    private RowSelection selection;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;
    private Serializable collectionKey;
    private Boolean readOnly;
    private ResultTransformer resultTransformer;

    public AbstractQueryImpl(String string, FlushMode flushMode, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        this.session = sessionImplementor;
        this.queryString = string;
        this.selection = new RowSelection();
        this.flushMode = flushMode;
        this.cacheMode = null;
        this.parameterMetadata = parameterMetadata;
    }

    public ParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.queryString + ')';
    }

    public final String getQueryString() {
        return this.queryString;
    }

    public RowSelection getSelection() {
        return this.selection;
    }

    public Query setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public Query setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public Query setCacheable(boolean bl) {
        this.cacheable = bl;
        return this;
    }

    public Query setCacheRegion(String string) {
        if (string != null) {
            this.cacheRegion = string.trim();
        }
        return this;
    }

    public Query setComment(String string) {
        this.comment = string;
        return this;
    }

    public Query setFirstResult(int n) {
        this.selection.setFirstRow(new Integer(n));
        return this;
    }

    public Query setMaxResults(int n) {
        if (n < 0) {
            this.selection.setMaxRows(null);
        } else {
            this.selection.setMaxRows(new Integer(n));
        }
        return this;
    }

    public Query setTimeout(int n) {
        this.selection.setTimeout(new Integer(n));
        return this;
    }

    public Query setFetchSize(int n) {
        this.selection.setFetchSize(new Integer(n));
        return this;
    }

    public Type[] getReturnTypes() throws HibernateException {
        return this.session.getFactory().getReturnTypes(this.queryString);
    }

    public String[] getReturnAliases() throws HibernateException {
        return this.session.getFactory().getReturnAliases(this.queryString);
    }

    public Query setCollectionKey(Serializable serializable) {
        this.collectionKey = serializable;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly == null ? this.getSession().getPersistenceContext().isDefaultReadOnly() : this.readOnly.booleanValue();
    }

    public Query setReadOnly(boolean bl) {
        this.readOnly = bl;
        return this;
    }

    public Query setResultTransformer(ResultTransformer resultTransformer) {
        this.resultTransformer = resultTransformer;
        return this;
    }

    public void setOptionalEntityName(String string) {
        this.optionalEntityName = string;
    }

    public void setOptionalId(Serializable serializable) {
        this.optionalId = serializable;
    }

    public void setOptionalObject(Object object) {
        this.optionalObject = object;
    }

    SessionImplementor getSession() {
        return this.session;
    }

    public abstract LockOptions getLockOptions();

    protected Map getNamedParams() {
        return new HashMap(this.namedParameters);
    }

    public String[] getNamedParameters() throws HibernateException {
        return ArrayHelper.toStringArray(this.parameterMetadata.getNamedParameterNames());
    }

    public boolean hasNamedParameters() {
        return this.parameterMetadata.getNamedParameterNames().size() > 0;
    }

    protected Map getNamedParameterLists() {
        return this.namedParameterLists;
    }

    protected List getValues() {
        return this.values;
    }

    protected List getTypes() {
        return this.types;
    }

    protected void verifyParameters() throws QueryException {
        this.verifyParameters(false);
    }

    protected void verifyParameters(boolean bl) throws HibernateException {
        if (this.parameterMetadata.getNamedParameterNames().size() != this.namedParameters.size() + this.namedParameterLists.size()) {
            HashSet hashSet = new HashSet(this.parameterMetadata.getNamedParameterNames());
            hashSet.removeAll(this.namedParameterLists.keySet());
            hashSet.removeAll(this.namedParameters.keySet());
            throw new QueryException("Not all named parameters have been set: " + hashSet, this.getQueryString());
        }
        int n = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            Object e = this.types.get(i);
            if (this.values.get(i) == UNSET_PARAMETER || e == UNSET_TYPE) {
                if (bl && i == 0) continue;
                throw new QueryException("Unset positional parameter at position: " + i, this.getQueryString());
            }
            n += ((Type)e).getColumnSpan(this.session.getFactory());
        }
        if (this.parameterMetadata.getOrdinalParameterCount() != n) {
            if (bl && this.parameterMetadata.getOrdinalParameterCount() - 1 != n) {
                throw new QueryException("Expected positional parameter count: " + (this.parameterMetadata.getOrdinalParameterCount() - 1) + ", actual parameters: " + this.values, this.getQueryString());
            }
            if (!bl) {
                throw new QueryException("Expected positional parameter count: " + this.parameterMetadata.getOrdinalParameterCount() + ", actual parameters: " + this.values, this.getQueryString());
            }
        }
    }

    public Query setParameter(int n, Object object, Type type) {
        if (this.parameterMetadata.getOrdinalParameterCount() == 0) {
            throw new IllegalArgumentException("No positional parameters in query: " + this.getQueryString());
        }
        if (n < 0 || n > this.parameterMetadata.getOrdinalParameterCount() - 1) {
            throw new IllegalArgumentException("Positional parameter does not exist: " + n + " in query: " + this.getQueryString());
        }
        int n2 = this.values.size();
        if (n < n2) {
            this.values.set(n, object);
            this.types.set(n, type);
        } else {
            for (int i = 0; i < n - n2; ++i) {
                this.values.add(UNSET_PARAMETER);
                this.types.add(UNSET_TYPE);
            }
            this.values.add(object);
            this.types.add(type);
        }
        return this;
    }

    public Query setParameter(String string, Object object, Type type) {
        if (!this.parameterMetadata.getNamedParameterNames().contains(string)) {
            throw new IllegalArgumentException("Parameter " + string + " does not exist as a named parameter in [" + this.getQueryString() + "]");
        }
        this.namedParameters.put(string, new TypedValue(type, object, this.session.getEntityMode()));
        return this;
    }

    public Query setParameter(int n, Object object) throws HibernateException {
        if (object == null) {
            this.setParameter(n, object, (Type)Hibernate.SERIALIZABLE);
        } else {
            this.setParameter(n, object, this.determineType(n, object));
        }
        return this;
    }

    public Query setParameter(String string, Object object) throws HibernateException {
        if (object == null) {
            Type type = this.parameterMetadata.getNamedParameterExpectedType(string);
            if (type == null) {
                type = Hibernate.SERIALIZABLE;
            }
            this.setParameter(string, object, type);
        } else {
            this.setParameter(string, object, this.determineType(string, object));
        }
        return this;
    }

    protected Type determineType(int n, Object object, Type type) {
        Type type2 = this.parameterMetadata.getOrdinalParameterExpectedType(n + 1);
        if (type2 == null) {
            type2 = type;
        }
        return type2;
    }

    protected Type determineType(int n, Object object) throws HibernateException {
        Type type = this.parameterMetadata.getOrdinalParameterExpectedType(n + 1);
        if (type == null) {
            type = this.guessType(object);
        }
        return type;
    }

    protected Type determineType(String string, Object object, Type type) {
        Type type2 = this.parameterMetadata.getNamedParameterExpectedType(string);
        if (type2 == null) {
            type2 = type;
        }
        return type2;
    }

    protected Type determineType(String string, Object object) throws HibernateException {
        Type type = this.parameterMetadata.getNamedParameterExpectedType(string);
        if (type == null) {
            type = this.guessType(object);
        }
        return type;
    }

    protected Type determineType(String string, Class clazz) throws HibernateException {
        Type type = this.parameterMetadata.getNamedParameterExpectedType(string);
        if (type == null) {
            type = this.guessType(clazz);
        }
        return type;
    }

    private Type guessType(Object object) throws HibernateException {
        Class clazz = HibernateProxyHelper.getClassWithoutInitializingProxy(object);
        return this.guessType(clazz);
    }

    private Type guessType(Class clazz) throws HibernateException {
        boolean bl;
        String string = clazz.getName();
        Type type = this.session.getFactory().getTypeResolver().heuristicType(string);
        boolean bl2 = bl = type != null && type instanceof SerializableType;
        if (type == null || bl) {
            try {
                this.session.getFactory().getEntityPersister(clazz.getName());
            }
            catch (MappingException mappingException) {
                if (bl) {
                    return type;
                }
                throw new HibernateException("Could not determine a type for class: " + string);
            }
            return Hibernate.entity(clazz);
        }
        return type;
    }

    public Query setString(int n, String string) {
        this.setParameter(n, (Object)string, (Type)Hibernate.STRING);
        return this;
    }

    public Query setCharacter(int n, char c) {
        this.setParameter(n, (Object)new Character(c), (Type)Hibernate.CHARACTER);
        return this;
    }

    public Query setBoolean(int n, boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        Type type = this.determineType(n, (Object)bl2, (Type)Hibernate.BOOLEAN);
        this.setParameter(n, (Object)bl2, type);
        return this;
    }

    public Query setByte(int n, byte by) {
        this.setParameter(n, (Object)new Byte(by), (Type)Hibernate.BYTE);
        return this;
    }

    public Query setShort(int n, short s) {
        this.setParameter(n, (Object)new Short(s), (Type)Hibernate.SHORT);
        return this;
    }

    public Query setInteger(int n, int n2) {
        this.setParameter(n, (Object)new Integer(n2), (Type)Hibernate.INTEGER);
        return this;
    }

    public Query setLong(int n, long l) {
        this.setParameter(n, (Object)new Long(l), (Type)Hibernate.LONG);
        return this;
    }

    public Query setFloat(int n, float f) {
        this.setParameter(n, (Object)new Float(f), (Type)Hibernate.FLOAT);
        return this;
    }

    public Query setDouble(int n, double d) {
        this.setParameter(n, (Object)new Double(d), (Type)Hibernate.DOUBLE);
        return this;
    }

    public Query setBinary(int n, byte[] byArray) {
        this.setParameter(n, (Object)byArray, (Type)Hibernate.BINARY);
        return this;
    }

    public Query setText(int n, String string) {
        this.setParameter(n, (Object)string, (Type)Hibernate.TEXT);
        return this;
    }

    public Query setSerializable(int n, Serializable serializable) {
        this.setParameter(n, (Object)serializable, (Type)Hibernate.SERIALIZABLE);
        return this;
    }

    public Query setDate(int n, Date date) {
        this.setParameter(n, (Object)date, (Type)Hibernate.DATE);
        return this;
    }

    public Query setTime(int n, Date date) {
        this.setParameter(n, (Object)date, (Type)Hibernate.TIME);
        return this;
    }

    public Query setTimestamp(int n, Date date) {
        this.setParameter(n, (Object)date, (Type)Hibernate.TIMESTAMP);
        return this;
    }

    public Query setEntity(int n, Object object) {
        this.setParameter(n, object, Hibernate.entity(this.resolveEntityName(object)));
        return this;
    }

    private String resolveEntityName(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("entity for parameter binding cannot be null");
        }
        return this.session.bestGuessEntityName(object);
    }

    public Query setLocale(int n, Locale locale) {
        this.setParameter(n, (Object)locale, (Type)Hibernate.LOCALE);
        return this;
    }

    public Query setCalendar(int n, Calendar calendar) {
        this.setParameter(n, (Object)calendar, (Type)Hibernate.CALENDAR);
        return this;
    }

    public Query setCalendarDate(int n, Calendar calendar) {
        this.setParameter(n, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
        return this;
    }

    public Query setBinary(String string, byte[] byArray) {
        this.setParameter(string, (Object)byArray, (Type)Hibernate.BINARY);
        return this;
    }

    public Query setText(String string, String string2) {
        this.setParameter(string, (Object)string2, (Type)Hibernate.TEXT);
        return this;
    }

    public Query setBoolean(String string, boolean bl) {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        Type type = this.determineType(string, (Object)bl2, (Type)Hibernate.BOOLEAN);
        this.setParameter(string, (Object)bl2, type);
        return this;
    }

    public Query setByte(String string, byte by) {
        this.setParameter(string, (Object)new Byte(by), (Type)Hibernate.BYTE);
        return this;
    }

    public Query setCharacter(String string, char c) {
        this.setParameter(string, (Object)new Character(c), (Type)Hibernate.CHARACTER);
        return this;
    }

    public Query setDate(String string, Date date) {
        this.setParameter(string, (Object)date, (Type)Hibernate.DATE);
        return this;
    }

    public Query setDouble(String string, double d) {
        this.setParameter(string, (Object)new Double(d), (Type)Hibernate.DOUBLE);
        return this;
    }

    public Query setEntity(String string, Object object) {
        this.setParameter(string, object, Hibernate.entity(this.resolveEntityName(object)));
        return this;
    }

    public Query setFloat(String string, float f) {
        this.setParameter(string, (Object)new Float(f), (Type)Hibernate.FLOAT);
        return this;
    }

    public Query setInteger(String string, int n) {
        this.setParameter(string, (Object)new Integer(n), (Type)Hibernate.INTEGER);
        return this;
    }

    public Query setLocale(String string, Locale locale) {
        this.setParameter(string, (Object)locale, (Type)Hibernate.LOCALE);
        return this;
    }

    public Query setCalendar(String string, Calendar calendar) {
        this.setParameter(string, (Object)calendar, (Type)Hibernate.CALENDAR);
        return this;
    }

    public Query setCalendarDate(String string, Calendar calendar) {
        this.setParameter(string, (Object)calendar, (Type)Hibernate.CALENDAR_DATE);
        return this;
    }

    public Query setLong(String string, long l) {
        this.setParameter(string, (Object)new Long(l), (Type)Hibernate.LONG);
        return this;
    }

    public Query setSerializable(String string, Serializable serializable) {
        this.setParameter(string, (Object)serializable, (Type)Hibernate.SERIALIZABLE);
        return this;
    }

    public Query setShort(String string, short s) {
        this.setParameter(string, (Object)new Short(s), (Type)Hibernate.SHORT);
        return this;
    }

    public Query setString(String string, String string2) {
        this.setParameter(string, (Object)string2, (Type)Hibernate.STRING);
        return this;
    }

    public Query setTime(String string, Date date) {
        this.setParameter(string, (Object)date, (Type)Hibernate.TIME);
        return this;
    }

    public Query setTimestamp(String string, Date date) {
        this.setParameter(string, (Object)date, (Type)Hibernate.TIMESTAMP);
        return this;
    }

    public Query setBigDecimal(int n, BigDecimal bigDecimal) {
        this.setParameter(n, (Object)bigDecimal, (Type)Hibernate.BIG_DECIMAL);
        return this;
    }

    public Query setBigDecimal(String string, BigDecimal bigDecimal) {
        this.setParameter(string, (Object)bigDecimal, (Type)Hibernate.BIG_DECIMAL);
        return this;
    }

    public Query setBigInteger(int n, BigInteger bigInteger) {
        this.setParameter(n, (Object)bigInteger, (Type)Hibernate.BIG_INTEGER);
        return this;
    }

    public Query setBigInteger(String string, BigInteger bigInteger) {
        this.setParameter(string, (Object)bigInteger, (Type)Hibernate.BIG_INTEGER);
        return this;
    }

    public Query setParameterList(String string, Collection collection, Type type) throws HibernateException {
        if (!this.parameterMetadata.getNamedParameterNames().contains(string)) {
            throw new IllegalArgumentException("Parameter " + string + " does not exist as a named parameter in [" + this.getQueryString() + "]");
        }
        this.namedParameterLists.put(string, new TypedValue(type, collection, this.session.getEntityMode()));
        return this;
    }

    protected String expandParameterLists(Map map) {
        String string = this.queryString;
        for (Map.Entry entry : this.namedParameterLists.entrySet()) {
            string = this.expandParameterList(string, (String)entry.getKey(), (TypedValue)entry.getValue(), map);
        }
        return string;
    }

    private String expandParameterList(String string, String string2, TypedValue typedValue, Map map) {
        String string3;
        Collection collection = (Collection)typedValue.getValue();
        Type type = typedValue.getType();
        if (collection.size() == 1) {
            map.put(string2, new TypedValue(type, collection.iterator().next(), this.session.getEntityMode()));
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(16);
        Iterator iterator = collection.iterator();
        int n = 0;
        boolean bl = this.parameterMetadata.getNamedParameterDescriptor(string2).isJpaStyle();
        while (iterator.hasNext()) {
            string3 = (bl ? 'x' + string2 : string2) + n++ + '_';
            map.put(string3, new TypedValue(type, iterator.next(), this.session.getEntityMode()));
            stringBuffer.append(":").append(string3);
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        string3 = bl ? "?" : ":";
        return StringHelper.replace(string, string3 + string2, stringBuffer.toString(), true);
    }

    public Query setParameterList(String string, Collection collection) throws HibernateException {
        if (collection == null) {
            throw new QueryException("Collection must be not null!");
        }
        if (collection.size() == 0) {
            this.setParameterList(string, collection, null);
        } else {
            this.setParameterList(string, collection, this.determineType(string, collection.iterator().next()));
        }
        return this;
    }

    public Query setParameterList(String string, Object[] objectArray, Type type) throws HibernateException {
        return this.setParameterList(string, Arrays.asList(objectArray), type);
    }

    public Query setParameterList(String string, Object[] objectArray) throws HibernateException {
        return this.setParameterList(string, Arrays.asList(objectArray));
    }

    public Query setProperties(Map map) throws HibernateException {
        String[] stringArray = this.getNamedParameters();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Object v = map.get(string);
            if (v == null) continue;
            Class<?> clazz = v.getClass();
            if (Collection.class.isAssignableFrom(clazz)) {
                this.setParameterList(string, (Collection)v);
                continue;
            }
            if (clazz.isArray()) {
                this.setParameterList(string, (Object[])v);
                continue;
            }
            this.setParameter(string, v, this.determineType(string, clazz));
        }
        return this;
    }

    public Query setProperties(Object object) throws HibernateException {
        Class<?> clazz = object.getClass();
        String[] stringArray = this.getNamedParameters();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                Getter getter = ReflectHelper.getGetter(clazz, string);
                Class clazz2 = getter.getReturnType();
                Object object2 = getter.get(object);
                if (Collection.class.isAssignableFrom(clazz2)) {
                    this.setParameterList(string, (Collection)object2);
                    continue;
                }
                if (clazz2.isArray()) {
                    this.setParameterList(string, (Object[])object2);
                    continue;
                }
                this.setParameter(string, object2, this.determineType(string, clazz2));
                continue;
            }
            catch (PropertyNotFoundException propertyNotFoundException) {
                // empty catch block
            }
        }
        return this;
    }

    public Query setParameters(Object[] objectArray, Type[] typeArray) {
        this.values = Arrays.asList(objectArray);
        this.types = Arrays.asList(typeArray);
        return this;
    }

    public Object uniqueResult() throws HibernateException {
        return AbstractQueryImpl.uniqueElement(this.list());
    }

    static Object uniqueElement(List list) throws NonUniqueResultException {
        int n = list.size();
        if (n == 0) {
            return null;
        }
        Object e = list.get(0);
        for (int i = 1; i < n; ++i) {
            if (list.get(i) == e) continue;
            throw new NonUniqueResultException(list.size());
        }
        return e;
    }

    protected RowSelection getRowSelection() {
        return this.selection;
    }

    public Type[] typeArray() {
        return ArrayHelper.toTypeArray(this.getTypes());
    }

    public Object[] valueArray() {
        return this.getValues().toArray();
    }

    public QueryParameters getQueryParameters(Map map) {
        Serializable[] serializableArray;
        Type[] typeArray = this.typeArray();
        Object[] objectArray = this.valueArray();
        LockOptions lockOptions = this.getLockOptions();
        RowSelection rowSelection = this.getSelection();
        boolean bl = this.isReadOnly();
        if (this.collectionKey == null) {
            serializableArray = null;
        } else {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = this.collectionKey;
        }
        return new QueryParameters(typeArray, objectArray, map, lockOptions, rowSelection, true, bl, this.cacheable, this.cacheRegion, this.comment, serializableArray, this.optionalObject, this.optionalEntityName, this.optionalId, this.resultTransformer);
    }

    protected void before() {
        if (this.flushMode != null) {
            this.sessionFlushMode = this.getSession().getFlushMode();
            this.getSession().setFlushMode(this.flushMode);
        }
        if (this.cacheMode != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(this.cacheMode);
        }
    }

    protected void after() {
        if (this.sessionFlushMode != null) {
            this.getSession().setFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
    }
}

