/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.NaturalIdentifier;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.util.StringHelper;

public class CriteriaImpl
implements Criteria,
Serializable {
    private final String entityOrClassName;
    private transient SessionImplementor session;
    private final String rootAlias;
    private List criterionEntries = new ArrayList();
    private List orderEntries = new ArrayList();
    private Projection projection;
    private Criteria projectionCriteria;
    private List subcriteriaList = new ArrayList();
    private Map fetchModes = new HashMap();
    private Map lockModes = new HashMap();
    private Integer maxResults;
    private Integer firstResult;
    private Integer timeout;
    private Integer fetchSize;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;
    private Boolean readOnly;
    private ResultTransformer resultTransformer = Criteria.ROOT_ENTITY;

    public CriteriaImpl(String string, SessionImplementor sessionImplementor) {
        this(string, "this", sessionImplementor);
    }

    public CriteriaImpl(String string, String string2, SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
        this.entityOrClassName = string;
        this.cacheable = false;
        this.rootAlias = string2;
    }

    public String toString() {
        return "CriteriaImpl(" + this.entityOrClassName + ":" + (this.rootAlias == null ? "" : this.rootAlias) + this.subcriteriaList.toString() + this.criterionEntries.toString() + (this.projection == null ? "" : this.projection.toString()) + ')';
    }

    public SessionImplementor getSession() {
        return this.session;
    }

    public void setSession(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
    }

    public String getEntityOrClassName() {
        return this.entityOrClassName;
    }

    public Map getLockModes() {
        return this.lockModes;
    }

    public Criteria getProjectionCriteria() {
        return this.projectionCriteria;
    }

    public Iterator iterateSubcriteria() {
        return this.subcriteriaList.iterator();
    }

    public Iterator iterateExpressionEntries() {
        return this.criterionEntries.iterator();
    }

    public Iterator iterateOrderings() {
        return this.orderEntries.iterator();
    }

    public Criteria add(Criteria criteria, Criterion criterion) {
        this.criterionEntries.add(new CriterionEntry(criterion, criteria));
        return this;
    }

    public String getAlias() {
        return this.rootAlias;
    }

    public Projection getProjection() {
        return this.projection;
    }

    public Criteria setProjection(Projection projection) {
        this.projection = projection;
        this.projectionCriteria = this;
        this.setResultTransformer(PROJECTION);
        return this;
    }

    public Criteria add(Criterion criterion) {
        this.add(this, criterion);
        return this;
    }

    public Criteria addOrder(Order order) {
        this.orderEntries.add(new OrderEntry(order, this));
        return this;
    }

    public FetchMode getFetchMode(String string) {
        return (FetchMode)this.fetchModes.get(string);
    }

    public Criteria setFetchMode(String string, FetchMode fetchMode) {
        this.fetchModes.put(string, fetchMode);
        return this;
    }

    public Criteria setLockMode(LockMode lockMode) {
        return this.setLockMode(this.getAlias(), lockMode);
    }

    public Criteria setLockMode(String string, LockMode lockMode) {
        this.lockModes.put(string, lockMode);
        return this;
    }

    public Criteria createAlias(String string, String string2) {
        return this.createAlias(string, string2, 0);
    }

    public Criteria createAlias(String string, String string2, int n) {
        new Subcriteria((Criteria)this, string, string2, n);
        return this;
    }

    public Criteria createAlias(String string, String string2, int n, Criterion criterion) {
        new Subcriteria(this, string, string2, n, criterion);
        return this;
    }

    public Criteria createCriteria(String string) {
        return this.createCriteria(string, 0);
    }

    public Criteria createCriteria(String string, int n) {
        return new Subcriteria((Criteria)this, string, n);
    }

    public Criteria createCriteria(String string, String string2) {
        return this.createCriteria(string, string2, 0);
    }

    public Criteria createCriteria(String string, String string2, int n) {
        return new Subcriteria((Criteria)this, string, string2, n);
    }

    public Criteria createCriteria(String string, String string2, int n, Criterion criterion) {
        return new Subcriteria(this, string, string2, n, criterion);
    }

    public ResultTransformer getResultTransformer() {
        return this.resultTransformer;
    }

    public Criteria setResultTransformer(ResultTransformer resultTransformer) {
        this.resultTransformer = resultTransformer;
        return this;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public Criteria setMaxResults(int n) {
        this.maxResults = new Integer(n);
        return this;
    }

    public Integer getFirstResult() {
        return this.firstResult;
    }

    public Criteria setFirstResult(int n) {
        this.firstResult = new Integer(n);
        return this;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Criteria setFetchSize(int n) {
        this.fetchSize = new Integer(n);
        return this;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public Criteria setTimeout(int n) {
        this.timeout = new Integer(n);
        return this;
    }

    public boolean isReadOnlyInitialized() {
        return this.readOnly != null;
    }

    public boolean isReadOnly() {
        if (!this.isReadOnlyInitialized() && this.getSession() == null) {
            throw new IllegalStateException("cannot determine readOnly/modifiable setting when it is not initialized and is not initialized and getSession() == null");
        }
        return this.isReadOnlyInitialized() ? this.readOnly.booleanValue() : this.getSession().getPersistenceContext().isDefaultReadOnly();
    }

    public Criteria setReadOnly(boolean bl) {
        this.readOnly = bl;
        return this;
    }

    public boolean getCacheable() {
        return this.cacheable;
    }

    public Criteria setCacheable(boolean bl) {
        this.cacheable = bl;
        return this;
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public Criteria setCacheRegion(String string) {
        this.cacheRegion = string.trim();
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public Criteria setComment(String string) {
        this.comment = string;
        return this;
    }

    public Criteria setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    public Criteria setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() throws HibernateException {
        this.before();
        try {
            List list = this.session.list(this);
            return list;
        }
        finally {
            this.after();
        }
    }

    public ScrollableResults scroll() {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(ScrollMode scrollMode) {
        this.before();
        try {
            ScrollableResults scrollableResults = this.session.scroll(this, scrollMode);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    public Object uniqueResult() throws HibernateException {
        return AbstractQueryImpl.uniqueElement(this.list());
    }

    protected void before() {
        if (this.flushMode != null) {
            this.sessionFlushMode = this.getSession().getFlushMode();
            this.getSession().setFlushMode(this.flushMode);
        }
        if (this.cacheMode != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(this.cacheMode);
        }
    }

    protected void after() {
        if (this.sessionFlushMode != null) {
            this.getSession().setFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
    }

    public boolean isLookupByNaturalKey() {
        if (this.projection != null) {
            return false;
        }
        if (this.subcriteriaList.size() > 0) {
            return false;
        }
        if (this.criterionEntries.size() != 1) {
            return false;
        }
        CriterionEntry criterionEntry = (CriterionEntry)this.criterionEntries.get(0);
        return criterionEntry.getCriterion() instanceof NaturalIdentifier;
    }

    public static final class OrderEntry
    implements Serializable {
        private final Order order;
        private final Criteria criteria;

        private OrderEntry(Order order, Criteria criteria) {
            this.criteria = criteria;
            this.order = order;
        }

        public Order getOrder() {
            return this.order;
        }

        public Criteria getCriteria() {
            return this.criteria;
        }

        public String toString() {
            return this.order.toString();
        }
    }

    public static final class CriterionEntry
    implements Serializable {
        private final Criterion criterion;
        private final Criteria criteria;

        private CriterionEntry(Criterion criterion, Criteria criteria) {
            this.criteria = criteria;
            this.criterion = criterion;
        }

        public Criterion getCriterion() {
            return this.criterion;
        }

        public Criteria getCriteria() {
            return this.criteria;
        }

        public String toString() {
            return this.criterion.toString();
        }
    }

    public final class Subcriteria
    implements Criteria,
    Serializable {
        private String alias;
        private String path;
        private Criteria parent;
        private LockMode lockMode;
        private int joinType;
        private Criterion withClause;

        private Subcriteria(Criteria criteria, String string, String string2, int n, Criterion criterion) {
            this.alias = string2;
            this.path = string;
            this.parent = criteria;
            this.joinType = n;
            this.withClause = criterion;
            CriteriaImpl.this.subcriteriaList.add(this);
        }

        private Subcriteria(Criteria criteria, String string, String string2, int n) {
            this(criteria, string, string2, n, (Criterion)null);
        }

        private Subcriteria(Criteria criteria, String string, int n) {
            this(criteria, string, null, n);
        }

        public String toString() {
            return "Subcriteria(" + this.path + ":" + (this.alias == null ? "" : this.alias) + ')';
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String string) {
            this.alias = string;
        }

        public String getPath() {
            return this.path;
        }

        public Criteria getParent() {
            return this.parent;
        }

        public LockMode getLockMode() {
            return this.lockMode;
        }

        public Criteria setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        public int getJoinType() {
            return this.joinType;
        }

        public Criterion getWithClause() {
            return this.withClause;
        }

        public Criteria add(Criterion criterion) {
            CriteriaImpl.this.add(this, criterion);
            return this;
        }

        public Criteria addOrder(Order order) {
            CriteriaImpl.this.orderEntries.add(new OrderEntry(order, this));
            return this;
        }

        public Criteria createAlias(String string, String string2) {
            return this.createAlias(string, string2, 0);
        }

        public Criteria createAlias(String string, String string2, int n) throws HibernateException {
            new Subcriteria((Criteria)this, string, string2, n);
            return this;
        }

        public Criteria createAlias(String string, String string2, int n, Criterion criterion) throws HibernateException {
            new Subcriteria((Criteria)this, string, string2, n, criterion);
            return this;
        }

        public Criteria createCriteria(String string) {
            return this.createCriteria(string, 0);
        }

        public Criteria createCriteria(String string, int n) throws HibernateException {
            return new Subcriteria(this, string, n);
        }

        public Criteria createCriteria(String string, String string2) {
            return this.createCriteria(string, string2, 0);
        }

        public Criteria createCriteria(String string, String string2, int n) throws HibernateException {
            return new Subcriteria((Criteria)this, string, string2, n);
        }

        public Criteria createCriteria(String string, String string2, int n, Criterion criterion) throws HibernateException {
            return new Subcriteria((Criteria)this, string, string2, n, criterion);
        }

        public boolean isReadOnly() {
            return CriteriaImpl.this.isReadOnly();
        }

        public boolean isReadOnlyInitialized() {
            return CriteriaImpl.this.isReadOnlyInitialized();
        }

        public Criteria setReadOnly(boolean bl) {
            CriteriaImpl.this.setReadOnly(bl);
            return this;
        }

        public Criteria setCacheable(boolean bl) {
            CriteriaImpl.this.setCacheable(bl);
            return this;
        }

        public Criteria setCacheRegion(String string) {
            CriteriaImpl.this.setCacheRegion(string);
            return this;
        }

        public List list() throws HibernateException {
            return CriteriaImpl.this.list();
        }

        public ScrollableResults scroll() throws HibernateException {
            return CriteriaImpl.this.scroll();
        }

        public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
            return CriteriaImpl.this.scroll(scrollMode);
        }

        public Object uniqueResult() throws HibernateException {
            return CriteriaImpl.this.uniqueResult();
        }

        public Criteria setFetchMode(String string, FetchMode fetchMode) {
            CriteriaImpl.this.setFetchMode(StringHelper.qualify(this.path, string), fetchMode);
            return this;
        }

        public Criteria setFlushMode(FlushMode flushMode) {
            CriteriaImpl.this.setFlushMode(flushMode);
            return this;
        }

        public Criteria setCacheMode(CacheMode cacheMode) {
            CriteriaImpl.this.setCacheMode(cacheMode);
            return this;
        }

        public Criteria setFirstResult(int n) {
            CriteriaImpl.this.setFirstResult(n);
            return this;
        }

        public Criteria setMaxResults(int n) {
            CriteriaImpl.this.setMaxResults(n);
            return this;
        }

        public Criteria setTimeout(int n) {
            CriteriaImpl.this.setTimeout(n);
            return this;
        }

        public Criteria setFetchSize(int n) {
            CriteriaImpl.this.setFetchSize(n);
            return this;
        }

        public Criteria setLockMode(String string, LockMode lockMode) {
            CriteriaImpl.this.setLockMode(string, lockMode);
            return this;
        }

        public Criteria setResultTransformer(ResultTransformer resultTransformer) {
            CriteriaImpl.this.setResultTransformer(resultTransformer);
            return this;
        }

        public Criteria setComment(String string) {
            CriteriaImpl.this.setComment(string);
            return this;
        }

        public Criteria setProjection(Projection projection) {
            CriteriaImpl.this.projection = projection;
            CriteriaImpl.this.projectionCriteria = this;
            this.setResultTransformer(PROJECTION);
            return this;
        }
    }
}

