/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.NonFlushedChanges;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.event.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonFlushedChangesImpl
implements NonFlushedChanges {
    private static final Logger log = LoggerFactory.getLogger(NonFlushedChangesImpl.class);
    private Map nonFlushedChangesByEntityMode = new HashMap();

    public NonFlushedChangesImpl(EventSource eventSource) {
        this.extractFromSession(eventSource);
    }

    public void extractFromSession(EventSource eventSource) {
        if (this.nonFlushedChangesByEntityMode.containsKey(eventSource.getEntityMode())) {
            throw new AssertionFailure("Already has non-flushed changes for entity mode: " + eventSource.getEntityMode());
        }
        this.nonFlushedChangesByEntityMode.put(eventSource.getEntityMode(), new SessionNonFlushedChanges(eventSource));
    }

    private SessionNonFlushedChanges getSessionNonFlushedChanges(EntityMode entityMode) {
        return (SessionNonFlushedChanges)this.nonFlushedChangesByEntityMode.get(entityMode);
    }

    ActionQueue getActionQueue(EntityMode entityMode) {
        return this.getSessionNonFlushedChanges(entityMode).actionQueue;
    }

    StatefulPersistenceContext getPersistenceContext(EntityMode entityMode) {
        return this.getSessionNonFlushedChanges(entityMode).persistenceContext;
    }

    public void clear() {
        this.nonFlushedChangesByEntityMode.clear();
    }

    private static class SessionNonFlushedChanges
    implements Serializable {
        private transient EntityMode entityMode;
        private transient ActionQueue actionQueue;
        private transient StatefulPersistenceContext persistenceContext;

        public SessionNonFlushedChanges(EventSource eventSource) {
            this.entityMode = eventSource.getEntityMode();
            this.actionQueue = eventSource.getActionQueue();
            this.persistenceContext = (StatefulPersistenceContext)eventSource.getPersistenceContext();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            this.entityMode = EntityMode.parse((String)objectInputStream.readObject());
            this.persistenceContext = StatefulPersistenceContext.deserialize(objectInputStream, null);
            this.actionQueue = ActionQueue.deserialize(objectInputStream, null);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            log.trace("serializing SessionNonFlushedChanges");
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.entityMode.toString());
            this.persistenceContext.serialize(objectOutputStream);
            this.actionQueue.serialize(objectOutputStream);
        }
    }
}

