/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.engine.query.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryScalarReturn;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLQueryImpl
extends AbstractQueryImpl
implements SQLQuery {
    private List<NativeSQLQueryReturn> queryReturns;
    private List<ReturnBuilder> queryReturnBuilders;
    private boolean autoDiscoverTypes;
    private Collection<String> querySpaces;
    private final boolean callable;

    SQLQueryImpl(NamedSQLQueryDefinition namedSQLQueryDefinition, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        super(namedSQLQueryDefinition.getQueryString(), namedSQLQueryDefinition.getFlushMode(), sessionImplementor, parameterMetadata);
        if (namedSQLQueryDefinition.getResultSetRef() != null) {
            ResultSetMappingDefinition resultSetMappingDefinition = sessionImplementor.getFactory().getResultSetMapping(namedSQLQueryDefinition.getResultSetRef());
            if (resultSetMappingDefinition == null) {
                throw new MappingException("Unable to find resultset-ref definition: " + namedSQLQueryDefinition.getResultSetRef());
            }
            this.queryReturns = Arrays.asList(resultSetMappingDefinition.getQueryReturns());
        } else {
            this.queryReturns = namedSQLQueryDefinition.getQueryReturns() != null && namedSQLQueryDefinition.getQueryReturns().length > 0 ? Arrays.asList(namedSQLQueryDefinition.getQueryReturns()) : new ArrayList<NativeSQLQueryReturn>();
        }
        this.querySpaces = namedSQLQueryDefinition.getQuerySpaces();
        this.callable = namedSQLQueryDefinition.isCallable();
    }

    SQLQueryImpl(String string, String[] stringArray, Class[] classArray, LockMode[] lockModeArray, SessionImplementor sessionImplementor, Collection<String> collection, FlushMode flushMode, ParameterMetadata parameterMetadata) {
        super(string, flushMode, sessionImplementor, parameterMetadata);
        this.queryReturns = new ArrayList<NativeSQLQueryReturn>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            NativeSQLQueryRootReturn nativeSQLQueryRootReturn = new NativeSQLQueryRootReturn(stringArray[i], classArray[i].getName(), lockModeArray == null ? LockMode.NONE : lockModeArray[i]);
            this.queryReturns.add(nativeSQLQueryRootReturn);
        }
        this.querySpaces = collection;
        this.callable = false;
    }

    SQLQueryImpl(String string, String[] stringArray, Class[] classArray, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        this(string, stringArray, classArray, null, sessionImplementor, null, null, parameterMetadata);
    }

    SQLQueryImpl(String string, SessionImplementor sessionImplementor, ParameterMetadata parameterMetadata) {
        super(string, null, sessionImplementor, parameterMetadata);
        this.queryReturns = new ArrayList<NativeSQLQueryReturn>();
        this.querySpaces = null;
        this.callable = false;
    }

    private NativeSQLQueryReturn[] getQueryReturns() {
        return this.queryReturns.toArray(new NativeSQLQueryReturn[this.queryReturns.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List list() throws HibernateException {
        this.verifyParameters();
        this.before();
        Map map = this.getNamedParams();
        NativeSQLQuerySpecification nativeSQLQuerySpecification = this.generateQuerySpecification(map);
        try {
            List list = this.getSession().list(nativeSQLQuerySpecification, this.getQueryParameters(map));
            return list;
        }
        finally {
            this.after();
        }
    }

    private NativeSQLQuerySpecification generateQuerySpecification(Map map) {
        return new NativeSQLQuerySpecification(this.expandParameterLists(map), this.getQueryReturns(), this.querySpaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        this.verifyParameters();
        this.before();
        Map map = this.getNamedParams();
        NativeSQLQuerySpecification nativeSQLQuerySpecification = this.generateQuerySpecification(map);
        QueryParameters queryParameters = this.getQueryParameters(map);
        queryParameters.setScrollMode(scrollMode);
        try {
            ScrollableResults scrollableResults = this.getSession().scroll(nativeSQLQuerySpecification, queryParameters);
            return scrollableResults;
        }
        finally {
            this.after();
        }
    }

    @Override
    public ScrollableResults scroll() throws HibernateException {
        return this.scroll(ScrollMode.SCROLL_INSENSITIVE);
    }

    @Override
    public Iterator iterate() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support iteration");
    }

    @Override
    public QueryParameters getQueryParameters(Map map) {
        QueryParameters queryParameters = super.getQueryParameters(map);
        queryParameters.setCallable(this.callable);
        queryParameters.setAutoDiscoverScalarTypes(this.autoDiscoverTypes);
        return queryParameters;
    }

    @Override
    protected void verifyParameters() {
        boolean bl;
        this.prepare();
        this.verifyParameters(this.callable);
        boolean bl2 = bl = this.queryReturns == null || this.queryReturns.isEmpty();
        if (bl) {
            this.autoDiscoverTypes = bl;
        } else {
            for (NativeSQLQueryReturn nativeSQLQueryReturn : this.queryReturns) {
                NativeSQLQueryScalarReturn nativeSQLQueryScalarReturn;
                if (!(nativeSQLQueryReturn instanceof NativeSQLQueryScalarReturn) || (nativeSQLQueryScalarReturn = (NativeSQLQueryScalarReturn)nativeSQLQueryReturn).getType() != null) continue;
                this.autoDiscoverTypes = true;
                break;
            }
        }
    }

    private void prepare() {
        if (this.queryReturnBuilders != null) {
            if (!this.queryReturnBuilders.isEmpty()) {
                if (this.queryReturns != null) {
                    this.queryReturns.clear();
                    this.queryReturns = null;
                }
                this.queryReturns = new ArrayList<NativeSQLQueryReturn>();
                for (ReturnBuilder returnBuilder : this.queryReturnBuilders) {
                    this.queryReturns.add(returnBuilder.buildReturn());
                }
                this.queryReturnBuilders.clear();
            }
            this.queryReturnBuilders = null;
        }
    }

    @Override
    public String[] getReturnAliases() throws HibernateException {
        throw new UnsupportedOperationException("SQL queries do not currently support returning aliases");
    }

    @Override
    public Type[] getReturnTypes() throws HibernateException {
        throw new UnsupportedOperationException("not yet implemented for SQL queries");
    }

    @Override
    public Query setLockMode(String string, LockMode lockMode) {
        throw new UnsupportedOperationException("cannot set the lock mode for a native SQL query");
    }

    @Override
    public Query setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("cannot set lock options for a native SQL query");
    }

    @Override
    public LockOptions getLockOptions() {
        return null;
    }

    @Override
    public SQLQuery addScalar(final String string, final Type type) {
        if (this.queryReturnBuilders == null) {
            this.queryReturnBuilders = new ArrayList<ReturnBuilder>();
        }
        this.queryReturnBuilders.add(new ReturnBuilder(){

            public NativeSQLQueryReturn buildReturn() {
                return new NativeSQLQueryScalarReturn(string, type);
            }
        });
        return this;
    }

    @Override
    public SQLQuery addScalar(String string) {
        return this.addScalar(string, null);
    }

    @Override
    public SQLQuery.RootReturn addRoot(String string, String string2) {
        RootReturnBuilder rootReturnBuilder = new RootReturnBuilder(string, string2);
        if (this.queryReturnBuilders == null) {
            this.queryReturnBuilders = new ArrayList<ReturnBuilder>();
        }
        this.queryReturnBuilders.add(rootReturnBuilder);
        return rootReturnBuilder;
    }

    @Override
    public SQLQuery.RootReturn addRoot(String string, Class clazz) {
        return this.addRoot(string, clazz.getName());
    }

    @Override
    public SQLQuery addEntity(String string) {
        return this.addEntity(StringHelper.unqualify(string), string);
    }

    @Override
    public SQLQuery addEntity(String string, String string2) {
        this.addRoot(string, string2);
        return this;
    }

    @Override
    public SQLQuery addEntity(String string, String string2, LockMode lockMode) {
        this.addRoot(string, string2).setLockMode(lockMode);
        return this;
    }

    @Override
    public SQLQuery addEntity(Class clazz) {
        return this.addEntity(clazz.getName());
    }

    @Override
    public SQLQuery addEntity(String string, Class clazz) {
        return this.addEntity(string, clazz.getName());
    }

    @Override
    public SQLQuery addEntity(String string, Class clazz, LockMode lockMode) {
        return this.addEntity(string, clazz.getName(), lockMode);
    }

    @Override
    public SQLQuery.FetchReturn addFetch(String string, String string2, String string3) {
        FetchReturnBuilder fetchReturnBuilder = new FetchReturnBuilder(string, string2, string3);
        if (this.queryReturnBuilders == null) {
            this.queryReturnBuilders = new ArrayList<ReturnBuilder>();
        }
        this.queryReturnBuilders.add(fetchReturnBuilder);
        return fetchReturnBuilder;
    }

    @Override
    public SQLQuery addJoin(String string, String string2, String string3) {
        this.addFetch(string, string2, string3);
        return this;
    }

    @Override
    public SQLQuery addJoin(String string, String string2) {
        this.createFetchJoin(string, string2);
        return this;
    }

    private SQLQuery.FetchReturn createFetchJoin(String string, String string2) {
        int n = string2.indexOf(46);
        if (n < 0) {
            throw new QueryException("not a property path: " + string2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        return this.addFetch(string, string3, string4);
    }

    @Override
    public SQLQuery addJoin(String string, String string2, LockMode lockMode) {
        this.createFetchJoin(string, string2).setLockMode(lockMode);
        return this;
    }

    @Override
    public SQLQuery setResultSetMapping(String string) {
        ResultSetMappingDefinition resultSetMappingDefinition = this.session.getFactory().getResultSetMapping(string);
        if (resultSetMappingDefinition == null) {
            throw new MappingException("Unknown SqlResultSetMapping [" + string + "]");
        }
        NativeSQLQueryReturn[] nativeSQLQueryReturnArray = resultSetMappingDefinition.getQueryReturns();
        this.queryReturns.addAll(Arrays.asList(nativeSQLQueryReturnArray));
        return this;
    }

    @Override
    public SQLQuery addSynchronizedQuerySpace(String string) {
        if (this.querySpaces == null) {
            this.querySpaces = new ArrayList<String>();
        }
        this.querySpaces.add(string);
        return this;
    }

    @Override
    public SQLQuery addSynchronizedEntityName(String string) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(string).getQuerySpaces());
    }

    @Override
    public SQLQuery addSynchronizedEntityClass(Class clazz) {
        return this.addQuerySpaces(this.getSession().getFactory().getEntityPersister(clazz.getName()).getQuerySpaces());
    }

    private SQLQuery addQuerySpaces(Serializable[] serializableArray) {
        if (serializableArray != null) {
            if (this.querySpaces == null) {
                this.querySpaces = new ArrayList<String>();
            }
            this.querySpaces.addAll(Arrays.asList((String[])serializableArray));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws HibernateException {
        Map map = this.getNamedParams();
        this.before();
        try {
            int n = this.getSession().executeNativeUpdate(this.generateQuerySpecification(map), this.getQueryParameters(map));
            return n;
        }
        finally {
            this.after();
        }
    }

    private static interface ReturnBuilder {
        public NativeSQLQueryReturn buildReturn();
    }

    private class FetchReturnBuilder
    implements SQLQuery.FetchReturn,
    ReturnBuilder {
        private final String alias;
        private String ownerTableAlias;
        private final String joinedPropertyName;
        private LockMode lockMode = LockMode.READ;
        private Map<String, List<String>> propertyMappings;

        private FetchReturnBuilder(String string, String string2, String string3) {
            this.alias = string;
            this.ownerTableAlias = string2;
            this.joinedPropertyName = string3;
        }

        public SQLQuery.FetchReturn setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        public SQLQuery.FetchReturn addProperty(String string, String string2) {
            this.addProperty(string).addColumnAlias(string2);
            return this;
        }

        public SQLQuery.ReturnProperty addProperty(final String string) {
            if (this.propertyMappings == null) {
                this.propertyMappings = new HashMap<String, List<String>>();
            }
            return new SQLQuery.ReturnProperty(){

                public SQLQuery.ReturnProperty addColumnAlias(String string2) {
                    ArrayList<String> arrayList = (ArrayList<String>)FetchReturnBuilder.this.propertyMappings.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string2);
                    return this;
                }
            };
        }

        public NativeSQLQueryReturn buildReturn() {
            return new NativeSQLQueryJoinReturn(this.alias, this.ownerTableAlias, this.joinedPropertyName, this.propertyMappings, this.lockMode);
        }
    }

    private class RootReturnBuilder
    implements SQLQuery.RootReturn,
    ReturnBuilder {
        private final String alias;
        private final String entityName;
        private LockMode lockMode = LockMode.READ;
        private Map<String, List<String>> propertyMappings;

        private RootReturnBuilder(String string, String string2) {
            this.alias = string;
            this.entityName = string2;
        }

        public SQLQuery.RootReturn setLockMode(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        public SQLQuery.RootReturn setDiscriminatorAlias(String string) {
            this.addProperty("class", string);
            return this;
        }

        public SQLQuery.RootReturn addProperty(String string, String string2) {
            this.addProperty(string).addColumnAlias(string2);
            return this;
        }

        public SQLQuery.ReturnProperty addProperty(final String string) {
            if (this.propertyMappings == null) {
                this.propertyMappings = new HashMap<String, List<String>>();
            }
            return new SQLQuery.ReturnProperty(){

                public SQLQuery.ReturnProperty addColumnAlias(String string2) {
                    ArrayList<String> arrayList = (ArrayList<String>)RootReturnBuilder.this.propertyMappings.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string2);
                    return this;
                }
            };
        }

        public NativeSQLQueryReturn buildReturn() {
            return new NativeSQLQueryRootReturn(this.alias, this.entityName, this.propertyMappings, this.lockMode);
        }
    }
}

