/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.Cache;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MappingException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.QueryException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.StatelessSession;
import org.hibernate.TypeHelper;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.QueryCache;
import org.hibernate.cache.Region;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.impl.CacheDataDescriptionImpl;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Settings;
import org.hibernate.classic.Session;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.context.CurrentSessionContext;
import org.hibernate.context.JTASessionContext;
import org.hibernate.context.ManagedSessionContext;
import org.hibernate.context.ThreadLocalSessionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.query.QueryPlanCache;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.EventListeners;
import org.hibernate.exception.SQLExceptionConverter;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.impl.SessionFactoryObjectFactory;
import org.hibernate.impl.SessionImpl;
import org.hibernate.impl.StatelessSessionImpl;
import org.hibernate.impl.TypeLocatorImpl;
import org.hibernate.jdbc.BatcherFactory;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.persister.PersisterFactory;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.stat.ConcurrentStatisticsImpl;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private static final Logger log = LoggerFactory.getLogger(SessionFactoryImpl.class);
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private final String name;
    private final String uuid;
    private final transient Map entityPersisters;
    private final transient Map<String, ClassMetadata> classMetadata;
    private final transient Map collectionPersisters;
    private final transient Map collectionMetadata;
    private final transient Map<String, Set<String>> collectionRolesByEntityParticipant;
    private final transient Map identifierGenerators;
    private final transient Map namedQueries;
    private final transient Map namedSqlQueries;
    private final transient Map sqlResultSetMappings;
    private final transient Map filters;
    private final transient Map fetchProfiles;
    private final transient Map imports;
    private final transient Interceptor interceptor;
    private final transient Settings settings;
    private final transient Properties properties;
    private transient SchemaExport schemaExport;
    private final transient TransactionManager transactionManager;
    private final transient QueryCache queryCache;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient Map queryCaches;
    private final transient Map allCacheRegions = new HashMap();
    private final transient Statistics statistics;
    private final transient EventListeners eventListeners;
    private final transient CurrentSessionContext currentSessionContext;
    private final transient EntityNotFoundDelegate entityNotFoundDelegate;
    private final transient SQLFunctionRegistry sqlFunctionRegistry;
    private final transient SessionFactoryObserver observer;
    private final transient HashMap entityNameResolvers = new HashMap();
    private final transient QueryPlanCache queryPlanCache;
    private final transient Cache cacheAccess = new CacheImpl();
    private transient boolean isClosed = false;
    private final transient TypeResolver typeResolver;
    private final transient TypeHelper typeHelper;

    public SessionFactoryImpl(Configuration configuration, Mapping mapping, Settings settings, EventListeners eventListeners, SessionFactoryObserver sessionFactoryObserver) throws HibernateException {
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        Object object4;
        Object object52;
        Object object7;
        Object object8;
        Serializable serializable;
        Object object9;
        Object object10;
        log.info("building session factory");
        this.statistics = new ConcurrentStatisticsImpl(this);
        this.getStatistics().setStatisticsEnabled(settings.isStatisticsEnabled());
        log.debug("Statistics initialized [enabled={}]}", settings.isStatisticsEnabled());
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)configuration.getProperties());
        this.interceptor = configuration.getInterceptor();
        this.settings = settings;
        this.sqlFunctionRegistry = new SQLFunctionRegistry(settings.getDialect(), configuration.getSqlFunctions());
        this.eventListeners = eventListeners;
        this.observer = sessionFactoryObserver != null ? sessionFactoryObserver : new SessionFactoryObserver(){

            public void sessionFactoryCreated(SessionFactory sessionFactory) {
            }

            public void sessionFactoryClosed(SessionFactory sessionFactory) {
            }
        };
        this.typeResolver = configuration.getTypeResolver().scope(this);
        this.typeHelper = new TypeLocatorImpl(this.typeResolver);
        this.filters = new HashMap();
        this.filters.putAll(configuration.getFilterDefinitions());
        if (log.isDebugEnabled()) {
            log.debug("Session factory constructed with filter configurations : " + this.filters);
        }
        if (log.isDebugEnabled()) {
            log.debug("instantiating session factory with properties: " + this.properties);
        }
        settings.getRegionFactory().start(settings, this.properties);
        this.queryPlanCache = new QueryPlanCache(this);
        this.identifierGenerators = new HashMap();
        Iterator<PersistentClass> iterator3 = configuration.getClassMappings();
        while (iterator3.hasNext()) {
            object10 = iterator3.next();
            if (((PersistentClass)object10).isInherited()) continue;
            object9 = ((PersistentClass)object10).getIdentifier().createIdentifierGenerator(configuration.getIdentifierGeneratorFactory(), settings.getDialect(), settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (RootClass)object10);
            this.identifierGenerators.put(((PersistentClass)object10).getEntityName(), object9);
        }
        object10 = settings.getCacheRegionPrefix() == null ? "" : settings.getCacheRegionPrefix() + ".";
        this.entityPersisters = new HashMap();
        object9 = new HashMap();
        HashMap<String, ClassMetadata> hashMap = new HashMap<String, ClassMetadata>();
        iterator3 = configuration.getClassMappings();
        while (iterator3.hasNext()) {
            AccessType accessType;
            serializable = iterator3.next();
            ((PersistentClass)serializable).prepareTemporaryTables(mapping, settings.getDialect());
            object8 = (String)object10 + ((PersistentClass)serializable).getRootClass().getCacheRegionName();
            object7 = (EntityRegionAccessStrategy)object9.get(object8);
            if (object7 == null && settings.isSecondLevelCacheEnabled() && (accessType = AccessType.parse(((PersistentClass)serializable).getCacheConcurrencyStrategy())) != null) {
                log.trace("Building cache for entity data [" + ((PersistentClass)serializable).getEntityName() + "]");
                object52 = settings.getRegionFactory().buildEntityRegion((String)object8, this.properties, CacheDataDescriptionImpl.decode((PersistentClass)serializable));
                object7 = object52.buildAccessStrategy(accessType);
                object9.put(object8, object7);
                this.allCacheRegions.put(object8, object52);
            }
            EntityPersister iterator22 = PersisterFactory.createClassPersister((PersistentClass)serializable, object7, this, mapping);
            this.entityPersisters.put(((PersistentClass)serializable).getEntityName(), iterator22);
            hashMap.put(((PersistentClass)serializable).getEntityName(), iterator22.getClassMetadata());
        }
        this.classMetadata = Collections.unmodifiableMap(hashMap);
        serializable = new HashMap();
        this.collectionPersisters = new HashMap();
        object8 = configuration.getCollectionMappings();
        while (object8.hasNext()) {
            Type type;
            object7 = (Collection)object8.next();
            String string = (String)object10 + ((Collection)object7).getCacheRegionName();
            object52 = AccessType.parse(((Collection)object7).getCacheConcurrencyStrategy());
            object4 = null;
            if (object52 != null && settings.isSecondLevelCacheEnabled()) {
                log.trace("Building cache for collection data [" + ((Collection)object7).getRole() + "]");
                object3 = settings.getRegionFactory().buildCollectionRegion(string, this.properties, CacheDataDescriptionImpl.decode((Collection)object7));
                object4 = object3.buildAccessStrategy((AccessType)object52);
                object9.put(string, object4);
                this.allCacheRegions.put(string, object3);
            }
            object3 = PersisterFactory.createCollectionPersister(configuration, object7, object4, this);
            this.collectionPersisters.put(((Collection)object7).getRole(), object3.getCollectionMetadata());
            iterator = object3.getIndexType();
            if (iterator != null && iterator.isAssociationType() && !iterator.isAnyType()) {
                String string2 = ((AssociationType)((Object)iterator)).getAssociatedEntityName(this);
                object2 = (Set)serializable.get(string2);
                if (object2 == null) {
                    object2 = new HashSet<String>();
                    serializable.put(string2, object2);
                }
                object2.add(object3.getRole());
            }
            if (!(type = object3.getElementType()).isAssociationType() || type.isAnyType()) continue;
            object2 = ((AssociationType)type).getAssociatedEntityName(this);
            object = (HashSet<String>)serializable.get(object2);
            if (object == null) {
                object = new HashSet<String>();
                serializable.put(object2, object);
            }
            object.add(object3.getRole());
        }
        this.collectionMetadata = Collections.unmodifiableMap(this.collectionPersisters);
        for (Map.Entry entry : serializable.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
        this.collectionRolesByEntityParticipant = Collections.unmodifiableMap(serializable);
        this.namedQueries = new HashMap<String, NamedQueryDefinition>(configuration.getNamedQueries());
        this.namedSqlQueries = new HashMap(configuration.getNamedSQLQueries());
        this.sqlResultSetMappings = new HashMap(configuration.getSqlResultSetMappings());
        this.imports = new HashMap<String, String>(configuration.getImports());
        for (Object object52 : this.entityPersisters.values()) {
            object52.postInstantiate();
            this.registerEntityNameResolvers((EntityPersister)object52);
        }
        for (Object object52 : this.collectionPersisters.values()) {
            object52.postInstantiate();
        }
        this.name = settings.getSessionFactoryName();
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception exception) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, this.properties);
        log.debug("instantiated session factory");
        if (settings.isAutoCreateSchema()) {
            new SchemaExport(configuration, settings).create(false, true);
        }
        if (settings.isAutoUpdateSchema()) {
            new SchemaUpdate(configuration, settings).execute(false, true);
        }
        if (settings.isAutoValidateSchema()) {
            new SchemaValidator(configuration, settings).validate();
        }
        if (settings.isAutoDropSchema()) {
            this.schemaExport = new SchemaExport(configuration, settings);
        }
        if (settings.getTransactionManagerLookup() != null) {
            log.debug("obtaining JTA TransactionManager");
            this.transactionManager = settings.getTransactionManagerLookup().getTransactionManager(this.properties);
        } else {
            if (settings.getTransactionFactory().isTransactionManagerRequired()) {
                throw new HibernateException("The chosen transaction strategy requires access to the JTA TransactionManager");
            }
            this.transactionManager = null;
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        if (settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(settings, this.properties);
            this.queryCache = settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, settings, this.properties);
            this.queryCaches = new HashMap();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            this.allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
        if (settings.isNamedQueryStartupCheckingEnabled() && !(object52 = this.checkNamedQueries()).isEmpty()) {
            object4 = object52.keySet();
            object3 = new StringBuffer("Errors in named queries: ");
            iterator = object4.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                object2 = (HibernateException)object52.get(string);
                ((StringBuffer)object3).append(string);
                if (iterator.hasNext()) {
                    ((StringBuffer)object3).append(", ");
                }
                log.error("Error in named query: " + string, (Throwable)object2);
            }
            throw new HibernateException(((StringBuffer)object3).toString());
        }
        object52 = configuration.getEntityNotFoundDelegate();
        if (object52 == null) {
            object52 = new EntityNotFoundDelegate(){

                public void handleEntityNotFound(String string, Serializable serializable) {
                    throw new ObjectNotFoundException(serializable, string);
                }
            };
        }
        this.entityNotFoundDelegate = object52;
        this.fetchProfiles = new HashMap();
        object7 = configuration.iterateFetchProfiles();
        while (object7.hasNext()) {
            object4 = (org.hibernate.mapping.FetchProfile)object7.next();
            object3 = new FetchProfile(((org.hibernate.mapping.FetchProfile)object4).getName());
            for (FetchProfile.Fetch fetch : ((org.hibernate.mapping.FetchProfile)object4).getFetches()) {
                object2 = this.getImportedClassName(fetch.getEntity());
                object = object2 == null ? null : this.entityPersisters.get(object2);
                if (object == null) {
                    throw new HibernateException("Unable to resolve entity reference [" + fetch.getEntity() + "] in fetch profile [" + ((FetchProfile)object3).getName() + "]");
                }
                Type type = object.getPropertyType(fetch.getAssociation());
                if (type == null || !type.isAssociationType()) {
                    throw new HibernateException("Fetch profile [" + ((FetchProfile)object3).getName() + "] specified an invalid association");
                }
                Fetch.Style style = Fetch.Style.parse(fetch.getStyle());
                ((FetchProfile)object3).addFetch(new Association((EntityPersister)object, fetch.getAssociation()), style);
                ((Loadable)object).registerAffectingFetchProfile(((FetchProfile)object3).getName());
            }
            this.fetchProfiles.put(((FetchProfile)object3).getName(), object3);
        }
        this.observer.sessionFactoryCreated(this);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public IdentifierGeneratorFactory getIdentifierGeneratorFactory() {
        return null;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    private void registerEntityNameResolvers(EntityPersister entityPersister) {
        if (entityPersister.getEntityMetamodel() == null || entityPersister.getEntityMetamodel().getTuplizerMapping() == null) {
            return;
        }
        Iterator iterator = entityPersister.getEntityMetamodel().getTuplizerMapping().iterateTuplizers();
        while (iterator.hasNext()) {
            EntityTuplizer entityTuplizer = (EntityTuplizer)iterator.next();
            this.registerEntityNameResolvers(entityTuplizer);
        }
    }

    private void registerEntityNameResolvers(EntityTuplizer entityTuplizer) {
        EntityNameResolver[] entityNameResolverArray = entityTuplizer.getEntityNameResolvers();
        if (entityNameResolverArray == null) {
            return;
        }
        for (int i = 0; i < entityNameResolverArray.length; ++i) {
            this.registerEntityNameResolver(entityNameResolverArray[i], entityTuplizer.getEntityMode());
        }
    }

    public void registerEntityNameResolver(EntityNameResolver entityNameResolver, EntityMode entityMode) {
        LinkedHashSet<EntityNameResolver> linkedHashSet = (LinkedHashSet<EntityNameResolver>)this.entityNameResolvers.get(entityMode);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet<EntityNameResolver>();
            this.entityNameResolvers.put(entityMode, linkedHashSet);
        }
        linkedHashSet.add(entityNameResolver);
    }

    public Iterator iterateEntityNameResolvers(EntityMode entityMode) {
        Set set = (Set)this.entityNameResolvers.get(entityMode);
        return set == null ? EmptyIterator.INSTANCE : set.iterator();
    }

    @Override
    public QueryPlanCache getQueryPlanCache() {
        return this.queryPlanCache;
    }

    private Map checkNamedQueries() throws HibernateException {
        NamedQueryDefinition namedQueryDefinition;
        String string;
        HashMap<String, HibernateException> hashMap = new HashMap<String, HibernateException>();
        log.debug("Checking " + this.namedQueries.size() + " named HQL queries");
        for (Map.Entry entry : this.namedQueries.entrySet()) {
            string = (String)entry.getKey();
            namedQueryDefinition = (NamedQueryDefinition)entry.getValue();
            try {
                log.debug("Checking named query: " + string);
                this.queryPlanCache.getHQLQueryPlan(namedQueryDefinition.getQueryString(), false, CollectionHelper.EMPTY_MAP);
            }
            catch (QueryException queryException) {
                hashMap.put(string, queryException);
            }
            catch (MappingException mappingException) {
                hashMap.put(string, mappingException);
            }
        }
        log.debug("Checking " + this.namedSqlQueries.size() + " named SQL queries");
        for (Map.Entry entry : this.namedSqlQueries.entrySet()) {
            string = (String)entry.getKey();
            namedQueryDefinition = (NamedSQLQueryDefinition)entry.getValue();
            try {
                NativeSQLQuerySpecification nativeSQLQuerySpecification;
                log.debug("Checking named SQL query: " + string);
                if (((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef() != null) {
                    ResultSetMappingDefinition resultSetMappingDefinition = (ResultSetMappingDefinition)this.sqlResultSetMappings.get(((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef());
                    if (resultSetMappingDefinition == null) {
                        throw new MappingException("Unable to find resultset-ref definition: " + ((NamedSQLQueryDefinition)namedQueryDefinition).getResultSetRef());
                    }
                    nativeSQLQuerySpecification = new NativeSQLQuerySpecification(namedQueryDefinition.getQueryString(), resultSetMappingDefinition.getQueryReturns(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQuerySpaces());
                } else {
                    nativeSQLQuerySpecification = new NativeSQLQuerySpecification(namedQueryDefinition.getQueryString(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQueryReturns(), ((NamedSQLQueryDefinition)namedQueryDefinition).getQuerySpaces());
                }
                this.queryPlanCache.getNativeSQLQueryPlan(nativeSQLQuerySpecification);
            }
            catch (QueryException queryException) {
                hashMap.put(string, queryException);
            }
            catch (MappingException mappingException) {
                hashMap.put(string, mappingException);
            }
        }
        return hashMap;
    }

    @Override
    public StatelessSession openStatelessSession() {
        return new StatelessSessionImpl(null, this);
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return new StatelessSessionImpl(connection, this);
    }

    private SessionImpl openSession(Connection connection, boolean bl, long l, Interceptor interceptor) {
        return new SessionImpl(connection, this, bl, l, interceptor == null ? this.interceptor : interceptor, this.settings.getDefaultEntityMode(), this.settings.isFlushBeforeCompletionEnabled(), this.settings.isAutoCloseSessionEnabled(), this.settings.getConnectionReleaseMode());
    }

    @Override
    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, interceptor);
    }

    @Override
    public Session openSession(Interceptor interceptor) throws HibernateException {
        long l = this.settings.getRegionFactory().nextTimestamp();
        return this.openSession(null, true, l, interceptor);
    }

    @Override
    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    @Override
    public Session openSession() throws HibernateException {
        return this.openSession(this.interceptor);
    }

    @Override
    public Session openTemporarySession() throws HibernateException {
        return new SessionImpl(null, this, true, this.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), false, false, ConnectionReleaseMode.AFTER_STATEMENT);
    }

    @Override
    public Session openSession(Connection connection, boolean bl, boolean bl2, ConnectionReleaseMode connectionReleaseMode) throws HibernateException {
        return new SessionImpl(connection, this, true, this.settings.getRegionFactory().nextTimestamp(), this.interceptor, this.settings.getDefaultEntityMode(), bl, bl2, connectionReleaseMode);
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        if (this.currentSessionContext == null) {
            throw new HibernateException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public EntityPersister getEntityPersister(String string) throws MappingException {
        EntityPersister entityPersister = (EntityPersister)this.entityPersisters.get(string);
        if (entityPersister == null) {
            throw new MappingException("Unknown entity: " + string);
        }
        return entityPersister;
    }

    @Override
    public CollectionPersister getCollectionPersister(String string) throws MappingException {
        CollectionPersister collectionPersister = (CollectionPersister)this.collectionPersisters.get(string);
        if (collectionPersister == null) {
            throw new MappingException("Unknown collection role: " + string);
        }
        return collectionPersister;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Dialect getDialect() {
        return this.settings.getDialect();
    }

    @Override
    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public TransactionFactory getTransactionFactory() {
        return this.settings.getTransactionFactory();
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public SQLExceptionConverter getSQLExceptionConverter() {
        return this.settings.getSQLExceptionConverter();
    }

    @Override
    public Set<String> getCollectionRolesByEntityParticipant(String string) {
        return this.collectionRolesByEntityParticipant.get(string);
    }

    @Override
    public Reference getReference() throws NamingException {
        log.debug("Returning a Reference to the SessionFactory");
        return new Reference(SessionFactoryImpl.class.getName(), new StringRefAddr("uuid", this.uuid), SessionFactoryObjectFactory.class.getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        log.trace("Resolving serialized SessionFactory");
        Object object = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (object == null) {
            object = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (object == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug("resolved SessionFactory by name");
        } else {
            log.debug("resolved SessionFactory by uid");
        }
        return object;
    }

    @Override
    public NamedQueryDefinition getNamedQuery(String string) {
        return (NamedQueryDefinition)this.namedQueries.get(string);
    }

    @Override
    public NamedSQLQueryDefinition getNamedSQLQuery(String string) {
        return (NamedSQLQueryDefinition)this.namedSqlQueries.get(string);
    }

    @Override
    public ResultSetMappingDefinition getResultSetMapping(String string) {
        return (ResultSetMappingDefinition)this.sqlResultSetMappings.get(string);
    }

    @Override
    public Type getIdentifierType(String string) throws MappingException {
        return this.getEntityPersister(string).getIdentifierType();
    }

    @Override
    public String getIdentifierPropertyName(String string) throws MappingException {
        return this.getEntityPersister(string).getIdentifierPropertyName();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        log.trace("deserializing");
        objectInputStream.defaultReadObject();
        log.debug("deserialized: " + this.uuid);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        log.debug("serializing: " + this.uuid);
        objectOutputStream.defaultWriteObject();
        log.trace("serialized");
    }

    @Override
    public Type[] getReturnTypes(String string) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(string, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnTypes();
    }

    @Override
    public String[] getReturnAliases(String string) throws HibernateException {
        return this.queryPlanCache.getHQLQueryPlan(string, false, CollectionHelper.EMPTY_MAP).getReturnMetadata().getReturnAliases();
    }

    @Override
    public ClassMetadata getClassMetadata(Class clazz) throws HibernateException {
        return this.getClassMetadata(clazz.getName());
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String string) throws HibernateException {
        return (CollectionMetadata)this.collectionMetadata.get(string);
    }

    @Override
    public ClassMetadata getClassMetadata(String string) throws HibernateException {
        return this.classMetadata.get(string);
    }

    @Override
    public String[] getImplementors(String string) throws MappingException {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (EntityPersister entityPersister : this.entityPersisters.values()) {
            boolean bl;
            if (!(entityPersister instanceof Queryable)) continue;
            Queryable queryable = (Queryable)entityPersister;
            String string2 = queryable.getEntityName();
            boolean bl2 = string.equals(string2);
            if (queryable.isExplicitPolymorphism()) {
                if (!bl2) continue;
                return new String[]{string};
            }
            if (bl2) {
                arrayList.add(string2);
                continue;
            }
            Class clazz2 = queryable.getMappedClass(EntityMode.POJO);
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            if (queryable.isInherited()) {
                Class clazz3 = this.getEntityPersister(queryable.getMappedSuperclass()).getMappedClass(EntityMode.POJO);
                bl = clazz.isAssignableFrom(clazz3);
            } else {
                bl = false;
            }
            if (bl) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String getImportedClassName(String string) {
        String string2 = (String)this.imports.get(string);
        if (string2 == null) {
            try {
                ReflectHelper.classForName(string);
                return string;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return string2;
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() throws HibernateException {
        return this.classMetadata;
    }

    @Override
    public Map getAllCollectionMetadata() throws HibernateException {
        return this.collectionMetadata;
    }

    @Override
    public Type getReferencedPropertyType(String string, String string2) throws MappingException {
        return this.getEntityPersister(string).getPropertyType(string2);
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.settings.getConnectionProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HibernateException {
        if (this.isClosed) {
            log.trace("already closed");
            return;
        }
        log.info("closing");
        this.isClosed = true;
        for (Object object : this.entityPersisters.values()) {
            if (!object.hasCache()) continue;
            object.getCacheAccessStrategy().getRegion().destroy();
        }
        for (Object object : this.collectionPersisters.values()) {
            if (!object.hasCache()) continue;
            object.getCacheAccessStrategy().getRegion().destroy();
        }
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            for (Object object : this.queryCaches.values()) {
                object.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.settings.getRegionFactory().stop();
        if (this.settings.isAutoDropSchema()) {
            this.schemaExport.drop(false, true);
        }
        try {
            this.settings.getConnectionProvider().close();
        }
        finally {
            SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
        }
        this.observer.sessionFactoryClosed(this);
        this.eventListeners.destroyListeners();
    }

    @Override
    public Cache getCache() {
        return this.cacheAccess;
    }

    @Override
    public void evictEntity(String string, Serializable serializable) throws HibernateException {
        this.getCache().evictEntity(string, serializable);
    }

    @Override
    public void evictEntity(String string) throws HibernateException {
        this.getCache().evictEntityRegion(string);
    }

    @Override
    public void evict(Class clazz, Serializable serializable) throws HibernateException {
        this.getCache().evictEntity(clazz, serializable);
    }

    @Override
    public void evict(Class clazz) throws HibernateException {
        this.getCache().evictEntityRegion(clazz);
    }

    @Override
    public void evictCollection(String string, Serializable serializable) throws HibernateException {
        this.getCache().evictCollection(string, serializable);
    }

    @Override
    public void evictCollection(String string) throws HibernateException {
        this.getCache().evictCollectionRegion(string);
    }

    @Override
    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    @Override
    public void evictQueries(String string) throws HibernateException {
        this.getCache().evictQueryRegion(string);
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    @Override
    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCache getQueryCache(String string) throws HibernateException {
        if (string == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        Map map = this.allCacheRegions;
        synchronized (map) {
            QueryCache queryCache = (QueryCache)this.queryCaches.get(string);
            if (queryCache == null) {
                queryCache = this.settings.getQueryCacheFactory().getQueryCache(string, this.updateTimestampsCache, this.settings, this.properties);
                this.queryCaches.put(string, queryCache);
                this.allCacheRegions.put(queryCache.getRegion().getName(), queryCache.getRegion());
            }
            return queryCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region getSecondLevelCacheRegion(String string) {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return (Region)this.allCacheRegions.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getAllSecondLevelCacheRegions() {
        Map map = this.allCacheRegions;
        synchronized (map) {
            return new HashMap(this.allCacheRegions);
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return (StatisticsImplementor)((Object)this.statistics);
    }

    @Override
    public FilterDefinition getFilterDefinition(String string) throws HibernateException {
        FilterDefinition filterDefinition = (FilterDefinition)this.filters.get(string);
        if (filterDefinition == null) {
            throw new HibernateException("No such filter configured [" + string + "]");
        }
        return filterDefinition;
    }

    @Override
    public boolean containsFetchProfileDefinition(String string) {
        return this.fetchProfiles.containsKey(string);
    }

    @Override
    public Set getDefinedFilterNames() {
        return this.filters.keySet();
    }

    public BatcherFactory getBatcherFactory() {
        return this.settings.getBatcherFactory();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator(String string) {
        return (IdentifierGenerator)this.identifierGenerators.get(string);
    }

    private CurrentSessionContext buildCurrentSessionContext() {
        String string = this.properties.getProperty("hibernate.current_session_context_class");
        if (string == null && this.transactionManager != null) {
            string = "jta";
        }
        if (string == null) {
            return null;
        }
        if ("jta".equals(string)) {
            if (this.settings.getTransactionFactory().areCallbacksLocalToHibernateTransactions()) {
                log.warn("JTASessionContext being used with JDBCTransactionFactory; auto-flush will not operate correctly with getCurrentSession()");
            }
            return new JTASessionContext(this);
        }
        if ("thread".equals(string)) {
            return new ThreadLocalSessionContext(this);
        }
        if ("managed".equals(string)) {
            return new ManagedSessionContext(this);
        }
        try {
            Class clazz = ReflectHelper.classForName(string);
            return (CurrentSessionContext)clazz.getConstructor(SessionFactoryImplementor.class).newInstance(this);
        }
        catch (Throwable throwable) {
            log.error("Unable to construct current session context [" + string + "]", throwable);
            return null;
        }
    }

    public EventListeners getEventListeners() {
        return this.eventListeners;
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    @Override
    public SQLFunctionRegistry getSqlFunctionRegistry() {
        return this.sqlFunctionRegistry;
    }

    @Override
    public FetchProfile getFetchProfile(String string) {
        return (FetchProfile)this.fetchProfiles.get(string);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.uuid);
        objectOutputStream.writeBoolean(this.name != null);
        if (this.name != null) {
            objectOutputStream.writeUTF(this.name);
        }
    }

    static SessionFactoryImpl deserialize(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        String string = objectInputStream.readUTF();
        boolean bl = objectInputStream.readBoolean();
        String string2 = null;
        if (bl) {
            string2 = objectInputStream.readUTF();
        }
        if ((object = SessionFactoryObjectFactory.getInstance(string)) == null) {
            log.trace("could not locate session factory by uuid [" + string + "] during session deserialization; trying name");
            if (bl) {
                object = SessionFactoryObjectFactory.getNamedInstance(string2);
            }
            if (object == null) {
                throw new InvalidObjectException("could not resolve session factory during session deserialization [uuid=" + string + ", name=" + string2 + "]");
            }
        }
        return (SessionFactoryImpl)object;
    }

    private class CacheImpl
    implements Cache {
        private CacheImpl() {
        }

        public boolean containsEntity(Class clazz, Serializable serializable) {
            return this.containsEntity(clazz.getName(), serializable);
        }

        public boolean containsEntity(String string, Serializable serializable) {
            EntityPersister entityPersister = SessionFactoryImpl.this.getEntityPersister(string);
            return entityPersister.hasCache() && entityPersister.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(serializable, entityPersister));
        }

        public void evictEntity(Class clazz, Serializable serializable) {
            this.evictEntity(clazz.getName(), serializable);
        }

        public void evictEntity(String string, Serializable serializable) {
            EntityPersister entityPersister = SessionFactoryImpl.this.getEntityPersister(string);
            if (entityPersister.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + MessageHelper.infoString(entityPersister, serializable, (SessionFactoryImplementor)SessionFactoryImpl.this));
                }
                entityPersister.getCacheAccessStrategy().evict(this.buildCacheKey(serializable, entityPersister));
            }
        }

        private CacheKey buildCacheKey(Serializable serializable, EntityPersister entityPersister) {
            return new CacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName(), EntityMode.POJO, SessionFactoryImpl.this);
        }

        public void evictEntityRegion(Class clazz) {
            this.evictEntityRegion(clazz.getName());
        }

        public void evictEntityRegion(String string) {
            EntityPersister entityPersister = SessionFactoryImpl.this.getEntityPersister(string);
            if (entityPersister.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + entityPersister.getEntityName());
                }
                entityPersister.getCacheAccessStrategy().evictAll();
            }
        }

        public void evictEntityRegions() {
            Iterator iterator = SessionFactoryImpl.this.entityPersisters.keySet().iterator();
            while (iterator.hasNext()) {
                this.evictEntityRegion((String)iterator.next());
            }
        }

        public boolean containsCollection(String string, Serializable serializable) {
            CollectionPersister collectionPersister = SessionFactoryImpl.this.getCollectionPersister(string);
            return collectionPersister.hasCache() && collectionPersister.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(serializable, collectionPersister));
        }

        public void evictCollection(String string, Serializable serializable) {
            CollectionPersister collectionPersister = SessionFactoryImpl.this.getCollectionPersister(string);
            if (collectionPersister.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + MessageHelper.collectionInfoString(collectionPersister, serializable, (SessionFactoryImplementor)SessionFactoryImpl.this));
                }
                CacheKey cacheKey = this.buildCacheKey(serializable, collectionPersister);
                collectionPersister.getCacheAccessStrategy().evict(cacheKey);
            }
        }

        private CacheKey buildCacheKey(Serializable serializable, CollectionPersister collectionPersister) {
            return new CacheKey(serializable, collectionPersister.getKeyType(), collectionPersister.getRole(), EntityMode.POJO, SessionFactoryImpl.this);
        }

        public void evictCollectionRegion(String string) {
            CollectionPersister collectionPersister = SessionFactoryImpl.this.getCollectionPersister(string);
            if (collectionPersister.hasCache()) {
                if (log.isDebugEnabled()) {
                    log.debug("evicting second-level cache: " + collectionPersister.getRole());
                }
                collectionPersister.getCacheAccessStrategy().evictAll();
            }
        }

        public void evictCollectionRegions() {
            Iterator iterator = SessionFactoryImpl.this.collectionPersisters.keySet().iterator();
            while (iterator.hasNext()) {
                this.evictCollectionRegion((String)iterator.next());
            }
        }

        public boolean containsQuery(String string) {
            return SessionFactoryImpl.this.queryCaches.get(string) != null;
        }

        public void evictDefaultQueryRegion() {
            if (SessionFactoryImpl.this.settings.isQueryCacheEnabled()) {
                SessionFactoryImpl.this.queryCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evictQueryRegion(String string) {
            if (string == null) {
                throw new NullPointerException("Region-name cannot be null (use Cache#evictDefaultQueryRegion to evict the default query cache)");
            }
            Map map = SessionFactoryImpl.this.allCacheRegions;
            synchronized (map) {
                QueryCache queryCache;
                if (SessionFactoryImpl.this.settings.isQueryCacheEnabled() && (queryCache = (QueryCache)SessionFactoryImpl.this.queryCaches.get(string)) != null) {
                    queryCache.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evictQueryRegions() {
            Map map = SessionFactoryImpl.this.allCacheRegions;
            synchronized (map) {
                for (QueryCache queryCache : SessionFactoryImpl.this.queryCaches.values()) {
                    queryCache.clear();
                }
            }
        }
    }
}

