/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.spi.ObjectFactory;
import org.hibernate.SessionFactory;
import org.hibernate.util.NamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFactoryObjectFactory
implements ObjectFactory {
    private static final SessionFactoryObjectFactory INSTANCE;
    private static final Logger log;
    private static final ConcurrentHashMap<String, SessionFactory> INSTANCES;
    private static final ConcurrentHashMap<String, SessionFactory> NAMED_INSTANCES;
    private static final NamingListener LISTENER;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        log.debug("JNDI lookup: " + name);
        String string = (String)((Reference)object).get(0).getContent();
        return SessionFactoryObjectFactory.getInstance(string);
    }

    public static void addInstance(String string, String string2, SessionFactory sessionFactory, Properties properties) {
        log.debug("registered: " + string + " (" + (string2 == null ? "unnamed" : string2) + ')');
        INSTANCES.put(string, sessionFactory);
        if (string2 != null) {
            NAMED_INSTANCES.put(string2, sessionFactory);
        }
        if (string2 == null) {
            log.info("Not binding factory to JNDI, no JNDI name configured");
        } else {
            log.info("Factory name: " + string2);
            try {
                InitialContext initialContext = NamingHelper.getInitialContext(properties);
                NamingHelper.bind(initialContext, string2, sessionFactory);
                log.info("Bound factory to JNDI name: " + string2);
                ((EventContext)((Object)initialContext)).addNamingListener(string2, 0, LISTENER);
            }
            catch (InvalidNameException invalidNameException) {
                log.error("Invalid JNDI name: " + string2, invalidNameException);
            }
            catch (NamingException namingException) {
                log.warn("Could not bind factory to JNDI", namingException);
            }
            catch (ClassCastException classCastException) {
                log.warn("InitialContext did not implement EventContext");
            }
        }
    }

    public static void removeInstance(String string, String string2, Properties properties) {
        if (string2 != null) {
            log.info("Unbinding factory from JNDI name: " + string2);
            try {
                InitialContext initialContext = NamingHelper.getInitialContext(properties);
                initialContext.unbind(string2);
                log.info("Unbound factory from JNDI name: " + string2);
            }
            catch (InvalidNameException invalidNameException) {
                log.error("Invalid JNDI name: " + string2, invalidNameException);
            }
            catch (NamingException namingException) {
                log.warn("Could not unbind factory from JNDI", namingException);
            }
            NAMED_INSTANCES.remove(string2);
        }
        INSTANCES.remove(string);
    }

    public static Object getNamedInstance(String string) {
        log.debug("lookup: name=" + string);
        SessionFactory sessionFactory = NAMED_INSTANCES.get(string);
        if (sessionFactory == null) {
            log.debug("Not found: " + string);
            log.debug(NAMED_INSTANCES.toString());
        }
        return sessionFactory;
    }

    public static Object getInstance(String string) {
        log.debug("lookup: uid=" + string);
        SessionFactory sessionFactory = INSTANCES.get(string);
        if (sessionFactory == null) {
            log.debug("Not found: " + string);
            log.debug(INSTANCES.toString());
        }
        return sessionFactory;
    }

    static {
        log = LoggerFactory.getLogger(SessionFactoryObjectFactory.class);
        INSTANCE = new SessionFactoryObjectFactory();
        log.debug("initializing class SessionFactoryObjectFactory");
        INSTANCES = new ConcurrentHashMap();
        NAMED_INSTANCES = new ConcurrentHashMap();
        LISTENER = new NamespaceChangeListener(){

            public void objectAdded(NamingEvent namingEvent) {
                log.debug("A factory was successfully bound to name: " + namingEvent.getNewBinding().getName());
            }

            public void objectRemoved(NamingEvent namingEvent) {
                String string = namingEvent.getOldBinding().getName();
                log.info("A factory was unbound from name: " + string);
                Object v = NAMED_INSTANCES.remove(string);
                Iterator iterator = INSTANCES.values().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != v) continue;
                    iterator.remove();
                }
            }

            public void objectRenamed(NamingEvent namingEvent) {
                String string = namingEvent.getOldBinding().getName();
                log.info("A factory was renamed from name: " + string);
                NAMED_INSTANCES.put(namingEvent.getNewBinding().getName(), NAMED_INSTANCES.remove(string));
            }

            public void namingExceptionThrown(NamingExceptionEvent namingExceptionEvent) {
                log.warn("Naming exception occurred accessing factory: " + namingExceptionEvent.getException());
            }
        };
    }
}

