/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.NonFlushedChanges;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.StatefulPersistenceContext;
import org.hibernate.engine.Status;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.query.FilterQueryPlan;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.DeleteEvent;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.DirtyCheckEvent;
import org.hibernate.event.DirtyCheckEventListener;
import org.hibernate.event.EventListeners;
import org.hibernate.event.EventSource;
import org.hibernate.event.EvictEvent;
import org.hibernate.event.EvictEventListener;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.FlushEventListener;
import org.hibernate.event.InitializeCollectionEvent;
import org.hibernate.event.InitializeCollectionEventListener;
import org.hibernate.event.LoadEvent;
import org.hibernate.event.LoadEventListener;
import org.hibernate.event.LockEvent;
import org.hibernate.event.LockEventListener;
import org.hibernate.event.MergeEvent;
import org.hibernate.event.MergeEventListener;
import org.hibernate.event.PersistEvent;
import org.hibernate.event.PersistEventListener;
import org.hibernate.event.RefreshEvent;
import org.hibernate.event.RefreshEventListener;
import org.hibernate.event.ReplicateEvent;
import org.hibernate.event.ReplicateEventListener;
import org.hibernate.event.SaveOrUpdateEvent;
import org.hibernate.event.SaveOrUpdateEventListener;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.impl.AbstractSessionImpl;
import org.hibernate.impl.CollectionFilterImpl;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.impl.FilterImpl;
import org.hibernate.impl.NonFlushedChangesImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.JDBCContext;
import org.hibernate.jdbc.Work;
import org.hibernate.loader.criteria.CriteriaLoader;
import org.hibernate.loader.custom.CustomLoader;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.stat.SessionStatisticsImpl;
import org.hibernate.type.SerializationException;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionImpl
extends AbstractSessionImpl
implements EventSource,
org.hibernate.classic.Session,
JDBCContext.Context,
LobCreationContext {
    private static final Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private transient EntityMode entityMode = EntityMode.POJO;
    private transient boolean autoClear;
    private transient long timestamp;
    private transient FlushMode flushMode = FlushMode.AUTO;
    private transient CacheMode cacheMode = CacheMode.NORMAL;
    private transient Interceptor interceptor;
    private transient int dontFlushFromFind = 0;
    private transient ActionQueue actionQueue;
    private transient StatefulPersistenceContext persistenceContext;
    private transient JDBCContext jdbcContext;
    private transient EventListeners listeners;
    private transient boolean flushBeforeCompletionEnabled;
    private transient boolean autoCloseSessionEnabled;
    private transient ConnectionReleaseMode connectionReleaseMode;
    private transient LoadQueryInfluencers loadQueryInfluencers;
    private transient Session rootSession;
    private transient Map childSessionsByEntityMode;
    private transient EntityNameResolver entityNameResolver = new CoordinatingEntityNameResolver();
    private transient LobHelperImpl lobHelper;

    private SessionImpl(SessionImpl sessionImpl, EntityMode entityMode) {
        super(sessionImpl.factory);
        this.rootSession = sessionImpl;
        this.timestamp = sessionImpl.timestamp;
        this.jdbcContext = sessionImpl.jdbcContext;
        this.interceptor = sessionImpl.interceptor;
        this.listeners = sessionImpl.listeners;
        this.actionQueue = new ActionQueue(this);
        this.entityMode = entityMode;
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.flushBeforeCompletionEnabled = false;
        this.autoCloseSessionEnabled = false;
        this.connectionReleaseMode = null;
        this.loadQueryInfluencers = new LoadQueryInfluencers(this.factory);
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().openSession();
        }
        log.debug("opened session [" + entityMode + "]");
    }

    SessionImpl(Connection connection, SessionFactoryImpl sessionFactoryImpl, boolean bl, long l, Interceptor interceptor, EntityMode entityMode, boolean bl2, boolean bl3, ConnectionReleaseMode connectionReleaseMode) {
        super(sessionFactoryImpl);
        this.rootSession = null;
        this.timestamp = l;
        this.entityMode = entityMode;
        this.interceptor = interceptor;
        this.listeners = sessionFactoryImpl.getEventListeners();
        this.actionQueue = new ActionQueue(this);
        this.persistenceContext = new StatefulPersistenceContext(this);
        this.flushBeforeCompletionEnabled = bl2;
        this.autoCloseSessionEnabled = bl3;
        this.connectionReleaseMode = connectionReleaseMode;
        this.jdbcContext = new JDBCContext(this, connection, interceptor);
        this.loadQueryInfluencers = new LoadQueryInfluencers(sessionFactoryImpl);
        if (sessionFactoryImpl.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImpl.getStatisticsImplementor().openSession();
        }
        if (log.isDebugEnabled()) {
            log.debug("opened session at timestamp: " + l);
        }
    }

    public Session getSession(EntityMode entityMode) {
        if (this.entityMode == entityMode) {
            return this;
        }
        if (this.rootSession != null) {
            return this.rootSession.getSession(entityMode);
        }
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SessionImpl sessionImpl = null;
        if (this.childSessionsByEntityMode == null) {
            this.childSessionsByEntityMode = new HashMap();
        } else {
            sessionImpl = (SessionImpl)this.childSessionsByEntityMode.get(entityMode);
        }
        if (sessionImpl == null) {
            sessionImpl = new SessionImpl(this, entityMode);
            this.childSessionsByEntityMode.put(entityMode, sessionImpl);
        }
        return sessionImpl;
    }

    public void clear() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.clear();
        this.actionQueue.clear();
    }

    public Batcher getBatcher() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.jdbcContext.getConnectionManager().getBatcher();
    }

    public long getTimestamp() {
        this.checkTransactionSynchStatus();
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection close() throws HibernateException {
        log.trace("closing session");
        if (this.isClosed()) {
            throw new SessionException("Session was already closed");
        }
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().closeSession();
        }
        try {
            Object object;
            try {
                if (this.childSessionsByEntityMode != null) {
                    for (SessionImpl sessionImpl : this.childSessionsByEntityMode.values()) {
                        sessionImpl.close();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.rootSession == null) {
                object = this.jdbcContext.getConnectionManager().close();
                return object;
            }
            object = null;
            return object;
        }
        finally {
            this.setClosed();
            this.cleanup();
        }
    }

    public ConnectionReleaseMode getConnectionReleaseMode() {
        this.checkTransactionSynchStatus();
        return this.connectionReleaseMode;
    }

    public boolean isAutoCloseSessionEnabled() {
        return this.autoCloseSessionEnabled;
    }

    public boolean isOpen() {
        this.checkTransactionSynchStatus();
        return !this.isClosed();
    }

    public boolean isFlushModeNever() {
        return FlushMode.isManualFlushMode(this.getFlushMode());
    }

    public boolean isFlushBeforeCompletionEnabled() {
        return this.flushBeforeCompletionEnabled;
    }

    public void managedFlush() {
        if (this.isClosed()) {
            log.trace("skipping auto-flush due to session closed");
            return;
        }
        log.trace("automatically flushing session");
        this.flush();
        if (this.childSessionsByEntityMode != null) {
            Iterator iterator = this.childSessionsByEntityMode.values().iterator();
            while (iterator.hasNext()) {
                ((Session)iterator.next()).flush();
            }
        }
    }

    public NonFlushedChanges getNonFlushedChanges() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        NonFlushedChangesImpl nonFlushedChangesImpl = new NonFlushedChangesImpl(this);
        if (this.childSessionsByEntityMode != null) {
            Iterator iterator = this.childSessionsByEntityMode.values().iterator();
            while (iterator.hasNext()) {
                nonFlushedChangesImpl.extractFromSession((EventSource)iterator.next());
            }
        }
        return nonFlushedChangesImpl;
    }

    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.replacePersistenceContext(((NonFlushedChangesImpl)nonFlushedChanges).getPersistenceContext(this.entityMode));
        this.replaceActionQueue(((NonFlushedChangesImpl)nonFlushedChanges).getActionQueue(this.entityMode));
        if (this.childSessionsByEntityMode != null) {
            Iterator iterator = this.childSessionsByEntityMode.values().iterator();
            while (iterator.hasNext()) {
                ((SessionImpl)iterator.next()).applyNonFlushedChanges(nonFlushedChanges);
            }
        }
    }

    private void replacePersistenceContext(StatefulPersistenceContext statefulPersistenceContext) {
        if (statefulPersistenceContext.getSession() != null) {
            throw new IllegalStateException("new persistence context is already connected to a session ");
        }
        this.persistenceContext.clear();
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializePersistenceContext(statefulPersistenceContext)));
            this.persistenceContext = StatefulPersistenceContext.deserialize(objectInputStream, this);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not deserialize the persistence context", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("could not deserialize the persistence context", classNotFoundException);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] serializePersistenceContext(StatefulPersistenceContext statefulPersistenceContext) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            statefulPersistenceContext.serialize(objectOutputStream);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not serialize persistence context", iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void replaceActionQueue(ActionQueue actionQueue) {
        if (this.actionQueue.hasAnyQueuedActions()) {
            throw new IllegalStateException("cannot replace an ActionQueue with queued actions ");
        }
        this.actionQueue.clear();
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new ByteArrayInputStream(SessionImpl.serializeActionQueue(actionQueue)));
            this.actionQueue = ActionQueue.deserialize(objectInputStream, this);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not deserialize the action queue", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SerializationException("could not deserialize the action queue", classNotFoundException);
        }
        finally {
            try {
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] serializeActionQueue(ActionQueue actionQueue) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            actionQueue.serialize(objectOutputStream);
        }
        catch (IOException iOException) {
            throw new SerializationException("could not serialize action queue", iOException);
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean shouldAutoClose() {
        return this.isAutoCloseSessionEnabled() && !this.isClosed();
    }

    public void managedClose() {
        log.trace("automatically closing session");
        this.close();
    }

    public Connection connection() throws HibernateException {
        this.errorIfClosed();
        return this.jdbcContext.borrowConnection();
    }

    public boolean isConnected() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.jdbcContext.getConnectionManager().isCurrentlyConnected();
    }

    public boolean isTransactionInProgress() {
        this.checkTransactionSynchStatus();
        return !this.isClosed() && this.jdbcContext.isTransactionInProgress();
    }

    public Connection disconnect() throws HibernateException {
        this.errorIfClosed();
        log.debug("disconnecting session");
        return this.jdbcContext.getConnectionManager().manualDisconnect();
    }

    public void reconnect() throws HibernateException {
        this.errorIfClosed();
        log.debug("reconnecting session");
        this.checkTransactionSynchStatus();
        this.jdbcContext.getConnectionManager().manualReconnect();
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.errorIfClosed();
        log.debug("reconnecting session");
        this.checkTransactionSynchStatus();
        this.jdbcContext.getConnectionManager().manualReconnect(connection);
    }

    public void beforeTransactionCompletion(Transaction transaction) {
        log.trace("before transaction completion");
        this.actionQueue.beforeTransactionCompletion();
        if (this.rootSession == null) {
            try {
                this.interceptor.beforeTransactionCompletion(transaction);
            }
            catch (Throwable throwable) {
                log.error("exception in interceptor beforeTransactionCompletion()", throwable);
            }
        }
    }

    public void setAutoClear(boolean bl) {
        this.errorIfClosed();
        this.autoClear = bl;
    }

    public void afterOperation(boolean bl) {
        if (!this.jdbcContext.isTransactionInProgress()) {
            this.jdbcContext.afterNontransactionalQuery(bl);
        }
    }

    public void afterTransactionCompletion(boolean bl, Transaction transaction) {
        log.trace("after transaction completion");
        this.persistenceContext.afterTransactionCompletion();
        this.actionQueue.afterTransactionCompletion(bl);
        if (this.rootSession == null && transaction != null) {
            try {
                this.interceptor.afterTransactionCompletion(transaction);
            }
            catch (Throwable throwable) {
                log.error("exception in interceptor afterTransactionCompletion()", throwable);
            }
        }
        if (this.autoClear) {
            this.clear();
        }
    }

    private void cleanup() {
        this.persistenceContext.clear();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object == null) {
            throw new NullPointerException("null object passed to getCurrentLockMode()");
        }
        if (object instanceof HibernateProxy && (object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry entityEntry = this.persistenceContext.getEntry(object);
        if (entityEntry == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (entityEntry.getStatus() != Status.MANAGED) {
            throw new ObjectDeletedException("The given object was deleted", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        return entityEntry.getLockMode();
    }

    public Object getEntityUsingInterceptor(EntityKey entityKey) throws HibernateException {
        this.errorIfClosed();
        Object object = this.persistenceContext.getEntity(entityKey);
        if (object == null) {
            Object object2 = this.interceptor.getEntity(entityKey.getEntityName(), entityKey.getIdentifier());
            if (object2 != null) {
                try {
                    this.lock(object2, LockMode.NONE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object2;
        }
        return object;
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.saveOrUpdate(null, object);
    }

    public void saveOrUpdate(String string, Object object) throws HibernateException {
        this.fireSaveOrUpdate(new SaveOrUpdateEvent(string, object, this));
    }

    private void fireSaveOrUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SaveOrUpdateEventListener[] saveOrUpdateEventListenerArray = this.listeners.getSaveOrUpdateEventListeners();
        for (int i = 0; i < saveOrUpdateEventListenerArray.length; ++i) {
            saveOrUpdateEventListenerArray[i].onSaveOrUpdate(saveOrUpdateEvent);
        }
    }

    public void save(Object object, Serializable serializable) throws HibernateException {
        this.save(null, object, serializable);
    }

    public Serializable save(Object object) throws HibernateException {
        return this.save(null, object);
    }

    public Serializable save(String string, Object object) throws HibernateException {
        return this.fireSave(new SaveOrUpdateEvent(string, object, this));
    }

    public void save(String string, Object object, Serializable serializable) throws HibernateException {
        this.fireSave(new SaveOrUpdateEvent(string, object, serializable, this));
    }

    private Serializable fireSave(SaveOrUpdateEvent saveOrUpdateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SaveOrUpdateEventListener[] saveOrUpdateEventListenerArray = this.listeners.getSaveEventListeners();
        for (int i = 0; i < saveOrUpdateEventListenerArray.length; ++i) {
            saveOrUpdateEventListenerArray[i].onSaveOrUpdate(saveOrUpdateEvent);
        }
        return saveOrUpdateEvent.getResultId();
    }

    public void update(Object object) throws HibernateException {
        this.update(null, object);
    }

    public void update(Object object, Serializable serializable) throws HibernateException {
        this.update(null, object, serializable);
    }

    public void update(String string, Object object) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(string, object, this));
    }

    public void update(String string, Object object, Serializable serializable) throws HibernateException {
        this.fireUpdate(new SaveOrUpdateEvent(string, object, serializable, this));
    }

    private void fireUpdate(SaveOrUpdateEvent saveOrUpdateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        SaveOrUpdateEventListener[] saveOrUpdateEventListenerArray = this.listeners.getUpdateEventListeners();
        for (int i = 0; i < saveOrUpdateEventListenerArray.length; ++i) {
            saveOrUpdateEventListenerArray[i].onSaveOrUpdate(saveOrUpdateEvent);
        }
    }

    public void lock(String string, Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(string, object, lockMode, (EventSource)this));
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return new LockRequestImpl(lockOptions);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.fireLock(new LockEvent(object, lockMode, (EventSource)this));
    }

    private void fireLock(String string, Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(string, object, lockOptions, (EventSource)this));
    }

    private void fireLock(Object object, LockOptions lockOptions) {
        this.fireLock(new LockEvent(object, lockOptions, (EventSource)this));
    }

    private void fireLock(LockEvent lockEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LockEventListener[] lockEventListenerArray = this.listeners.getLockEventListeners();
        for (int i = 0; i < lockEventListenerArray.length; ++i) {
            lockEventListenerArray[i].onLock(lockEvent);
        }
    }

    public void persist(String string, Object object) throws HibernateException {
        this.firePersist(new PersistEvent(string, object, this));
    }

    public void persist(Object object) throws HibernateException {
        this.persist(null, object);
    }

    public void persist(String string, Object object, Map map) throws HibernateException {
        this.firePersist(map, new PersistEvent(string, object, this));
    }

    private void firePersist(Map map, PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] persistEventListenerArray = this.listeners.getPersistEventListeners();
        for (int i = 0; i < persistEventListenerArray.length; ++i) {
            persistEventListenerArray[i].onPersist(persistEvent, map);
        }
    }

    private void firePersist(PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] persistEventListenerArray = this.listeners.getPersistEventListeners();
        for (int i = 0; i < persistEventListenerArray.length; ++i) {
            persistEventListenerArray[i].onPersist(persistEvent);
        }
    }

    public void persistOnFlush(String string, Object object) throws HibernateException {
        this.firePersistOnFlush(new PersistEvent(string, object, this));
    }

    public void persistOnFlush(Object object) throws HibernateException {
        this.persist(null, object);
    }

    public void persistOnFlush(String string, Object object, Map map) throws HibernateException {
        this.firePersistOnFlush(map, new PersistEvent(string, object, this));
    }

    private void firePersistOnFlush(Map map, PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] persistEventListenerArray = this.listeners.getPersistOnFlushEventListeners();
        for (int i = 0; i < persistEventListenerArray.length; ++i) {
            persistEventListenerArray[i].onPersist(persistEvent, map);
        }
    }

    private void firePersistOnFlush(PersistEvent persistEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        PersistEventListener[] persistEventListenerArray = this.listeners.getPersistOnFlushEventListeners();
        for (int i = 0; i < persistEventListenerArray.length; ++i) {
            persistEventListenerArray[i].onPersist(persistEvent);
        }
    }

    public Object merge(String string, Object object) throws HibernateException {
        return this.fireMerge(new MergeEvent(string, object, this));
    }

    public Object merge(Object object) throws HibernateException {
        return this.merge(null, object);
    }

    public void merge(String string, Object object, Map map) throws HibernateException {
        this.fireMerge(map, new MergeEvent(string, object, this));
    }

    private Object fireMerge(MergeEvent mergeEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] mergeEventListenerArray = this.listeners.getMergeEventListeners();
        for (int i = 0; i < mergeEventListenerArray.length; ++i) {
            mergeEventListenerArray[i].onMerge(mergeEvent);
        }
        return mergeEvent.getResult();
    }

    private void fireMerge(Map map, MergeEvent mergeEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] mergeEventListenerArray = this.listeners.getMergeEventListeners();
        for (int i = 0; i < mergeEventListenerArray.length; ++i) {
            mergeEventListenerArray[i].onMerge(mergeEvent, map);
        }
    }

    public Object saveOrUpdateCopy(String string, Object object) throws HibernateException {
        return this.fireSaveOrUpdateCopy(new MergeEvent(string, object, this));
    }

    public Object saveOrUpdateCopy(Object object) throws HibernateException {
        return this.saveOrUpdateCopy(null, object);
    }

    public Object saveOrUpdateCopy(String string, Object object, Serializable serializable) throws HibernateException {
        return this.fireSaveOrUpdateCopy(new MergeEvent(string, object, serializable, this));
    }

    public Object saveOrUpdateCopy(Object object, Serializable serializable) throws HibernateException {
        return this.saveOrUpdateCopy(null, object, serializable);
    }

    public void saveOrUpdateCopy(String string, Object object, Map map) throws HibernateException {
        this.fireSaveOrUpdateCopy(map, new MergeEvent(string, object, this));
    }

    private void fireSaveOrUpdateCopy(Map map, MergeEvent mergeEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] mergeEventListenerArray = this.listeners.getSaveOrUpdateCopyEventListeners();
        for (int i = 0; i < mergeEventListenerArray.length; ++i) {
            mergeEventListenerArray[i].onMerge(mergeEvent, map);
        }
    }

    private Object fireSaveOrUpdateCopy(MergeEvent mergeEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        MergeEventListener[] mergeEventListenerArray = this.listeners.getSaveOrUpdateCopyEventListeners();
        for (int i = 0; i < mergeEventListenerArray.length; ++i) {
            mergeEventListenerArray[i].onMerge(mergeEvent);
        }
        return mergeEvent.getResult();
    }

    public void delete(Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(object, this));
    }

    public void delete(String string, Object object) throws HibernateException {
        this.fireDelete(new DeleteEvent(string, object, this));
    }

    public void delete(String string, Object object, boolean bl, Set set) throws HibernateException {
        this.fireDelete(new DeleteEvent(string, object, bl, this), set);
    }

    private void fireDelete(DeleteEvent deleteEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        DeleteEventListener[] deleteEventListenerArray = this.listeners.getDeleteEventListeners();
        for (int i = 0; i < deleteEventListenerArray.length; ++i) {
            deleteEventListenerArray[i].onDelete(deleteEvent);
        }
    }

    private void fireDelete(DeleteEvent deleteEvent, Set set) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        DeleteEventListener[] deleteEventListenerArray = this.listeners.getDeleteEventListeners();
        for (int i = 0; i < deleteEventListenerArray.length; ++i) {
            deleteEventListenerArray[i].onDelete(deleteEvent, set);
        }
    }

    public void load(Object object, Serializable serializable) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, object, this);
        this.fireLoad(loadEvent, LoadEventListener.RELOAD);
    }

    public Object load(Class clazz, Serializable serializable) throws HibernateException {
        return this.load(clazz.getName(), serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String string, Serializable serializable) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, string, false, (EventSource)this);
        boolean bl = false;
        try {
            this.fireLoad(loadEvent, LoadEventListener.LOAD);
            if (loadEvent.getResult() == null) {
                this.getFactory().getEntityNotFoundDelegate().handleEntityNotFound(string, serializable);
            }
            bl = true;
            Object object = loadEvent.getResult();
            return object;
        }
        finally {
            this.afterOperation(bl);
        }
    }

    public Object get(Class clazz, Serializable serializable) throws HibernateException {
        return this.get(clazz.getName(), serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String string, Serializable serializable) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, string, false, (EventSource)this);
        boolean bl = false;
        try {
            this.fireLoad(loadEvent, LoadEventListener.GET);
            bl = true;
            Object object = loadEvent.getResult();
            return object;
        }
        finally {
            this.afterOperation(bl);
        }
    }

    public Object immediateLoad(String string, Serializable serializable) throws HibernateException {
        Object object;
        if (log.isDebugEnabled()) {
            object = this.getFactory().getEntityPersister(string);
            log.debug("initializing proxy: " + MessageHelper.infoString((EntityPersister)object, serializable, this.getFactory()));
        }
        object = new LoadEvent(serializable, string, true, (EventSource)this);
        this.fireLoad((LoadEvent)object, LoadEventListener.IMMEDIATE_LOAD);
        return ((LoadEvent)object).getResult();
    }

    public Object internalLoad(String string, Serializable serializable, boolean bl, boolean bl2) throws HibernateException {
        LoadEventListener.LoadType loadType = bl2 ? LoadEventListener.INTERNAL_LOAD_NULLABLE : (bl ? LoadEventListener.INTERNAL_LOAD_EAGER : LoadEventListener.INTERNAL_LOAD_LAZY);
        LoadEvent loadEvent = new LoadEvent(serializable, string, true, (EventSource)this);
        this.fireLoad(loadEvent, loadType);
        if (!bl2) {
            UnresolvableObjectException.throwIfNull(loadEvent.getResult(), serializable, string);
        }
        return loadEvent.getResult();
    }

    public Object load(Class clazz, Serializable serializable, LockMode lockMode) throws HibernateException {
        return this.load(clazz.getName(), serializable, lockMode);
    }

    public Object load(Class clazz, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.load(clazz.getName(), serializable, lockOptions);
    }

    public Object load(String string, Serializable serializable, LockMode lockMode) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, string, lockMode, (EventSource)this);
        this.fireLoad(loadEvent, LoadEventListener.LOAD);
        return loadEvent.getResult();
    }

    public Object load(String string, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, string, lockOptions, (EventSource)this);
        this.fireLoad(loadEvent, LoadEventListener.LOAD);
        return loadEvent.getResult();
    }

    public Object get(Class clazz, Serializable serializable, LockMode lockMode) throws HibernateException {
        return this.get(clazz.getName(), serializable, lockMode);
    }

    public Object get(Class clazz, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        return this.get(clazz.getName(), serializable, lockOptions);
    }

    public Object get(String string, Serializable serializable, LockMode lockMode) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, string, lockMode, (EventSource)this);
        this.fireLoad(loadEvent, LoadEventListener.GET);
        return loadEvent.getResult();
    }

    public Object get(String string, Serializable serializable, LockOptions lockOptions) throws HibernateException {
        LoadEvent loadEvent = new LoadEvent(serializable, string, lockOptions, (EventSource)this);
        this.fireLoad(loadEvent, LoadEventListener.GET);
        return loadEvent.getResult();
    }

    private void fireLoad(LoadEvent loadEvent, LoadEventListener.LoadType loadType) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        LoadEventListener[] loadEventListenerArray = this.listeners.getLoadEventListeners();
        for (int i = 0; i < loadEventListenerArray.length; ++i) {
            loadEventListenerArray[i].onLoad(loadEvent, loadType);
        }
    }

    public void refresh(Object object) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, this));
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockMode, (EventSource)this));
    }

    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.fireRefresh(new RefreshEvent(object, lockOptions, (EventSource)this));
    }

    public void refresh(Object object, Map map) throws HibernateException {
        this.fireRefresh(map, new RefreshEvent(object, this));
    }

    private void fireRefresh(RefreshEvent refreshEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        RefreshEventListener[] refreshEventListenerArray = this.listeners.getRefreshEventListeners();
        for (int i = 0; i < refreshEventListenerArray.length; ++i) {
            refreshEventListenerArray[i].onRefresh(refreshEvent);
        }
    }

    private void fireRefresh(Map map, RefreshEvent refreshEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        RefreshEventListener[] refreshEventListenerArray = this.listeners.getRefreshEventListeners();
        for (int i = 0; i < refreshEventListenerArray.length; ++i) {
            refreshEventListenerArray[i].onRefresh(refreshEvent, map);
        }
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(object, replicationMode, this));
    }

    public void replicate(String string, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.fireReplicate(new ReplicateEvent(string, object, replicationMode, this));
    }

    private void fireReplicate(ReplicateEvent replicateEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        ReplicateEventListener[] replicateEventListenerArray = this.listeners.getReplicateEventListeners();
        for (int i = 0; i < replicateEventListenerArray.length; ++i) {
            replicateEventListenerArray[i].onReplicate(replicateEvent);
        }
    }

    public void evict(Object object) throws HibernateException {
        this.fireEvict(new EvictEvent(object, this));
    }

    private void fireEvict(EvictEvent evictEvent) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        EvictEventListener[] evictEventListenerArray = this.listeners.getEvictEventListeners();
        for (int i = 0; i < evictEventListenerArray.length; ++i) {
            evictEventListenerArray[i].onEvict(evictEvent);
        }
    }

    protected boolean autoFlushIfRequired(Set set) throws HibernateException {
        this.errorIfClosed();
        if (!this.isTransactionInProgress()) {
            return false;
        }
        AutoFlushEvent autoFlushEvent = new AutoFlushEvent(set, this);
        AutoFlushEventListener[] autoFlushEventListenerArray = this.listeners.getAutoFlushEventListeners();
        for (int i = 0; i < autoFlushEventListenerArray.length; ++i) {
            autoFlushEventListenerArray[i].onAutoFlush(autoFlushEvent);
        }
        return autoFlushEvent.isFlushRequired();
    }

    public boolean isDirty() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        log.debug("checking session dirtiness");
        if (this.actionQueue.areInsertionsOrDeletionsQueued()) {
            log.debug("session dirty (scheduled updates and insertions)");
            return true;
        }
        DirtyCheckEvent dirtyCheckEvent = new DirtyCheckEvent(this);
        DirtyCheckEventListener[] dirtyCheckEventListenerArray = this.listeners.getDirtyCheckEventListeners();
        for (int i = 0; i < dirtyCheckEventListenerArray.length; ++i) {
            dirtyCheckEventListenerArray[i].onDirtyCheck(dirtyCheckEvent);
        }
        return dirtyCheckEvent.isDirty();
    }

    public void flush() throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new HibernateException("Flush during cascade is dangerous");
        }
        FlushEventListener[] flushEventListenerArray = this.listeners.getFlushEventListeners();
        for (int i = 0; i < flushEventListenerArray.length; ++i) {
            flushEventListenerArray[i].onFlush(new FlushEvent(this));
        }
    }

    public void forceFlush(EntityEntry entityEntry) throws HibernateException {
        this.errorIfClosed();
        if (log.isDebugEnabled()) {
            log.debug("flushing to force deletion of re-saved object: " + MessageHelper.infoString(entityEntry.getPersister(), entityEntry.getId(), this.getFactory()));
        }
        if (this.persistenceContext.getCascadeLevel() > 0) {
            throw new ObjectDeletedException("deleted object would be re-saved by cascade (remove deleted object from associations)", entityEntry.getId(), entityEntry.getPersister().getEntityName());
        }
        this.flush();
    }

    public List find(String string) throws HibernateException {
        return this.list(string, new QueryParameters());
    }

    public List find(String string, Object object, Type type) throws HibernateException {
        return this.list(string, new QueryParameters(type, object));
    }

    public List find(String string, Object[] objectArray, Type[] typeArray) throws HibernateException {
        return this.list(string, new QueryParameters(typeArray, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        List list = CollectionHelper.EMPTY_LIST;
        boolean bl = false;
        ++this.dontFlushFromFind;
        try {
            list = hQLQueryPlan.performList(queryParameters, this);
            bl = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(bl);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        boolean bl = false;
        int n = 0;
        try {
            n = hQLQueryPlan.performExecuteUpdate(queryParameters, this);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeNativeUpdate(NativeSQLQuerySpecification nativeSQLQuerySpecification, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        NativeSQLQueryPlan nativeSQLQueryPlan = this.getNativeSQLQueryPlan(nativeSQLQuerySpecification);
        this.autoFlushIfRequired(nativeSQLQueryPlan.getCustomQuery().getQuerySpaces());
        boolean bl = false;
        int n = 0;
        try {
            n = nativeSQLQueryPlan.performExecuteUpdate(queryParameters, this);
            bl = true;
        }
        finally {
            this.afterOperation(bl);
        }
        return n;
    }

    public Iterator iterate(String string) throws HibernateException {
        return this.iterate(string, new QueryParameters());
    }

    public Iterator iterate(String string, Object object, Type type) throws HibernateException {
        return this.iterate(string, new QueryParameters(type, object));
    }

    public Iterator iterate(String string, Object[] objectArray, Type[] typeArray) throws HibernateException {
        return this.iterate(string, new QueryParameters(typeArray, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterate(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        queryParameters.validateParameters();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, true);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            Iterator iterator = hQLQueryPlan.performIterate(queryParameters, this);
            return iterator;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        HQLQueryPlan hQLQueryPlan = this.getHQLQueryPlan(string, false);
        this.autoFlushIfRequired(hQLQueryPlan.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = hQLQueryPlan.performScroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    public int delete(String string) throws HibernateException {
        return this.delete(string, ArrayHelper.EMPTY_OBJECT_ARRAY, ArrayHelper.EMPTY_TYPE_ARRAY);
    }

    public int delete(String string, Object object, Type type) throws HibernateException {
        return this.delete(string, new Object[]{object}, new Type[]{type});
    }

    public int delete(String string, Object[] objectArray, Type[] typeArray) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (string == null) {
            throw new IllegalArgumentException("attempt to doAfterTransactionCompletion delete-by-query with null query");
        }
        if (log.isTraceEnabled()) {
            log.trace("delete: " + string);
            if (objectArray.length != 0) {
                log.trace("parameters: " + StringHelper.toString(objectArray));
            }
        }
        List list = this.find(string, objectArray, typeArray);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.delete(list.get(i));
        }
        return n;
    }

    public Query createFilter(Object object, String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        CollectionFilterImpl collectionFilterImpl = new CollectionFilterImpl(string, object, (SessionImplementor)this, this.getFilterQueryPlan(object, string, null, false).getParameterMetadata());
        collectionFilterImpl.setComment(string);
        return collectionFilterImpl;
    }

    public Query getNamedQuery(String string) throws MappingException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.getNamedQuery(string);
    }

    public Object instantiate(String string, Serializable serializable) throws HibernateException {
        return this.instantiate(this.factory.getEntityPersister(string), serializable);
    }

    public Object instantiate(EntityPersister entityPersister, Serializable serializable) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        Object object = this.interceptor.instantiate(entityPersister.getEntityName(), this.entityMode, serializable);
        if (object == null) {
            object = entityPersister.instantiate(serializable, this);
        }
        return object;
    }

    public EntityMode getEntityMode() {
        this.checkTransactionSynchStatus();
        return this.entityMode;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("setting flush mode to: " + flushMode);
        }
        this.flushMode = flushMode;
    }

    public FlushMode getFlushMode() {
        this.checkTransactionSynchStatus();
        return this.flushMode;
    }

    public CacheMode getCacheMode() {
        this.checkTransactionSynchStatus();
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("setting cache mode to: " + cacheMode);
        }
        this.cacheMode = cacheMode;
    }

    public Transaction getTransaction() throws HibernateException {
        this.errorIfClosed();
        return this.jdbcContext.getTransaction();
    }

    public Transaction beginTransaction() throws HibernateException {
        this.errorIfClosed();
        if (this.rootSession != null) {
            log.warn("Transaction started on non-root session");
        }
        Transaction transaction = this.getTransaction();
        transaction.begin();
        return transaction;
    }

    public void afterTransactionBegin(Transaction transaction) {
        this.errorIfClosed();
        this.interceptor.afterTransactionBegin(transaction);
    }

    public EntityPersister getEntityPersister(String string, Object object) {
        this.errorIfClosed();
        if (string == null) {
            return this.factory.getEntityPersister(this.guessEntityName(object));
        }
        try {
            return this.factory.getEntityPersister(string).getSubclassEntityPersister(object, this.getFactory(), this.entityMode);
        }
        catch (HibernateException hibernateException) {
            try {
                return this.getEntityPersister(null, object);
            }
            catch (HibernateException hibernateException2) {
                throw hibernateException;
            }
        }
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (lazyInitializer.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return lazyInitializer.getIdentifier();
        }
        EntityEntry entityEntry = this.persistenceContext.getEntry(object);
        if (entityEntry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entityEntry.getId();
    }

    public Serializable getContextEntityIdentifier(Object object) {
        this.errorIfClosed();
        if (object instanceof HibernateProxy) {
            return this.getProxyIdentifier(object);
        }
        EntityEntry entityEntry = this.persistenceContext.getEntry(object);
        return entityEntry != null ? entityEntry.getId() : null;
    }

    private Serializable getProxyIdentifier(Object object) {
        return ((HibernateProxy)object).getHibernateLazyInitializer().getIdentifier();
    }

    public Collection filter(Object object, String string) throws HibernateException {
        return this.listFilter(object, string, new QueryParameters(new Type[1], new Object[1]));
    }

    public Collection filter(Object object, String string, Object object2, Type type) throws HibernateException {
        return this.listFilter(object, string, new QueryParameters(new Type[]{null, type}, new Object[]{null, object2}));
    }

    public Collection filter(Object object, String string, Object[] objectArray, Type[] typeArray) throws HibernateException {
        Object[] objectArray2 = new Object[objectArray.length + 1];
        Type[] typeArray2 = new Type[typeArray.length + 1];
        System.arraycopy(objectArray, 0, objectArray2, 1, objectArray.length);
        System.arraycopy(typeArray, 0, typeArray2, 1, typeArray.length);
        return this.listFilter(object, string, new QueryParameters(typeArray2, objectArray2));
    }

    private FilterQueryPlan getFilterQueryPlan(Object object, String string, QueryParameters queryParameters, boolean bl) throws HibernateException {
        if (object == null) {
            throw new NullPointerException("null collection passed to filter");
        }
        CollectionEntry collectionEntry = this.persistenceContext.getCollectionEntryOrNull(object);
        CollectionPersister collectionPersister = collectionEntry == null ? null : collectionEntry.getLoadedPersister();
        FilterQueryPlan filterQueryPlan = null;
        if (collectionPersister == null) {
            CollectionPersister collectionPersister2;
            this.flush();
            collectionEntry = this.persistenceContext.getCollectionEntryOrNull(object);
            CollectionPersister collectionPersister3 = collectionPersister2 = collectionEntry == null ? null : collectionEntry.getLoadedPersister();
            if (collectionPersister2 == null) {
                throw new QueryException("The collection was unreferenced");
            }
            filterQueryPlan = this.factory.getQueryPlanCache().getFilterQueryPlan(string, collectionPersister2.getRole(), bl, this.getEnabledFilters());
        } else {
            filterQueryPlan = this.factory.getQueryPlanCache().getFilterQueryPlan(string, collectionPersister.getRole(), bl, this.getEnabledFilters());
            if (this.autoFlushIfRequired(filterQueryPlan.getQuerySpaces())) {
                CollectionPersister collectionPersister4;
                collectionEntry = this.persistenceContext.getCollectionEntryOrNull(object);
                CollectionPersister collectionPersister5 = collectionPersister4 = collectionEntry == null ? null : collectionEntry.getLoadedPersister();
                if (collectionPersister != collectionPersister4) {
                    if (collectionPersister4 == null) {
                        throw new QueryException("The collection was dereferenced");
                    }
                    filterQueryPlan = this.factory.getQueryPlanCache().getFilterQueryPlan(string, collectionPersister4.getRole(), bl, this.getEnabledFilters());
                }
            }
        }
        if (queryParameters != null) {
            queryParameters.getPositionalParameterValues()[0] = collectionEntry.getLoadedKey();
            queryParameters.getPositionalParameterTypes()[0] = collectionEntry.getLoadedPersister().getKeyType();
        }
        return filterQueryPlan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listFilter(Object object, String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan filterQueryPlan = this.getFilterQueryPlan(object, string, queryParameters, false);
        List list = CollectionHelper.EMPTY_LIST;
        boolean bl = false;
        ++this.dontFlushFromFind;
        try {
            list = filterQueryPlan.performList(queryParameters, this);
            bl = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(bl);
        }
        return list;
    }

    public Iterator iterateFilter(Object object, String string, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        FilterQueryPlan filterQueryPlan = this.getFilterQueryPlan(object, string, queryParameters, true);
        return filterQueryPlan.performIterate(queryParameters, this);
    }

    public Criteria createCriteria(Class clazz, String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(clazz.getName(), string, this);
    }

    public Criteria createCriteria(String string, String string2) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(string, string2, this);
    }

    public Criteria createCriteria(Class clazz) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(clazz.getName(), this);
    }

    public Criteria createCriteria(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new CriteriaImpl(string, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scroll(CriteriaImpl criteriaImpl, ScrollMode scrollMode) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String string = criteriaImpl.getEntityOrClassName();
        CriteriaLoader criteriaLoader = new CriteriaLoader(this.getOuterJoinLoadable(string), this.factory, criteriaImpl, string, this.getLoadQueryInfluencers());
        this.autoFlushIfRequired(criteriaLoader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = criteriaLoader.scroll(this, scrollMode);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list(CriteriaImpl criteriaImpl) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        String[] stringArray = this.factory.getImplementors(criteriaImpl.getEntityOrClassName());
        int n = stringArray.length;
        CriteriaLoader[] criteriaLoaderArray = new CriteriaLoader[n];
        HashSet hashSet = new HashSet();
        for (int i = 0; i < n; ++i) {
            criteriaLoaderArray[i] = new CriteriaLoader(this.getOuterJoinLoadable(stringArray[i]), this.factory, criteriaImpl, stringArray[i], this.getLoadQueryInfluencers());
            hashSet.addAll(criteriaLoaderArray[i].getQuerySpaces());
        }
        this.autoFlushIfRequired(hashSet);
        List list = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        boolean bl = false;
        try {
            for (int i = 0; i < n; ++i) {
                List list2 = criteriaLoaderArray[i].list(this);
                list2.addAll(list);
                list = list2;
            }
            bl = true;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(bl);
        }
        return list;
    }

    private OuterJoinLoadable getOuterJoinLoadable(String string) throws MappingException {
        EntityPersister entityPersister = this.factory.getEntityPersister(string);
        if (!(entityPersister instanceof OuterJoinLoadable)) {
            throw new MappingException("class persister is not OuterJoinLoadable: " + string);
        }
        return (OuterJoinLoadable)entityPersister;
    }

    public boolean contains(Object object) {
        Object object2;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            object2 = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (object2.isUninitialized()) {
                return object2.getSession() == this;
            }
            object = object2.getImplementation();
        }
        return (object2 = this.persistenceContext.getEntry(object)) != null && ((EntityEntry)object2).getStatus() != Status.DELETED && ((EntityEntry)object2).getStatus() != Status.GONE;
    }

    public Query createQuery(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createQuery(string);
    }

    public SQLQuery createSQLQuery(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return super.createSQLQuery(string);
    }

    public Query createSQLQuery(String string, String string2, Class clazz) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new SQLQueryImpl(string, new String[]{string2}, new Class[]{clazz}, this, this.factory.getQueryPlanCache().getSQLParameterMetadata(string));
    }

    public Query createSQLQuery(String string, String[] stringArray, Class[] classArray) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return new SQLQueryImpl(string, stringArray, classArray, this, this.factory.getQueryPlanCache().getSQLParameterMetadata(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("scroll SQL query: " + customQuery.getSQL());
        }
        CustomLoader customLoader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(customLoader.getQuerySpaces());
        ++this.dontFlushFromFind;
        try {
            ScrollableResults scrollableResults = customLoader.scroll(queryParameters, this);
            return scrollableResults;
        }
        finally {
            --this.dontFlushFromFind;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (log.isTraceEnabled()) {
            log.trace("SQL query: " + customQuery.getSQL());
        }
        CustomLoader customLoader = new CustomLoader(customQuery, this.getFactory());
        this.autoFlushIfRequired(customLoader.getQuerySpaces());
        ++this.dontFlushFromFind;
        boolean bl = false;
        try {
            List list = customLoader.list(this, queryParameters);
            bl = true;
            List list2 = list;
            return list2;
        }
        finally {
            --this.dontFlushFromFind;
            this.afterOperation(bl);
        }
    }

    public SessionFactory getSessionFactory() {
        this.checkTransactionSynchStatus();
        return this.factory;
    }

    public void initializeCollection(PersistentCollection persistentCollection, boolean bl) throws HibernateException {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        InitializeCollectionEventListener[] initializeCollectionEventListenerArray = this.listeners.getInitializeCollectionEventListeners();
        for (int i = 0; i < initializeCollectionEventListenerArray.length; ++i) {
            initializeCollectionEventListenerArray[i].onInitializeCollection(new InitializeCollectionEvent(persistentCollection, this));
        }
    }

    public String bestGuessEntityName(Object object) {
        Object object2;
        if (object instanceof HibernateProxy) {
            object2 = ((HibernateProxy)object).getHibernateLazyInitializer();
            if (object2.isUninitialized()) {
                return object2.getEntityName();
            }
            object = object2.getImplementation();
        }
        if ((object2 = this.persistenceContext.getEntry(object)) == null) {
            return this.guessEntityName(object);
        }
        return ((EntityEntry)object2).getPersister().getEntityName();
    }

    public String getEntityName(Object object) {
        EntityEntry entityEntry;
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        if (object instanceof HibernateProxy) {
            if (!this.persistenceContext.containsProxy(object)) {
                throw new TransientObjectException("proxy was not associated with the session");
            }
            object = ((HibernateProxy)object).getHibernateLazyInitializer().getImplementation();
        }
        if ((entityEntry = this.persistenceContext.getEntry(object)) == null) {
            this.throwTransientObjectException(object);
        }
        return entityEntry.getPersister().getEntityName();
    }

    private void throwTransientObjectException(Object object) throws HibernateException {
        throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + this.guessEntityName(object));
    }

    public String guessEntityName(Object object) throws HibernateException {
        this.errorIfClosed();
        return this.entityNameResolver.resolveEntityName(object);
    }

    public void cancelQuery() throws HibernateException {
        this.errorIfClosed();
        this.getBatcher().cancelLastQuery();
    }

    public Interceptor getInterceptor() {
        this.checkTransactionSynchStatus();
        return this.interceptor;
    }

    public int getDontFlushFromFind() {
        return this.dontFlushFromFind;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(500).append("SessionImpl(");
        if (!this.isClosed()) {
            stringBuffer.append(this.persistenceContext).append(";").append(this.actionQueue);
        } else {
            stringBuffer.append("<closed>");
        }
        return stringBuffer.append(')').toString();
    }

    public EventListeners getListeners() {
        return this.listeners;
    }

    public ActionQueue getActionQueue() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.actionQueue;
    }

    public PersistenceContext getPersistenceContext() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext;
    }

    public SessionStatistics getStatistics() {
        this.checkTransactionSynchStatus();
        return new SessionStatisticsImpl(this);
    }

    public boolean isEventSource() {
        this.checkTransactionSynchStatus();
        return true;
    }

    public boolean isDefaultReadOnly() {
        return this.persistenceContext.isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean bl) {
        this.persistenceContext.setDefaultReadOnly(bl);
    }

    public boolean isReadOnly(Object object) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.persistenceContext.isReadOnly(object);
    }

    public void setReadOnly(Object object, boolean bl) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.persistenceContext.setReadOnly(object, bl);
    }

    public void doWork(Work work) throws HibernateException {
        try {
            work.execute(this.jdbcContext.getConnectionManager().getConnection());
            this.jdbcContext.getConnectionManager().afterStatement();
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSettings().getSQLExceptionConverter(), sQLException, "error executing work");
        }
    }

    public void afterScrollOperation() {
    }

    public JDBCContext getJDBCContext() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.jdbcContext;
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    public Filter getEnabledFilter(String string) {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilter(string);
    }

    public Filter enableFilter(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.enableFilter(string);
    }

    public void disableFilter(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.disableFilter(string);
    }

    public Object getFilterParameterValue(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterValue(string);
    }

    public Type getFilterParameterType(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getFilterParameterType(string);
    }

    public Map getEnabledFilters() {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getEnabledFilters();
    }

    public String getFetchProfile() {
        this.checkTransactionSynchStatus();
        return this.loadQueryInfluencers.getInternalFetchProfile();
    }

    public void setFetchProfile(String string) {
        this.errorIfClosed();
        this.checkTransactionSynchStatus();
        this.loadQueryInfluencers.setInternalFetchProfile(string);
    }

    public boolean isFetchProfileEnabled(String string) throws UnknownProfileException {
        return this.loadQueryInfluencers.isFetchProfileEnabled(string);
    }

    public void enableFetchProfile(String string) throws UnknownProfileException {
        this.loadQueryInfluencers.enableFetchProfile(string);
    }

    public void disableFetchProfile(String string) throws UnknownProfileException {
        this.loadQueryInfluencers.disableFetchProfile(string);
    }

    private void checkTransactionSynchStatus() {
        if (this.jdbcContext != null && !this.isClosed()) {
            this.jdbcContext.registerSynchronizationIfPossible();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        log.trace("deserializing session");
        objectInputStream.defaultReadObject();
        this.entityNameResolver = new CoordinatingEntityNameResolver();
        boolean bl = objectInputStream.readBoolean();
        this.connectionReleaseMode = ConnectionReleaseMode.parse((String)objectInputStream.readObject());
        this.entityMode = EntityMode.parse((String)objectInputStream.readObject());
        this.autoClear = objectInputStream.readBoolean();
        this.flushMode = FlushMode.parse((String)objectInputStream.readObject());
        this.cacheMode = CacheMode.parse((String)objectInputStream.readObject());
        this.flushBeforeCompletionEnabled = objectInputStream.readBoolean();
        this.autoCloseSessionEnabled = objectInputStream.readBoolean();
        this.interceptor = (Interceptor)objectInputStream.readObject();
        this.factory = SessionFactoryImpl.deserialize(objectInputStream);
        this.listeners = this.factory.getEventListeners();
        if (bl) {
            this.jdbcContext = JDBCContext.deserialize(objectInputStream, this, this.interceptor);
        }
        this.persistenceContext = StatefulPersistenceContext.deserialize(objectInputStream, this);
        this.actionQueue = ActionQueue.deserialize(objectInputStream, this);
        this.loadQueryInfluencers = (LoadQueryInfluencers)objectInputStream.readObject();
        this.childSessionsByEntityMode = (Map)objectInputStream.readObject();
        for (Object object : this.loadQueryInfluencers.getEnabledFilterNames()) {
            ((FilterImpl)this.loadQueryInfluencers.getEnabledFilter((String)object)).afterDeserialize(this.factory);
        }
        if (bl && this.childSessionsByEntityMode != null) {
            for (Object object : this.childSessionsByEntityMode.values()) {
                ((SessionImpl)object).rootSession = this;
                ((SessionImpl)object).jdbcContext = this.jdbcContext;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.jdbcContext.getConnectionManager().isReadyForSerialization()) {
            throw new IllegalStateException("Cannot serialize a session while connected");
        }
        log.trace("serializing session");
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeBoolean(this.rootSession == null);
        objectOutputStream.writeObject(this.connectionReleaseMode.toString());
        objectOutputStream.writeObject(this.entityMode.toString());
        objectOutputStream.writeBoolean(this.autoClear);
        objectOutputStream.writeObject(this.flushMode.toString());
        objectOutputStream.writeObject(this.cacheMode.toString());
        objectOutputStream.writeBoolean(this.flushBeforeCompletionEnabled);
        objectOutputStream.writeBoolean(this.autoCloseSessionEnabled);
        objectOutputStream.writeObject(this.interceptor);
        this.factory.serialize(objectOutputStream);
        if (this.rootSession == null) {
            this.jdbcContext.serialize(objectOutputStream);
        }
        this.persistenceContext.serialize(objectOutputStream);
        this.actionQueue.serialize(objectOutputStream);
        objectOutputStream.writeObject(this.loadQueryInfluencers);
        objectOutputStream.writeObject(this.childSessionsByEntityMode);
    }

    public Object execute(LobCreationContext.Callback callback) {
        Connection connection = this.jdbcContext.getConnectionManager().getConnection();
        try {
            Object object = callback.executeOnConnection(connection);
            return object;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "Error creating contextual LOB : " + sQLException.getMessage());
        }
        finally {
            this.jdbcContext.getConnectionManager().afterStatement();
        }
    }

    public TypeHelper getTypeHelper() {
        return this.getSessionFactory().getTypeHelper();
    }

    public LobHelper getLobHelper() {
        if (this.lobHelper == null) {
            this.lobHelper = new LobHelperImpl(this);
        }
        return this.lobHelper;
    }

    private class LockRequestImpl
    implements Session.LockRequest {
        private final LockOptions lockOptions = new LockOptions();

        private LockRequestImpl(LockOptions lockOptions) {
            LockOptions.copy(lockOptions, this.lockOptions);
        }

        public LockMode getLockMode() {
            return this.lockOptions.getLockMode();
        }

        public Session.LockRequest setLockMode(LockMode lockMode) {
            this.lockOptions.setLockMode(lockMode);
            return this;
        }

        public int getTimeOut() {
            return this.lockOptions.getTimeOut();
        }

        public Session.LockRequest setTimeOut(int n) {
            this.lockOptions.setTimeOut(n);
            return this;
        }

        public boolean getScope() {
            return this.lockOptions.getScope();
        }

        public Session.LockRequest setScope(boolean bl) {
            this.lockOptions.setScope(bl);
            return this;
        }

        public void lock(String string, Object object) throws HibernateException {
            SessionImpl.this.fireLock(string, object, this.lockOptions);
        }

        public void lock(Object object) throws HibernateException {
            SessionImpl.this.fireLock(object, this.lockOptions);
        }
    }

    private class CoordinatingEntityNameResolver
    implements EntityNameResolver {
        private CoordinatingEntityNameResolver() {
        }

        public String resolveEntityName(Object object) {
            EntityNameResolver entityNameResolver;
            String string = SessionImpl.this.interceptor.getEntityName(object);
            if (string != null) {
                return string;
            }
            Iterator iterator = SessionImpl.this.factory.iterateEntityNameResolvers(SessionImpl.this.entityMode);
            while (iterator.hasNext() && (string = (entityNameResolver = (EntityNameResolver)iterator.next()).resolveEntityName(object)) == null) {
            }
            if (string != null) {
                return string;
            }
            return object.getClass().getName();
        }
    }

    private static class LobHelperImpl
    implements LobHelper {
        private final SessionImpl session;

        private LobHelperImpl(SessionImpl sessionImpl) {
            this.session = sessionImpl;
        }

        public Blob createBlob(byte[] byArray) {
            return this.lobCreator().createBlob(byArray);
        }

        private LobCreator lobCreator() {
            return this.session.getFactory().getSettings().getJdbcSupport().getLobCreator(this.session);
        }

        public Blob createBlob(InputStream inputStream, long l) {
            return this.lobCreator().createBlob(inputStream, l);
        }

        public Clob createClob(String string) {
            return this.lobCreator().createClob(string);
        }

        public Clob createClob(Reader reader, long l) {
            return this.lobCreator().createClob(reader, l);
        }

        public Clob createNClob(String string) {
            return this.lobCreator().createNClob(string);
        }

        public Clob createNClob(Reader reader, long l) {
            return this.lobCreator().createNClob(reader, l);
        }
    }
}

