/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.io.Serializable;
import java.util.Properties;
import org.hibernate.TypeHelper;
import org.hibernate.type.BasicType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeResolver;
import org.hibernate.usertype.CompositeUserType;

public class TypeLocatorImpl
implements TypeHelper,
Serializable {
    private final TypeResolver typeResolver;

    public TypeLocatorImpl(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public BasicType basic(String string) {
        return this.typeResolver.basic(string);
    }

    public BasicType basic(Class clazz) {
        Class clazz2;
        BasicType basicType = this.typeResolver.basic(clazz.getName());
        if (basicType == null && (clazz2 = this.resolvePrimitiveOrPrimitiveWrapperVariantJavaType(clazz)) != null) {
            basicType = this.typeResolver.basic(clazz2.getName());
        }
        return basicType;
    }

    private Class resolvePrimitiveOrPrimitiveWrapperVariantJavaType(Class clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.class;
        }
        if (Boolean.class.equals((Object)clazz)) {
            return Boolean.TYPE;
        }
        if (Character.TYPE.equals(clazz)) {
            return Character.class;
        }
        if (Character.class.equals((Object)clazz)) {
            return Character.TYPE;
        }
        if (Byte.TYPE.equals(clazz)) {
            return Byte.class;
        }
        if (Byte.class.equals((Object)clazz)) {
            return Byte.TYPE;
        }
        if (Short.TYPE.equals(clazz)) {
            return Short.class;
        }
        if (Short.class.equals((Object)clazz)) {
            return Short.TYPE;
        }
        if (Integer.TYPE.equals(clazz)) {
            return Integer.class;
        }
        if (Integer.class.equals((Object)clazz)) {
            return Integer.TYPE;
        }
        if (Long.TYPE.equals(clazz)) {
            return Long.class;
        }
        if (Long.class.equals((Object)clazz)) {
            return Long.TYPE;
        }
        if (Float.TYPE.equals(clazz)) {
            return Float.class;
        }
        if (Float.class.equals((Object)clazz)) {
            return Float.TYPE;
        }
        if (Double.TYPE.equals(clazz)) {
            return Double.class;
        }
        if (Double.class.equals((Object)clazz)) {
            return Double.TYPE;
        }
        return null;
    }

    public Type heuristicType(String string) {
        return this.typeResolver.heuristicType(string);
    }

    public Type entity(Class clazz) {
        return this.entity(clazz.getName());
    }

    public Type entity(String string) {
        return this.typeResolver.getTypeFactory().manyToOne(string);
    }

    public Type custom(Class clazz) {
        return this.custom(clazz, null);
    }

    public Type custom(Class clazz, Properties properties) {
        if (CompositeUserType.class.isAssignableFrom(clazz)) {
            return this.typeResolver.getTypeFactory().customComponent(clazz, properties);
        }
        return this.typeResolver.getTypeFactory().custom(clazz, properties);
    }

    public Type any(Type type, Type type2) {
        return this.typeResolver.getTypeFactory().any(type, type2);
    }
}

