/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.ScrollMode;
import org.hibernate.TransactionException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Batcher;
import org.hibernate.jdbc.ConnectionManager;
import org.hibernate.jdbc.util.FormatStyle;
import org.hibernate.util.JDBCExceptionReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatcher
implements Batcher {
    private static int globalOpenPreparedStatementCount;
    private static int globalOpenResultSetCount;
    private int openPreparedStatementCount;
    private int openResultSetCount;
    protected static final Logger log;
    private final ConnectionManager connectionManager;
    private final SessionFactoryImplementor factory;
    private PreparedStatement batchUpdate;
    private String batchUpdateSQL;
    private HashSet statementsToClose = new HashSet();
    private HashSet resultSetsToClose = new HashSet();
    private PreparedStatement lastQuery;
    private boolean releasing = false;
    private final Interceptor interceptor;
    private long transactionTimeout = -1L;
    boolean isTransactionTimeoutSet;

    public AbstractBatcher(ConnectionManager connectionManager, Interceptor interceptor) {
        this.connectionManager = connectionManager;
        this.interceptor = interceptor;
        this.factory = connectionManager.getFactory();
    }

    public void setTransactionTimeout(int n) {
        this.isTransactionTimeoutSet = true;
        this.transactionTimeout = System.currentTimeMillis() / 1000L + (long)n;
    }

    public void unsetTransactionTimeout() {
        this.isTransactionTimeoutSet = false;
    }

    protected PreparedStatement getStatement() {
        return this.batchUpdate;
    }

    public CallableStatement prepareCallableStatement(String string) throws SQLException, HibernateException {
        this.executeBatch();
        this.logOpenPreparedStatement();
        return this.getCallableStatement(this.connectionManager.getConnection(), string, false);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException, HibernateException {
        return this.prepareStatement(string, false);
    }

    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException, HibernateException {
        this.executeBatch();
        this.logOpenPreparedStatement();
        return this.getPreparedStatement(this.connectionManager.getConnection(), string, false, bl, null, null, false);
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException, HibernateException {
        this.executeBatch();
        this.logOpenPreparedStatement();
        return this.getPreparedStatement(this.connectionManager.getConnection(), string, false, false, stringArray, null, false);
    }

    public PreparedStatement prepareSelectStatement(String string) throws SQLException, HibernateException {
        this.logOpenPreparedStatement();
        return this.getPreparedStatement(this.connectionManager.getConnection(), string, false, false, null, null, false);
    }

    public PreparedStatement prepareQueryStatement(String string, boolean bl, ScrollMode scrollMode) throws SQLException, HibernateException {
        this.logOpenPreparedStatement();
        PreparedStatement preparedStatement = this.getPreparedStatement(this.connectionManager.getConnection(), string, bl, scrollMode);
        this.setStatementFetchSize(preparedStatement);
        this.statementsToClose.add(preparedStatement);
        this.lastQuery = preparedStatement;
        return preparedStatement;
    }

    public CallableStatement prepareCallableQueryStatement(String string, boolean bl, ScrollMode scrollMode) throws SQLException, HibernateException {
        this.logOpenPreparedStatement();
        CallableStatement callableStatement = (CallableStatement)this.getPreparedStatement(this.connectionManager.getConnection(), string, bl, false, null, scrollMode, true);
        this.setStatementFetchSize(callableStatement);
        this.statementsToClose.add(callableStatement);
        this.lastQuery = callableStatement;
        return callableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortBatch(SQLException sQLException) {
        try {
            if (this.batchUpdate != null) {
                this.closeStatement(this.batchUpdate);
            }
        }
        catch (SQLException sQLException2) {
            JDBCExceptionReporter.logExceptions(sQLException2);
        }
        finally {
            this.batchUpdate = null;
            this.batchUpdateSQL = null;
        }
    }

    public ResultSet getResultSet(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = preparedStatement.executeQuery();
        this.resultSetsToClose.add(resultSet);
        this.logOpenResults();
        return resultSet;
    }

    public ResultSet getResultSet(CallableStatement callableStatement, Dialect dialect) throws SQLException {
        ResultSet resultSet = dialect.getResultSet(callableStatement);
        this.resultSetsToClose.add(resultSet);
        this.logOpenResults();
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeQueryStatement(PreparedStatement preparedStatement, ResultSet resultSet) throws SQLException {
        boolean bl = this.statementsToClose.remove(preparedStatement);
        try {
            if (resultSet != null && this.resultSetsToClose.remove(resultSet)) {
                this.logCloseResults();
                resultSet.close();
            }
        }
        finally {
            if (bl) {
                this.closeQueryStatement(preparedStatement);
            }
        }
    }

    public PreparedStatement prepareBatchStatement(String string) throws SQLException, HibernateException {
        if (!(string = this.getSQL(string)).equals(this.batchUpdateSQL)) {
            this.batchUpdate = this.prepareStatement(string);
            this.batchUpdateSQL = string;
        } else {
            log.debug("reusing prepared statement");
            this.log(string);
        }
        return this.batchUpdate;
    }

    public CallableStatement prepareBatchCallableStatement(String string) throws SQLException, HibernateException {
        if (!string.equals(this.batchUpdateSQL)) {
            this.batchUpdate = this.prepareCallableStatement(string);
            this.batchUpdateSQL = string;
        }
        return (CallableStatement)this.batchUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws HibernateException {
        if (this.batchUpdate != null) {
            try {
                try {
                    this.doExecuteBatch(this.batchUpdate);
                }
                finally {
                    this.closeStatement(this.batchUpdate);
                }
            }
            catch (SQLException sQLException) {
                throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "Could not execute JDBC batch update", this.batchUpdateSQL);
            }
            finally {
                this.batchUpdate = null;
                this.batchUpdateSQL = null;
            }
        }
    }

    public void closeStatement(PreparedStatement preparedStatement) throws SQLException {
        this.logClosePreparedStatement();
        this.closePreparedStatement(preparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeQueryStatement(PreparedStatement preparedStatement) throws SQLException {
        try {
            if (preparedStatement.getMaxRows() != 0) {
                preparedStatement.setMaxRows(0);
            }
            if (preparedStatement.getQueryTimeout() != 0) {
                preparedStatement.setQueryTimeout(0);
            }
        }
        catch (Exception exception) {
            log.warn("exception clearing maxRows/queryTimeout", exception);
            return;
        }
        finally {
            this.closeStatement(preparedStatement);
        }
        if (this.lastQuery == preparedStatement) {
            this.lastQuery = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatements() {
        try {
            this.releasing = true;
            try {
                if (this.batchUpdate != null) {
                    this.batchUpdate.close();
                }
            }
            catch (SQLException sQLException) {
                log.warn("Could not close a JDBC prepared statement", sQLException);
            }
            this.batchUpdate = null;
            this.batchUpdateSQL = null;
            Iterator iterator = this.resultSetsToClose.iterator();
            while (iterator.hasNext()) {
                try {
                    this.logCloseResults();
                    ((ResultSet)iterator.next()).close();
                }
                catch (SQLException sQLException) {
                    log.warn("Could not close a JDBC result set", sQLException);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    log.info("encountered CME attempting to release batcher; assuming cause is tx-timeout scenario and ignoring");
                    break;
                }
                catch (Throwable throwable) {
                    log.warn("Could not close a JDBC result set", throwable);
                }
            }
            this.resultSetsToClose.clear();
            iterator = this.statementsToClose.iterator();
            while (iterator.hasNext()) {
                try {
                    this.closeQueryStatement((PreparedStatement)iterator.next());
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    log.info("encountered CME attempting to release batcher; assuming cause is tx-timeout scenario and ignoring");
                    break;
                }
                catch (SQLException sQLException) {
                    log.warn("Could not close a JDBC statement", sQLException);
                }
            }
            this.statementsToClose.clear();
        }
        finally {
            this.releasing = false;
        }
    }

    protected abstract void doExecuteBatch(PreparedStatement var1) throws SQLException, HibernateException;

    private String preparedStatementCountsToString() {
        return " (open PreparedStatements: " + this.openPreparedStatementCount + ", globally: " + globalOpenPreparedStatementCount + ")";
    }

    private String resultSetCountsToString() {
        return " (open ResultSets: " + this.openResultSetCount + ", globally: " + globalOpenResultSetCount + ")";
    }

    private void logOpenPreparedStatement() {
        if (log.isDebugEnabled()) {
            log.debug("about to open PreparedStatement" + this.preparedStatementCountsToString());
            ++this.openPreparedStatementCount;
            ++globalOpenPreparedStatementCount;
        }
    }

    private void logClosePreparedStatement() {
        if (log.isDebugEnabled()) {
            log.debug("about to close PreparedStatement" + this.preparedStatementCountsToString());
            --this.openPreparedStatementCount;
            --globalOpenPreparedStatementCount;
        }
    }

    private void logOpenResults() {
        if (log.isDebugEnabled()) {
            log.debug("about to open ResultSet" + this.resultSetCountsToString());
            ++this.openResultSetCount;
            ++globalOpenResultSetCount;
        }
    }

    private void logCloseResults() {
        if (log.isDebugEnabled()) {
            log.debug("about to close ResultSet" + this.resultSetCountsToString());
            --this.openResultSetCount;
            --globalOpenResultSetCount;
        }
    }

    protected SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    private void log(String string) {
        this.factory.getSettings().getSqlStatementLogger().logStatement(string, FormatStyle.BASIC);
    }

    private PreparedStatement getPreparedStatement(Connection connection, String string, boolean bl, ScrollMode scrollMode) throws SQLException {
        return this.getPreparedStatement(connection, string, bl, false, null, scrollMode, false);
    }

    private CallableStatement getCallableStatement(Connection connection, String string, boolean bl) throws SQLException {
        if (bl && !this.factory.getSettings().isScrollableResultSetsEnabled()) {
            throw new AssertionFailure("scrollable result sets are not enabled");
        }
        string = this.getSQL(string);
        this.log(string);
        log.trace("preparing callable statement");
        if (bl) {
            return connection.prepareCall(string, 1004, 1007);
        }
        return connection.prepareCall(string);
    }

    private String getSQL(String string) {
        if ((string = this.interceptor.onPrepareStatement(string)) == null || string.length() == 0) {
            throw new AssertionFailure("Interceptor.onPrepareStatement() returned null or empty string.");
        }
        return string;
    }

    private PreparedStatement getPreparedStatement(Connection connection, String string, boolean bl, boolean bl2, String[] stringArray, ScrollMode scrollMode, boolean bl3) throws SQLException {
        if (bl && !this.factory.getSettings().isScrollableResultSetsEnabled()) {
            throw new AssertionFailure("scrollable result sets are not enabled");
        }
        if (bl2 && !this.factory.getSettings().isGetGeneratedKeysEnabled()) {
            throw new AssertionFailure("getGeneratedKeys() support is not enabled");
        }
        string = this.getSQL(string);
        this.log(string);
        log.trace("preparing statement");
        PreparedStatement preparedStatement = bl ? (bl3 ? connection.prepareCall(string, scrollMode.toResultSetType(), 1007) : connection.prepareStatement(string, scrollMode.toResultSetType(), 1007)) : (bl2 ? connection.prepareStatement(string, 1) : (stringArray != null ? connection.prepareStatement(string, stringArray) : (bl3 ? connection.prepareCall(string) : connection.prepareStatement(string))));
        this.setTimeout(preparedStatement);
        if (this.factory.getStatistics().isStatisticsEnabled()) {
            this.factory.getStatisticsImplementor().prepareStatement();
        }
        return preparedStatement;
    }

    private void setTimeout(PreparedStatement preparedStatement) throws SQLException {
        if (this.isTransactionTimeoutSet) {
            int n = (int)(this.transactionTimeout - System.currentTimeMillis() / 1000L);
            if (n <= 0) {
                throw new TransactionException("transaction timeout expired");
            }
            preparedStatement.setQueryTimeout(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePreparedStatement(PreparedStatement preparedStatement) throws SQLException {
        try {
            log.trace("closing statement");
            preparedStatement.close();
            if (this.factory.getStatistics().isStatisticsEnabled()) {
                this.factory.getStatisticsImplementor().closeStatement();
            }
        }
        finally {
            if (!this.releasing) {
                this.connectionManager.afterStatement();
            }
        }
    }

    private void setStatementFetchSize(PreparedStatement preparedStatement) throws SQLException {
        Integer n = this.factory.getSettings().getJdbcFetchSize();
        if (n != null) {
            preparedStatement.setFetchSize(n);
        }
    }

    public Connection openConnection() throws HibernateException {
        log.debug("opening JDBC connection");
        try {
            return this.factory.getConnectionProvider().getConnection();
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "Cannot open connection");
        }
    }

    public void closeConnection(Connection connection) throws HibernateException {
        if (connection == null) {
            log.debug("found null connection on AbstractBatcher#closeConnection");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("closing JDBC connection" + this.preparedStatementCountsToString() + this.resultSetCountsToString());
        }
        try {
            if (!connection.isClosed()) {
                JDBCExceptionReporter.logAndClearWarnings(connection);
            }
            this.factory.getConnectionProvider().closeConnection(connection);
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "Cannot close connection");
        }
    }

    public void cancelLastQuery() throws HibernateException {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.factory.getSQLExceptionConverter(), sQLException, "Cannot cancel query");
        }
    }

    public boolean hasOpenResources() {
        return this.resultSetsToClose.size() > 0 || this.statementsToClose.size() > 0;
    }

    public String openResourceStatsAsString() {
        return this.preparedStatementCountsToString() + this.resultSetCountsToString();
    }

    static {
        log = LoggerFactory.getLogger(AbstractBatcher.class);
    }
}

