/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.jdbc.BatchFailedException;
import org.hibernate.jdbc.BatchedTooManyRowsAffectedException;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.TooManyRowsAffectedException;
import org.hibernate.util.JDBCExceptionReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expectations {
    private static final Logger log = LoggerFactory.getLogger(Expectations.class);
    public static final int USUAL_EXPECTED_COUNT = 1;
    public static final int USUAL_PARAM_POSITION = 1;
    public static final Expectation NONE = new Expectation(){

        public void verifyOutcome(int n, PreparedStatement preparedStatement, int n2) {
        }

        public int prepare(PreparedStatement preparedStatement) {
            return 0;
        }

        public boolean canBeBatched() {
            return true;
        }
    };
    public static final Expectation BASIC = new BasicExpectation(1);
    public static final Expectation PARAM = new BasicParamExpectation(1, 1);

    public static Expectation appropriateExpectation(ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        if (executeUpdateResultCheckStyle == ExecuteUpdateResultCheckStyle.NONE) {
            return NONE;
        }
        if (executeUpdateResultCheckStyle == ExecuteUpdateResultCheckStyle.COUNT) {
            return BASIC;
        }
        if (executeUpdateResultCheckStyle == ExecuteUpdateResultCheckStyle.PARAM) {
            return PARAM;
        }
        throw new HibernateException("unknown check style : " + executeUpdateResultCheckStyle);
    }

    private Expectations() {
    }

    public static class BasicParamExpectation
    extends BasicExpectation {
        private final int parameterPosition;

        protected BasicParamExpectation(int n, int n2) {
            super(n);
            this.parameterPosition = n2;
        }

        public int prepare(PreparedStatement preparedStatement) throws SQLException, HibernateException {
            this.toCallableStatement(preparedStatement).registerOutParameter(this.parameterPosition, 2);
            return 1;
        }

        public boolean canBeBatched() {
            return false;
        }

        protected int determineRowCount(int n, PreparedStatement preparedStatement) {
            try {
                return this.toCallableStatement(preparedStatement).getInt(this.parameterPosition);
            }
            catch (SQLException sQLException) {
                JDBCExceptionReporter.logExceptions(sQLException, "could not extract row counts from CallableStatement");
                throw new GenericJDBCException("could not extract row counts from CallableStatement", sQLException);
            }
        }

        private CallableStatement toCallableStatement(PreparedStatement preparedStatement) {
            if (!CallableStatement.class.isInstance(preparedStatement)) {
                throw new HibernateException("BasicParamExpectation operates exclusively on CallableStatements : " + preparedStatement.getClass());
            }
            return (CallableStatement)preparedStatement;
        }
    }

    public static class BasicExpectation
    implements Expectation {
        private final int expectedRowCount;

        protected BasicExpectation(int n) {
            this.expectedRowCount = n;
            if (n < 0) {
                throw new IllegalArgumentException("Expected row count must be greater than zero");
            }
        }

        public final void verifyOutcome(int n, PreparedStatement preparedStatement, int n2) {
            n = this.determineRowCount(n, preparedStatement);
            if (n2 < 0) {
                this.checkNonBatched(n);
            } else {
                this.checkBatched(n, n2);
            }
        }

        private void checkBatched(int n, int n2) {
            if (n == -2) {
                if (log.isDebugEnabled()) {
                    log.debug("success of batch update unknown: " + n2);
                }
            } else {
                if (n == -3) {
                    throw new BatchFailedException("Batch update failed: " + n2);
                }
                if (this.expectedRowCount > n) {
                    throw new StaleStateException("Batch update returned unexpected row count from update [" + n2 + "]; actual row count: " + n + "; expected: " + this.expectedRowCount);
                }
                if (this.expectedRowCount < n) {
                    String string = "Batch update returned unexpected row count from update [" + n2 + "]; actual row count: " + n + "; expected: " + this.expectedRowCount;
                    throw new BatchedTooManyRowsAffectedException(string, this.expectedRowCount, n, n2);
                }
            }
        }

        private void checkNonBatched(int n) {
            if (this.expectedRowCount > n) {
                throw new StaleStateException("Unexpected row count: " + n + "; expected: " + this.expectedRowCount);
            }
            if (this.expectedRowCount < n) {
                String string = "Unexpected row count: " + n + "; expected: " + this.expectedRowCount;
                throw new TooManyRowsAffectedException(string, this.expectedRowCount, n);
            }
        }

        public int prepare(PreparedStatement preparedStatement) throws SQLException, HibernateException {
            return 0;
        }

        public boolean canBeBatched() {
            return true;
        }

        protected int determineRowCount(int n, PreparedStatement preparedStatement) {
            return n;
        }
    }
}

