/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc.util;

import org.hibernate.jdbc.util.BasicFormatterImpl;
import org.hibernate.jdbc.util.DDLFormatterImpl;
import org.hibernate.jdbc.util.Formatter;

public class FormatStyle {
    public static final FormatStyle BASIC = new FormatStyle("basic", new BasicFormatterImpl());
    public static final FormatStyle DDL = new FormatStyle("ddl", new DDLFormatterImpl());
    public static final FormatStyle NONE = new FormatStyle("none", new NoFormatImpl());
    private final String name;
    private final Formatter formatter;

    private FormatStyle(String string, Formatter formatter) {
        this.name = string;
        this.formatter = formatter;
    }

    public String getName() {
        return this.name;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FormatStyle formatStyle = (FormatStyle)object;
        return this.name.equals(formatStyle.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    private static class NoFormatImpl
    implements Formatter {
        private NoFormatImpl() {
        }

        public String format(String string) {
            return string;
        }
    }
}

