/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc.util;

import org.hibernate.jdbc.util.FormatStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStatementLogger {
    private static final Logger log = LoggerFactory.getLogger("org.hibernate.SQL");
    private boolean logToStdout;
    private boolean formatSql;

    public SQLStatementLogger() {
        this(false, false);
    }

    public SQLStatementLogger(boolean bl, boolean bl2) {
        this.logToStdout = bl;
        this.formatSql = bl2;
    }

    public boolean isLogToStdout() {
        return this.logToStdout;
    }

    public void setLogToStdout(boolean bl) {
        this.logToStdout = bl;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    public void setFormatSql(boolean bl) {
        this.formatSql = bl;
    }

    public void logStatement(String string, FormatStyle formatStyle) {
        if (log.isDebugEnabled() || this.logToStdout) {
            formatStyle = this.determineActualStyle(formatStyle);
            string = formatStyle.getFormatter().format(string);
        }
        log.debug(string);
        if (this.logToStdout) {
            System.out.println("Hibernate: " + string);
        }
    }

    private FormatStyle determineActualStyle(FormatStyle formatStyle) {
        return this.formatSql ? formatStyle : FormatStyle.NONE;
    }
}

