/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import org.hibernate.MappingException;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.collection.BasicCollectionJoinWalker;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.persister.collection.QueryableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCollectionLoader
extends CollectionLoader {
    private static final Logger log = LoggerFactory.getLogger(BasicCollectionLoader.class);

    public BasicCollectionLoader(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, 1, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public BasicCollectionLoader(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, n, null, sessionFactoryImplementor, loadQueryInfluencers);
    }

    protected BasicCollectionLoader(QueryableCollection queryableCollection, int n, String string, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
        BasicCollectionJoinWalker basicCollectionJoinWalker = new BasicCollectionJoinWalker(queryableCollection, n, string, sessionFactoryImplementor, loadQueryInfluencers);
        this.initFromWalker(basicCollectionJoinWalker);
        this.postInstantiate();
        log.debug("Static select for collection " + queryableCollection.getRole() + ": " + this.getSQLString());
    }
}

