/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import org.hibernate.MappingException;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.collection.CollectionLoader;
import org.hibernate.loader.collection.OneToManyJoinWalker;
import org.hibernate.persister.collection.QueryableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneToManyLoader
extends CollectionLoader {
    private static final Logger log = LoggerFactory.getLogger(OneToManyLoader.class);

    public OneToManyLoader(QueryableCollection queryableCollection, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, 1, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public OneToManyLoader(QueryableCollection queryableCollection, int n, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(queryableCollection, n, null, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public OneToManyLoader(QueryableCollection queryableCollection, int n, String string, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(queryableCollection, sessionFactoryImplementor, loadQueryInfluencers);
        OneToManyJoinWalker oneToManyJoinWalker = new OneToManyJoinWalker(queryableCollection, n, string, sessionFactoryImplementor, loadQueryInfluencers);
        this.initFromWalker(oneToManyJoinWalker);
        this.postInstantiate();
        log.debug("Static select for one-to-many " + queryableCollection.getRole() + ": " + this.getSQLString());
    }
}

