/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.criteria;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.impl.CriteriaImpl;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.loader.PropertyPath;
import org.hibernate.loader.criteria.CriteriaQueryTranslator;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class CriteriaJoinWalker
extends AbstractEntityJoinWalker {
    private final CriteriaQueryTranslator translator;
    private final Set querySpaces;
    private final Type[] resultTypes;
    private final String[] userAliases;
    private final List userAliasList = new ArrayList();

    public Type[] getResultTypes() {
        return this.resultTypes;
    }

    public String[] getUserAliases() {
        return this.userAliases;
    }

    public CriteriaJoinWalker(OuterJoinLoadable outerJoinLoadable, CriteriaQueryTranslator criteriaQueryTranslator, SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, LoadQueryInfluencers loadQueryInfluencers) {
        this(outerJoinLoadable, criteriaQueryTranslator, sessionFactoryImplementor, criteriaImpl, string, loadQueryInfluencers, null);
    }

    public CriteriaJoinWalker(OuterJoinLoadable outerJoinLoadable, CriteriaQueryTranslator criteriaQueryTranslator, SessionFactoryImplementor sessionFactoryImplementor, CriteriaImpl criteriaImpl, String string, LoadQueryInfluencers loadQueryInfluencers, String string2) {
        super(outerJoinLoadable, sessionFactoryImplementor, loadQueryInfluencers, string2);
        this.translator = criteriaQueryTranslator;
        this.querySpaces = criteriaQueryTranslator.getQuerySpaces();
        if (criteriaQueryTranslator.hasProjection()) {
            this.resultTypes = criteriaQueryTranslator.getProjectedTypes();
            this.initProjection(criteriaQueryTranslator.getSelect(), criteriaQueryTranslator.getWhereCondition(), criteriaQueryTranslator.getOrderBy(), criteriaQueryTranslator.getGroupBy(), LockOptions.NONE);
        } else {
            this.resultTypes = new Type[]{sessionFactoryImplementor.getTypeResolver().getTypeFactory().manyToOne(outerJoinLoadable.getEntityName())};
            this.initAll(criteriaQueryTranslator.getWhereCondition(), criteriaQueryTranslator.getOrderBy(), LockOptions.NONE);
        }
        this.userAliasList.add(criteriaImpl.getAlias());
        this.userAliases = ArrayHelper.toStringArray(this.userAliasList);
    }

    protected int getJoinType(OuterJoinLoadable outerJoinLoadable, PropertyPath propertyPath, int n, AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle, String string, String[] stringArray, boolean bl, int n2) throws MappingException {
        if (this.translator.isJoin(propertyPath.getFullPath())) {
            return this.translator.getJoinType(propertyPath.getFullPath());
        }
        if (this.translator.hasProjection()) {
            return -1;
        }
        FetchMode fetchMode2 = this.translator.getRootCriteria().getFetchMode(propertyPath.getFullPath());
        if (CriteriaJoinWalker.isDefaultFetchMode(fetchMode2)) {
            if (this.isJoinFetchEnabledByProfile(outerJoinLoadable, propertyPath, n)) {
                return this.getJoinType(bl, n2);
            }
            return super.getJoinType(outerJoinLoadable, propertyPath, n, associationType, fetchMode, cascadeStyle, string, stringArray, bl, n2);
        }
        if (fetchMode2 == FetchMode.JOIN) {
            this.isDuplicateAssociation(string, stringArray, associationType);
            return this.getJoinType(bl, n2);
        }
        return -1;
    }

    protected int getJoinType(AssociationType associationType, FetchMode fetchMode, PropertyPath propertyPath, String string, String[] stringArray, boolean bl, int n, CascadeStyle cascadeStyle) throws MappingException {
        return this.translator.isJoin(propertyPath.getFullPath()) ? this.translator.getJoinType(propertyPath.getFullPath()) : super.getJoinType(associationType, fetchMode, propertyPath, string, stringArray, bl, n, cascadeStyle);
    }

    private static boolean isDefaultFetchMode(FetchMode fetchMode) {
        return fetchMode == null || fetchMode == FetchMode.DEFAULT;
    }

    protected String getWhereFragment() throws MappingException {
        return super.getWhereFragment() + ((Queryable)this.getPersister()).filterFragment(this.getAlias(), this.getLoadQueryInfluencers().getEnabledFilters());
    }

    protected String generateTableAlias(int n, PropertyPath propertyPath, Joinable joinable) {
        if (joinable.consumesEntityAlias()) {
            String string;
            Criteria criteria = this.translator.getCriteria(propertyPath.getFullPath());
            String string2 = string = criteria == null ? null : this.translator.getSQLAlias(criteria);
            if (string != null) {
                this.userAliasList.add(criteria.getAlias());
                return string;
            }
            this.userAliasList.add(null);
        }
        return super.generateTableAlias(n + this.translator.getSQLAliasCount(), propertyPath, joinable);
    }

    protected String generateRootAlias(String string) {
        return "this_";
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public String getComment() {
        return "criteria query";
    }

    protected String getWithClause(PropertyPath propertyPath) {
        return this.translator.getWithClause(propertyPath.getFullPath());
    }
}

