/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom;

import java.util.Map;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.util.StringHelper;

public class ColumnCollectionAliases
implements CollectionAliases {
    private final String[] keyAliases;
    private final String[] indexAliases;
    private final String[] elementAliases;
    private final String identifierAlias;
    private Map userProvidedAliases;

    public ColumnCollectionAliases(Map map, SQLLoadableCollection sQLLoadableCollection) {
        this.userProvidedAliases = map;
        this.keyAliases = this.getUserProvidedAliases("key", sQLLoadableCollection.getKeyColumnNames());
        this.indexAliases = this.getUserProvidedAliases("index", sQLLoadableCollection.getIndexColumnNames());
        this.elementAliases = this.getUserProvidedAliases("element", sQLLoadableCollection.getElementColumnNames());
        this.identifierAlias = this.getUserProvidedAlias("id", sQLLoadableCollection.getIdentifierColumnName());
    }

    public String[] getSuffixedKeyAliases() {
        return this.keyAliases;
    }

    public String[] getSuffixedIndexAliases() {
        return this.indexAliases;
    }

    public String[] getSuffixedElementAliases() {
        return this.elementAliases;
    }

    public String getSuffixedIdentifierAlias() {
        return this.identifierAlias;
    }

    public String getSuffix() {
        return "";
    }

    public String toString() {
        return super.toString() + " [ suffixedKeyAliases=[" + this.join(this.keyAliases) + "], suffixedIndexAliases=[" + this.join(this.indexAliases) + "], suffixedElementAliases=[" + this.join(this.elementAliases) + "], suffixedIdentifierAlias=[" + this.identifierAlias + "]]";
    }

    private String join(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        return StringHelper.join(", ", stringArray);
    }

    private String[] getUserProvidedAliases(String string, String[] stringArray) {
        String[] stringArray2 = (String[])this.userProvidedAliases.get(string);
        if (stringArray2 == null) {
            return stringArray;
        }
        return stringArray2;
    }

    private String getUserProvidedAlias(String string, String string2) {
        String[] stringArray = (String[])this.userProvidedAliases.get(string);
        if (stringArray == null) {
            return string2;
        }
        return stringArray[0];
    }
}

