/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.sql.SQLQueryParser;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLCustomQuery
implements CustomQuery {
    public static final Logger log = LoggerFactory.getLogger(SQLCustomQuery.class);
    private final String sql;
    private final Set querySpaces = new HashSet();
    private final Map namedParameterBindPoints = new HashMap();
    private final List customQueryReturns = new ArrayList();

    public String getSQL() {
        return this.sql;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public Map getNamedParameterBindPoints() {
        return this.namedParameterBindPoints;
    }

    public List getCustomQueryReturns() {
        return this.customQueryReturns;
    }

    public SQLCustomQuery(String string, NativeSQLQueryReturn[] nativeSQLQueryReturnArray, Collection collection, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        log.trace("starting processing of sql query [" + string + "]");
        SQLQueryReturnProcessor sQLQueryReturnProcessor = new SQLQueryReturnProcessor(nativeSQLQueryReturnArray, sessionFactoryImplementor);
        SQLQueryReturnProcessor.ResultAliasContext resultAliasContext = sQLQueryReturnProcessor.process();
        SQLQueryParser sQLQueryParser = new SQLQueryParser(string, new ParserContext(resultAliasContext), sessionFactoryImplementor);
        this.sql = sQLQueryParser.process();
        this.namedParameterBindPoints.putAll(sQLQueryParser.getNamedParameters());
        this.customQueryReturns.addAll(sQLQueryReturnProcessor.generateCustomReturns(sQLQueryParser.queryHasAliases()));
        if (collection != null) {
            this.querySpaces.addAll(collection);
        }
    }

    private static class ParserContext
    implements SQLQueryParser.ParserContext {
        private final SQLQueryReturnProcessor.ResultAliasContext aliasContext;

        public ParserContext(SQLQueryReturnProcessor.ResultAliasContext resultAliasContext) {
            this.aliasContext = resultAliasContext;
        }

        public boolean isEntityAlias(String string) {
            return this.getEntityPersisterByAlias(string) != null;
        }

        public SQLLoadable getEntityPersisterByAlias(String string) {
            return this.aliasContext.getEntityPersister(string);
        }

        public String getEntitySuffixByAlias(String string) {
            return this.aliasContext.getEntitySuffix(string);
        }

        public boolean isCollectionAlias(String string) {
            return this.getCollectionPersisterByAlias(string) != null;
        }

        public SQLLoadableCollection getCollectionPersisterByAlias(String string) {
            return this.aliasContext.getCollectionPersister(string);
        }

        public String getCollectionSuffixByAlias(String string) {
            return this.aliasContext.getCollectionSuffix(string);
        }

        public Map getPropertyResultsMapByAlias(String string) {
            return this.aliasContext.getPropertyResultsMap(string);
        }
    }
}

