/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.QueryException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.ParameterParser;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;

public class SQLQueryParser {
    private static final String HIBERNATE_PLACEHOLDER_PREFIX = "h-";
    private static final String DOMAIN_PLACEHOLDER = "h-domain";
    private static final String CATALOG_PLACEHOLDER = "h-catalog";
    private static final String SCHEMA_PLACEHOLDER = "h-schema";
    private final SessionFactoryImplementor factory;
    private final String originalQueryString;
    private final ParserContext context;
    private final Map namedParameters = new HashMap();
    private long aliasesFound = 0L;

    public SQLQueryParser(String string, ParserContext parserContext, SessionFactoryImplementor sessionFactoryImplementor) {
        this.originalQueryString = string;
        this.context = parserContext;
        this.factory = sessionFactoryImplementor;
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }

    public boolean queryHasAliases() {
        return this.aliasesFound > 0L;
    }

    public String process() {
        String string = this.substituteBrackets(this.originalQueryString);
        string = this.substituteParams(string);
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String substituteBrackets(String string) throws QueryException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 20);
        int n = 0;
        while (n < string.length()) {
            String string2;
            int n2 = string.indexOf(123, n);
            if (n2 < 0) {
                stringBuffer.append(string.substring(n));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n, n2));
            int n3 = string.indexOf(125, n2 + 1);
            if (n3 < 0) {
                throw new QueryException("Unmatched braces for alias path", string);
            }
            String string3 = string.substring(n2 + 1, n3);
            boolean bl = string3.startsWith(HIBERNATE_PLACEHOLDER_PREFIX);
            if (bl) {
                if (DOMAIN_PLACEHOLDER.equals(string3)) {
                    String string4 = this.factory.getSettings().getDefaultCatalogName();
                    if (string4 != null) {
                        stringBuffer.append(string4);
                        stringBuffer.append(".");
                    }
                    if ((string2 = this.factory.getSettings().getDefaultSchemaName()) != null) {
                        stringBuffer.append(string2);
                        stringBuffer.append(".");
                    }
                } else if (SCHEMA_PLACEHOLDER.equals(string3)) {
                    String string5 = this.factory.getSettings().getDefaultSchemaName();
                    if (string5 != null) {
                        stringBuffer.append(string5);
                        stringBuffer.append(".");
                    }
                } else {
                    if (!CATALOG_PLACEHOLDER.equals(string3)) throw new QueryException("Unknown placeholder ", string3);
                    String string6 = this.factory.getSettings().getDefaultCatalogName();
                    if (string6 != null) {
                        stringBuffer.append(string6);
                        stringBuffer.append(".");
                    }
                }
            } else {
                int n4 = string3.indexOf(46);
                if (n4 == -1) {
                    if (this.context.isEntityAlias(string3)) {
                        stringBuffer.append(string3);
                        ++this.aliasesFound;
                    } else {
                        stringBuffer.append('{').append(string3).append('}');
                    }
                } else {
                    String string7;
                    string2 = string3.substring(0, n4);
                    if (this.context.isCollectionAlias(string2)) {
                        string7 = string3.substring(n4 + 1);
                        stringBuffer.append(this.resolveCollectionProperties(string2, string7));
                        ++this.aliasesFound;
                    } else if (this.context.isEntityAlias(string2)) {
                        string7 = string3.substring(n4 + 1);
                        stringBuffer.append(this.resolveProperties(string2, string7));
                        ++this.aliasesFound;
                    } else {
                        stringBuffer.append('{').append(string3).append('}');
                    }
                }
            }
            n = n3 + 1;
        }
        return stringBuffer.toString();
    }

    private String resolveCollectionProperties(String string, String string2) {
        Map map = this.context.getPropertyResultsMapByAlias(string);
        SQLLoadableCollection sQLLoadableCollection = this.context.getCollectionPersisterByAlias(string);
        String string3 = this.context.getCollectionSuffixByAlias(string);
        if ("*".equals(string2)) {
            if (!map.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            String string4 = sQLLoadableCollection.selectFragment(string, string3);
            ++this.aliasesFound;
            return string4 + ", " + this.resolveProperties(string, string2);
        }
        if ("element.*".equals(string2)) {
            return this.resolveProperties(string, "*");
        }
        String[] stringArray = (String[])map.get(string2);
        if (stringArray == null) {
            stringArray = sQLLoadableCollection.getCollectionPropertyColumnAliases(string2, string3);
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new QueryException("No column name found for property [" + string2 + "] for alias [" + string + "]", this.originalQueryString);
        }
        if (stringArray.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + string2 + "] is mapped to " + stringArray.length + " columns.", this.originalQueryString);
        }
        ++this.aliasesFound;
        return stringArray[0];
    }

    private String resolveProperties(String string, String string2) {
        Map map = this.context.getPropertyResultsMapByAlias(string);
        SQLLoadable sQLLoadable = this.context.getEntityPersisterByAlias(string);
        String string3 = this.context.getEntitySuffixByAlias(string);
        if ("*".equals(string2)) {
            if (!map.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            ++this.aliasesFound;
            return sQLLoadable.selectFragment(string, string3);
        }
        String[] stringArray = (String[])map.get(string2);
        if (stringArray == null) {
            stringArray = sQLLoadable.getSubclassPropertyColumnAliases(string2, string3);
        }
        if (stringArray == null || stringArray.length == 0) {
            throw new QueryException("No column name found for property [" + string2 + "] for alias [" + string + "]", this.originalQueryString);
        }
        if (stringArray.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + string2 + "] is mapped to " + stringArray.length + " columns.", this.originalQueryString);
        }
        ++this.aliasesFound;
        return stringArray[0];
    }

    private String substituteParams(String string) {
        ParameterSubstitutionRecognizer parameterSubstitutionRecognizer = new ParameterSubstitutionRecognizer();
        ParameterParser.parse(string, parameterSubstitutionRecognizer);
        this.namedParameters.clear();
        this.namedParameters.putAll(parameterSubstitutionRecognizer.namedParameterBindPoints);
        return parameterSubstitutionRecognizer.result.toString();
    }

    public static class ParameterSubstitutionRecognizer
    implements ParameterParser.Recognizer {
        StringBuffer result = new StringBuffer();
        Map namedParameterBindPoints = new HashMap();
        int parameterCount = 0;

        public void outParameter(int n) {
            this.result.append('?');
        }

        public void ordinalParameter(int n) {
            this.result.append('?');
        }

        public void namedParameter(String string, int n) {
            this.addNamedParameter(string);
            this.result.append('?');
        }

        public void jpaPositionalParameter(String string, int n) {
            this.namedParameter(string, n);
        }

        public void other(char c) {
            this.result.append(c);
        }

        private void addNamedParameter(String string) {
            Integer n = new Integer(this.parameterCount++);
            Object v = this.namedParameterBindPoints.get(string);
            if (v == null) {
                this.namedParameterBindPoints.put(string, n);
            } else if (v instanceof Integer) {
                ArrayList<Object> arrayList = new ArrayList<Object>(4);
                arrayList.add(v);
                arrayList.add(n);
                this.namedParameterBindPoints.put(string, arrayList);
            } else {
                ((List)v).add(n);
            }
        }
    }

    static interface ParserContext {
        public boolean isEntityAlias(String var1);

        public SQLLoadable getEntityPersisterByAlias(String var1);

        public String getEntitySuffixByAlias(String var1);

        public boolean isCollectionAlias(String var1);

        public SQLLoadableCollection getCollectionPersisterByAlias(String var1);

        public String getCollectionSuffixByAlias(String var1);

        public Map getPropertyResultsMapByAlias(String var1);
    }
}

