/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.query.sql.NativeSQLQueryCollectionReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryJoinReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryNonScalarReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryRootReturn;
import org.hibernate.engine.query.sql.NativeSQLQueryScalarReturn;
import org.hibernate.loader.BasicLoader;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.ColumnEntityAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.custom.CollectionFetchReturn;
import org.hibernate.loader.custom.CollectionReturn;
import org.hibernate.loader.custom.ColumnCollectionAliases;
import org.hibernate.loader.custom.EntityFetchReturn;
import org.hibernate.loader.custom.NonScalarReturn;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.ScalarReturn;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLQueryReturnProcessor {
    public static final Logger log = LoggerFactory.getLogger(SQLQueryReturnProcessor.class);
    private NativeSQLQueryReturn[] queryReturns;
    private final Map alias2Return = new HashMap();
    private final Map alias2OwnerAlias = new HashMap();
    private final Map alias2Persister = new HashMap();
    private final Map alias2Suffix = new HashMap();
    private final Map alias2CollectionPersister = new HashMap();
    private final Map alias2CollectionSuffix = new HashMap();
    private final Map entityPropertyResultMaps = new HashMap();
    private final Map collectionPropertyResultMaps = new HashMap();
    private final SessionFactoryImplementor factory;
    private int entitySuffixSeed = 0;
    private int collectionSuffixSeed = 0;

    public SQLQueryReturnProcessor(NativeSQLQueryReturn[] nativeSQLQueryReturnArray, SessionFactoryImplementor sessionFactoryImplementor) {
        this.queryReturns = nativeSQLQueryReturnArray;
        this.factory = sessionFactoryImplementor;
    }

    private Map internalGetPropertyResultsMap(String string) {
        NativeSQLQueryReturn nativeSQLQueryReturn = (NativeSQLQueryReturn)this.alias2Return.get(string);
        if (nativeSQLQueryReturn instanceof NativeSQLQueryNonScalarReturn) {
            return ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getPropertyResultsMap();
        }
        return null;
    }

    private boolean hasPropertyResultMap(String string) {
        Map map = this.internalGetPropertyResultsMap(string);
        return map != null && !map.isEmpty();
    }

    public ResultAliasContext process() {
        int n;
        for (n = 0; n < this.queryReturns.length; ++n) {
            if (!(this.queryReturns[n] instanceof NativeSQLQueryNonScalarReturn)) continue;
            NativeSQLQueryNonScalarReturn nativeSQLQueryNonScalarReturn = (NativeSQLQueryNonScalarReturn)this.queryReturns[n];
            this.alias2Return.put(nativeSQLQueryNonScalarReturn.getAlias(), nativeSQLQueryNonScalarReturn);
            if (!(nativeSQLQueryNonScalarReturn instanceof NativeSQLQueryJoinReturn)) continue;
            NativeSQLQueryJoinReturn nativeSQLQueryJoinReturn = (NativeSQLQueryJoinReturn)nativeSQLQueryNonScalarReturn;
            this.alias2OwnerAlias.put(nativeSQLQueryJoinReturn.getAlias(), nativeSQLQueryJoinReturn.getOwnerAlias());
        }
        for (n = 0; n < this.queryReturns.length; ++n) {
            this.processReturn(this.queryReturns[n]);
        }
        return new ResultAliasContext();
    }

    public List generateCustomReturns(boolean bl) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < this.queryReturns.length; ++i) {
            Object object;
            Object object2;
            NonScalarReturn nonScalarReturn;
            Object object3;
            String string;
            NativeSQLQueryReturn nativeSQLQueryReturn;
            if (this.queryReturns[i] instanceof NativeSQLQueryScalarReturn) {
                nativeSQLQueryReturn = (NativeSQLQueryScalarReturn)this.queryReturns[i];
                arrayList.add(new ScalarReturn(((NativeSQLQueryScalarReturn)nativeSQLQueryReturn).getType(), ((NativeSQLQueryScalarReturn)nativeSQLQueryReturn).getColumnAlias()));
                continue;
            }
            if (this.queryReturns[i] instanceof NativeSQLQueryRootReturn) {
                nativeSQLQueryReturn = (NativeSQLQueryRootReturn)this.queryReturns[i];
                string = ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getAlias();
                object3 = bl || this.hasPropertyResultMap(string) ? new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string)) : new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string));
                nonScalarReturn = new RootReturn(string, ((NativeSQLQueryRootReturn)nativeSQLQueryReturn).getReturnEntityName(), (EntityAliases)object3, ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getLockMode());
                arrayList.add(nonScalarReturn);
                hashMap.put(((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getAlias(), nonScalarReturn);
                continue;
            }
            if (this.queryReturns[i] instanceof NativeSQLQueryCollectionReturn) {
                nativeSQLQueryReturn = (NativeSQLQueryCollectionReturn)this.queryReturns[i];
                string = ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getAlias();
                object3 = (SQLLoadableCollection)this.alias2CollectionPersister.get(string);
                boolean bl2 = object3.getElementType().isEntityType();
                DefaultEntityAliases defaultEntityAliases = null;
                if (bl || this.hasPropertyResultMap(string)) {
                    object2 = new GeneratedCollectionAliases((Map)this.collectionPropertyResultMaps.get(string), (SQLLoadableCollection)this.alias2CollectionPersister.get(string), (String)this.alias2CollectionSuffix.get(string));
                    if (bl2) {
                        defaultEntityAliases = new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string));
                    }
                } else {
                    object2 = new ColumnCollectionAliases((Map)this.collectionPropertyResultMaps.get(string), (SQLLoadableCollection)this.alias2CollectionPersister.get(string));
                    if (bl2) {
                        defaultEntityAliases = new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string));
                    }
                }
                object = new CollectionReturn(string, ((NativeSQLQueryCollectionReturn)nativeSQLQueryReturn).getOwnerEntityName(), ((NativeSQLQueryCollectionReturn)nativeSQLQueryReturn).getOwnerProperty(), (CollectionAliases)object2, defaultEntityAliases, ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getLockMode());
                arrayList.add(object);
                hashMap.put(((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getAlias(), object);
                continue;
            }
            if (!(this.queryReturns[i] instanceof NativeSQLQueryJoinReturn)) continue;
            nativeSQLQueryReturn = (NativeSQLQueryJoinReturn)this.queryReturns[i];
            string = ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getAlias();
            nonScalarReturn = (NonScalarReturn)hashMap.get(((NativeSQLQueryJoinReturn)nativeSQLQueryReturn).getOwnerAlias());
            if (this.alias2CollectionPersister.containsKey(string)) {
                object2 = (SQLLoadableCollection)this.alias2CollectionPersister.get(string);
                boolean bl3 = object2.getElementType().isEntityType();
                DefaultEntityAliases defaultEntityAliases = null;
                if (bl || this.hasPropertyResultMap(string)) {
                    object = new GeneratedCollectionAliases((Map)this.collectionPropertyResultMaps.get(string), (CollectionPersister)object2, (String)this.alias2CollectionSuffix.get(string));
                    if (bl3) {
                        defaultEntityAliases = new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string));
                    }
                } else {
                    object = new ColumnCollectionAliases((Map)this.collectionPropertyResultMaps.get(string), (SQLLoadableCollection)object2);
                    if (bl3) {
                        defaultEntityAliases = new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string));
                    }
                }
                object3 = new CollectionFetchReturn(string, nonScalarReturn, ((NativeSQLQueryJoinReturn)nativeSQLQueryReturn).getOwnerProperty(), (CollectionAliases)object, defaultEntityAliases, ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getLockMode());
            } else {
                object2 = bl || this.hasPropertyResultMap(string) ? new DefaultEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string)) : new ColumnEntityAliases((Map)this.entityPropertyResultMaps.get(string), (SQLLoadable)this.alias2Persister.get(string), (String)this.alias2Suffix.get(string));
                object3 = new EntityFetchReturn(string, (EntityAliases)object2, nonScalarReturn, ((NativeSQLQueryJoinReturn)nativeSQLQueryReturn).getOwnerProperty(), ((NativeSQLQueryNonScalarReturn)nativeSQLQueryReturn).getLockMode());
            }
            arrayList.add(object3);
            hashMap.put(string, object3);
        }
        return arrayList;
    }

    private SQLLoadable getSQLLoadable(String string) throws MappingException {
        EntityPersister entityPersister = this.factory.getEntityPersister(string);
        if (!(entityPersister instanceof SQLLoadable)) {
            throw new MappingException("class persister is not SQLLoadable: " + string);
        }
        return (SQLLoadable)entityPersister;
    }

    private String generateEntitySuffix() {
        return BasicLoader.generateSuffixes(this.entitySuffixSeed++, 1)[0];
    }

    private String generateCollectionSuffix() {
        return this.collectionSuffixSeed++ + "__";
    }

    private void processReturn(NativeSQLQueryReturn nativeSQLQueryReturn) {
        if (nativeSQLQueryReturn instanceof NativeSQLQueryScalarReturn) {
            this.processScalarReturn((NativeSQLQueryScalarReturn)nativeSQLQueryReturn);
        } else if (nativeSQLQueryReturn instanceof NativeSQLQueryRootReturn) {
            this.processRootReturn((NativeSQLQueryRootReturn)nativeSQLQueryReturn);
        } else if (nativeSQLQueryReturn instanceof NativeSQLQueryCollectionReturn) {
            this.processCollectionReturn((NativeSQLQueryCollectionReturn)nativeSQLQueryReturn);
        } else {
            this.processJoinReturn((NativeSQLQueryJoinReturn)nativeSQLQueryReturn);
        }
    }

    private void processScalarReturn(NativeSQLQueryScalarReturn nativeSQLQueryScalarReturn) {
    }

    private void processRootReturn(NativeSQLQueryRootReturn nativeSQLQueryRootReturn) {
        if (this.alias2Persister.containsKey(nativeSQLQueryRootReturn.getAlias())) {
            return;
        }
        SQLLoadable sQLLoadable = this.getSQLLoadable(nativeSQLQueryRootReturn.getReturnEntityName());
        this.addPersister(nativeSQLQueryRootReturn.getAlias(), nativeSQLQueryRootReturn.getPropertyResultsMap(), sQLLoadable);
    }

    private void addPersister(String string, Map map, SQLLoadable sQLLoadable) {
        this.alias2Persister.put(string, sQLLoadable);
        String string2 = this.generateEntitySuffix();
        log.trace("mapping alias [" + string + "] to entity-suffix [" + string2 + "]");
        this.alias2Suffix.put(string, string2);
        this.entityPropertyResultMaps.put(string, map);
    }

    private void addCollection(String string, String string2, Map map) {
        SQLLoadableCollection sQLLoadableCollection = (SQLLoadableCollection)this.factory.getCollectionPersister(string);
        this.alias2CollectionPersister.put(string2, sQLLoadableCollection);
        String string3 = this.generateCollectionSuffix();
        log.trace("mapping alias [" + string2 + "] to collection-suffix [" + string3 + "]");
        this.alias2CollectionSuffix.put(string2, string3);
        this.collectionPropertyResultMaps.put(string2, map);
        if (sQLLoadableCollection.isOneToMany() || sQLLoadableCollection.isManyToMany()) {
            SQLLoadable sQLLoadable = (SQLLoadable)sQLLoadableCollection.getElementPersister();
            this.addPersister(string2, this.filter(map), sQLLoadable);
        }
    }

    private Map filter(Map map) {
        HashMap hashMap = new HashMap(map.size());
        String string = "element.";
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            if (!string2.startsWith(string)) continue;
            hashMap.put(string2.substring(string.length()), entry.getValue());
        }
        return hashMap;
    }

    private void processCollectionReturn(NativeSQLQueryCollectionReturn nativeSQLQueryCollectionReturn) {
        String string = nativeSQLQueryCollectionReturn.getOwnerEntityName() + '.' + nativeSQLQueryCollectionReturn.getOwnerProperty();
        this.addCollection(string, nativeSQLQueryCollectionReturn.getAlias(), nativeSQLQueryCollectionReturn.getPropertyResultsMap());
    }

    private void processJoinReturn(NativeSQLQueryJoinReturn nativeSQLQueryJoinReturn) {
        Type type;
        Object object;
        String string = nativeSQLQueryJoinReturn.getAlias();
        if (this.alias2Persister.containsKey(string) || this.alias2CollectionPersister.containsKey(string)) {
            return;
        }
        String string2 = nativeSQLQueryJoinReturn.getOwnerAlias();
        if (!this.alias2Return.containsKey(string2)) {
            throw new HibernateException("Owner alias [" + string2 + "] is unknown for alias [" + string + "]");
        }
        if (!this.alias2Persister.containsKey(string2)) {
            object = (NativeSQLQueryNonScalarReturn)this.alias2Return.get(string2);
            this.processReturn((NativeSQLQueryReturn)object);
        }
        if ((type = (object = (SQLLoadable)this.alias2Persister.get(string2)).getPropertyType(nativeSQLQueryJoinReturn.getOwnerProperty())).isCollectionType()) {
            String string3 = object.getEntityName() + '.' + nativeSQLQueryJoinReturn.getOwnerProperty();
            this.addCollection(string3, string, nativeSQLQueryJoinReturn.getPropertyResultsMap());
        } else if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            String string4 = entityType.getAssociatedEntityName();
            SQLLoadable sQLLoadable = this.getSQLLoadable(string4);
            this.addPersister(string, nativeSQLQueryJoinReturn.getPropertyResultsMap(), sQLLoadable);
        }
    }

    class ResultAliasContext {
        ResultAliasContext() {
        }

        public SQLLoadable getEntityPersister(String string) {
            return (SQLLoadable)SQLQueryReturnProcessor.this.alias2Persister.get(string);
        }

        public SQLLoadableCollection getCollectionPersister(String string) {
            return (SQLLoadableCollection)SQLQueryReturnProcessor.this.alias2CollectionPersister.get(string);
        }

        public String getEntitySuffix(String string) {
            return (String)SQLQueryReturnProcessor.this.alias2Suffix.get(string);
        }

        public String getCollectionSuffix(String string) {
            return (String)SQLQueryReturnProcessor.this.alias2CollectionSuffix.get(string);
        }

        public String getOwnerAlias(String string) {
            return (String)SQLQueryReturnProcessor.this.alias2OwnerAlias.get(string);
        }

        public Map getPropertyResultsMap(String string) {
            return SQLQueryReturnProcessor.this.internalGetPropertyResultsMap(string);
        }
    }
}

