/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import java.io.Serializable;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.Loader;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class BatchingEntityLoader
implements UniqueEntityLoader {
    private final Loader[] loaders;
    private final int[] batchSizes;
    private final EntityPersister persister;
    private final Type idType;

    public BatchingEntityLoader(EntityPersister entityPersister, int[] nArray, Loader[] loaderArray) {
        this.batchSizes = nArray;
        this.loaders = loaderArray;
        this.persister = entityPersister;
        this.idType = entityPersister.getIdentifierType();
    }

    private Object getObjectFromList(List list, Serializable serializable, SessionImplementor sessionImplementor) {
        for (Object e : list) {
            boolean bl = this.idType.isEqual(serializable, sessionImplementor.getContextEntityIdentifier(e), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            if (!bl) continue;
            return e;
        }
        return null;
    }

    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor) {
        return this.load(serializable, object, sessionImplementor, LockOptions.NONE);
    }

    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor, LockOptions lockOptions) {
        Serializable[] serializableArray = sessionImplementor.getPersistenceContext().getBatchFetchQueue().getEntityBatch(this.persister, serializable, this.batchSizes[0], sessionImplementor.getEntityMode());
        for (int i = 0; i < this.batchSizes.length - 1; ++i) {
            int n = this.batchSizes[i];
            if (serializableArray[n - 1] == null) continue;
            Serializable[] serializableArray2 = new Serializable[n];
            System.arraycopy(serializableArray, 0, serializableArray2, 0, n);
            List list = this.loaders[i].loadEntityBatch(sessionImplementor, serializableArray2, this.idType, object, this.persister.getEntityName(), serializable, this.persister, lockOptions);
            return this.getObjectFromList(list, serializable, sessionImplementor);
        }
        return ((UniqueEntityLoader)((Object)this.loaders[this.batchSizes.length - 1])).load(serializable, object, sessionImplementor);
    }

    public static UniqueEntityLoader createBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        if (n > 1) {
            int[] nArray = ArrayHelper.getBatchSizes(n);
            Loader[] loaderArray = new Loader[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                loaderArray[i] = new EntityLoader(outerJoinLoadable, nArray[i], lockMode, sessionFactoryImplementor, loadQueryInfluencers);
            }
            return new BatchingEntityLoader(outerJoinLoadable, nArray, loaderArray);
        }
        return new EntityLoader(outerJoinLoadable, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public static UniqueEntityLoader createBatchingEntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        if (n > 1) {
            int[] nArray = ArrayHelper.getBatchSizes(n);
            Loader[] loaderArray = new Loader[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                loaderArray[i] = new EntityLoader(outerJoinLoadable, nArray[i], lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
            }
            return new BatchingEntityLoader(outerJoinLoadable, nArray, loaderArray);
        }
        return new EntityLoader(outerJoinLoadable, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
    }
}

