/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import org.hibernate.FetchMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.AbstractEntityJoinWalker;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.AssociationType;
import org.hibernate.util.CollectionHelper;

public class CascadeEntityJoinWalker
extends AbstractEntityJoinWalker {
    private final CascadingAction cascadeAction;

    public CascadeEntityJoinWalker(OuterJoinLoadable outerJoinLoadable, CascadingAction cascadingAction, SessionFactoryImplementor sessionFactoryImplementor) throws MappingException {
        super(outerJoinLoadable, sessionFactoryImplementor, LoadQueryInfluencers.NONE);
        this.cascadeAction = cascadingAction;
        StringBuffer stringBuffer = this.whereString(this.getAlias(), outerJoinLoadable.getIdentifierColumnNames(), 1).append(outerJoinLoadable.filterFragment(this.getAlias(), CollectionHelper.EMPTY_MAP));
        this.initAll(stringBuffer.toString(), "", LockOptions.READ);
    }

    protected boolean isJoinedFetchEnabled(AssociationType associationType, FetchMode fetchMode, CascadeStyle cascadeStyle) {
        return !(!associationType.isEntityType() && !associationType.isCollectionType() || cascadeStyle != null && !cascadeStyle.doCascade(this.cascadeAction));
    }

    protected boolean isTooManyCollections() {
        return CascadeEntityJoinWalker.countCollectionPersisters(this.associations) > 0;
    }

    public String getComment() {
        return "load " + this.getPersister().getEntityName();
    }
}

