/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.entity;

import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.entity.AbstractEntityLoader;
import org.hibernate.loader.entity.EntityJoinWalker;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.type.Type;

public class EntityLoader
extends AbstractEntityLoader {
    private final boolean batchLoader;
    private final int[][] compositeKeyManyToOneTargetIndices;

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(outerJoinLoadable, 1, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(outerJoinLoadable, 1, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(outerJoinLoadable, outerJoinLoadable.getIdentifierColumnNames(), outerJoinLoadable.getIdentifierType(), n, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        this(outerJoinLoadable, outerJoinLoadable.getIdentifierColumnNames(), outerJoinLoadable.getIdentifierType(), n, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
    }

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, String[] stringArray, Type type, int n, LockMode lockMode, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(outerJoinLoadable, type, sessionFactoryImplementor, loadQueryInfluencers);
        EntityJoinWalker entityJoinWalker = new EntityJoinWalker(outerJoinLoadable, stringArray, n, lockMode, sessionFactoryImplementor, loadQueryInfluencers);
        this.initFromWalker(entityJoinWalker);
        this.compositeKeyManyToOneTargetIndices = entityJoinWalker.getCompositeKeyManyToOneTargetIndices();
        this.postInstantiate();
        this.batchLoader = n > 1;
        log.debug("Static select for entity " + this.entityName + " [" + lockMode + "]: " + this.getSQLString());
    }

    public EntityLoader(OuterJoinLoadable outerJoinLoadable, String[] stringArray, Type type, int n, LockOptions lockOptions, SessionFactoryImplementor sessionFactoryImplementor, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        super(outerJoinLoadable, type, sessionFactoryImplementor, loadQueryInfluencers);
        EntityJoinWalker entityJoinWalker = new EntityJoinWalker(outerJoinLoadable, stringArray, n, lockOptions, sessionFactoryImplementor, loadQueryInfluencers);
        this.initFromWalker(entityJoinWalker);
        this.compositeKeyManyToOneTargetIndices = entityJoinWalker.getCompositeKeyManyToOneTargetIndices();
        this.postInstantiate();
        this.batchLoader = n > 1;
        log.debug("Static select for entity " + this.entityName + " [" + lockOptions.getLockMode() + ":" + lockOptions.getTimeOut() + "]: " + this.getSQLString());
    }

    public Object loadByUniqueKey(SessionImplementor sessionImplementor, Object object) {
        return this.load(sessionImplementor, object, null, null, LockOptions.NONE);
    }

    protected boolean isSingleRowLoader() {
        return !this.batchLoader;
    }

    public int[][] getCompositeKeyManyToOneTargetIndices() {
        return this.compositeKeyManyToOneTargetIndices;
    }
}

