/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.SQLFunctionRegistry;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.sql.Template;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class Column
implements Selectable,
Serializable,
Cloneable {
    public static final int DEFAULT_LENGTH = 255;
    public static final int DEFAULT_PRECISION = 19;
    public static final int DEFAULT_SCALE = 2;
    private int length = 255;
    private int precision = 19;
    private int scale = 2;
    private Value value;
    private int typeIndex = 0;
    private String name;
    private boolean nullable = true;
    private boolean unique = false;
    private String sqlType;
    private Integer sqlTypeCode;
    private boolean quoted = false;
    int uniqueInteger;
    private String checkConstraint;
    private String comment;
    private String defaultValue;
    private String customWrite;
    private String customRead;

    public Column() {
    }

    public Column(String string) {
        this.setName(string);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string.charAt(0) == '`' || "`\"[".indexOf(string.charAt(0)) > -1) {
            this.quoted = true;
            this.name = string.substring(1, string.length() - 1);
        } else {
            this.name = string;
        }
    }

    public String getQuotedName() {
        return this.quoted ? "`" + this.name + "`" : this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return this.quoted ? dialect.openQuote() + this.name + dialect.closeQuote() : this.name;
    }

    public String getAlias(Dialect dialect) {
        boolean bl;
        String string = this.name;
        String string2 = Integer.toString(this.uniqueInteger) + '_';
        int n = StringHelper.lastIndexOfLetter(this.name);
        if (n == -1) {
            string = "column";
        } else if (n < this.name.length() - 1) {
            string = this.name.substring(0, n + 1);
        }
        if (string.length() > dialect.getMaxAliasLength()) {
            string = string.substring(0, dialect.getMaxAliasLength() - string2.length());
        }
        boolean bl2 = bl = this.name.equals(string) && !this.quoted && !this.name.toLowerCase().equals("rowid");
        if (bl) {
            return string;
        }
        return string + string2;
    }

    public String getAlias(Dialect dialect, Table table) {
        return this.getAlias(dialect) + table.getUniqueInteger() + '_';
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public void setTypeIndex(int n) {
        this.typeIndex = n;
    }

    public int getSqlTypeCode(Mapping mapping) throws MappingException {
        Type type = this.getValue().getType();
        try {
            int n = type.sqlTypes(mapping)[this.getTypeIndex()];
            if (this.getSqlTypeCode() != null && this.getSqlTypeCode() != n) {
                throw new MappingException("SQLType code's does not match. mapped as " + n + " but is " + this.getSqlTypeCode());
            }
            return n;
        }
        catch (Exception exception) {
            throw new MappingException("Could not determine type for column " + this.name + " of type " + type.getClass().getName() + ": " + exception.getClass().getName(), exception);
        }
    }

    public Integer getSqlTypeCode() {
        return this.sqlTypeCode;
    }

    public void setSqlTypeCode(Integer n) {
        this.sqlTypeCode = n;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getSqlType(Dialect dialect, Mapping mapping) throws HibernateException {
        return this.sqlType == null ? dialect.getTypeName(this.getSqlTypeCode(mapping), this.getLength(), this.getPrecision(), this.getScale()) : this.sqlType;
    }

    public boolean equals(Object object) {
        return object instanceof Column && this.equals((Column)object);
    }

    public boolean equals(Column column) {
        if (null == column) {
            return false;
        }
        if (this == column) {
            return true;
        }
        return this.isQuoted() ? this.name.equals(column.name) : this.name.equalsIgnoreCase(column.name);
    }

    public int hashCode() {
        return this.isQuoted() ? this.name.hashCode() : this.name.toLowerCase().hashCode();
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(String string) {
        this.sqlType = string;
    }

    public void setUnique(boolean bl) {
        this.unique = bl;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getName() + ')';
    }

    public String getCheckConstraint() {
        return this.checkConstraint;
    }

    public void setCheckConstraint(String string) {
        this.checkConstraint = string;
    }

    public boolean hasCheckConstraint() {
        return this.checkConstraint != null;
    }

    public String getTemplate(Dialect dialect, SQLFunctionRegistry sQLFunctionRegistry) {
        return this.hasCustomRead() ? Template.renderWhereStringTemplate(this.customRead, dialect, sQLFunctionRegistry) : "$PlaceHolder$." + this.getQuotedName(dialect);
    }

    public boolean hasCustomRead() {
        return this.customRead != null && this.customRead.length() > 0;
    }

    public String getReadExpr(Dialect dialect) {
        return this.hasCustomRead() ? this.customRead : this.getQuotedName(dialect);
    }

    public String getWriteExpr() {
        return this.customWrite != null && this.customWrite.length() > 0 ? this.customWrite : "?";
    }

    public boolean isFormula() {
        return false;
    }

    public String getText(Dialect dialect) {
        return this.getQuotedName(dialect);
    }

    public String getText() {
        return this.getName();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getCustomWrite() {
        return this.customWrite;
    }

    public void setCustomWrite(String string) {
        this.customWrite = string;
    }

    public String getCustomRead() {
        return this.customRead;
    }

    public void setCustomRead(String string) {
        this.customRead = string;
    }

    public String getCanonicalName() {
        return this.quoted ? this.name : this.name.toLowerCase();
    }

    protected Object clone() {
        Column column = new Column();
        column.setLength(this.length);
        column.setScale(this.scale);
        column.setValue(this.value);
        column.setTypeIndex(this.typeIndex);
        column.setName(this.getQuotedName());
        column.setNullable(this.nullable);
        column.setPrecision(this.precision);
        column.setUnique(this.unique);
        column.setSqlType(this.sqlType);
        column.setSqlTypeCode(this.sqlTypeCode);
        column.uniqueInteger = this.uniqueInteger;
        column.setCheckConstraint(this.checkConstraint);
        column.setComment(this.comment);
        column.setDefaultValue(this.defaultValue);
        column.setCustomRead(this.customRead);
        column.setCustomWrite(this.customWrite);
        return column;
    }
}

