/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimaryKey;

public abstract class IdentifierCollection
extends Collection {
    public static final String DEFAULT_IDENTIFIER_COLUMN_NAME = "id";
    private KeyValue identifier;

    public IdentifierCollection(Mappings mappings, PersistentClass persistentClass) {
        super(mappings, persistentClass);
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(KeyValue keyValue) {
        this.identifier = keyValue;
    }

    public final boolean isIdentified() {
        return true;
    }

    void createPrimaryKey() {
        if (!this.isOneToMany()) {
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.addColumns(this.getIdentifier().getColumnIterator());
            this.getCollectionTable().setPrimaryKey(primaryKey);
        }
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (!this.getIdentifier().isValid(mapping)) {
            throw new MappingException("collection id mapping has wrong number of columns: " + this.getRole() + " type: " + this.getIdentifier().getType().getName());
        }
    }
}

