/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;

public class JoinedSubclass
extends Subclass
implements TableOwner {
    private Table table;
    private KeyValue key;

    public JoinedSubclass(PersistentClass persistentClass) {
        super(persistentClass);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
        this.getSuperclass().addSubclassTable(table);
    }

    public KeyValue getKey() {
        return this.key;
    }

    public void setKey(KeyValue keyValue) {
        this.key = keyValue;
    }

    public void validate(Mapping mapping) throws MappingException {
        super.validate(mapping);
        if (this.key != null && !this.key.isValid(mapping)) {
            throw new MappingException("subclass key mapping has wrong number of columns: " + this.getEntityName() + " type: " + this.key.getType().getName());
        }
    }

    public Iterator getReferenceablePropertyIterator() {
        return this.getPropertyIterator();
    }

    public Object accept(PersistentClassVisitor persistentClassVisitor) {
        return persistentClassVisitor.accept(this);
    }
}

