/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class MappedSuperclass {
    private final MappedSuperclass superMappedSuperclass;
    private final PersistentClass superPersistentClass;
    private final List declaredProperties;
    private Class mappedClass;
    private Property identifierProperty;
    private Property version;
    private Component identifierMapper;

    public MappedSuperclass(MappedSuperclass mappedSuperclass, PersistentClass persistentClass) {
        this.superMappedSuperclass = mappedSuperclass;
        this.superPersistentClass = persistentClass;
        this.declaredProperties = new ArrayList();
    }

    public MappedSuperclass getSuperMappedSuperclass() {
        return this.superMappedSuperclass;
    }

    public boolean hasIdentifierProperty() {
        return this.getIdentifierProperty() != null;
    }

    public boolean isVersioned() {
        return this.getVersion() != null;
    }

    public PersistentClass getSuperPersistentClass() {
        return this.superPersistentClass;
    }

    public Iterator getDeclaredPropertyIterator() {
        return this.declaredProperties.iterator();
    }

    public void addDeclaredProperty(Property property) {
        String string = property.getName();
        Iterator iterator = this.declaredProperties.iterator();
        while (iterator.hasNext()) {
            if (!string.equals(((Property)iterator.next()).getName())) continue;
            return;
        }
        this.declaredProperties.add(property);
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public void setMappedClass(Class clazz) {
        this.mappedClass = clazz;
    }

    public Property getIdentifierProperty() {
        Property property = this.identifierProperty;
        if (property == null) {
            if (this.superMappedSuperclass != null) {
                property = this.superMappedSuperclass.getIdentifierProperty();
            }
            if (property == null && this.superPersistentClass != null) {
                property = this.superPersistentClass.getIdentifierProperty();
            }
        }
        return property;
    }

    public Property getDeclaredIdentifierProperty() {
        return this.identifierProperty;
    }

    public void setDeclaredIdentifierProperty(Property property) {
        this.identifierProperty = property;
    }

    public Property getVersion() {
        Property property = this.version;
        if (property == null) {
            if (this.superMappedSuperclass != null) {
                property = this.superMappedSuperclass.getVersion();
            }
            if (property == null && this.superPersistentClass != null) {
                property = this.superPersistentClass.getVersion();
            }
        }
        return property;
    }

    public Property getDeclaredVersion() {
        return this.version;
    }

    public void setDeclaredVersion(Property property) {
        this.version = property;
    }

    public Component getIdentifierMapper() {
        Component component = this.identifierMapper;
        if (component == null) {
            if (this.superMappedSuperclass != null) {
                component = this.superMappedSuperclass.getIdentifierMapper();
            }
            if (component == null && this.superPersistentClass != null) {
                component = this.superPersistentClass.getIdentifierMapper();
            }
        }
        return component;
    }

    public Component getDeclaredIdentifierMapper() {
        return this.identifierMapper;
    }

    public void setDeclaredIdentifierMapper(Component component) {
        this.identifierMapper = component;
    }
}

