/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class OneToMany
implements Value {
    private final Mappings mappings;
    private final Table referencingTable;
    private String referencedEntityName;
    private PersistentClass associatedClass;
    private boolean embedded;
    private boolean ignoreNotFound;

    private EntityType getEntityType() {
        return this.mappings.getTypeResolver().getTypeFactory().manyToOne(this.getReferencedEntityName(), null, false, false, this.isEmbedded(), this.isIgnoreNotFound(), false);
    }

    public OneToMany(Mappings mappings, PersistentClass persistentClass) throws MappingException {
        this.mappings = mappings;
        this.referencingTable = persistentClass == null ? null : persistentClass.getTable();
    }

    public PersistentClass getAssociatedClass() {
        return this.associatedClass;
    }

    public void setAssociatedClass(PersistentClass persistentClass) {
        this.associatedClass = persistentClass;
    }

    public void createForeignKey() {
    }

    public Iterator getColumnIterator() {
        return this.associatedClass.getKey().getColumnIterator();
    }

    public int getColumnSpan() {
        return this.associatedClass.getKey().getColumnSpan();
    }

    public FetchMode getFetchMode() {
        return FetchMode.JOIN;
    }

    public Table getTable() {
        return this.referencingTable;
    }

    public Type getType() {
        return this.getEntityType();
    }

    public boolean isNullable() {
        return false;
    }

    public boolean isSimpleValue() {
        return false;
    }

    public boolean isAlternateUniqueKey() {
        return false;
    }

    public boolean hasFormula() {
        return false;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        if (this.referencedEntityName == null) {
            throw new MappingException("one to many association must specify the referenced entity");
        }
        return true;
    }

    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    public void setReferencedEntityName(String string) {
        this.referencedEntityName = string == null ? null : string.intern();
    }

    public void setTypeUsingReflection(String string, String string2) {
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }

    public boolean[] getColumnInsertability() {
        throw new UnsupportedOperationException();
    }

    public boolean[] getColumnUpdateability() {
        throw new UnsupportedOperationException();
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean bl) {
        this.embedded = bl;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public void setIgnoreNotFound(boolean bl) {
        this.ignoreNotFound = bl;
    }
}

