/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;

public class OneToOne
extends ToOne {
    private boolean constrained;
    private ForeignKeyDirection foreignKeyType;
    private KeyValue identifier;
    private String propertyName;
    private String entityName;

    public OneToOne(Mappings mappings, Table table, PersistentClass persistentClass) throws MappingException {
        super(mappings, table);
        this.identifier = persistentClass.getKey();
        this.entityName = persistentClass.getEntityName();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string == null ? null : string.intern();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String string) {
        this.entityName = this.entityName == null ? null : this.entityName.intern();
    }

    public Type getType() throws MappingException {
        if (this.getColumnIterator().hasNext()) {
            return this.getMappings().getTypeResolver().getTypeFactory().specialOneToOne(this.getReferencedEntityName(), this.foreignKeyType, this.referencedPropertyName, this.isLazy(), this.isUnwrapProxy(), this.entityName, this.propertyName);
        }
        return this.getMappings().getTypeResolver().getTypeFactory().oneToOne(this.getReferencedEntityName(), this.foreignKeyType, this.referencedPropertyName, this.isLazy(), this.isUnwrapProxy(), this.isEmbedded(), this.entityName, this.propertyName);
    }

    public void createForeignKey() throws MappingException {
        if (this.constrained && this.referencedPropertyName == null) {
            this.createForeignKeyOfEntity(((EntityType)this.getType()).getAssociatedEntityName());
        }
    }

    public List getConstraintColumns() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.identifier.getColumnIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public ForeignKeyDirection getForeignKeyType() {
        return this.foreignKeyType;
    }

    public KeyValue getIdentifier() {
        return this.identifier;
    }

    public void setConstrained(boolean bl) {
        this.constrained = bl;
    }

    public void setForeignKeyType(ForeignKeyDirection foreignKeyDirection) {
        this.foreignKeyType = foreignKeyDirection;
    }

    public void setIdentifier(KeyValue keyValue) {
        this.identifier = keyValue;
    }

    public boolean isNullable() {
        return !this.constrained;
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }
}

