/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Filterable;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClassVisitor;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.sql.Alias;
import org.hibernate.util.EmptyIterator;
import org.hibernate.util.JoinedIterator;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.SingletonIterator;
import org.hibernate.util.StringHelper;

public abstract class PersistentClass
implements Serializable,
Filterable,
MetaAttributable {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    public static final String NULL_DISCRIMINATOR_MAPPING = "null";
    public static final String NOT_NULL_DISCRIMINATOR_MAPPING = "not null";
    private String entityName;
    private String className;
    private String proxyInterfaceName;
    private String nodeName;
    private String discriminatorValue;
    private boolean lazy;
    private ArrayList properties = new ArrayList();
    private ArrayList declaredProperties = new ArrayList();
    private final ArrayList subclasses = new ArrayList();
    private final ArrayList subclassProperties = new ArrayList();
    private final ArrayList subclassTables = new ArrayList();
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private int batchSize = -1;
    private boolean selectBeforeUpdate;
    private Map metaAttributes;
    private ArrayList joins = new ArrayList();
    private final ArrayList subclassJoins = new ArrayList();
    private final Map filters = new HashMap();
    protected final Set synchronizedTables = new HashSet();
    private String loaderName;
    private Boolean isAbstract;
    private boolean hasSubselectLoadableCollections;
    private Component identifierMapper;
    private String customSQLInsert;
    private boolean customInsertCallable;
    private ExecuteUpdateResultCheckStyle insertCheckStyle;
    private String customSQLUpdate;
    private boolean customUpdateCallable;
    private ExecuteUpdateResultCheckStyle updateCheckStyle;
    private String customSQLDelete;
    private boolean customDeleteCallable;
    private ExecuteUpdateResultCheckStyle deleteCheckStyle;
    private String temporaryIdTableName;
    private String temporaryIdTableDDL;
    private Map tuplizerImpls;
    protected int optimisticLockMode;
    private MappedSuperclass superMappedSuperclass;
    private Component declaredIdentifierMapper;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string == null ? null : string.intern();
    }

    public String getProxyInterfaceName() {
        return this.proxyInterfaceName;
    }

    public void setProxyInterfaceName(String string) {
        this.proxyInterfaceName = string;
    }

    public Class getMappedClass() throws MappingException {
        if (this.className == null) {
            return null;
        }
        try {
            return ReflectHelper.classForName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("entity class not found: " + this.className, classNotFoundException);
        }
    }

    public Class getProxyInterface() {
        if (this.proxyInterfaceName == null) {
            return null;
        }
        try {
            return ReflectHelper.classForName(this.proxyInterfaceName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MappingException("proxy class not found: " + this.proxyInterfaceName, classNotFoundException);
        }
    }

    public boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    abstract int nextSubclassId();

    public abstract int getSubclassId();

    public boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicInsert(boolean bl) {
        this.dynamicInsert = bl;
    }

    public void setDynamicUpdate(boolean bl) {
        this.dynamicUpdate = bl;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void addSubclass(Subclass subclass) throws MappingException {
        for (PersistentClass persistentClass = this.getSuperclass(); persistentClass != null; persistentClass = persistentClass.getSuperclass()) {
            if (!subclass.getEntityName().equals(persistentClass.getEntityName())) continue;
            throw new MappingException("Circular inheritance mapping detected: " + subclass.getEntityName() + " will have it self as superclass when extending " + this.getEntityName());
        }
        this.subclasses.add(subclass);
    }

    public boolean hasSubclasses() {
        return this.subclasses.size() > 0;
    }

    public int getSubclassSpan() {
        int n = this.subclasses.size();
        Iterator iterator = this.subclasses.iterator();
        while (iterator.hasNext()) {
            n += ((Subclass)iterator.next()).getSubclassSpan();
        }
        return n;
    }

    public Iterator getSubclassIterator() {
        Iterator[] iteratorArray = new Iterator[this.subclasses.size() + 1];
        Iterator iterator = this.subclasses.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            iteratorArray[n++] = ((Subclass)iterator.next()).getSubclassIterator();
        }
        iteratorArray[n] = this.subclasses.iterator();
        return new JoinedIterator(iteratorArray);
    }

    public Iterator getSubclassClosureIterator() {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        arrayList.add(new SingletonIterator(this));
        Iterator iterator = this.getSubclassIterator();
        while (iterator.hasNext()) {
            PersistentClass persistentClass = (PersistentClass)iterator.next();
            arrayList.add(persistentClass.getSubclassClosureIterator());
        }
        return new JoinedIterator(arrayList);
    }

    public Table getIdentityTable() {
        return this.getRootTable();
    }

    public Iterator getDirectSubclasses() {
        return this.subclasses.iterator();
    }

    public void addProperty(Property property) {
        this.properties.add(property);
        this.declaredProperties.add(property);
        property.setPersistentClass(this);
    }

    public abstract Table getTable();

    public String getEntityName() {
        return this.entityName;
    }

    public abstract boolean isMutable();

    public abstract boolean hasIdentifierProperty();

    public abstract Property getIdentifierProperty();

    public abstract Property getDeclaredIdentifierProperty();

    public abstract KeyValue getIdentifier();

    public abstract Property getVersion();

    public abstract Property getDeclaredVersion();

    public abstract Value getDiscriminator();

    public abstract boolean isInherited();

    public abstract boolean isPolymorphic();

    public abstract boolean isVersioned();

    public abstract String getCacheConcurrencyStrategy();

    public abstract PersistentClass getSuperclass();

    public abstract boolean isExplicitPolymorphism();

    public abstract boolean isDiscriminatorInsertable();

    public abstract Iterator getPropertyClosureIterator();

    public abstract Iterator getTableClosureIterator();

    public abstract Iterator getKeyClosureIterator();

    protected void addSubclassProperty(Property property) {
        this.subclassProperties.add(property);
    }

    protected void addSubclassJoin(Join join) {
        this.subclassJoins.add(join);
    }

    protected void addSubclassTable(Table table) {
        this.subclassTables.add(table);
    }

    public Iterator getSubclassPropertyClosureIterator() {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        arrayList.add(this.getPropertyClosureIterator());
        arrayList.add(this.subclassProperties.iterator());
        for (int i = 0; i < this.subclassJoins.size(); ++i) {
            Join join = (Join)this.subclassJoins.get(i);
            arrayList.add(join.getPropertyIterator());
        }
        return new JoinedIterator(arrayList);
    }

    public Iterator getSubclassJoinClosureIterator() {
        return new JoinedIterator(this.getJoinClosureIterator(), this.subclassJoins.iterator());
    }

    public Iterator getSubclassTableClosureIterator() {
        return new JoinedIterator(this.getTableClosureIterator(), this.subclassTables.iterator());
    }

    public boolean isClassOrSuperclassJoin(Join join) {
        return this.joins.contains(join);
    }

    public boolean isClassOrSuperclassTable(Table table) {
        return this.getTable() == table;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public void setLazy(boolean bl) {
        this.lazy = bl;
    }

    public abstract boolean hasEmbeddedIdentifier();

    public abstract Class getEntityPersisterClass();

    public abstract void setEntityPersisterClass(Class var1);

    public abstract Table getRootTable();

    public abstract RootClass getRootClass();

    public abstract KeyValue getKey();

    public void setDiscriminatorValue(String string) {
        this.discriminatorValue = string;
    }

    public void setEntityName(String string) {
        this.entityName = string == null ? null : string.intern();
    }

    public void createPrimaryKey() {
        PrimaryKey primaryKey = new PrimaryKey();
        Table table = this.getTable();
        primaryKey.setTable(table);
        primaryKey.setName(PK_ALIAS.toAliasString(table.getName()));
        table.setPrimaryKey(primaryKey);
        primaryKey.addColumns(this.getKey().getColumnIterator());
    }

    public abstract String getWhere();

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        this.batchSize = n;
    }

    public boolean hasSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(boolean bl) {
        this.selectBeforeUpdate = bl;
    }

    public Iterator getReferenceablePropertyIterator() {
        return this.getPropertyClosureIterator();
    }

    public Property getReferencedProperty(String string) throws MappingException {
        try {
            return this.getRecursiveProperty(string, this.getReferenceablePropertyIterator());
        }
        catch (MappingException mappingException) {
            throw new MappingException("property-ref [" + string + "] not found on entity [" + this.getEntityName() + "]", mappingException);
        }
    }

    public Property getRecursiveProperty(String string) throws MappingException {
        try {
            return this.getRecursiveProperty(string, this.getPropertyIterator());
        }
        catch (MappingException mappingException) {
            throw new MappingException("property [" + string + "] not found on entity [" + this.getEntityName() + "]", mappingException);
        }
    }

    private Property getRecursiveProperty(String string, Iterator iterator) throws MappingException {
        Property property = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        try {
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (property == null) {
                    Property property2 = this.getIdentifierProperty();
                    if (property2 != null && property2.getName().equals(string2)) {
                        property = property2;
                    } else if (property2 == null && this.getIdentifierMapper() != null) {
                        try {
                            property2 = this.getProperty(string2, this.getIdentifierMapper().getPropertyIterator());
                            if (property2 != null) {
                                property = property2;
                            }
                        }
                        catch (MappingException mappingException) {
                            // empty catch block
                        }
                    }
                    if (property != null) continue;
                    property = this.getProperty(string2, iterator);
                    continue;
                }
                property = ((Component)property.getValue()).getProperty(string2);
            }
        }
        catch (MappingException mappingException) {
            throw new MappingException("property [" + string + "] not found on entity [" + this.getEntityName() + "]");
        }
        return property;
    }

    private Property getProperty(String string, Iterator iterator) throws MappingException {
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!property.getName().equals(StringHelper.root(string))) continue;
            return property;
        }
        throw new MappingException("property [" + string + "] not found on entity [" + this.getEntityName() + "]");
    }

    public Property getProperty(String string) throws MappingException {
        Iterator iterator = this.getPropertyClosureIterator();
        Property property = this.getIdentifierProperty();
        if (property != null && property.getName().equals(StringHelper.root(string))) {
            return property;
        }
        return this.getProperty(string, iterator);
    }

    public abstract int getOptimisticLockMode();

    public void setOptimisticLockMode(int n) {
        this.optimisticLockMode = n;
    }

    public void validate(Mapping mapping) throws MappingException {
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.isValid(mapping)) continue;
            throw new MappingException("property mapping has wrong number of columns: " + StringHelper.qualify(this.getEntityName(), property.getName()) + " type: " + property.getType().getName());
        }
        this.checkPropertyDuplication();
        this.checkColumnDuplication();
    }

    private void checkPropertyDuplication() throws MappingException {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.getPropertyIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (hashSet.add(property.getName())) continue;
            throw new MappingException("Duplicate property mapping of " + property.getName() + " found in " + this.getEntityName());
        }
    }

    public boolean isDiscriminatorValueNotNull() {
        return NOT_NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    public boolean isDiscriminatorValueNull() {
        return NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public void setMetaAttributes(Map map) {
        this.metaAttributes = map;
    }

    public MetaAttribute getMetaAttribute(String string) {
        return this.metaAttributes == null ? null : (MetaAttribute)this.metaAttributes.get(string);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.getEntityName() + ')';
    }

    public Iterator getJoinIterator() {
        return this.joins.iterator();
    }

    public Iterator getJoinClosureIterator() {
        return this.joins.iterator();
    }

    public void addJoin(Join join) {
        this.joins.add(join);
        join.setPersistentClass(this);
    }

    public int getJoinClosureSpan() {
        return this.joins.size();
    }

    public int getPropertyClosureSpan() {
        int n = this.properties.size();
        for (int i = 0; i < this.joins.size(); ++i) {
            Join join = (Join)this.joins.get(i);
            n += join.getPropertySpan();
        }
        return n;
    }

    public int getJoinNumber(Property property) {
        int n = 1;
        Iterator iterator = this.getSubclassJoinClosureIterator();
        while (iterator.hasNext()) {
            Join join = (Join)iterator.next();
            if (join.containsProperty(property)) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    public Iterator getPropertyIterator() {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        arrayList.add(this.properties.iterator());
        for (int i = 0; i < this.joins.size(); ++i) {
            Join join = (Join)this.joins.get(i);
            arrayList.add(join.getPropertyIterator());
        }
        return new JoinedIterator(arrayList);
    }

    public Iterator getUnjoinedPropertyIterator() {
        return this.properties.iterator();
    }

    public void setCustomSQLInsert(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLInsert = string;
        this.customInsertCallable = bl;
        this.insertCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLInsert() {
        return this.customSQLInsert;
    }

    public boolean isCustomInsertCallable() {
        return this.customInsertCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLInsertCheckStyle() {
        return this.insertCheckStyle;
    }

    public void setCustomSQLUpdate(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLUpdate = string;
        this.customUpdateCallable = bl;
        this.updateCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLUpdate() {
        return this.customSQLUpdate;
    }

    public boolean isCustomUpdateCallable() {
        return this.customUpdateCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLUpdateCheckStyle() {
        return this.updateCheckStyle;
    }

    public void setCustomSQLDelete(String string, boolean bl, ExecuteUpdateResultCheckStyle executeUpdateResultCheckStyle) {
        this.customSQLDelete = string;
        this.customDeleteCallable = bl;
        this.deleteCheckStyle = executeUpdateResultCheckStyle;
    }

    public String getCustomSQLDelete() {
        return this.customSQLDelete;
    }

    public boolean isCustomDeleteCallable() {
        return this.customDeleteCallable;
    }

    public ExecuteUpdateResultCheckStyle getCustomSQLDeleteCheckStyle() {
        return this.deleteCheckStyle;
    }

    public void addFilter(String string, String string2) {
        this.filters.put(string, string2);
    }

    public Map getFilterMap() {
        return this.filters;
    }

    public boolean isForceDiscriminator() {
        return false;
    }

    public abstract boolean isJoinedSubclass();

    public String getLoaderName() {
        return this.loaderName;
    }

    public void setLoaderName(String string) {
        this.loaderName = string == null ? null : string.intern();
    }

    public abstract Set getSynchronizedTables();

    public void addSynchronizedTable(String string) {
        this.synchronizedTables.add(string);
    }

    public Boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(Boolean bl) {
        this.isAbstract = bl;
    }

    protected void checkColumnDuplication(Set set, Iterator iterator) throws MappingException {
        while (iterator.hasNext()) {
            Column column;
            Selectable selectable = (Selectable)iterator.next();
            if (selectable.isFormula() || set.add((column = (Column)selectable).getName())) continue;
            throw new MappingException("Repeated column in mapping for entity: " + this.getEntityName() + " column: " + column.getName() + " (should be mapped with insert=\"false\" update=\"false\")");
        }
    }

    protected void checkPropertyColumnDuplication(Set set, Iterator iterator) throws MappingException {
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (property.getValue() instanceof Component) {
                Component component = (Component)property.getValue();
                this.checkPropertyColumnDuplication(set, component.getPropertyIterator());
                continue;
            }
            if (!property.isUpdateable() && !property.isInsertable()) continue;
            this.checkColumnDuplication(set, property.getColumnIterator());
        }
    }

    protected Iterator getNonDuplicatedPropertyIterator() {
        return this.getUnjoinedPropertyIterator();
    }

    protected Iterator getDiscriminatorColumnIterator() {
        return EmptyIterator.INSTANCE;
    }

    protected void checkColumnDuplication() {
        HashSet hashSet = new HashSet();
        if (this.getIdentifierMapper() == null) {
            this.checkColumnDuplication(hashSet, this.getKey().getColumnIterator());
        }
        this.checkColumnDuplication(hashSet, this.getDiscriminatorColumnIterator());
        this.checkPropertyColumnDuplication(hashSet, this.getNonDuplicatedPropertyIterator());
        Iterator iterator = this.getJoinIterator();
        while (iterator.hasNext()) {
            hashSet.clear();
            Join join = (Join)iterator.next();
            this.checkColumnDuplication(hashSet, join.getKey().getColumnIterator());
            this.checkPropertyColumnDuplication(hashSet, join.getPropertyIterator());
        }
    }

    public abstract Object accept(PersistentClassVisitor var1);

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    public boolean hasPojoRepresentation() {
        return this.getClassName() != null;
    }

    public boolean hasDom4jRepresentation() {
        return this.getNodeName() != null;
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    public void setSubselectLoadableCollections(boolean bl) {
        this.hasSubselectLoadableCollections = bl;
    }

    public void prepareTemporaryTables(Mapping mapping, Dialect dialect) {
        if (dialect.supportsTemporaryTables()) {
            this.temporaryIdTableName = dialect.generateTemporaryTableName(this.getTable().getName());
            Table table = new Table();
            table.setName(this.temporaryIdTableName);
            Iterator iterator = this.getTable().getPrimaryKey().getColumnIterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                table.addColumn((Column)column.clone());
            }
            this.temporaryIdTableDDL = table.sqlTemporaryTableCreateString(dialect, mapping);
        }
    }

    public String getTemporaryIdTableName() {
        return this.temporaryIdTableName;
    }

    public String getTemporaryIdTableDDL() {
        return this.temporaryIdTableDDL;
    }

    public Component getIdentifierMapper() {
        return this.identifierMapper;
    }

    public Component getDeclaredIdentifierMapper() {
        return this.declaredIdentifierMapper;
    }

    public void setDeclaredIdentifierMapper(Component component) {
        this.declaredIdentifierMapper = component;
    }

    public boolean hasIdentifierMapper() {
        return this.identifierMapper != null;
    }

    public void setIdentifierMapper(Component component) {
        this.identifierMapper = component;
    }

    public void addTuplizer(EntityMode entityMode, String string) {
        if (this.tuplizerImpls == null) {
            this.tuplizerImpls = new HashMap();
        }
        this.tuplizerImpls.put(entityMode, string);
    }

    public String getTuplizerImplClassName(EntityMode entityMode) {
        if (this.tuplizerImpls == null) {
            return null;
        }
        return (String)this.tuplizerImpls.get(entityMode);
    }

    public Map getTuplizerMap() {
        if (this.tuplizerImpls == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.tuplizerImpls);
    }

    public boolean hasNaturalId() {
        Iterator iterator = this.getRootClass().getPropertyIterator();
        while (iterator.hasNext()) {
            if (!((Property)iterator.next()).isNaturalIdentifier()) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isLazyPropertiesCacheable();

    public Iterator getDeclaredPropertyIterator() {
        ArrayList<Iterator> arrayList = new ArrayList<Iterator>();
        arrayList.add(this.declaredProperties.iterator());
        for (int i = 0; i < this.joins.size(); ++i) {
            Join join = (Join)this.joins.get(i);
            arrayList.add(join.getDeclaredPropertyIterator());
        }
        return new JoinedIterator(arrayList);
    }

    public void addMappedsuperclassProperty(Property property) {
        this.properties.add(property);
        property.setPersistentClass(this);
    }

    public MappedSuperclass getSuperMappedSuperclass() {
        return this.superMappedSuperclass;
    }

    public void setSuperMappedSuperclass(MappedSuperclass mappedSuperclass) {
        this.superMappedSuperclass = mappedSuperclass;
    }
}

