/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.Mappings;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.Type;
import org.hibernate.util.ReflectHelper;

public class SimpleValue
implements KeyValue {
    public static final String DEFAULT_ID_GEN_STRATEGY = "assigned";
    private final Mappings mappings;
    private final List columns = new ArrayList();
    private String typeName;
    private Properties identifierGeneratorProperties;
    private String identifierGeneratorStrategy = "assigned";
    private String nullValue;
    private Table table;
    private String foreignKeyName;
    private boolean alternateUniqueKey;
    private Properties typeParameters;
    private boolean cascadeDeleteEnabled;

    public SimpleValue(Mappings mappings) {
        this.mappings = mappings;
    }

    public SimpleValue(Mappings mappings, Table table) {
        this(mappings);
        this.table = table;
    }

    public Mappings getMappings() {
        return this.mappings;
    }

    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    public void setCascadeDeleteEnabled(boolean bl) {
        this.cascadeDeleteEnabled = bl;
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
        column.setValue(this);
        column.setTypeIndex(this.columns.size() - 1);
    }

    public void addFormula(Formula formula) {
        this.columns.add(formula);
    }

    public boolean hasFormula() {
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Formula)) continue;
            return true;
        }
        return false;
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public List getConstraintColumns() {
        return this.columns;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String string) {
        this.typeName = string;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void createForeignKey() throws MappingException {
    }

    public void createForeignKeyOfEntity(String string) {
        if (!this.hasFormula() && !"none".equals(this.getForeignKeyName())) {
            ForeignKey foreignKey = this.table.createForeignKey(this.getForeignKeyName(), this.getConstraintColumns(), string);
            foreignKey.setCascadeDeleteEnabled(this.cascadeDeleteEnabled);
        }
    }

    public IdentifierGenerator createIdentifierGenerator(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect, String string, String string2, RootClass rootClass) throws MappingException {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.setProperty("schema", string2);
        }
        if (string != null) {
            properties.setProperty("catalog", string);
        }
        if (rootClass != null) {
            properties.setProperty("entity_name", rootClass.getEntityName());
        }
        String string3 = this.getTable().getQuotedName(dialect);
        properties.setProperty("target_table", string3);
        String string4 = ((Column)this.getColumnIterator().next()).getQuotedName(dialect);
        properties.setProperty("target_column", string4);
        if (rootClass != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = rootClass.getIdentityTables().iterator();
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                stringBuffer.append(table.getQuotedName(dialect));
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
            properties.setProperty("identity_tables", stringBuffer.toString());
        } else {
            properties.setProperty("identity_tables", string3);
        }
        if (this.identifierGeneratorProperties != null) {
            properties.putAll((Map<?, ?>)this.identifierGeneratorProperties);
        }
        properties.put("hibernate.id.optimizer.pooled.prefer_lo", this.mappings.getConfigurationProperties().getProperty("hibernate.id.optimizer.pooled.prefer_lo", "false"));
        identifierGeneratorFactory.setDialect(dialect);
        return identifierGeneratorFactory.createIdentifierGenerator(this.identifierGeneratorStrategy, this.getType(), properties);
    }

    public boolean isUpdateable() {
        return true;
    }

    public FetchMode getFetchMode() {
        return FetchMode.SELECT;
    }

    public Properties getIdentifierGeneratorProperties() {
        return this.identifierGeneratorProperties;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public Table getTable() {
        return this.table;
    }

    public String getIdentifierGeneratorStrategy() {
        return this.identifierGeneratorStrategy;
    }

    public boolean isIdentityColumn(IdentifierGeneratorFactory identifierGeneratorFactory, Dialect dialect) {
        identifierGeneratorFactory.setDialect(dialect);
        return identifierGeneratorFactory.getIdentifierGeneratorClass(this.identifierGeneratorStrategy).equals(IdentityGenerator.class);
    }

    public void setIdentifierGeneratorProperties(Properties properties) {
        this.identifierGeneratorProperties = properties;
    }

    public void setIdentifierGeneratorStrategy(String string) {
        this.identifierGeneratorStrategy = string;
    }

    public void setNullValue(String string) {
        this.nullValue = string;
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String string) {
        this.foreignKeyName = string;
    }

    public boolean isAlternateUniqueKey() {
        return this.alternateUniqueKey;
    }

    public void setAlternateUniqueKey(boolean bl) {
        this.alternateUniqueKey = bl;
    }

    public boolean isNullable() {
        if (this.hasFormula()) {
            return true;
        }
        boolean bl = true;
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            if (((Column)iterator.next()).isNullable()) continue;
            bl = false;
            return bl;
        }
        return bl;
    }

    public boolean isSimpleValue() {
        return true;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        return this.getColumnSpan() == this.getType().getColumnSpan(mapping);
    }

    public Type getType() throws MappingException {
        if (this.typeName == null) {
            throw new MappingException("No type name");
        }
        Type type = this.mappings.getTypeResolver().heuristicType(this.typeName, this.typeParameters);
        if (type == null) {
            String string = "Could not determine type for: " + this.typeName;
            if (this.table != null) {
                string = string + ", at table: " + this.table.getName();
            }
            if (this.columns != null && this.columns.size() > 0) {
                string = string + ", for columns: " + this.columns;
            }
            throw new MappingException(string);
        }
        return type;
    }

    public void setTypeUsingReflection(String string, String string2) throws MappingException {
        if (this.typeName == null) {
            if (string == null) {
                throw new MappingException("you must specify types for a dynamic entity: " + string2);
            }
            this.typeName = ReflectHelper.reflectedPropertyClass(string, string2).getName();
        }
    }

    public boolean isTypeSpecified() {
        return this.typeName != null;
    }

    public void setTypeParameters(Properties properties) {
        this.typeParameters = properties;
    }

    public Properties getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.columns.toString() + ')';
    }

    public Object accept(ValueVisitor valueVisitor) {
        return valueVisitor.accept(this);
    }

    public boolean[] getColumnInsertability() {
        boolean[] blArray = new boolean[this.getColumnSpan()];
        int n = 0;
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            Selectable selectable = (Selectable)iterator.next();
            blArray[n++] = !selectable.isFormula();
        }
        return blArray;
    }

    public boolean[] getColumnUpdateability() {
        return this.getColumnInsertability();
    }
}

