/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.util.CollectionHelper;

public class Table
implements RelationalModel,
Serializable {
    private String name;
    private String schema;
    private String catalog;
    private Map columns = new LinkedHashMap();
    private KeyValue idValue;
    private PrimaryKey primaryKey;
    private Map indexes = new HashMap();
    private Map foreignKeys = new HashMap();
    private Map uniqueKeys = new HashMap();
    private final int uniqueInteger;
    private boolean quoted;
    private boolean schemaQuoted;
    private static int tableCounter = 0;
    private List checkConstraints = new ArrayList();
    private String rowId;
    private String subselect;
    private boolean isAbstract;
    private boolean hasDenormalizedTables = false;
    private String comment;

    public Table() {
        this.uniqueInteger = tableCounter++;
    }

    public Table(String string) {
        this();
        this.setName(string);
    }

    public String getQualifiedName(Dialect dialect, String string, String string2) {
        if (this.subselect != null) {
            return "( " + this.subselect + " )";
        }
        String string3 = this.getQuotedName(dialect);
        String string4 = this.schema == null ? string2 : this.getQuotedSchema(dialect);
        String string5 = this.catalog == null ? string : this.catalog;
        return Table.qualify(string5, string4, string3);
    }

    public static String qualify(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string).append('.');
        }
        if (string2 != null) {
            stringBuffer.append(string2).append('.');
        }
        return stringBuffer.append(string3).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quoted ? "`" + this.name + "`" : this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return this.quoted ? dialect.openQuote() + this.name + dialect.closeQuote() : this.name;
    }

    public String getQuotedSchema() {
        return this.schemaQuoted ? "`" + this.schema + "`" : this.schema;
    }

    public String getQuotedSchema(Dialect dialect) {
        return this.schemaQuoted ? dialect.openQuote() + this.schema + dialect.closeQuote() : this.schema;
    }

    public void setName(String string) {
        if (string.charAt(0) == '`') {
            this.quoted = true;
            this.name = string.substring(1, string.length() - 1);
        } else {
            this.name = string;
        }
    }

    public Column getColumn(Column column) {
        if (column == null) {
            return null;
        }
        Column column2 = (Column)this.columns.get(column.getCanonicalName());
        return column.equals(column2) ? column2 : null;
    }

    public Column getColumn(int n) {
        Iterator iterator = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iterator.next();
        }
        return (Column)iterator.next();
    }

    public void addColumn(Column column) {
        Column column2 = this.getColumn(column);
        if (column2 == null) {
            this.columns.put(column.getCanonicalName(), column);
            column.uniqueInteger = this.columns.size();
        } else {
            column.uniqueInteger = column2.uniqueInteger;
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.values().iterator();
    }

    public Iterator getIndexIterator() {
        return this.indexes.values().iterator();
    }

    public Iterator getForeignKeyIterator() {
        return this.foreignKeys.values().iterator();
    }

    public Iterator getUniqueKeyIterator() {
        return this.getUniqueKeys().values().iterator();
    }

    Map getUniqueKeys() {
        if (this.uniqueKeys.size() > 1) {
            Iterator iterator = this.uniqueKeys.entrySet().iterator();
            HashMap hashMap = new HashMap(this.uniqueKeys.size());
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                UniqueKey uniqueKey = (UniqueKey)entry.getValue();
                List list = uniqueKey.getColumns();
                int n = hashMap.size();
                boolean bl = false;
                Iterator iterator2 = hashMap.entrySet().iterator();
                while (iterator2.hasNext()) {
                    UniqueKey uniqueKey2 = (UniqueKey)iterator2.next().getValue();
                    if (!uniqueKey2.getColumns().containsAll(list) || !list.containsAll(uniqueKey2.getColumns())) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                hashMap.put(entry.getKey(), uniqueKey);
            }
            return hashMap;
        }
        return this.uniqueKeys;
    }

    public void validateColumns(Dialect dialect, Mapping mapping, TableMetadata tableMetadata) {
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            ColumnMetadata columnMetadata = tableMetadata.getColumnMetadata(column.getName());
            if (columnMetadata == null) {
                throw new HibernateException("Missing column: " + column.getName() + " in " + Table.qualify(tableMetadata.getCatalog(), tableMetadata.getSchema(), tableMetadata.getName()));
            }
            boolean bl = column.getSqlType(dialect, mapping).toLowerCase().startsWith(columnMetadata.getTypeName().toLowerCase()) || columnMetadata.getTypeCode() == column.getSqlTypeCode(mapping);
            if (bl) continue;
            throw new HibernateException("Wrong column type in " + Table.qualify(tableMetadata.getCatalog(), tableMetadata.getSchema(), tableMetadata.getName()) + " for column " + column.getName() + ". Found: " + columnMetadata.getTypeName().toLowerCase() + ", expected: " + column.getSqlType(dialect, mapping));
        }
    }

    public Iterator sqlAlterStrings(Dialect dialect, Mapping mapping, TableMetadata tableMetadata, String string, String string2) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer("alter table ").append(this.getQualifiedName(dialect, string, string2)).append(' ').append(dialect.getAddColumnString());
        Iterator iterator = this.getColumnIterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string3;
            boolean bl;
            Column column = (Column)iterator.next();
            ColumnMetadata columnMetadata = tableMetadata.getColumnMetadata(column.getName());
            if (columnMetadata != null) continue;
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString()).append(' ').append(column.getQuotedName(dialect)).append(' ').append(column.getSqlType(dialect, mapping));
            String string4 = column.getDefaultValue();
            if (string4 != null) {
                stringBuffer2.append(" default ").append(string4);
            }
            if (column.isNullable()) {
                stringBuffer2.append(dialect.getNullColumnString());
            } else {
                stringBuffer2.append(" not null");
            }
            boolean bl2 = bl = column.isUnique() && dialect.supportsUnique() && (!column.isNullable() || dialect.supportsNotNullUnique());
            if (bl) {
                stringBuffer2.append(" unique");
            }
            if (column.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                stringBuffer2.append(" check(").append(column.getCheckConstraint()).append(")");
            }
            if ((string3 = column.getComment()) != null) {
                stringBuffer2.append(dialect.getColumnComment(string3));
            }
            arrayList.add(stringBuffer2.toString());
        }
        return arrayList.iterator();
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    public String sqlTemporaryTableCreateString(Dialect dialect, Mapping mapping) throws HibernateException {
        StringBuffer stringBuffer = new StringBuffer(dialect.getCreateTemporaryTableString()).append(' ').append(this.name).append(" (");
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            stringBuffer.append(column.getQuotedName(dialect)).append(' ');
            stringBuffer.append(column.getSqlType(dialect, mapping));
            if (column.isNullable()) {
                stringBuffer.append(dialect.getNullColumnString());
            } else {
                stringBuffer.append(" not null");
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(") ");
        stringBuffer.append(dialect.getCreateTemporaryTablePostfix());
        return stringBuffer.toString();
    }

    public String sqlCreateString(Dialect dialect, Mapping mapping, String string, String string2) {
        Object object;
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer(this.hasPrimaryKey() ? dialect.getCreateTableString() : dialect.getCreateMultisetTableString()).append(' ').append(this.getQualifiedName(dialect, string, string2)).append(" (");
        boolean bl = this.idValue != null && this.idValue.isIdentityColumn(mapping.getIdentifierGeneratorFactory(), dialect);
        String string3 = null;
        if (this.hasPrimaryKey() && bl) {
            string3 = ((Column)this.getPrimaryKey().getColumnIterator().next()).getQuotedName(dialect);
        }
        Iterator iterator2 = this.getColumnIterator();
        while (iterator2.hasNext()) {
            boolean bl2;
            iterator = (Column)iterator2.next();
            stringBuffer.append(((Column)((Object)iterator)).getQuotedName(dialect)).append(' ');
            if (bl && ((Column)((Object)iterator)).getQuotedName(dialect).equals(string3)) {
                if (dialect.hasDataTypeInIdentityColumn()) {
                    stringBuffer.append(((Column)((Object)iterator)).getSqlType(dialect, mapping));
                }
                stringBuffer.append(' ').append(dialect.getIdentityColumnString(((Column)((Object)iterator)).getSqlTypeCode(mapping)));
            } else {
                stringBuffer.append(((Column)((Object)iterator)).getSqlType(dialect, mapping));
                String string4 = ((Column)((Object)iterator)).getDefaultValue();
                if (string4 != null) {
                    stringBuffer.append(" default ").append(string4);
                }
                if (((Column)((Object)iterator)).isNullable()) {
                    stringBuffer.append(dialect.getNullColumnString());
                } else {
                    stringBuffer.append(" not null");
                }
            }
            boolean bl3 = bl2 = ((Column)((Object)iterator)).isUnique() && (!((Column)((Object)iterator)).isNullable() || dialect.supportsNotNullUnique());
            if (bl2) {
                if (dialect.supportsUnique()) {
                    stringBuffer.append(" unique");
                } else {
                    object = this.getOrCreateUniqueKey(((Column)((Object)iterator)).getQuotedName(dialect) + '_');
                    ((Constraint)object).addColumn((Column)((Object)iterator));
                }
            }
            if (((Column)((Object)iterator)).hasCheckConstraint() && dialect.supportsColumnCheck()) {
                stringBuffer.append(" check (").append(((Column)((Object)iterator)).getCheckConstraint()).append(")");
            }
            if ((object = ((Column)((Object)iterator)).getComment()) != null) {
                stringBuffer.append(dialect.getColumnComment((String)object));
            }
            if (!iterator2.hasNext()) continue;
            stringBuffer.append(", ");
        }
        if (this.hasPrimaryKey()) {
            stringBuffer.append(", ").append(this.getPrimaryKey().sqlConstraintString(dialect));
        }
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            iterator = this.getUniqueKeyIterator();
            while (iterator.hasNext()) {
                UniqueKey uniqueKey = (UniqueKey)iterator.next();
                object = uniqueKey.sqlConstraintString(dialect);
                if (object == null) continue;
                stringBuffer.append(", ").append((String)object);
            }
        }
        if (dialect.supportsTableCheck()) {
            iterator = this.checkConstraints.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(", check (").append(iterator.next()).append(')');
            }
        }
        stringBuffer.append(')');
        if (this.comment != null) {
            stringBuffer.append(dialect.getTableComment(this.comment));
        }
        return stringBuffer.append(dialect.getTableTypeString()).toString();
    }

    public String sqlDropString(Dialect dialect, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            stringBuffer.append("if exists ");
        }
        stringBuffer.append(this.getQualifiedName(dialect, string, string2)).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            stringBuffer.append(" if exists");
        }
        return stringBuffer.toString();
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Index getOrCreateIndex(String string) {
        Index index = (Index)this.indexes.get(string);
        if (index == null) {
            index = new Index();
            index.setName(string);
            index.setTable(this);
            this.indexes.put(string, index);
        }
        return index;
    }

    public Index getIndex(String string) {
        return (Index)this.indexes.get(string);
    }

    public Index addIndex(Index index) {
        Index index2 = (Index)this.indexes.get(index.getName());
        if (index2 != null) {
            throw new MappingException("Index " + index.getName() + " already exists!");
        }
        this.indexes.put(index.getName(), index);
        return index;
    }

    public UniqueKey addUniqueKey(UniqueKey uniqueKey) {
        UniqueKey uniqueKey2 = (UniqueKey)this.uniqueKeys.get(uniqueKey.getName());
        if (uniqueKey2 != null) {
            throw new MappingException("UniqueKey " + uniqueKey.getName() + " already exists!");
        }
        this.uniqueKeys.put(uniqueKey.getName(), uniqueKey);
        return uniqueKey;
    }

    public UniqueKey createUniqueKey(List list) {
        String string = "UK" + this.uniqueColumnString(list.iterator());
        UniqueKey uniqueKey = this.getOrCreateUniqueKey(string);
        uniqueKey.addColumns(list.iterator());
        return uniqueKey;
    }

    public UniqueKey getUniqueKey(String string) {
        return (UniqueKey)this.uniqueKeys.get(string);
    }

    public UniqueKey getOrCreateUniqueKey(String string) {
        UniqueKey uniqueKey = (UniqueKey)this.uniqueKeys.get(string);
        if (uniqueKey == null) {
            uniqueKey = new UniqueKey();
            uniqueKey.setName(string);
            uniqueKey.setTable(this);
            this.uniqueKeys.put(string, uniqueKey);
        }
        return uniqueKey;
    }

    public void createForeignKeys() {
    }

    public ForeignKey createForeignKey(String string, List list, String string2) {
        return this.createForeignKey(string, list, string2, null);
    }

    public ForeignKey createForeignKey(String string, List list, String string2, List list2) {
        ForeignKeyKey foreignKeyKey = new ForeignKeyKey(list, string2, list2);
        ForeignKey foreignKey = (ForeignKey)this.foreignKeys.get(foreignKeyKey);
        if (foreignKey == null) {
            foreignKey = new ForeignKey();
            if (string != null) {
                foreignKey.setName(string);
            } else {
                foreignKey.setName("FK" + this.uniqueColumnString(list.iterator(), string2));
            }
            foreignKey.setTable(this);
            this.foreignKeys.put(foreignKeyKey, foreignKey);
            foreignKey.setReferencedEntityName(string2);
            foreignKey.addColumns(list.iterator());
            if (list2 != null) {
                foreignKey.addReferencedColumns(list2.iterator());
            }
        }
        if (string != null) {
            foreignKey.setName(string);
        }
        return foreignKey;
    }

    public String uniqueColumnString(Iterator iterator) {
        return this.uniqueColumnString(iterator, null);
    }

    public String uniqueColumnString(Iterator iterator, String string) {
        int n = 0;
        if (string != null) {
            n += string.hashCode();
        }
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return (Integer.toHexString(this.name.hashCode()) + Integer.toHexString(n)).toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String string) {
        if (string != null && string.charAt(0) == '`') {
            this.schemaQuoted = true;
            this.schema = string.substring(1, string.length() - 1);
        } else {
            this.schema = string;
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String string) {
        this.catalog = string;
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }

    public void setIdentifierValue(KeyValue keyValue) {
        this.idValue = keyValue;
    }

    public KeyValue getIdentifierValue() {
        return this.idValue;
    }

    public boolean isSchemaQuoted() {
        return this.schemaQuoted;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public void setQuoted(boolean bl) {
        this.quoted = bl;
    }

    public void addCheckConstraint(String string) {
        this.checkConstraints.add(string);
    }

    public boolean containsColumn(Column column) {
        return this.columns.containsValue(column);
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String string) {
        this.rowId = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append(this.getClass().getName()).append('(');
        if (this.getCatalog() != null) {
            stringBuffer.append(this.getCatalog() + ".");
        }
        if (this.getSchema() != null) {
            stringBuffer.append(this.getSchema() + ".");
        }
        stringBuffer.append(this.getName()).append(')');
        return stringBuffer.toString();
    }

    public String getSubselect() {
        return this.subselect;
    }

    public void setSubselect(String string) {
        this.subselect = string;
    }

    public boolean isSubselect() {
        return this.subselect != null;
    }

    public boolean isAbstractUnionTable() {
        return this.hasDenormalizedTables() && this.isAbstract;
    }

    public boolean hasDenormalizedTables() {
        return this.hasDenormalizedTables;
    }

    void setHasDenormalizedTables() {
        this.hasDenormalizedTables = true;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isPhysicalTable() {
        return !this.isSubselect() && !this.isAbstractUnionTable();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public Iterator getCheckConstraintsIterator() {
        return this.checkConstraints.iterator();
    }

    public Iterator sqlCommentStrings(Dialect dialect, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dialect.supportsCommentOn()) {
            Object object;
            String string3;
            String string4 = this.getQualifiedName(dialect, string, string2);
            String string5 = string3 = this.schema == null ? string2 : this.getQuotedSchema(dialect);
            if (this.comment != null) {
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(this.comment, string3, this.getQuotedName(dialect), null));
                } else {
                    object = new StringBuffer().append("comment on table ").append(string4).append(" is '").append(this.comment).append("'");
                    arrayList.add(((StringBuffer)object).toString());
                }
            }
            object = this.getColumnIterator();
            while (object.hasNext()) {
                Column column = (Column)object.next();
                String string6 = column.getComment();
                if (string6 == null) continue;
                if (dialect instanceof SQLServerDialect) {
                    arrayList.add(this.generateSqlServerComment(string6, string3, this.getQuotedName(dialect), column.getQuotedName(dialect)));
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer().append("comment on column ").append(string4).append('.').append(column.getQuotedName(dialect)).append(" is '").append(string6).append("'");
                arrayList.add(stringBuffer.toString());
            }
        }
        return arrayList.iterator();
    }

    private String generateSqlServerComment(String string, String string2, String string3, String string4) {
        if (string2 == null || string2.length() == 0) {
            string2 = "dbo";
        }
        StringBuffer stringBuffer = new StringBuffer().append("exec sp_addextendedproperty ");
        stringBuffer.append("@name = ").append("N'MS_Description', ").append("@value = '").append(string.replaceAll("\n", "\r\n")).append("', ");
        stringBuffer.append("@level0type = ").append("N'Schema', ").append("@level0name = '").append(string2).append("', ");
        stringBuffer.append("@level1type = ").append("N'Table', ").append("@level1name = '").append(string3).append("'");
        if (string4 != null) {
            stringBuffer.append(", ");
            stringBuffer.append("@level2type = ").append("N'Column', ").append("@level2name = '").append(string4).append("'");
        }
        return stringBuffer.toString();
    }

    static class ForeignKeyKey
    implements Serializable {
        String referencedClassName;
        List columns;
        List referencedColumns;

        ForeignKeyKey(List list, String string, List list2) {
            this.referencedClassName = string;
            this.columns = new ArrayList();
            this.columns.addAll(list);
            if (list2 != null) {
                this.referencedColumns = new ArrayList();
                this.referencedColumns.addAll(list2);
            } else {
                this.referencedColumns = CollectionHelper.EMPTY_LIST;
            }
        }

        public int hashCode() {
            return ((Object)this.columns).hashCode() + ((Object)this.referencedColumns).hashCode();
        }

        public boolean equals(Object object) {
            ForeignKeyKey foreignKeyKey = (ForeignKeyKey)object;
            return ((Object)foreignKeyKey.columns).equals(this.columns) && foreignKeyKey.referencedClassName.equals(this.referencedClassName) && ((Object)foreignKeyKey.referencedColumns).equals(this.referencedColumns);
        }
    }
}

