/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Constraint;
import org.hibernate.mapping.Index;
import org.hibernate.util.StringHelper;

public class UniqueKey
extends Constraint {
    public String sqlConstraintString(Dialect dialect) {
        StringBuffer stringBuffer = new StringBuffer("unique (");
        boolean bl = false;
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!bl && column.isNullable()) {
                bl = true;
            }
            stringBuffer.append(column.getQuotedName(dialect));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return !bl || dialect.supportsNotNullUnique() ? stringBuffer.append(')').toString() : null;
    }

    public String sqlConstraintString(Dialect dialect, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(dialect.getAddPrimaryKeyConstraintString(string)).append('(');
        Iterator iterator = this.getColumnIterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!bl && column.isNullable()) {
                bl = true;
            }
            stringBuffer.append(column.getQuotedName(dialect));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return !bl || dialect.supportsNotNullUnique() ? StringHelper.replace(stringBuffer.append(')').toString(), "primary key", "unique") : null;
    }

    public String sqlCreateString(Dialect dialect, Mapping mapping, String string, String string2) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlCreateString(dialect, mapping, string, string2);
        }
        return Index.buildSqlCreateIndexString(dialect, this.getName(), this.getTable(), this.getColumnIterator(), true, string, string2);
    }

    public String sqlDropString(Dialect dialect, String string, String string2) {
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            return super.sqlDropString(dialect, string, string2);
        }
        return Index.buildSqlDropIndexString(dialect, this.getTable(), this.getName(), string, string2);
    }

    public boolean isGenerated(Dialect dialect) {
        if (dialect.supportsNotNullUnique()) {
            return true;
        }
        Iterator iterator = this.getColumnIterator();
        while (iterator.hasNext()) {
            if (!((Column)iterator.next()).isNullable()) continue;
            return false;
        }
        return true;
    }
}

