/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class DynamicFilterParameterSpecification
implements ParameterSpecification {
    private final String filterName;
    private final String parameterName;
    private final Type definedParameterType;

    public DynamicFilterParameterSpecification(String string, String string2, Type type) {
        this.filterName = string;
        this.parameterName = string2;
        this.definedParameterType = type;
    }

    public int bind(PreparedStatement preparedStatement, QueryParameters queryParameters, SessionImplementor sessionImplementor, int n) throws SQLException {
        int n2 = this.definedParameterType.getColumnSpan(sessionImplementor.getFactory());
        Object object = sessionImplementor.getLoadQueryInfluencers().getFilterParameterValue(this.filterName + '.' + this.parameterName);
        if (Collection.class.isInstance(object)) {
            int n3 = 0;
            Iterator iterator = ((Collection)object).iterator();
            while (iterator.hasNext()) {
                this.definedParameterType.nullSafeSet(preparedStatement, iterator.next(), n + n3, sessionImplementor);
                n3 += n2;
            }
            return n3;
        }
        this.definedParameterType.nullSafeSet(preparedStatement, object, n, sessionImplementor);
        return n2;
    }

    public Type getExpectedType() {
        return this.definedParameterType;
    }

    public void setExpectedType(Type type) {
    }

    public String renderDisplayInfo() {
        return "dynamic-filter={filterName=" + this.filterName + ",paramName=" + this.parameterName + "}";
    }
}

