/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.TypedValue;
import org.hibernate.param.AbstractExplicitParameterSpecification;
import org.hibernate.param.ParameterSpecification;

public class NamedParameterSpecification
extends AbstractExplicitParameterSpecification
implements ParameterSpecification {
    private final String name;

    public NamedParameterSpecification(int n, int n2, String string) {
        super(n, n2);
        this.name = string;
    }

    public int bind(PreparedStatement preparedStatement, QueryParameters queryParameters, SessionImplementor sessionImplementor, int n) throws SQLException {
        TypedValue typedValue = (TypedValue)queryParameters.getNamedParameters().get(this.name);
        typedValue.getType().nullSafeSet(preparedStatement, typedValue.getValue(), n, sessionImplementor);
        return typedValue.getType().getColumnSpan(sessionImplementor.getFactory());
    }

    public String renderDisplayInfo() {
        return "name=" + this.name + ", expectedType=" + this.getExpectedType();
    }

    public String getName() {
        return this.name;
    }
}

