/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;

public final class PersisterFactory {
    private static final Class[] PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, EntityRegionAccessStrategy.class, SessionFactoryImplementor.class, Mapping.class};
    private static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CollectionRegionAccessStrategy.class, Configuration.class, SessionFactoryImplementor.class};

    private PersisterFactory() {
    }

    public static EntityPersister createClassPersister(PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        Class clazz = persistentClass.getEntityPersisterClass();
        if (clazz == null || clazz == SingleTableEntityPersister.class) {
            return new SingleTableEntityPersister(persistentClass, entityRegionAccessStrategy, sessionFactoryImplementor, mapping);
        }
        if (clazz == JoinedSubclassEntityPersister.class) {
            return new JoinedSubclassEntityPersister(persistentClass, entityRegionAccessStrategy, sessionFactoryImplementor, mapping);
        }
        if (clazz == UnionSubclassEntityPersister.class) {
            return new UnionSubclassEntityPersister(persistentClass, entityRegionAccessStrategy, sessionFactoryImplementor, mapping);
        }
        return PersisterFactory.create(clazz, persistentClass, entityRegionAccessStrategy, sessionFactoryImplementor, mapping);
    }

    public static CollectionPersister createCollectionPersister(Configuration configuration, Collection collection, CollectionRegionAccessStrategy collectionRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        Class clazz = collection.getCollectionPersisterClass();
        if (clazz == null) {
            return collection.isOneToMany() ? new OneToManyPersister(collection, collectionRegionAccessStrategy, configuration, sessionFactoryImplementor) : new BasicCollectionPersister(collection, collectionRegionAccessStrategy, configuration, sessionFactoryImplementor);
        }
        return PersisterFactory.create(clazz, configuration, collection, collectionRegionAccessStrategy, sessionFactoryImplementor);
    }

    private static EntityPersister create(Class clazz, PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        Constructor constructor;
        try {
            constructor = clazz.getConstructor(PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception exception) {
            throw new MappingException("Could not get constructor for " + clazz.getName(), exception);
        }
        try {
            return (EntityPersister)constructor.newInstance(persistentClass, entityRegionAccessStrategy, sessionFactoryImplementor, mapping);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof HibernateException) {
                throw (HibernateException)throwable;
            }
            throw new MappingException("Could not instantiate persister " + clazz.getName(), throwable);
        }
        catch (Exception exception) {
            throw new MappingException("Could not instantiate persister " + clazz.getName(), exception);
        }
    }

    private static CollectionPersister create(Class clazz, Configuration configuration, Collection collection, CollectionRegionAccessStrategy collectionRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        Constructor constructor;
        try {
            constructor = clazz.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception exception) {
            throw new MappingException("Could not get constructor for " + clazz.getName(), exception);
        }
        try {
            return (CollectionPersister)constructor.newInstance(collection, collectionRegionAccessStrategy, configuration, sessionFactoryImplementor);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof HibernateException) {
                throw (HibernateException)throwable;
            }
            throw new MappingException("Could not instantiate collection persister " + clazz.getName(), throwable);
        }
        catch (Exception exception) {
            throw new MappingException("Could not instantiate collection persister " + clazz.getName(), exception);
        }
    }
}

