/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.cache.CacheKey;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cache.entry.CacheEntry;
import org.hibernate.cache.entry.CacheEntryStructure;
import org.hibernate.cache.entry.StructuredCacheEntry;
import org.hibernate.cache.entry.UnstructuredCacheEntry;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.LoadQueryInfluencers;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.ValueInclusion;
import org.hibernate.engine.Versioning;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.PostInsertIdentifierGenerator;
import org.hibernate.id.PostInsertIdentityPersister;
import org.hibernate.id.insert.Binder;
import org.hibernate.id.insert.IdentifierGeneratingInsert;
import org.hibernate.id.insert.InsertGeneratedIdentifierDelegate;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.jdbc.TooManyRowsAffectedException;
import org.hibernate.loader.entity.BatchingEntityLoader;
import org.hibernate.loader.entity.CascadeEntityLoader;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.BasicEntityPropertyMapping;
import org.hibernate.persister.entity.DiscriminatorMetadata;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.persister.entity.NamedQueryLoader;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.entity.SQLLoadable;
import org.hibernate.persister.entity.UniqueKeyLoadable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.sql.Alias;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.SimpleSelect;
import org.hibernate.sql.Template;
import org.hibernate.sql.Update;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.hibernate.type.VersionType;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.FilterHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityPersister
implements OuterJoinLoadable,
Queryable,
ClassMetadata,
UniqueKeyLoadable,
SQLLoadable,
LazyPropertyInitializer,
PostInsertIdentityPersister,
Lockable {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityPersister.class);
    public static final String ENTITY_CLASS = "class";
    private final SessionFactoryImplementor factory;
    private final EntityRegionAccessStrategy cacheAccessStrategy;
    private final boolean isLazyPropertiesCacheable;
    private final CacheEntryStructure cacheEntryStructure;
    private final EntityMetamodel entityMetamodel;
    private final String[] rootTableKeyColumnNames;
    private final String[] rootTableKeyColumnReaders;
    private final String[] rootTableKeyColumnReaderTemplates;
    private final String[] identifierAliases;
    private final int identifierColumnSpan;
    private final String versionColumnName;
    private final boolean hasFormulaProperties;
    private final int batchSize;
    private final boolean hasSubselectLoadableCollections;
    protected final String rowIdName;
    private final Set lazyProperties;
    private final String sqlWhereString;
    private final String sqlWhereStringTemplate;
    private final int[] propertyColumnSpans;
    private final String[] propertySubclassNames;
    private final String[][] propertyColumnAliases;
    private final String[][] propertyColumnNames;
    private final String[][] propertyColumnFormulaTemplates;
    private final String[][] propertyColumnReaderTemplates;
    private final String[][] propertyColumnWriters;
    private final boolean[][] propertyColumnUpdateable;
    private final boolean[][] propertyColumnInsertable;
    private final boolean[] propertyUniqueness;
    private final boolean[] propertySelectable;
    private final String[] lazyPropertyNames;
    private final int[] lazyPropertyNumbers;
    private final Type[] lazyPropertyTypes;
    private final String[][] lazyPropertyColumnAliases;
    private final String[] subclassPropertyNameClosure;
    private final String[] subclassPropertySubclassNameClosure;
    private final Type[] subclassPropertyTypeClosure;
    private final String[][] subclassPropertyFormulaTemplateClosure;
    private final String[][] subclassPropertyColumnNameClosure;
    private final String[][] subclassPropertyColumnReaderClosure;
    private final String[][] subclassPropertyColumnReaderTemplateClosure;
    private final FetchMode[] subclassPropertyFetchModeClosure;
    private final boolean[] subclassPropertyNullabilityClosure;
    private final boolean[] propertyDefinedOnSubclass;
    private final int[][] subclassPropertyColumnNumberClosure;
    private final int[][] subclassPropertyFormulaNumberClosure;
    private final CascadeStyle[] subclassPropertyCascadeStyleClosure;
    private final String[] subclassColumnClosure;
    private final boolean[] subclassColumnLazyClosure;
    private final String[] subclassColumnAliasClosure;
    private final boolean[] subclassColumnSelectableClosure;
    private final String[] subclassColumnReaderTemplateClosure;
    private final String[] subclassFormulaClosure;
    private final String[] subclassFormulaTemplateClosure;
    private final String[] subclassFormulaAliasClosure;
    private final boolean[] subclassFormulaLazyClosure;
    private final FilterHelper filterHelper;
    private final Set affectingFetchProfileNames = new HashSet();
    private final Map uniqueKeyLoaders = new HashMap();
    private final Map lockers = new HashMap();
    private final Map loaders = new HashMap();
    private String sqlVersionSelectString;
    private String sqlSnapshotSelectString;
    private String sqlLazySelectString;
    private String sqlIdentityInsertString;
    private String sqlUpdateByRowIdString;
    private String sqlLazyUpdateByRowIdString;
    private String[] sqlDeleteStrings;
    private String[] sqlInsertStrings;
    private String[] sqlUpdateStrings;
    private String[] sqlLazyUpdateStrings;
    private String sqlInsertGeneratedValuesSelectString;
    private String sqlUpdateGeneratedValuesSelectString;
    protected boolean[] insertCallable;
    protected boolean[] updateCallable;
    protected boolean[] deleteCallable;
    protected String[] customSQLInsert;
    protected String[] customSQLUpdate;
    protected String[] customSQLDelete;
    protected ExecuteUpdateResultCheckStyle[] insertResultCheckStyles;
    protected ExecuteUpdateResultCheckStyle[] updateResultCheckStyles;
    protected ExecuteUpdateResultCheckStyle[] deleteResultCheckStyles;
    private InsertGeneratedIdentifierDelegate identityDelegate;
    private boolean[] tableHasColumns;
    private final String loaderName;
    private UniqueEntityLoader queryLoader;
    private final String temporaryIdTableName;
    private final String temporaryIdTableDDL;
    private final Map subclassPropertyAliases = new HashMap();
    private final Map subclassPropertyColumnNames = new HashMap();
    protected final BasicEntityPropertyMapping propertyMapping;
    private static final String DISCRIMINATOR_ALIAS = "clazz_";
    private DiscriminatorMetadata discriminatorMetadata;

    protected void addDiscriminatorToInsert(Insert insert) {
    }

    protected void addDiscriminatorToSelect(SelectFragment selectFragment, String string, String string2) {
    }

    protected abstract int[] getSubclassColumnTableNumberClosure();

    protected abstract int[] getSubclassFormulaTableNumberClosure();

    public abstract String getSubclassTableName(int var1);

    protected abstract String[] getSubclassTableKeyColumns(int var1);

    protected abstract boolean isClassOrSuperclassTable(int var1);

    protected abstract int getSubclassTableSpan();

    protected abstract int getTableSpan();

    protected abstract boolean isTableCascadeDeleteEnabled(int var1);

    protected abstract String getTableName(int var1);

    protected abstract String[] getKeyColumns(int var1);

    protected abstract boolean isPropertyOfTable(int var1, int var2);

    protected abstract int[] getPropertyTableNumbersInSelect();

    protected abstract int[] getPropertyTableNumbers();

    protected abstract int getSubclassPropertyTableNumber(int var1);

    protected abstract String filterFragment(String var1) throws MappingException;

    public String getDiscriminatorColumnName() {
        return DISCRIMINATOR_ALIAS;
    }

    public String getDiscriminatorColumnReaders() {
        return DISCRIMINATOR_ALIAS;
    }

    public String getDiscriminatorColumnReaderTemplate() {
        return DISCRIMINATOR_ALIAS;
    }

    protected String getDiscriminatorAlias() {
        return DISCRIMINATOR_ALIAS;
    }

    protected String getDiscriminatorFormulaTemplate() {
        return null;
    }

    protected boolean isInverseTable(int n) {
        return false;
    }

    protected boolean isNullableTable(int n) {
        return false;
    }

    protected boolean isNullableSubclassTable(int n) {
        return false;
    }

    protected boolean isInverseSubclassTable(int n) {
        return false;
    }

    public boolean isSubclassEntityName(String string) {
        return this.entityMetamodel.getSubclassEntityNames().contains(string);
    }

    private boolean[] getTableHasColumns() {
        return this.tableHasColumns;
    }

    public String[] getRootTableKeyColumnNames() {
        return this.rootTableKeyColumnNames;
    }

    protected String[] getSQLUpdateByRowIdStrings() {
        if (this.sqlUpdateByRowIdString == null) {
            throw new AssertionFailure("no update by row id");
        }
        String[] stringArray = new String[this.getTableSpan() + 1];
        stringArray[0] = this.sqlUpdateByRowIdString;
        System.arraycopy(this.sqlUpdateStrings, 0, stringArray, 1, this.getTableSpan());
        return stringArray;
    }

    protected String[] getSQLLazyUpdateByRowIdStrings() {
        if (this.sqlLazyUpdateByRowIdString == null) {
            throw new AssertionFailure("no update by row id");
        }
        String[] stringArray = new String[this.getTableSpan()];
        stringArray[0] = this.sqlLazyUpdateByRowIdString;
        for (int i = 1; i < this.getTableSpan(); ++i) {
            stringArray[i] = this.sqlLazyUpdateStrings[i];
        }
        return stringArray;
    }

    protected String getSQLSnapshotSelectString() {
        return this.sqlSnapshotSelectString;
    }

    protected String getSQLLazySelectString() {
        return this.sqlLazySelectString;
    }

    protected String[] getSQLDeleteStrings() {
        return this.sqlDeleteStrings;
    }

    protected String[] getSQLInsertStrings() {
        return this.sqlInsertStrings;
    }

    protected String[] getSQLUpdateStrings() {
        return this.sqlUpdateStrings;
    }

    protected String[] getSQLLazyUpdateStrings() {
        return this.sqlLazyUpdateStrings;
    }

    protected String getSQLIdentityInsertString() {
        return this.sqlIdentityInsertString;
    }

    protected String getVersionSelectString() {
        return this.sqlVersionSelectString;
    }

    protected boolean isInsertCallable(int n) {
        return this.insertCallable[n];
    }

    protected boolean isUpdateCallable(int n) {
        return this.updateCallable[n];
    }

    protected boolean isDeleteCallable(int n) {
        return this.deleteCallable[n];
    }

    protected boolean isSubclassPropertyDeferred(String string, String string2) {
        return false;
    }

    protected boolean isSubclassTableSequentialSelect(int n) {
        return false;
    }

    public boolean hasSequentialSelect() {
        return false;
    }

    protected boolean[] getTableUpdateNeeded(int[] nArray, boolean bl) {
        if (nArray == null) {
            return this.getTableHasColumns();
        }
        boolean[] blArray = this.getPropertyUpdateability();
        int[] nArray2 = this.getPropertyTableNumbers();
        boolean[] blArray2 = new boolean[this.getTableSpan()];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = nArray2[n];
            blArray2[n2] = blArray2[n2] || this.getPropertyColumnSpan(n) > 0 && blArray[n];
        }
        if (this.isVersioned()) {
            blArray2[0] = blArray2[0] || Versioning.isVersionIncrementRequired(nArray, bl, this.getPropertyVersionability());
        }
        return blArray2;
    }

    public boolean hasRowId() {
        return this.rowIdName != null;
    }

    public AbstractEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Serializable serializable;
        this.factory = sessionFactoryImplementor;
        this.cacheAccessStrategy = entityRegionAccessStrategy;
        this.isLazyPropertiesCacheable = persistentClass.isLazyPropertiesCacheable();
        this.cacheEntryStructure = sessionFactoryImplementor.getSettings().isStructuredCacheEntriesEnabled() ? new StructuredCacheEntry(this) : new UnstructuredCacheEntry();
        this.entityMetamodel = new EntityMetamodel(persistentClass, sessionFactoryImplementor);
        int n = persistentClass.getBatchSize();
        if (n == -1) {
            n = sessionFactoryImplementor.getSettings().getDefaultBatchFetchSize();
        }
        this.batchSize = n;
        this.hasSubselectLoadableCollections = persistentClass.hasSubselectLoadableCollections();
        this.propertyMapping = new BasicEntityPropertyMapping(this);
        this.identifierColumnSpan = persistentClass.getIdentifier().getColumnSpan();
        this.rootTableKeyColumnNames = new String[this.identifierColumnSpan];
        this.rootTableKeyColumnReaders = new String[this.identifierColumnSpan];
        this.rootTableKeyColumnReaderTemplates = new String[this.identifierColumnSpan];
        this.identifierAliases = new String[this.identifierColumnSpan];
        this.rowIdName = persistentClass.getRootTable().getRowId();
        this.loaderName = persistentClass.getLoaderName();
        Iterator iterator = persistentClass.getIdentifier().getColumnIterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            this.rootTableKeyColumnNames[n2] = column.getQuotedName(sessionFactoryImplementor.getDialect());
            this.rootTableKeyColumnReaders[n2] = column.getReadExpr(sessionFactoryImplementor.getDialect());
            this.rootTableKeyColumnReaderTemplates[n2] = column.getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
            this.identifierAliases[n2] = column.getAlias(sessionFactoryImplementor.getDialect(), persistentClass.getRootTable());
            ++n2;
        }
        this.versionColumnName = persistentClass.isVersioned() ? ((Column)persistentClass.getVersion().getColumnIterator().next()).getQuotedName(sessionFactoryImplementor.getDialect()) : null;
        this.sqlWhereString = StringHelper.isNotEmpty(persistentClass.getWhere()) ? "( " + persistentClass.getWhere() + ") " : null;
        this.sqlWhereStringTemplate = this.sqlWhereString == null ? null : Template.renderWhereStringTemplate(this.sqlWhereString, sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
        boolean bl = this.isInstrumented(EntityMode.POJO);
        int n3 = this.entityMetamodel.getPropertySpan();
        this.propertyColumnSpans = new int[n3];
        this.propertySubclassNames = new String[n3];
        this.propertyColumnAliases = new String[n3][];
        this.propertyColumnNames = new String[n3][];
        this.propertyColumnFormulaTemplates = new String[n3][];
        this.propertyColumnReaderTemplates = new String[n3][];
        this.propertyColumnWriters = new String[n3][];
        this.propertyUniqueness = new boolean[n3];
        this.propertySelectable = new boolean[n3];
        this.propertyColumnUpdateable = new boolean[n3][];
        this.propertyColumnInsertable = new boolean[n3][];
        HashSet<Property> hashSet = new HashSet<Property>();
        this.lazyProperties = new HashSet();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Type> arrayList3 = new ArrayList<Type>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        iterator = persistentClass.getPropertyClosureIterator();
        n2 = 0;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            int n4;
            serializable = (Property)iterator.next();
            hashSet.add((Property)serializable);
            this.propertyColumnSpans[n2] = n4 = ((Property)serializable).getColumnSpan();
            this.propertySubclassNames[n2] = ((Property)serializable).getPersistentClass().getEntityName();
            object7 = new String[n4];
            object6 = new String[n4];
            object5 = new String[n4];
            object4 = new String[n4];
            object3 = new String[n4];
            object2 = ((Property)serializable).getColumnIterator();
            int n5 = 0;
            while (object2.hasNext()) {
                object = (Selectable)object2.next();
                object6[n5] = object.getAlias(sessionFactoryImplementor.getDialect(), ((Property)serializable).getValue().getTable());
                if (object.isFormula()) {
                    bl2 = true;
                    object3[n5] = object.getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
                } else {
                    cloneable = (Column)object;
                    object7[n5] = ((Column)cloneable).getQuotedName(sessionFactoryImplementor.getDialect());
                    object5[n5] = ((Column)cloneable).getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
                    object4[n5] = ((Column)cloneable).getWriteExpr();
                }
                ++n5;
            }
            this.propertyColumnNames[n2] = object7;
            this.propertyColumnFormulaTemplates[n2] = object3;
            this.propertyColumnReaderTemplates[n2] = object5;
            this.propertyColumnWriters[n2] = object4;
            this.propertyColumnAliases[n2] = object6;
            if (bl && ((Property)serializable).isLazy()) {
                this.lazyProperties.add(((Property)serializable).getName());
                arrayList.add(((Property)serializable).getName());
                arrayList2.add(new Integer(n2));
                arrayList3.add(((Property)serializable).getValue().getType());
                arrayList4.add(object6);
            }
            this.propertyColumnUpdateable[n2] = ((Property)serializable).getValue().getColumnUpdateability();
            this.propertyColumnInsertable[n2] = ((Property)serializable).getValue().getColumnInsertability();
            this.propertySelectable[n2] = ((Property)serializable).isSelectable();
            this.propertyUniqueness[n2] = ((Property)serializable).getValue().isAlternateUniqueKey();
            ++n2;
        }
        this.hasFormulaProperties = bl2;
        this.lazyPropertyColumnAliases = ArrayHelper.to2DStringArray(arrayList4);
        this.lazyPropertyNames = ArrayHelper.toStringArray(arrayList);
        this.lazyPropertyNumbers = ArrayHelper.toIntArray(arrayList2);
        this.lazyPropertyTypes = ArrayHelper.toTypeArray(arrayList3);
        serializable = new ArrayList();
        ArrayList<Boolean> arrayList5 = new ArrayList<Boolean>();
        object7 = new ArrayList();
        object6 = new ArrayList();
        object5 = new ArrayList();
        object4 = new ArrayList();
        object3 = new ArrayList();
        object2 = new ArrayList();
        ArrayList<Type> arrayList6 = new ArrayList<Type>();
        object = new ArrayList();
        cloneable = new ArrayList();
        ArrayList<String[]> arrayList7 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList8 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList9 = new ArrayList<String[]>();
        ArrayList<String[]> arrayList10 = new ArrayList<String[]>();
        ArrayList<FetchMode> arrayList11 = new ArrayList<FetchMode>();
        ArrayList<CascadeStyle> arrayList12 = new ArrayList<CascadeStyle>();
        ArrayList<Boolean> arrayList13 = new ArrayList<Boolean>();
        ArrayList<int[]> arrayList14 = new ArrayList<int[]>();
        ArrayList<int[]> arrayList15 = new ArrayList<int[]>();
        ArrayList<Boolean> arrayList16 = new ArrayList<Boolean>();
        ArrayList<Boolean> arrayList17 = new ArrayList<Boolean>();
        iterator = persistentClass.getSubclassPropertyClosureIterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            ((ArrayList)object).add(property.getName());
            ((ArrayList)cloneable).add(property.getPersistentClass().getEntityName());
            boolean bl3 = !hashSet.contains(property);
            arrayList13.add(bl3);
            arrayList17.add(property.isOptional() || bl3);
            arrayList6.add(property.getType());
            Iterator iterator2 = property.getColumnIterator();
            String[] stringArray = new String[property.getColumnSpan()];
            String[] stringArray2 = new String[property.getColumnSpan()];
            String[] stringArray3 = new String[property.getColumnSpan()];
            String[] stringArray4 = new String[property.getColumnSpan()];
            int[] nArray = new int[property.getColumnSpan()];
            int[] nArray2 = new int[property.getColumnSpan()];
            int n6 = 0;
            Boolean bl4 = property.isLazy() && bl;
            while (iterator2.hasNext()) {
                Object object8;
                Selectable selectable = (Selectable)iterator2.next();
                if (selectable.isFormula()) {
                    object8 = selectable.getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
                    nArray2[n6] = ((ArrayList)object3).size();
                    nArray[n6] = -1;
                    ((ArrayList)object3).add(object8);
                    stringArray4[n6] = object8;
                    ((ArrayList)object5).add(selectable.getText(sessionFactoryImplementor.getDialect()));
                    ((ArrayList)object4).add(selectable.getAlias(sessionFactoryImplementor.getDialect()));
                    ((ArrayList)object2).add(bl4);
                } else {
                    String string;
                    object8 = (Column)selectable;
                    String string2 = ((Column)object8).getQuotedName(sessionFactoryImplementor.getDialect());
                    nArray[n6] = ((ArrayList)serializable).size();
                    nArray2[n6] = -1;
                    ((ArrayList)serializable).add(string2);
                    stringArray[n6] = string2;
                    ((ArrayList)object6).add(selectable.getAlias(sessionFactoryImplementor.getDialect(), property.getValue().getTable()));
                    arrayList5.add(bl4);
                    arrayList16.add(property.isSelectable());
                    stringArray2[n6] = ((Column)object8).getReadExpr(sessionFactoryImplementor.getDialect());
                    stringArray3[n6] = string = ((Column)object8).getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
                    ((ArrayList)object7).add(string);
                }
                ++n6;
            }
            arrayList8.add(stringArray);
            arrayList9.add(stringArray2);
            arrayList10.add(stringArray3);
            arrayList7.add(stringArray4);
            arrayList14.add(nArray);
            arrayList15.add(nArray2);
            arrayList11.add(property.getValue().getFetchMode());
            arrayList12.add(property.getCascadeStyle());
        }
        this.subclassColumnClosure = ArrayHelper.toStringArray((Collection)((Object)serializable));
        this.subclassColumnAliasClosure = ArrayHelper.toStringArray((Collection)object6);
        this.subclassColumnLazyClosure = ArrayHelper.toBooleanArray(arrayList5);
        this.subclassColumnSelectableClosure = ArrayHelper.toBooleanArray(arrayList16);
        this.subclassColumnReaderTemplateClosure = ArrayHelper.toStringArray((Collection)object7);
        this.subclassFormulaClosure = ArrayHelper.toStringArray((Collection)object5);
        this.subclassFormulaTemplateClosure = ArrayHelper.toStringArray((Collection)object3);
        this.subclassFormulaAliasClosure = ArrayHelper.toStringArray((Collection)object4);
        this.subclassFormulaLazyClosure = ArrayHelper.toBooleanArray((Collection)object2);
        this.subclassPropertyNameClosure = ArrayHelper.toStringArray((Collection)object);
        this.subclassPropertySubclassNameClosure = ArrayHelper.toStringArray((Collection)((Object)cloneable));
        this.subclassPropertyTypeClosure = ArrayHelper.toTypeArray(arrayList6);
        this.subclassPropertyNullabilityClosure = ArrayHelper.toBooleanArray(arrayList17);
        this.subclassPropertyFormulaTemplateClosure = ArrayHelper.to2DStringArray(arrayList7);
        this.subclassPropertyColumnNameClosure = ArrayHelper.to2DStringArray(arrayList8);
        this.subclassPropertyColumnReaderClosure = ArrayHelper.to2DStringArray(arrayList9);
        this.subclassPropertyColumnReaderTemplateClosure = ArrayHelper.to2DStringArray(arrayList10);
        this.subclassPropertyColumnNumberClosure = ArrayHelper.to2DIntArray(arrayList14);
        this.subclassPropertyFormulaNumberClosure = ArrayHelper.to2DIntArray(arrayList15);
        this.subclassPropertyCascadeStyleClosure = new CascadeStyle[arrayList12.size()];
        iterator = arrayList12.iterator();
        int n7 = 0;
        while (iterator.hasNext()) {
            this.subclassPropertyCascadeStyleClosure[n7++] = (CascadeStyle)iterator.next();
        }
        this.subclassPropertyFetchModeClosure = new FetchMode[arrayList11.size()];
        iterator = arrayList11.iterator();
        n7 = 0;
        while (iterator.hasNext()) {
            this.subclassPropertyFetchModeClosure[n7++] = (FetchMode)iterator.next();
        }
        this.propertyDefinedOnSubclass = new boolean[arrayList13.size()];
        iterator = arrayList13.iterator();
        n7 = 0;
        while (iterator.hasNext()) {
            this.propertyDefinedOnSubclass[n7++] = (Boolean)iterator.next();
        }
        this.filterHelper = new FilterHelper(persistentClass.getFilterMap(), sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
        this.temporaryIdTableName = persistentClass.getTemporaryIdTableName();
        this.temporaryIdTableDDL = persistentClass.getTemporaryIdTableDDL();
    }

    protected String generateLazySelectString() {
        if (!this.entityMetamodel.hasLazyProperties()) {
            return null;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < this.lazyPropertyNames.length; ++i) {
            int n = this.getSubclassPropertyIndex(this.lazyPropertyNames[i]);
            int n2 = this.getSubclassPropertyTableNumber(n);
            hashSet.add(new Integer(n2));
            int[] nArray = this.subclassPropertyColumnNumberClosure[n];
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] == -1) continue;
                arrayList.add(new Integer(nArray[j]));
            }
            int[] nArray2 = this.subclassPropertyFormulaNumberClosure[n];
            for (int j = 0; j < nArray2.length; ++j) {
                if (nArray2[j] == -1) continue;
                arrayList2.add(new Integer(nArray2[j]));
            }
        }
        if (arrayList.size() == 0 && arrayList2.size() == 0) {
            return null;
        }
        return this.renderSelect(ArrayHelper.toIntArray(hashSet), ArrayHelper.toIntArray(arrayList), ArrayHelper.toIntArray(arrayList2));
    }

    public Object initializeLazyProperty(String string, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        Serializable serializable = sessionImplementor.getContextEntityIdentifier(object);
        EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(object);
        if (entityEntry == null) {
            throw new HibernateException("entity is not associated with the session: " + serializable);
        }
        if (log.isTraceEnabled()) {
            log.trace("initializing lazy properties of: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()) + ", field access: " + string);
        }
        if (this.hasCache()) {
            CacheEntry cacheEntry;
            CacheKey cacheKey = new CacheKey(serializable, this.getIdentifierType(), this.getEntityName(), sessionImplementor.getEntityMode(), this.getFactory());
            Object object2 = this.getCacheAccessStrategy().get(cacheKey, sessionImplementor.getTimestamp());
            if (object2 != null && !(cacheEntry = (CacheEntry)this.getCacheEntryStructure().destructure(object2, this.factory)).areLazyPropertiesUnfetched()) {
                return this.initializeLazyPropertiesFromCache(string, object, sessionImplementor, entityEntry, cacheEntry);
            }
        }
        return this.initializeLazyPropertiesFromDatastore(string, object, sessionImplementor, serializable, entityEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object initializeLazyPropertiesFromDatastore(String string, Object object, SessionImplementor sessionImplementor, Serializable serializable, EntityEntry entityEntry) {
        if (!this.hasLazyProperties()) {
            throw new AssertionFailure("no lazy properties");
        }
        log.trace("initializing lazy properties from datastore");
        try {
            Object object2;
            block13: {
                object2 = null;
                PreparedStatement preparedStatement = null;
                try {
                    String string2 = this.getSQLLazySelectString();
                    ResultSet resultSet = null;
                    try {
                        if (string2 != null) {
                            preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(string2);
                            this.getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                            resultSet = preparedStatement.executeQuery();
                            resultSet.next();
                        }
                        Object[] objectArray = entityEntry.getLoadedState();
                        for (int i = 0; i < this.lazyPropertyNames.length; ++i) {
                            Object object3 = this.lazyPropertyTypes[i].nullSafeGet(resultSet, this.lazyPropertyColumnAliases[i], sessionImplementor, object);
                            if (!this.initializeLazyProperty(string, object, sessionImplementor, objectArray, i, object3)) continue;
                            object2 = object3;
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    if (preparedStatement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        sessionImplementor.getBatcher().closeStatement(preparedStatement);
                    }
                    throw throwable;
                }
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
            log.trace("done initializing lazy properties");
            return object2;
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not initialize lazy properties: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()), this.getSQLLazySelectString());
        }
    }

    private Object initializeLazyPropertiesFromCache(String string, Object object, SessionImplementor sessionImplementor, EntityEntry entityEntry, CacheEntry cacheEntry) {
        log.trace("initializing lazy properties from second-level cache");
        Object object2 = null;
        Serializable[] serializableArray = cacheEntry.getDisassembledState();
        Object[] objectArray = entityEntry.getLoadedState();
        for (int i = 0; i < this.lazyPropertyNames.length; ++i) {
            Object object3 = this.lazyPropertyTypes[i].assemble(serializableArray[this.lazyPropertyNumbers[i]], sessionImplementor, object);
            if (!this.initializeLazyProperty(string, object, sessionImplementor, objectArray, i, object3)) continue;
            object2 = object3;
        }
        log.trace("done initializing lazy properties");
        return object2;
    }

    private boolean initializeLazyProperty(String string, Object object, SessionImplementor sessionImplementor, Object[] objectArray, int n, Object object2) {
        this.setPropertyValue(object, this.lazyPropertyNumbers[n], object2, sessionImplementor.getEntityMode());
        if (objectArray != null) {
            objectArray[this.lazyPropertyNumbers[n]] = this.lazyPropertyTypes[n].deepCopy(object2, sessionImplementor.getEntityMode(), this.factory);
        }
        return string.equals(this.lazyPropertyNames[n]);
    }

    public boolean isBatchable() {
        return this.optimisticLockMode() == -1 || !this.isVersioned() && this.optimisticLockMode() == 0 || this.getFactory().getSettings().isJdbcBatchVersionedData();
    }

    public Serializable[] getQuerySpaces() {
        return this.getPropertySpaces();
    }

    protected Set getLazyProperties() {
        return this.lazyProperties;
    }

    public boolean isBatchLoadable() {
        return this.batchSize > 1;
    }

    public String[] getIdentifierColumnNames() {
        return this.rootTableKeyColumnNames;
    }

    public String[] getIdentifierColumnReaders() {
        return this.rootTableKeyColumnReaders;
    }

    public String[] getIdentifierColumnReaderTemplates() {
        return this.rootTableKeyColumnReaderTemplates;
    }

    protected int getIdentifierColumnSpan() {
        return this.identifierColumnSpan;
    }

    protected String[] getIdentifierAliases() {
        return this.identifierAliases;
    }

    public String getVersionColumnName() {
        return this.versionColumnName;
    }

    protected String getVersionedTableName() {
        return this.getTableName(0);
    }

    protected boolean[] getSubclassColumnLazyiness() {
        return this.subclassColumnLazyClosure;
    }

    protected boolean[] getSubclassFormulaLazyiness() {
        return this.subclassFormulaLazyClosure;
    }

    public boolean isCacheInvalidationRequired() {
        return this.hasFormulaProperties() || !this.isVersioned() && (this.entityMetamodel.isDynamicUpdate() || this.getTableSpan() > 1);
    }

    public boolean isLazyPropertiesCacheable() {
        return this.isLazyPropertiesCacheable;
    }

    public String selectFragment(String string, String string2) {
        return this.identifierSelectFragment(string, string2) + this.propertySelectFragment(string, string2, false);
    }

    public String[] getIdentifierAliases(String string) {
        return new Alias(string).toAliasStrings(this.getIdentifierAliases());
    }

    public String[] getPropertyAliases(String string, int n) {
        return new Alias(string).toUnquotedAliasStrings(this.propertyColumnAliases[n]);
    }

    public String getDiscriminatorAlias(String string) {
        return this.entityMetamodel.hasSubclasses() ? new Alias(string).toAliasString(this.getDiscriminatorAlias()) : null;
    }

    public String identifierSelectFragment(String string, String string2) {
        return new SelectFragment().setSuffix(string2).addColumns(string, this.getIdentifierColumnNames(), this.getIdentifierAliases()).toFragmentString().substring(2);
    }

    public String propertySelectFragment(String string, String string2, boolean bl) {
        return this.propertySelectFragmentFragment(string, string2, bl).toFragmentString();
    }

    public SelectFragment propertySelectFragmentFragment(String string, String string2, boolean bl) {
        Object object;
        SelectFragment selectFragment = new SelectFragment().setSuffix(string2).setUsedAliases(this.getIdentifierAliases());
        int[] nArray = this.getSubclassColumnTableNumberClosure();
        String[] stringArray = this.getSubclassColumnAliasClosure();
        String[] stringArray2 = this.getSubclassColumnReaderTemplateClosure();
        for (int i = 0; i < this.getSubclassColumnClosure().length; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = (bl || !this.subclassColumnLazyClosure[i]) && !this.isSubclassTableSequentialSelect(nArray[i]) && this.subclassColumnSelectableClosure[i];
            if (!bl2) continue;
            object = this.generateTableAlias(string, nArray[i]);
            selectFragment.addColumnTemplate((String)object, stringArray2[i], stringArray[i]);
        }
        int[] nArray2 = this.getSubclassFormulaTableNumberClosure();
        String[] stringArray3 = this.getSubclassFormulaTemplateClosure();
        object = this.getSubclassFormulaAliasClosure();
        for (int i = 0; i < this.getSubclassFormulaTemplateClosure().length; ++i) {
            boolean bl4;
            boolean bl5 = bl4 = (bl || !this.subclassFormulaLazyClosure[i]) && !this.isSubclassTableSequentialSelect(nArray2[i]);
            if (!bl4) continue;
            String string3 = this.generateTableAlias(string, nArray2[i]);
            selectFragment.addFormula(string3, stringArray3[i], object[i]);
        }
        if (this.entityMetamodel.hasSubclasses()) {
            this.addDiscriminatorToSelect(selectFragment, string, string2);
        }
        if (this.hasRowId()) {
            selectFragment.addColumn(string, this.rowIdName, "rowid_");
        }
        return selectFragment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object[] getDatabaseSnapshot(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Getting current persistent state for: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
        }
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.getSQLSnapshotSelectString());
            try {
                Object[] objectArray;
                ResultSet resultSet;
                block12: {
                    this.getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) break block12;
                    Object[] objectArray2 = null;
                    resultSet.close();
                    return objectArray2;
                }
                try {
                    Type[] typeArray = this.getPropertyTypes();
                    Object[] objectArray3 = new Object[typeArray.length];
                    boolean[] blArray = this.getPropertyUpdateability();
                    for (int i = 0; i < typeArray.length; ++i) {
                        if (!blArray[i]) continue;
                        objectArray3[i] = typeArray[i].hydrate(resultSet, this.getPropertyAliases("", i), sessionImplementor, null);
                    }
                    objectArray = objectArray3;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return objectArray;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve snapshot: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()), this.getSQLSnapshotSelectString());
        }
    }

    protected String generateSelectVersionString() {
        SimpleSelect simpleSelect = new SimpleSelect(this.getFactory().getDialect()).setTableName(this.getVersionedTableName());
        if (this.isVersioned()) {
            simpleSelect.addColumn(this.versionColumnName);
        } else {
            simpleSelect.addColumns(this.rootTableKeyColumnNames);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            simpleSelect.setComment("get version " + this.getEntityName());
        }
        return simpleSelect.addCondition(this.rootTableKeyColumnNames, "=?").toStatementString();
    }

    protected String generateInsertGeneratedValuesSelectString() {
        return this.generateGeneratedValuesSelectString(this.getPropertyInsertGenerationInclusions());
    }

    protected String generateUpdateGeneratedValuesSelectString() {
        return this.generateGeneratedValuesSelectString(this.getPropertyUpdateGenerationInclusions());
    }

    private String generateGeneratedValuesSelectString(ValueInclusion[] valueInclusionArray) {
        Select select = new Select(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("get generated state " + this.getEntityName());
        }
        String[] stringArray = StringHelper.qualify(this.getRootAlias(), this.getIdentifierColumnNames());
        String string = this.concretePropertySelectFragment(this.getRootAlias(), valueInclusionArray);
        string = string.substring(2);
        String string2 = this.fromTableFragment(this.getRootAlias()) + this.fromJoinFragment(this.getRootAlias(), true, false);
        String string3 = new StringBuffer().append(StringHelper.join("=? and ", stringArray)).append("=?").append(this.whereJoinFragment(this.getRootAlias(), true, false)).toString();
        return select.setSelectClause(string).setFromClause(string2).setOuterJoins("", "").setWhereClause(string3).toStatementString();
    }

    protected String concretePropertySelectFragment(String string, final ValueInclusion[] valueInclusionArray) {
        return this.concretePropertySelectFragment(string, new InclusionChecker(){

            public boolean includeProperty(int n) {
                return valueInclusionArray[n] != ValueInclusion.NONE;
            }
        });
    }

    protected String concretePropertySelectFragment(String string, final boolean[] blArray) {
        return this.concretePropertySelectFragment(string, new InclusionChecker(){

            public boolean includeProperty(int n) {
                return blArray[n];
            }
        });
    }

    protected String concretePropertySelectFragment(String string, InclusionChecker inclusionChecker) {
        int n = this.getPropertyNames().length;
        int[] nArray = this.getPropertyTableNumbersInSelect();
        SelectFragment selectFragment = new SelectFragment();
        for (int i = 0; i < n; ++i) {
            if (!inclusionChecker.includeProperty(i)) continue;
            selectFragment.addColumnTemplates(this.generateTableAlias(string, nArray[i]), this.propertyColumnReaderTemplates[i], this.propertyColumnAliases[i]);
            selectFragment.addFormulas(this.generateTableAlias(string, nArray[i]), this.propertyColumnFormulaTemplates[i], this.propertyColumnAliases[i]);
        }
        return selectFragment.toFragmentString();
    }

    protected String generateSnapshotSelectString() {
        Select select = new Select(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("get current state " + this.getEntityName());
        }
        String[] stringArray = StringHelper.qualify(this.getRootAlias(), this.getIdentifierColumnNames());
        String string = StringHelper.join(", ", stringArray) + this.concretePropertySelectFragment(this.getRootAlias(), this.getPropertyUpdateability());
        String string2 = this.fromTableFragment(this.getRootAlias()) + this.fromJoinFragment(this.getRootAlias(), true, false);
        String string3 = new StringBuffer().append(StringHelper.join("=? and ", stringArray)).append("=?").append(this.whereJoinFragment(this.getRootAlias(), true, false)).toString();
        return select.setSelectClause(string).setFromClause(string2).setOuterJoins("", "").setWhereClause(string3).toStatementString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object forceVersionIncrement(Serializable serializable, Object object, SessionImplementor sessionImplementor) {
        if (!this.isVersioned()) {
            throw new AssertionFailure("cannot force version increment on non-versioned entity");
        }
        if (this.isVersionPropertyGenerated()) {
            throw new HibernateException("LockMode.FORCE is currently not supported for generated version properties");
        }
        Object object2 = this.getVersionType().next(object, sessionImplementor);
        if (log.isTraceEnabled()) {
            log.trace("Forcing version increment [" + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()) + "; " + this.getVersionType().toLoggableString(object, this.getFactory()) + " -> " + this.getVersionType().toLoggableString(object2, this.getFactory()) + "]");
        }
        String string = this.generateVersionIncrementUpdateString();
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = sessionImplementor.getBatcher().prepareStatement(string);
                this.getVersionType().nullSafeSet(preparedStatement, object2, 1, sessionImplementor);
                this.getIdentifierType().nullSafeSet(preparedStatement, serializable, 2, sessionImplementor);
                this.getVersionType().nullSafeSet(preparedStatement, object, 2 + this.getIdentifierColumnSpan(), sessionImplementor);
                int n = preparedStatement.executeUpdate();
                if (n != 1) {
                    throw new StaleObjectStateException(this.getEntityName(), serializable);
                }
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve version: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()), this.getVersionSelectString());
        }
        return object2;
    }

    private String generateVersionIncrementUpdateString() {
        Update update = new Update(this.getFactory().getDialect());
        update.setTableName(this.getTableName(0));
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("forced version increment");
        }
        update.addColumn(this.getVersionColumnName());
        update.addPrimaryKeyColumns(this.getIdentifierColumnNames());
        update.setVersionColumnName(this.getVersionColumnName());
        return update.toStatementString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object getCurrentVersion(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Getting version: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
        }
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(this.getVersionSelectString());
            try {
                ResultSet resultSet;
                block14: {
                    block13: {
                        Object var5_6;
                        this.getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                        resultSet = preparedStatement.executeQuery();
                        try {
                            if (resultSet.next()) break block13;
                            var5_6 = null;
                        }
                        catch (Throwable throwable) {
                            resultSet.close();
                            throw throwable;
                        }
                        resultSet.close();
                        return var5_6;
                    }
                    if (this.isVersioned()) break block14;
                    AbstractEntityPersister abstractEntityPersister = this;
                    resultSet.close();
                    return abstractEntityPersister;
                }
                Object object = this.getVersionType().nullSafeGet(resultSet, this.getVersionColumnName(), sessionImplementor, null);
                resultSet.close();
                return object;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve version: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()), this.getVersionSelectString());
        }
    }

    protected void initLockers() {
        this.lockers.put(LockMode.READ, this.generateLocker(LockMode.READ));
        this.lockers.put(LockMode.UPGRADE, this.generateLocker(LockMode.UPGRADE));
        this.lockers.put(LockMode.UPGRADE_NOWAIT, this.generateLocker(LockMode.UPGRADE_NOWAIT));
        this.lockers.put(LockMode.FORCE, this.generateLocker(LockMode.FORCE));
        this.lockers.put(LockMode.PESSIMISTIC_READ, this.generateLocker(LockMode.PESSIMISTIC_READ));
        this.lockers.put(LockMode.PESSIMISTIC_WRITE, this.generateLocker(LockMode.PESSIMISTIC_WRITE));
        this.lockers.put(LockMode.PESSIMISTIC_FORCE_INCREMENT, this.generateLocker(LockMode.PESSIMISTIC_FORCE_INCREMENT));
        this.lockers.put(LockMode.OPTIMISTIC, this.generateLocker(LockMode.OPTIMISTIC));
        this.lockers.put(LockMode.OPTIMISTIC_FORCE_INCREMENT, this.generateLocker(LockMode.OPTIMISTIC_FORCE_INCREMENT));
    }

    protected LockingStrategy generateLocker(LockMode lockMode) {
        return this.factory.getDialect().getLockingStrategy(this, lockMode);
    }

    private LockingStrategy getLocker(LockMode lockMode) {
        return (LockingStrategy)this.lockers.get(lockMode);
    }

    public void lock(Serializable serializable, Object object, Object object2, LockMode lockMode, SessionImplementor sessionImplementor) throws HibernateException {
        this.getLocker(lockMode).lock(serializable, object, object2, -1, sessionImplementor);
    }

    public void lock(Serializable serializable, Object object, Object object2, LockOptions lockOptions, SessionImplementor sessionImplementor) throws HibernateException {
        this.getLocker(lockOptions.getLockMode()).lock(serializable, object, object2, lockOptions.getTimeOut(), sessionImplementor);
    }

    public String getRootTableName() {
        return this.getSubclassTableName(0);
    }

    public String getRootTableAlias(String string) {
        return string;
    }

    public String[] getRootTableIdentifierColumnNames() {
        return this.getRootTableKeyColumnNames();
    }

    public String[] toColumns(String string, String string2) throws QueryException {
        return this.propertyMapping.toColumns(string, string2);
    }

    public String[] toColumns(String string) throws QueryException {
        return this.propertyMapping.getColumnNames(string);
    }

    public Type toType(String string) throws QueryException {
        return this.propertyMapping.toType(string);
    }

    public String[] getPropertyColumnNames(String string) {
        return this.propertyMapping.getColumnNames(string);
    }

    public int getSubclassPropertyTableNumber(String string) {
        int n;
        String string2 = StringHelper.root(string);
        Type type = this.propertyMapping.toType(string2);
        if (type.isAssociationType()) {
            AssociationType associationType = (AssociationType)type;
            if (associationType.useLHSPrimaryKey()) {
                return 0;
            }
            if (type.isCollectionType()) {
                string2 = associationType.getLHSPropertyName();
            }
        }
        return (n = ArrayHelper.indexOf(this.getSubclassPropertyNameClosure(), string2)) == -1 ? 0 : this.getSubclassPropertyTableNumber(n);
    }

    public Queryable.Declarer getSubclassPropertyDeclarer(String string) {
        int n = this.getSubclassPropertyTableNumber(string);
        if (n == 0) {
            return Queryable.Declarer.CLASS;
        }
        if (this.isClassOrSuperclassTable(n)) {
            return Queryable.Declarer.SUPERCLASS;
        }
        return Queryable.Declarer.SUBCLASS;
    }

    public DiscriminatorMetadata getTypeDiscriminatorMetadata() {
        if (this.discriminatorMetadata == null) {
            this.discriminatorMetadata = this.buildTypeDiscriminatorMetadata();
        }
        return this.discriminatorMetadata;
    }

    private DiscriminatorMetadata buildTypeDiscriminatorMetadata() {
        return new DiscriminatorMetadata(){

            public String getSqlFragment(String string) {
                return AbstractEntityPersister.this.toColumns(string, AbstractEntityPersister.ENTITY_CLASS)[0];
            }

            public Type getResolutionType() {
                return new DiscriminatorType(AbstractEntityPersister.this.getDiscriminatorType(), AbstractEntityPersister.this);
            }
        };
    }

    protected String generateTableAlias(String string, int n) {
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer().append(string);
        if (!string.endsWith("_")) {
            stringBuffer.append('_');
        }
        return stringBuffer.append(n).append('_').toString();
    }

    public String[] toColumns(String string, int n) {
        String string2 = this.generateTableAlias(string, this.getSubclassPropertyTableNumber(n));
        String[] stringArray = this.getSubclassPropertyColumnNames(n);
        String[] stringArray2 = this.getSubclassPropertyFormulaTemplateClosure()[n];
        String[] stringArray3 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray3[i] = stringArray[i] == null ? StringHelper.replace(stringArray2[i], "$PlaceHolder$", string2) : StringHelper.qualify(string2, stringArray[i]);
        }
        return stringArray3;
    }

    private int getSubclassPropertyIndex(String string) {
        return ArrayHelper.indexOf(this.subclassPropertyNameClosure, string);
    }

    protected String[] getPropertySubclassNames() {
        return this.propertySubclassNames;
    }

    public String[] getPropertyColumnNames(int n) {
        return this.propertyColumnNames[n];
    }

    public String[] getPropertyColumnWriters(int n) {
        return this.propertyColumnWriters[n];
    }

    protected int getPropertyColumnSpan(int n) {
        return this.propertyColumnSpans[n];
    }

    protected boolean hasFormulaProperties() {
        return this.hasFormulaProperties;
    }

    public FetchMode getFetchMode(int n) {
        return this.subclassPropertyFetchModeClosure[n];
    }

    public CascadeStyle getCascadeStyle(int n) {
        return this.subclassPropertyCascadeStyleClosure[n];
    }

    public Type getSubclassPropertyType(int n) {
        return this.subclassPropertyTypeClosure[n];
    }

    public String getSubclassPropertyName(int n) {
        return this.subclassPropertyNameClosure[n];
    }

    public int countSubclassProperties() {
        return this.subclassPropertyTypeClosure.length;
    }

    public String[] getSubclassPropertyColumnNames(int n) {
        return this.subclassPropertyColumnNameClosure[n];
    }

    public boolean isDefinedOnSubclass(int n) {
        return this.propertyDefinedOnSubclass[n];
    }

    protected String[][] getSubclassPropertyFormulaTemplateClosure() {
        return this.subclassPropertyFormulaTemplateClosure;
    }

    protected Type[] getSubclassPropertyTypeClosure() {
        return this.subclassPropertyTypeClosure;
    }

    protected String[][] getSubclassPropertyColumnNameClosure() {
        return this.subclassPropertyColumnNameClosure;
    }

    public String[][] getSubclassPropertyColumnReaderClosure() {
        return this.subclassPropertyColumnReaderClosure;
    }

    public String[][] getSubclassPropertyColumnReaderTemplateClosure() {
        return this.subclassPropertyColumnReaderTemplateClosure;
    }

    protected String[] getSubclassPropertyNameClosure() {
        return this.subclassPropertyNameClosure;
    }

    protected String[] getSubclassPropertySubclassNameClosure() {
        return this.subclassPropertySubclassNameClosure;
    }

    protected String[] getSubclassColumnClosure() {
        return this.subclassColumnClosure;
    }

    protected String[] getSubclassColumnAliasClosure() {
        return this.subclassColumnAliasClosure;
    }

    public String[] getSubclassColumnReaderTemplateClosure() {
        return this.subclassColumnReaderTemplateClosure;
    }

    protected String[] getSubclassFormulaClosure() {
        return this.subclassFormulaClosure;
    }

    protected String[] getSubclassFormulaTemplateClosure() {
        return this.subclassFormulaTemplateClosure;
    }

    protected String[] getSubclassFormulaAliasClosure() {
        return this.subclassFormulaAliasClosure;
    }

    public String[] getSubclassPropertyColumnAliases(String string, String string2) {
        String[] stringArray = (String[])this.subclassPropertyAliases.get(string);
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = new Alias(string2).toUnquotedAliasString(stringArray[i]);
        }
        return stringArray2;
    }

    public String[] getSubclassPropertyColumnNames(String string) {
        return (String[])this.subclassPropertyColumnNames.get(string);
    }

    protected void initSubclassPropertyAliasesMap(PersistentClass persistentClass) throws MappingException {
        this.internalInitSubclassPropertyAliasesMap(null, persistentClass.getSubclassPropertyClosureIterator());
        if (!this.entityMetamodel.hasNonIdentifierPropertyNamedId()) {
            this.subclassPropertyAliases.put("id", this.getIdentifierAliases());
            this.subclassPropertyColumnNames.put("id", this.getIdentifierColumnNames());
        }
        if (this.hasIdentifierProperty()) {
            this.subclassPropertyAliases.put(this.getIdentifierPropertyName(), this.getIdentifierAliases());
            this.subclassPropertyColumnNames.put(this.getIdentifierPropertyName(), this.getIdentifierColumnNames());
        }
        if (this.getIdentifierType().isComponentType()) {
            CompositeType compositeType = (CompositeType)this.getIdentifierType();
            String[] stringArray = compositeType.getPropertyNames();
            String[] stringArray2 = this.getIdentifierAliases();
            String[] stringArray3 = this.getIdentifierColumnNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (this.entityMetamodel.hasNonIdentifierPropertyNamedId()) {
                    this.subclassPropertyAliases.put("id." + stringArray[i], new String[]{stringArray2[i]});
                    this.subclassPropertyColumnNames.put("id." + this.getIdentifierPropertyName() + "." + stringArray[i], new String[]{stringArray3[i]});
                }
                if (this.hasIdentifierProperty()) {
                    this.subclassPropertyAliases.put(this.getIdentifierPropertyName() + "." + stringArray[i], new String[]{stringArray2[i]});
                    this.subclassPropertyColumnNames.put(this.getIdentifierPropertyName() + "." + stringArray[i], new String[]{stringArray3[i]});
                    continue;
                }
                this.subclassPropertyAliases.put(stringArray[i], new String[]{stringArray2[i]});
                this.subclassPropertyColumnNames.put(stringArray[i], new String[]{stringArray3[i]});
            }
        }
        if (this.entityMetamodel.isPolymorphic()) {
            this.subclassPropertyAliases.put(ENTITY_CLASS, new String[]{this.getDiscriminatorAlias()});
            this.subclassPropertyColumnNames.put(ENTITY_CLASS, new String[]{this.getDiscriminatorColumnName()});
        }
    }

    private void internalInitSubclassPropertyAliasesMap(String string, Iterator iterator) {
        while (iterator.hasNext()) {
            String[] stringArray;
            String[] stringArray2;
            String string2;
            Property property = (Property)iterator.next();
            String string3 = string2 = string == null ? property.getName() : string + "." + property.getName();
            if (property.isComposite()) {
                stringArray2 = (String[])property.getValue();
                stringArray = stringArray2.getPropertyIterator();
                this.internalInitSubclassPropertyAliasesMap(string2, (Iterator)stringArray);
                continue;
            }
            stringArray2 = new String[property.getColumnSpan()];
            stringArray = new String[property.getColumnSpan()];
            Iterator iterator2 = property.getColumnIterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Selectable selectable = (Selectable)iterator2.next();
                stringArray2[n] = selectable.getAlias(this.getFactory().getDialect(), property.getValue().getTable());
                stringArray[n] = selectable.getText(this.getFactory().getDialect());
                ++n;
            }
            this.subclassPropertyAliases.put(string2, stringArray2);
            this.subclassPropertyColumnNames.put(string2, stringArray);
        }
    }

    public Object loadByUniqueKey(String string, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getAppropriateUniqueKeyLoader(string, sessionImplementor).loadByUniqueKey(sessionImplementor, object);
    }

    private EntityLoader getAppropriateUniqueKeyLoader(String string, SessionImplementor sessionImplementor) {
        boolean bl;
        boolean bl2 = bl = !sessionImplementor.getLoadQueryInfluencers().hasEnabledFilters() && !sessionImplementor.getLoadQueryInfluencers().hasEnabledFetchProfiles() && string.indexOf(46) < 0;
        if (bl) {
            return (EntityLoader)this.uniqueKeyLoaders.get(string);
        }
        return this.createUniqueKeyLoader(this.propertyMapping.toType(string), this.propertyMapping.toColumns(string), sessionImplementor.getLoadQueryInfluencers());
    }

    public int getPropertyIndex(String string) {
        return this.entityMetamodel.getPropertyIndex(string);
    }

    protected void createUniqueKeyLoaders() throws MappingException {
        Type[] typeArray = this.getPropertyTypes();
        String[] stringArray = this.getPropertyNames();
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!this.propertyUniqueness[i]) continue;
            this.uniqueKeyLoaders.put(stringArray[i], this.createUniqueKeyLoader(typeArray[i], this.getPropertyColumnNames(i), LoadQueryInfluencers.NONE));
        }
    }

    private EntityLoader createUniqueKeyLoader(Type type, String[] stringArray, LoadQueryInfluencers loadQueryInfluencers) {
        if (type.isEntityType()) {
            String string = ((EntityType)type).getAssociatedEntityName();
            type = this.getFactory().getEntityPersister(string).getIdentifierType();
        }
        return new EntityLoader((OuterJoinLoadable)this, stringArray, type, 1, LockMode.NONE, this.getFactory(), loadQueryInfluencers);
    }

    protected String getSQLWhereString(String string) {
        return StringHelper.replace(this.sqlWhereStringTemplate, "$PlaceHolder$", string);
    }

    protected boolean hasWhere() {
        return this.sqlWhereString != null;
    }

    private void initOrdinaryPropertyPaths(Mapping mapping) throws MappingException {
        for (int i = 0; i < this.getSubclassPropertyNameClosure().length; ++i) {
            this.propertyMapping.initPropertyPaths(this.getSubclassPropertyNameClosure()[i], this.getSubclassPropertyTypeClosure()[i], this.getSubclassPropertyColumnNameClosure()[i], this.getSubclassPropertyColumnReaderClosure()[i], this.getSubclassPropertyColumnReaderTemplateClosure()[i], this.getSubclassPropertyFormulaTemplateClosure()[i], mapping);
        }
    }

    private void initIdentifierPropertyPaths(Mapping mapping) throws MappingException {
        String string = this.getIdentifierPropertyName();
        if (string != null) {
            this.propertyMapping.initPropertyPaths(string, this.getIdentifierType(), this.getIdentifierColumnNames(), this.getIdentifierColumnReaders(), this.getIdentifierColumnReaderTemplates(), null, mapping);
        }
        if (this.entityMetamodel.getIdentifierProperty().isEmbedded()) {
            this.propertyMapping.initPropertyPaths(null, this.getIdentifierType(), this.getIdentifierColumnNames(), this.getIdentifierColumnReaders(), this.getIdentifierColumnReaderTemplates(), null, mapping);
        }
        if (!this.entityMetamodel.hasNonIdentifierPropertyNamedId()) {
            this.propertyMapping.initPropertyPaths("id", this.getIdentifierType(), this.getIdentifierColumnNames(), this.getIdentifierColumnReaders(), this.getIdentifierColumnReaderTemplates(), null, mapping);
        }
    }

    private void initDiscriminatorPropertyPath(Mapping mapping) throws MappingException {
        this.propertyMapping.initPropertyPaths(ENTITY_CLASS, this.getDiscriminatorType(), new String[]{this.getDiscriminatorColumnName()}, new String[]{this.getDiscriminatorColumnReaders()}, new String[]{this.getDiscriminatorColumnReaderTemplate()}, new String[]{this.getDiscriminatorFormulaTemplate()}, this.getFactory());
    }

    protected void initPropertyPaths(Mapping mapping) throws MappingException {
        this.initOrdinaryPropertyPaths(mapping);
        this.initOrdinaryPropertyPaths(mapping);
        this.initIdentifierPropertyPaths(mapping);
        if (this.entityMetamodel.isPolymorphic()) {
            this.initDiscriminatorPropertyPath(mapping);
        }
    }

    protected UniqueEntityLoader createEntityLoader(LockMode lockMode, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return BatchingEntityLoader.createBatchingEntityLoader((OuterJoinLoadable)this, this.batchSize, lockMode, this.getFactory(), loadQueryInfluencers);
    }

    protected UniqueEntityLoader createEntityLoader(LockOptions lockOptions, LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return BatchingEntityLoader.createBatchingEntityLoader((OuterJoinLoadable)this, this.batchSize, lockOptions, this.getFactory(), loadQueryInfluencers);
    }

    protected UniqueEntityLoader createEntityLoader(LockMode lockMode) throws MappingException {
        return this.createEntityLoader(lockMode, LoadQueryInfluencers.NONE);
    }

    protected boolean check(int n, Serializable serializable, int n2, Expectation expectation, PreparedStatement preparedStatement) throws HibernateException {
        try {
            expectation.verifyOutcome(n, preparedStatement, -1);
        }
        catch (StaleStateException staleStateException) {
            if (!this.isNullableTable(n2)) {
                if (this.getFactory().getStatistics().isStatisticsEnabled()) {
                    this.getFactory().getStatisticsImplementor().optimisticFailure(this.getEntityName());
                }
                throw new StaleObjectStateException(this.getEntityName(), serializable);
            }
        }
        catch (TooManyRowsAffectedException tooManyRowsAffectedException) {
            throw new HibernateException("Duplicate identifier in table for: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
        }
        finally {
            return false;
        }
        return true;
    }

    protected String generateUpdateString(boolean[] blArray, int n, boolean bl) {
        return this.generateUpdateString(blArray, n, null, bl);
    }

    protected String generateUpdateString(boolean[] blArray, int n, Object[] objectArray, boolean bl) {
        Update update = new Update(this.getFactory().getDialect()).setTableName(this.getTableName(n));
        if (bl) {
            update.addPrimaryKeyColumns(new String[]{this.rowIdName});
        } else {
            update.addPrimaryKeyColumns(this.getKeyColumns(n));
        }
        boolean bl2 = false;
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!blArray[i] || !this.isPropertyOfTable(i, n)) continue;
            update.addColumns(this.getPropertyColumnNames(i), this.propertyColumnUpdateable[i], this.propertyColumnWriters[i]);
            bl2 = bl2 || this.getPropertyColumnSpan(i) > 0;
        }
        if (n == 0 && this.isVersioned() && this.entityMetamodel.getOptimisticLockMode() == 0) {
            if (this.checkVersion(blArray)) {
                update.setVersionColumnName(this.getVersionColumnName());
                bl2 = true;
            }
        } else if (this.entityMetamodel.getOptimisticLockMode() > 0 && objectArray != null) {
            boolean[] blArray2 = this.entityMetamodel.getOptimisticLockMode() == 2 ? this.getPropertyUpdateability() : blArray;
            boolean[] blArray3 = this.getPropertyVersionability();
            Type[] typeArray = this.getPropertyTypes();
            for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
                boolean bl3;
                boolean bl4 = bl3 = blArray2[i] && this.isPropertyOfTable(i, n) && blArray3[i];
                if (!bl3) continue;
                String[] stringArray = this.getPropertyColumnNames(i);
                String[] stringArray2 = this.getPropertyColumnWriters(i);
                boolean[] blArray4 = typeArray[i].toColumnNullness(objectArray[i], this.getFactory());
                for (int j = 0; j < blArray4.length; ++j) {
                    if (blArray4[j]) {
                        update.addWhereColumn(stringArray[j], "=" + stringArray2[j]);
                        continue;
                    }
                    update.addWhereColumn(stringArray[j], " is null");
                }
            }
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("update " + this.getEntityName());
        }
        return bl2 ? update.toStatementString() : null;
    }

    private boolean checkVersion(boolean[] blArray) {
        return blArray[this.getVersionProperty()] || this.entityMetamodel.getPropertyUpdateGenerationInclusions()[this.getVersionProperty()] != ValueInclusion.NONE;
    }

    protected String generateInsertString(boolean[] blArray, int n) {
        return this.generateInsertString(false, blArray, n);
    }

    protected String generateInsertString(boolean bl, boolean[] blArray) {
        return this.generateInsertString(bl, blArray, 0);
    }

    protected String generateInsertString(boolean bl, boolean[] blArray, int n) {
        Insert insert = new Insert(this.getFactory().getDialect()).setTableName(this.getTableName(n));
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!blArray[i] || !this.isPropertyOfTable(i, n)) continue;
            insert.addColumns(this.getPropertyColumnNames(i), this.propertyColumnInsertable[i], this.propertyColumnWriters[i]);
        }
        if (n == 0) {
            this.addDiscriminatorToInsert(insert);
        }
        if (n == 0 && bl) {
            insert.addIdentityColumn(this.getKeyColumns(0)[0]);
        } else {
            insert.addColumns(this.getKeyColumns(n));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert " + this.getEntityName());
        }
        String string = insert.toStatementString();
        if (n == 0 && bl && this.useInsertSelectIdentity()) {
            string = this.getFactory().getDialect().appendIdentitySelectToInsert(string);
        }
        return string;
    }

    protected String generateIdentityInsertString(boolean[] blArray) {
        IdentifierGeneratingInsert identifierGeneratingInsert = this.identityDelegate.prepareIdentifierGeneratingInsert();
        identifierGeneratingInsert.setTableName(this.getTableName(0));
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!blArray[i] || !this.isPropertyOfTable(i, 0)) continue;
            identifierGeneratingInsert.addColumns(this.getPropertyColumnNames(i), this.propertyColumnInsertable[i], this.propertyColumnWriters[i]);
        }
        this.addDiscriminatorToInsert(identifierGeneratingInsert);
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            identifierGeneratingInsert.setComment("insert " + this.getEntityName());
        }
        return identifierGeneratingInsert.toStatementString();
    }

    protected String generateDeleteString(int n) {
        Delete delete = new Delete().setTableName(this.getTableName(n)).addPrimaryKeyColumns(this.getKeyColumns(n));
        if (n == 0) {
            delete.setVersionColumnName(this.getVersionColumnName());
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete " + this.getEntityName());
        }
        return delete.toStatementString();
    }

    protected int dehydrate(Serializable serializable, Object[] objectArray, boolean[] blArray, boolean[][] blArray2, int n, PreparedStatement preparedStatement, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        return this.dehydrate(serializable, objectArray, null, blArray, blArray2, n, preparedStatement, sessionImplementor, 1);
    }

    protected int dehydrate(Serializable serializable, Object[] objectArray, Object object, boolean[] blArray, boolean[][] blArray2, int n, PreparedStatement preparedStatement, SessionImplementor sessionImplementor, int n2) throws SQLException, HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Dehydrating entity: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
        }
        for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
            if (!blArray[i] || !this.isPropertyOfTable(i, n)) continue;
            this.getPropertyTypes()[i].nullSafeSet(preparedStatement, objectArray[i], n2, blArray2[i], sessionImplementor);
            n2 += ArrayHelper.countTrue(blArray2[i]);
        }
        if (object != null) {
            preparedStatement.setObject(n2, object);
            ++n2;
        } else if (serializable != null) {
            this.getIdentifierType().nullSafeSet(preparedStatement, serializable, n2, sessionImplementor);
            n2 += this.getIdentifierColumnSpan();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] hydrate(ResultSet resultSet, Serializable serializable, Object object, Loadable loadable, String[][] stringArray, boolean bl, SessionImplementor sessionImplementor) throws SQLException, HibernateException {
        Object[] objectArray;
        block11: {
            if (log.isTraceEnabled()) {
                log.trace("Hydrating entity: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
            }
            AbstractEntityPersister abstractEntityPersister = (AbstractEntityPersister)loadable;
            boolean bl2 = abstractEntityPersister.hasSequentialSelect();
            PreparedStatement preparedStatement = null;
            ResultSet resultSet2 = null;
            boolean bl3 = false;
            try {
                Object object2;
                if (bl2 && (object2 = abstractEntityPersister.getSequentialSelect(this.getEntityName())) != null) {
                    preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement((String)object2);
                    abstractEntityPersister.getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                    resultSet2 = preparedStatement.executeQuery();
                    if (!resultSet2.next()) {
                        bl3 = true;
                    }
                }
                object2 = this.getPropertyNames();
                Type[] typeArray = this.getPropertyTypes();
                Object[] objectArray2 = new Object[typeArray.length];
                boolean[] blArray = this.getPropertyLaziness();
                String[] stringArray2 = this.getSubclassPropertySubclassNameClosure();
                for (int i = 0; i < typeArray.length; ++i) {
                    if (!this.propertySelectable[i]) {
                        objectArray2[i] = BackrefPropertyAccessor.UNKNOWN;
                        continue;
                    }
                    if (bl || !blArray[i]) {
                        boolean bl4;
                        boolean bl5 = bl4 = bl2 && abstractEntityPersister.isSubclassPropertyDeferred(object2[i], stringArray2[i]);
                        if (bl4 && bl3) {
                            objectArray2[i] = null;
                            continue;
                        }
                        ResultSet resultSet3 = bl4 ? resultSet2 : resultSet;
                        String[] stringArray3 = bl4 ? this.propertyColumnAliases[i] : stringArray[i];
                        objectArray2[i] = typeArray[i].hydrate(resultSet3, stringArray3, sessionImplementor, object);
                        continue;
                    }
                    objectArray2[i] = LazyPropertyInitializer.UNFETCHED_PROPERTY;
                }
                if (resultSet2 != null) {
                    resultSet2.close();
                }
                objectArray = objectArray2;
                if (preparedStatement == null) break block11;
            }
            catch (Throwable throwable) {
                if (preparedStatement != null) {
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                }
                throw throwable;
            }
            sessionImplementor.getBatcher().closeStatement(preparedStatement);
        }
        return objectArray;
    }

    protected boolean useInsertSelectIdentity() {
        return !this.useGetGeneratedKeys() && this.getFactory().getDialect().supportsInsertSelectIdentity();
    }

    protected boolean useGetGeneratedKeys() {
        return this.getFactory().getSettings().isGetGeneratedKeysEnabled();
    }

    protected String getSequentialSelect(String string) {
        throw new UnsupportedOperationException("no sequential selects");
    }

    protected Serializable insert(final Object[] objectArray, final boolean[] blArray, String string, final Object object, final SessionImplementor sessionImplementor) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Inserting entity: " + this.getEntityName() + " (native id)");
            if (this.isVersioned()) {
                log.trace("Version: " + Versioning.getVersion(objectArray, this));
            }
        }
        Binder binder = new Binder(){

            public void bindValues(PreparedStatement preparedStatement) throws SQLException {
                AbstractEntityPersister.this.dehydrate(null, objectArray, blArray, AbstractEntityPersister.this.propertyColumnInsertable, 0, preparedStatement, sessionImplementor);
            }

            public Object getEntity() {
                return object;
            }
        };
        return this.identityDelegate.performInsert(string, sessionImplementor, binder);
    }

    public String getIdentitySelectString() {
        return this.getFactory().getDialect().getIdentitySelectString(this.getTableName(0), this.getKeyColumns(0)[0], this.getIdentifierType().sqlTypes(this.getFactory())[0]);
    }

    public String getSelectByUniqueKeyString(String string) {
        return new SimpleSelect(this.getFactory().getDialect()).setTableName(this.getTableName(0)).addColumns(this.getKeyColumns(0)).addCondition(this.getPropertyColumnNames(string), "=?").toStatementString();
    }

    protected void insert(Serializable serializable, Object[] objectArray, boolean[] blArray, int n, String string, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        if (this.isInverseTable(n)) {
            return;
        }
        if (this.isNullableTable(n) && this.isAllNull(objectArray, n)) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Inserting entity: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
            if (n == 0 && this.isVersioned()) {
                log.trace("Version: " + Versioning.getVersion(objectArray, this));
            }
        }
        Expectation expectation = Expectations.appropriateExpectation(this.insertResultCheckStyles[n]);
        boolean bl = this.isInsertCallable(n);
        boolean bl2 = n == 0 && expectation.canBeBatched();
        try {
            PreparedStatement preparedStatement = bl2 ? (bl ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string)) : (bl ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string));
            try {
                int n2 = 1;
                this.dehydrate(serializable, objectArray, null, blArray, this.propertyColumnInsertable, n, preparedStatement, sessionImplementor, n2 += expectation.prepare(preparedStatement));
                if (bl2) {
                    sessionImplementor.getBatcher().addToBatch(expectation);
                } else {
                    expectation.verifyOutcome(preparedStatement.executeUpdate(), preparedStatement, -1);
                }
            }
            catch (SQLException sQLException) {
                if (bl2) {
                    sessionImplementor.getBatcher().abortBatch(sQLException);
                }
                throw sQLException;
            }
            finally {
                if (!bl2) {
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                }
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not insert: " + MessageHelper.infoString(this), string);
        }
    }

    protected void updateOrInsert(Serializable serializable, Object[] objectArray, Object[] objectArray2, Object object, boolean[] blArray, int n, Object object2, Object object3, String string, SessionImplementor sessionImplementor) throws HibernateException {
        if (!this.isInverseTable(n)) {
            boolean bl;
            if (this.isNullableTable(n) && objectArray2 != null && this.isAllNull(objectArray2, n)) {
                bl = false;
            } else if (this.isNullableTable(n) && this.isAllNull(objectArray, n)) {
                bl = true;
                this.delete(serializable, object2, n, object3, this.getSQLDeleteStrings()[n], sessionImplementor, null);
            } else {
                bl = this.update(serializable, objectArray, objectArray2, object, blArray, n, object2, object3, string, sessionImplementor);
            }
            if (!bl && !this.isAllNull(objectArray, n)) {
                this.insert(serializable, objectArray, this.getPropertyInsertability(), n, this.getSQLInsertStrings()[n], object3, sessionImplementor);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean update(Serializable serializable, Object[] objectArray, Object[] objectArray2, Object object, boolean[] blArray, int n, Object object2, Object object3, String string, SessionImplementor sessionImplementor) throws HibernateException {
        boolean bl;
        boolean bl2 = n == 0 && this.isVersioned();
        Expectation expectation = Expectations.appropriateExpectation(this.updateResultCheckStyles[n]);
        boolean bl3 = this.isUpdateCallable(n);
        boolean bl4 = bl = n == 0 && expectation.canBeBatched() && this.isBatchable();
        if (log.isTraceEnabled()) {
            log.trace("Updating entity: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
            if (bl2) {
                log.trace("Existing version: " + object2 + " -> New version: " + objectArray[this.getVersionProperty()]);
            }
        }
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = bl ? (bl3 ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string)) : (bl3 ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string));
            try {
                n2 += expectation.prepare(preparedStatement);
                n2 = this.dehydrate(serializable, objectArray, object, blArray, this.propertyColumnUpdateable, n, preparedStatement, sessionImplementor, n2);
                if (bl2 && 0 == this.entityMetamodel.getOptimisticLockMode()) {
                    if (this.checkVersion(blArray)) {
                        this.getVersionType().nullSafeSet(preparedStatement, object2, n2, sessionImplementor);
                    }
                } else if (this.entityMetamodel.getOptimisticLockMode() > 0 && objectArray2 != null) {
                    boolean[] blArray2 = this.getPropertyVersionability();
                    boolean[] blArray3 = this.entityMetamodel.getOptimisticLockMode() == 2 ? this.getPropertyUpdateability() : blArray;
                    Type[] typeArray = this.getPropertyTypes();
                    for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
                        boolean bl5;
                        boolean bl6 = bl5 = blArray3[i] && this.isPropertyOfTable(i, n) && blArray2[i];
                        if (!bl5) continue;
                        boolean[] blArray4 = typeArray[i].toColumnNullness(objectArray2[i], this.getFactory());
                        typeArray[i].nullSafeSet(preparedStatement, objectArray2[i], n2, blArray4, sessionImplementor);
                        n2 += ArrayHelper.countTrue(blArray4);
                    }
                }
                if (bl) {
                    sessionImplementor.getBatcher().addToBatch(expectation);
                    boolean bl7 = true;
                    return bl7;
                }
                boolean bl8 = this.check(preparedStatement.executeUpdate(), serializable, n, expectation, preparedStatement);
                return bl8;
            }
            catch (SQLException sQLException) {
                if (!bl) throw sQLException;
                sessionImplementor.getBatcher().abortBatch(sQLException);
                throw sQLException;
            }
            finally {
                if (!bl) {
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                }
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not update: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()), string);
        }
    }

    protected void delete(Serializable serializable, Object object, int n, Object object2, String string, SessionImplementor sessionImplementor, Object[] objectArray) throws HibernateException {
        boolean bl;
        if (this.isInverseTable(n)) {
            return;
        }
        boolean bl2 = n == 0 && this.isVersioned();
        boolean bl3 = this.isDeleteCallable(n);
        Expectation expectation = Expectations.appropriateExpectation(this.deleteResultCheckStyles[n]);
        boolean bl4 = bl = n == 0 && this.isBatchable() && expectation.canBeBatched();
        if (log.isTraceEnabled()) {
            log.trace("Deleting entity: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
            if (bl2) {
                log.trace("Version: " + object);
            }
        }
        if (this.isTableCascadeDeleteEnabled(n)) {
            if (log.isTraceEnabled()) {
                log.trace("delete handled by foreign key constraint: " + this.getTableName(n));
            }
            return;
        }
        try {
            int n2 = 1;
            PreparedStatement preparedStatement = bl ? (bl3 ? sessionImplementor.getBatcher().prepareBatchCallableStatement(string) : sessionImplementor.getBatcher().prepareBatchStatement(string)) : (bl3 ? sessionImplementor.getBatcher().prepareCallableStatement(string) : sessionImplementor.getBatcher().prepareStatement(string));
            try {
                this.getIdentifierType().nullSafeSet(preparedStatement, serializable, n2 += expectation.prepare(preparedStatement), sessionImplementor);
                n2 += this.getIdentifierColumnSpan();
                if (bl2) {
                    this.getVersionType().nullSafeSet(preparedStatement, object, n2, sessionImplementor);
                } else if (this.entityMetamodel.getOptimisticLockMode() > 0 && objectArray != null) {
                    boolean[] blArray = this.getPropertyVersionability();
                    Type[] typeArray = this.getPropertyTypes();
                    for (int i = 0; i < this.entityMetamodel.getPropertySpan(); ++i) {
                        if (!this.isPropertyOfTable(i, n) || !blArray[i]) continue;
                        boolean[] blArray2 = typeArray[i].toColumnNullness(objectArray[i], this.getFactory());
                        typeArray[i].nullSafeSet(preparedStatement, objectArray[i], n2, blArray2, sessionImplementor);
                        n2 += ArrayHelper.countTrue(blArray2);
                    }
                }
                if (bl) {
                    sessionImplementor.getBatcher().addToBatch(expectation);
                } else {
                    this.check(preparedStatement.executeUpdate(), serializable, n, expectation, preparedStatement);
                }
            }
            catch (SQLException sQLException) {
                if (bl) {
                    sessionImplementor.getBatcher().abortBatch(sQLException);
                }
                throw sQLException;
            }
            finally {
                if (!bl) {
                    sessionImplementor.getBatcher().closeStatement(preparedStatement);
                }
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not delete: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()), string);
        }
    }

    private String[] getUpdateStrings(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? this.getSQLLazyUpdateByRowIdStrings() : this.getSQLUpdateByRowIdStrings();
        }
        return bl2 ? this.getSQLLazyUpdateStrings() : this.getSQLUpdateStrings();
    }

    public void update(Serializable serializable, Object[] objectArray, int[] nArray, boolean bl, Object[] objectArray2, Object object, Object object2, Object object3, SessionImplementor sessionImplementor) throws HibernateException {
        int n;
        String[] stringArray;
        boolean[] blArray;
        boolean[] blArray2 = this.getTableUpdateNeeded(nArray, bl);
        int n2 = this.getTableSpan();
        EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(object2);
        if (entityEntry == null && !this.isMutable()) {
            throw new IllegalStateException("Updating immutable entity that is not in session yet!");
        }
        if (this.entityMetamodel.isDynamicUpdate() && nArray != null) {
            blArray = this.getPropertiesToUpdate(nArray, bl);
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = blArray2[n] ? this.generateUpdateString(blArray, n, objectArray2, n == 0 && object3 != null) : null;
            }
        } else if (!this.isModifiableEntity(entityEntry)) {
            blArray = this.getPropertiesToUpdate(nArray == null ? ArrayHelper.EMPTY_INT_ARRAY : nArray, bl);
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = blArray2[n] ? this.generateUpdateString(blArray, n, objectArray2, n == 0 && object3 != null) : null;
            }
        } else {
            stringArray = this.getUpdateStrings(object3 != null, this.hasUninitializedLazyProperties(object2, sessionImplementor.getEntityMode()));
            blArray = this.getPropertyUpdateability(object2, sessionImplementor.getEntityMode());
        }
        for (n = 0; n < n2; ++n) {
            if (!blArray2[n]) continue;
            this.updateOrInsert(serializable, objectArray, objectArray2, n == 0 ? object3 : null, blArray, n, object, object2, stringArray[n], sessionImplementor);
        }
    }

    public Serializable insert(Object[] objectArray, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        Serializable serializable;
        int n = this.getTableSpan();
        if (this.entityMetamodel.isDynamicInsert()) {
            boolean[] blArray = this.getPropertiesToInsert(objectArray);
            serializable = this.insert(objectArray, blArray, this.generateInsertString(true, blArray), object, sessionImplementor);
            for (int i = 1; i < n; ++i) {
                this.insert(serializable, objectArray, blArray, i, this.generateInsertString(blArray, i), object, sessionImplementor);
            }
        } else {
            serializable = this.insert(objectArray, this.getPropertyInsertability(), this.getSQLIdentityInsertString(), object, sessionImplementor);
            for (int i = 1; i < n; ++i) {
                this.insert(serializable, objectArray, this.getPropertyInsertability(), i, this.getSQLInsertStrings()[i], object, sessionImplementor);
            }
        }
        return serializable;
    }

    public void insert(Serializable serializable, Object[] objectArray, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        int n = this.getTableSpan();
        if (this.entityMetamodel.isDynamicInsert()) {
            boolean[] blArray = this.getPropertiesToInsert(objectArray);
            for (int i = 0; i < n; ++i) {
                this.insert(serializable, objectArray, blArray, i, this.generateInsertString(blArray, i), object, sessionImplementor);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.insert(serializable, objectArray, this.getPropertyInsertability(), i, this.getSQLInsertStrings()[i], object, sessionImplementor);
            }
        }
    }

    public void delete(Serializable serializable, Object object, Object object2, SessionImplementor sessionImplementor) throws HibernateException {
        Object object3;
        int n = this.getTableSpan();
        boolean bl = !this.entityMetamodel.isVersioned() && this.entityMetamodel.getOptimisticLockMode() > 0;
        Object[] objectArray = null;
        if (bl) {
            object3 = new EntityKey(serializable, this, sessionImplementor.getEntityMode());
            Object object4 = sessionImplementor.getPersistenceContext().getEntity((EntityKey)object3);
            if (object4 != null) {
                EntityEntry entityEntry = sessionImplementor.getPersistenceContext().getEntry(object4);
                objectArray = entityEntry.getLoadedState();
            }
        }
        object3 = bl && objectArray != null ? this.generateSQLDeletStrings(objectArray) : this.getSQLDeleteStrings();
        for (int i = n - 1; i >= 0; --i) {
            this.delete(serializable, object, i, object2, object3[i], sessionImplementor, objectArray);
        }
    }

    private String[] generateSQLDeletStrings(Object[] objectArray) {
        int n = this.getTableSpan();
        String[] stringArray = new String[n];
        for (int i = n - 1; i >= 0; --i) {
            Delete delete = new Delete().setTableName(this.getTableName(i)).addPrimaryKeyColumns(this.getKeyColumns(i));
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                delete.setComment("delete " + this.getEntityName() + " [" + i + "]");
            }
            boolean[] blArray = this.getPropertyVersionability();
            Type[] typeArray = this.getPropertyTypes();
            for (int j = 0; j < this.entityMetamodel.getPropertySpan(); ++j) {
                if (!this.isPropertyOfTable(j, i) || !blArray[j]) continue;
                String[] stringArray2 = this.getPropertyColumnNames(j);
                boolean[] blArray2 = typeArray[j].toColumnNullness(objectArray[j], this.getFactory());
                for (int k = 0; k < blArray2.length; ++k) {
                    if (blArray2[k]) {
                        delete.addWhereFragment(stringArray2[k] + " = ?");
                        continue;
                    }
                    delete.addWhereFragment(stringArray2[k] + " is null");
                }
            }
            stringArray[i] = delete.toStatementString();
        }
        return stringArray;
    }

    protected void logStaticSQL() {
        if (log.isDebugEnabled()) {
            log.debug("Static SQL for entity: " + this.getEntityName());
            if (this.sqlLazySelectString != null) {
                log.debug(" Lazy select: " + this.sqlLazySelectString);
            }
            if (this.sqlVersionSelectString != null) {
                log.debug(" Version select: " + this.sqlVersionSelectString);
            }
            if (this.sqlSnapshotSelectString != null) {
                log.debug(" Snapshot select: " + this.sqlSnapshotSelectString);
            }
            for (int i = 0; i < this.getTableSpan(); ++i) {
                log.debug(" Insert " + i + ": " + this.getSQLInsertStrings()[i]);
                log.debug(" Update " + i + ": " + this.getSQLUpdateStrings()[i]);
                log.debug(" Delete " + i + ": " + this.getSQLDeleteStrings()[i]);
            }
            if (this.sqlIdentityInsertString != null) {
                log.debug(" Identity insert: " + this.sqlIdentityInsertString);
            }
            if (this.sqlUpdateByRowIdString != null) {
                log.debug(" Update by row id (all fields): " + this.sqlUpdateByRowIdString);
            }
            if (this.sqlLazyUpdateByRowIdString != null) {
                log.debug(" Update by row id (non-lazy fields): " + this.sqlLazyUpdateByRowIdString);
            }
            if (this.sqlInsertGeneratedValuesSelectString != null) {
                log.debug("Insert-generated property select: " + this.sqlInsertGeneratedValuesSelectString);
            }
            if (this.sqlUpdateGeneratedValuesSelectString != null) {
                log.debug("Update-generated property select: " + this.sqlUpdateGeneratedValuesSelectString);
            }
        }
    }

    public String filterFragment(String string, Map map) throws MappingException {
        StringBuffer stringBuffer = new StringBuffer();
        this.filterHelper.render(stringBuffer, this.generateFilterConditionAlias(string), map);
        return stringBuffer.append(this.filterFragment(string)).toString();
    }

    public String generateFilterConditionAlias(String string) {
        return string;
    }

    public String oneToManyFilterFragment(String string) throws MappingException {
        return "";
    }

    public String fromJoinFragment(String string, boolean bl, boolean bl2) {
        return this.getSubclassTableSpan() == 1 ? "" : this.createJoin(string, bl, bl2).toFromFragmentString();
    }

    public String whereJoinFragment(String string, boolean bl, boolean bl2) {
        return this.getSubclassTableSpan() == 1 ? "" : this.createJoin(string, bl, bl2).toWhereFragmentString();
    }

    protected boolean isSubclassTableLazy(int n) {
        return false;
    }

    protected JoinFragment createJoin(String string, boolean bl, boolean bl2) {
        String[] stringArray = StringHelper.qualify(string, this.getIdentifierColumnNames());
        JoinFragment joinFragment = this.getFactory().getDialect().createOuterJoinFragment();
        int n = this.getSubclassTableSpan();
        for (int i = 1; i < n; ++i) {
            boolean bl3;
            boolean bl4 = bl3 = this.isClassOrSuperclassTable(i) || bl2 && !this.isSubclassTableSequentialSelect(i) && !this.isSubclassTableLazy(i);
            if (!bl3) continue;
            joinFragment.addJoin(this.getSubclassTableName(i), this.generateTableAlias(string, i), stringArray, this.getSubclassTableKeyColumns(i), bl && this.isClassOrSuperclassTable(i) && !this.isInverseTable(i) && !this.isNullableTable(i) ? 0 : 1);
        }
        return joinFragment;
    }

    protected JoinFragment createJoin(int[] nArray, String string) {
        String[] stringArray = StringHelper.qualify(string, this.getSubclassTableKeyColumns(nArray[0]));
        JoinFragment joinFragment = this.getFactory().getDialect().createOuterJoinFragment();
        for (int i = 1; i < nArray.length; ++i) {
            int n = nArray[i];
            joinFragment.addJoin(this.getSubclassTableName(n), this.generateTableAlias(this.getRootAlias(), n), stringArray, this.getSubclassTableKeyColumns(n), this.isInverseSubclassTable(n) || this.isNullableSubclassTable(n) ? 1 : 0);
        }
        return joinFragment;
    }

    protected SelectFragment createSelect(int[] nArray, int[] nArray2) {
        Object object;
        SelectFragment selectFragment = new SelectFragment();
        int[] nArray3 = this.getSubclassColumnTableNumberClosure();
        String[] stringArray = this.getSubclassColumnAliasClosure();
        String[] stringArray2 = this.getSubclassColumnReaderTemplateClosure();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (!this.subclassColumnSelectableClosure[n]) continue;
            object = this.generateTableAlias(this.getRootAlias(), nArray3[n]);
            selectFragment.addColumnTemplate((String)object, stringArray2[n], stringArray[n]);
        }
        int[] nArray4 = this.getSubclassFormulaTableNumberClosure();
        String[] stringArray3 = this.getSubclassFormulaTemplateClosure();
        object = this.getSubclassFormulaAliasClosure();
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray2[i];
            String string = this.generateTableAlias(this.getRootAlias(), nArray4[n]);
            selectFragment.addFormula(string, stringArray3[n], object[n]);
        }
        return selectFragment;
    }

    protected String createFrom(int n, String string) {
        return this.getSubclassTableName(n) + ' ' + string;
    }

    protected String createWhereByKey(int n, String string) {
        return StringHelper.join("=? and ", StringHelper.qualify(string, this.getSubclassTableKeyColumns(n))) + "=?";
    }

    protected String renderSelect(int[] nArray, int[] nArray2, int[] nArray3) {
        Arrays.sort(nArray);
        int n = nArray[0];
        String string = this.generateTableAlias(this.getRootAlias(), n);
        String string2 = this.createWhereByKey(n, string);
        String string3 = this.createFrom(n, string);
        JoinFragment joinFragment = this.createJoin(nArray, string);
        SelectFragment selectFragment = this.createSelect(nArray2, nArray3);
        Select select = new Select(this.getFactory().getDialect());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        select.setFromClause(string3);
        select.setWhereClause(string2);
        select.setOuterJoins(joinFragment.toFromFragmentString(), joinFragment.toWhereFragmentString());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("sequential select " + this.getEntityName());
        }
        return select.toStatementString();
    }

    private String getRootAlias() {
        return StringHelper.generateAlias(this.getEntityName());
    }

    protected void postConstruct(Mapping mapping) throws MappingException {
        int n;
        this.initPropertyPaths(mapping);
        int n2 = this.getTableSpan();
        this.sqlDeleteStrings = new String[n2];
        this.sqlInsertStrings = new String[n2];
        this.sqlUpdateStrings = new String[n2];
        this.sqlLazyUpdateStrings = new String[n2];
        this.sqlUpdateByRowIdString = this.rowIdName == null ? null : this.generateUpdateString(this.getPropertyUpdateability(), 0, true);
        this.sqlLazyUpdateByRowIdString = this.rowIdName == null ? null : this.generateUpdateString(this.getNonLazyPropertyUpdateability(), 0, true);
        for (n = 0; n < n2; ++n) {
            this.sqlInsertStrings[n] = this.customSQLInsert[n] == null ? this.generateInsertString(this.getPropertyInsertability(), n) : this.customSQLInsert[n];
            this.sqlUpdateStrings[n] = this.customSQLUpdate[n] == null ? this.generateUpdateString(this.getPropertyUpdateability(), n, false) : this.customSQLUpdate[n];
            this.sqlLazyUpdateStrings[n] = this.customSQLUpdate[n] == null ? this.generateUpdateString(this.getNonLazyPropertyUpdateability(), n, false) : this.customSQLUpdate[n];
            this.sqlDeleteStrings[n] = this.customSQLDelete[n] == null ? this.generateDeleteString(n) : this.customSQLDelete[n];
        }
        this.tableHasColumns = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            this.tableHasColumns[n] = this.sqlUpdateStrings[n] != null;
        }
        this.sqlSnapshotSelectString = this.generateSnapshotSelectString();
        this.sqlLazySelectString = this.generateLazySelectString();
        this.sqlVersionSelectString = this.generateSelectVersionString();
        if (this.hasInsertGeneratedProperties()) {
            this.sqlInsertGeneratedValuesSelectString = this.generateInsertGeneratedValuesSelectString();
        }
        if (this.hasUpdateGeneratedProperties()) {
            this.sqlUpdateGeneratedValuesSelectString = this.generateUpdateGeneratedValuesSelectString();
        }
        if (this.isIdentifierAssignedByInsert()) {
            this.identityDelegate = ((PostInsertIdentifierGenerator)this.getIdentifierGenerator()).getInsertGeneratedIdentifierDelegate(this, this.getFactory().getDialect(), this.useGetGeneratedKeys());
            this.sqlIdentityInsertString = this.customSQLInsert[0] == null ? this.generateIdentityInsertString(this.getPropertyInsertability()) : this.customSQLInsert[0];
        } else {
            this.sqlIdentityInsertString = null;
        }
        this.logStaticSQL();
    }

    public void postInstantiate() throws MappingException {
        this.createLoaders();
        this.createUniqueKeyLoaders();
        this.createQueryLoader();
    }

    private void createLoaders() {
        this.loaders.put(LockMode.NONE, this.createEntityLoader(LockMode.NONE));
        UniqueEntityLoader uniqueEntityLoader = this.createEntityLoader(LockMode.READ);
        this.loaders.put(LockMode.READ, uniqueEntityLoader);
        boolean bl = this.getSubclassTableSpan() > 1 && this.hasSubclasses() && !this.getFactory().getDialect().supportsOuterJoinForUpdate();
        this.loaders.put(LockMode.UPGRADE, bl ? uniqueEntityLoader : this.createEntityLoader(LockMode.UPGRADE));
        this.loaders.put(LockMode.UPGRADE_NOWAIT, bl ? uniqueEntityLoader : this.createEntityLoader(LockMode.UPGRADE_NOWAIT));
        this.loaders.put(LockMode.FORCE, bl ? uniqueEntityLoader : this.createEntityLoader(LockMode.FORCE));
        this.loaders.put(LockMode.PESSIMISTIC_READ, bl ? uniqueEntityLoader : this.createEntityLoader(LockMode.PESSIMISTIC_READ));
        this.loaders.put(LockMode.PESSIMISTIC_WRITE, bl ? uniqueEntityLoader : this.createEntityLoader(LockMode.PESSIMISTIC_WRITE));
        this.loaders.put(LockMode.PESSIMISTIC_FORCE_INCREMENT, bl ? uniqueEntityLoader : this.createEntityLoader(LockMode.PESSIMISTIC_FORCE_INCREMENT));
        this.loaders.put(LockMode.OPTIMISTIC, this.createEntityLoader(LockMode.OPTIMISTIC));
        this.loaders.put(LockMode.OPTIMISTIC_FORCE_INCREMENT, this.createEntityLoader(LockMode.OPTIMISTIC_FORCE_INCREMENT));
        this.loaders.put("merge", new CascadeEntityLoader(this, CascadingAction.MERGE, this.getFactory()));
        this.loaders.put("refresh", new CascadeEntityLoader(this, CascadingAction.REFRESH, this.getFactory()));
    }

    protected void createQueryLoader() {
        if (this.loaderName != null) {
            this.queryLoader = new NamedQueryLoader(this.loaderName, this);
        }
    }

    public Object load(Serializable serializable, Object object, LockMode lockMode, SessionImplementor sessionImplementor) {
        return this.load(serializable, object, new LockOptions().setLockMode(lockMode), sessionImplementor);
    }

    public Object load(Serializable serializable, Object object, LockOptions lockOptions, SessionImplementor sessionImplementor) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("Fetching entity: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
        }
        UniqueEntityLoader uniqueEntityLoader = this.getAppropriateLoader(lockOptions, sessionImplementor);
        return uniqueEntityLoader.load(serializable, object, sessionImplementor, lockOptions);
    }

    public void registerAffectingFetchProfile(String string) {
        this.affectingFetchProfileNames.add(string);
    }

    private boolean isAffectedByEnabledFetchProfiles(SessionImplementor sessionImplementor) {
        Iterator iterator = sessionImplementor.getLoadQueryInfluencers().getEnabledFetchProfileNames().iterator();
        while (iterator.hasNext()) {
            if (!this.affectingFetchProfileNames.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean isAffectedByEnabledFilters(SessionImplementor sessionImplementor) {
        return sessionImplementor.getLoadQueryInfluencers().hasEnabledFilters() && this.filterHelper.isAffectedBy(sessionImplementor.getLoadQueryInfluencers().getEnabledFilters());
    }

    private UniqueEntityLoader getAppropriateLoader(LockOptions lockOptions, SessionImplementor sessionImplementor) {
        if (this.queryLoader != null) {
            return this.queryLoader;
        }
        if (this.isAffectedByEnabledFilters(sessionImplementor)) {
            return this.createEntityLoader(lockOptions, sessionImplementor.getLoadQueryInfluencers());
        }
        if (sessionImplementor.getLoadQueryInfluencers().getInternalFetchProfile() != null && LockMode.UPGRADE.greaterThan(lockOptions.getLockMode())) {
            return (UniqueEntityLoader)this.loaders.get(sessionImplementor.getLoadQueryInfluencers().getInternalFetchProfile());
        }
        if (this.isAffectedByEnabledFetchProfiles(sessionImplementor)) {
            return this.createEntityLoader(lockOptions, sessionImplementor.getLoadQueryInfluencers());
        }
        if (lockOptions.getTimeOut() != -1) {
            return this.createEntityLoader(lockOptions, sessionImplementor.getLoadQueryInfluencers());
        }
        return (UniqueEntityLoader)this.loaders.get(lockOptions.getLockMode());
    }

    private boolean isAllNull(Object[] objectArray, int n) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isPropertyOfTable(i, n) || objectArray[i] == null) continue;
            return false;
        }
        return true;
    }

    public boolean isSubclassPropertyNullable(int n) {
        return this.subclassPropertyNullabilityClosure[n];
    }

    protected final boolean[] getPropertiesToUpdate(int[] nArray, boolean bl) {
        boolean[] blArray = new boolean[this.entityMetamodel.getPropertySpan()];
        boolean[] blArray2 = this.getPropertyUpdateability();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (!blArray2[n]) continue;
            blArray[n] = true;
        }
        if (this.isVersioned() && blArray2[this.getVersionProperty()]) {
            blArray[this.getVersionProperty()] = Versioning.isVersionIncrementRequired(nArray, bl, this.getPropertyVersionability());
        }
        return blArray;
    }

    protected boolean[] getPropertiesToInsert(Object[] objectArray) {
        boolean[] blArray = new boolean[objectArray.length];
        boolean[] blArray2 = this.getPropertyInsertability();
        for (int i = 0; i < objectArray.length; ++i) {
            blArray[i] = blArray2[i] && objectArray[i] != null;
        }
        return blArray;
    }

    public int[] findDirty(Object[] objectArray, Object[] objectArray2, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        int[] nArray = TypeHelper.findDirty(this.entityMetamodel.getProperties(), objectArray, objectArray2, this.propertyColumnUpdateable, this.hasUninitializedLazyProperties(object, sessionImplementor.getEntityMode()), sessionImplementor);
        if (nArray == null) {
            return null;
        }
        this.logDirtyProperties(nArray);
        return nArray;
    }

    public int[] findModified(Object[] objectArray, Object[] objectArray2, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        int[] nArray = TypeHelper.findModified(this.entityMetamodel.getProperties(), objectArray2, objectArray, this.propertyColumnUpdateable, this.hasUninitializedLazyProperties(object, sessionImplementor.getEntityMode()), sessionImplementor);
        if (nArray == null) {
            return null;
        }
        this.logDirtyProperties(nArray);
        return nArray;
    }

    protected boolean[] getPropertyUpdateability(Object object, EntityMode entityMode) {
        return this.hasUninitializedLazyProperties(object, entityMode) ? this.getNonLazyPropertyUpdateability() : this.getPropertyUpdateability();
    }

    private void logDirtyProperties(int[] nArray) {
        if (log.isTraceEnabled()) {
            for (int i = 0; i < nArray.length; ++i) {
                String string = this.entityMetamodel.getProperties()[nArray[i]].getName();
                log.trace(StringHelper.qualify(this.getEntityName(), string) + " is dirty");
            }
        }
    }

    protected EntityTuplizer getTuplizer(SessionImplementor sessionImplementor) {
        return this.getTuplizer(sessionImplementor.getEntityMode());
    }

    protected EntityTuplizer getTuplizer(EntityMode entityMode) {
        return this.entityMetamodel.getTuplizer(entityMode);
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public EntityMetamodel getEntityMetamodel() {
        return this.entityMetamodel;
    }

    public boolean hasCache() {
        return this.cacheAccessStrategy != null;
    }

    public EntityRegionAccessStrategy getCacheAccessStrategy() {
        return this.cacheAccessStrategy;
    }

    public CacheEntryStructure getCacheEntryStructure() {
        return this.cacheEntryStructure;
    }

    public Comparator getVersionComparator() {
        return this.isVersioned() ? this.getVersionType().getComparator() : null;
    }

    public final String getEntityName() {
        return this.entityMetamodel.getName();
    }

    public EntityType getEntityType() {
        return this.entityMetamodel.getEntityType();
    }

    public boolean isPolymorphic() {
        return this.entityMetamodel.isPolymorphic();
    }

    public boolean isInherited() {
        return this.entityMetamodel.isInherited();
    }

    public boolean hasCascades() {
        return this.entityMetamodel.hasCascades();
    }

    public boolean hasIdentifierProperty() {
        return !this.entityMetamodel.getIdentifierProperty().isVirtual();
    }

    public VersionType getVersionType() {
        return (VersionType)this.locateVersionType();
    }

    private Type locateVersionType() {
        return this.entityMetamodel.getVersionProperty() == null ? null : this.entityMetamodel.getVersionProperty().getType();
    }

    public int getVersionProperty() {
        return this.entityMetamodel.getVersionPropertyIndex();
    }

    public boolean isVersioned() {
        return this.entityMetamodel.isVersioned();
    }

    public boolean isIdentifierAssignedByInsert() {
        return this.entityMetamodel.getIdentifierProperty().isIdentifierAssignedByInsert();
    }

    public boolean hasLazyProperties() {
        return this.entityMetamodel.hasLazyProperties();
    }

    public void afterReassociate(Object object, SessionImplementor sessionImplementor) {
        if (FieldInterceptionHelper.isInstrumented(object)) {
            FieldInterceptor fieldInterceptor = FieldInterceptionHelper.extractFieldInterceptor(object);
            if (fieldInterceptor != null) {
                fieldInterceptor.setSession(sessionImplementor);
            } else {
                FieldInterceptor fieldInterceptor2 = FieldInterceptionHelper.injectFieldInterceptor(object, this.getEntityName(), null, sessionImplementor);
                fieldInterceptor2.dirty();
            }
        }
    }

    public Boolean isTransient(Object object, SessionImplementor sessionImplementor) throws HibernateException {
        Boolean bl;
        Serializable serializable = this.canExtractIdOutOfEntity() ? this.getIdentifier(object, sessionImplementor) : null;
        if (serializable == null) {
            return Boolean.TRUE;
        }
        Object object2 = this.getVersion(object, sessionImplementor.getEntityMode());
        if (this.isVersioned() && (bl = this.entityMetamodel.getVersionProperty().getUnsavedValue().isUnsaved(object2)) != null) {
            return bl;
        }
        bl = this.entityMetamodel.getIdentifierProperty().getUnsavedValue().isUnsaved(serializable);
        if (bl != null) {
            return bl;
        }
        if (this.hasCache()) {
            CacheKey cacheKey = new CacheKey(serializable, this.getIdentifierType(), this.getRootEntityName(), sessionImplementor.getEntityMode(), sessionImplementor.getFactory());
            if (this.getCacheAccessStrategy().get(cacheKey, sessionImplementor.getTimestamp()) != null) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean hasCollections() {
        return this.entityMetamodel.hasCollections();
    }

    public boolean hasMutableProperties() {
        return this.entityMetamodel.hasMutableProperties();
    }

    public boolean isMutable() {
        return this.entityMetamodel.isMutable();
    }

    private boolean isModifiableEntity(EntityEntry entityEntry) {
        return entityEntry == null ? this.isMutable() : entityEntry.isModifiableEntity();
    }

    public boolean isAbstract() {
        return this.entityMetamodel.isAbstract();
    }

    public boolean hasSubclasses() {
        return this.entityMetamodel.hasSubclasses();
    }

    public boolean hasProxy() {
        return this.entityMetamodel.isLazy();
    }

    public IdentifierGenerator getIdentifierGenerator() throws HibernateException {
        return this.entityMetamodel.getIdentifierProperty().getIdentifierGenerator();
    }

    public String getRootEntityName() {
        return this.entityMetamodel.getRootName();
    }

    public ClassMetadata getClassMetadata() {
        return this;
    }

    public String getMappedSuperclass() {
        return this.entityMetamodel.getSuperclass();
    }

    public boolean isExplicitPolymorphism() {
        return this.entityMetamodel.isExplicitPolymorphism();
    }

    protected boolean useDynamicUpdate() {
        return this.entityMetamodel.isDynamicUpdate();
    }

    protected boolean useDynamicInsert() {
        return this.entityMetamodel.isDynamicInsert();
    }

    protected boolean hasEmbeddedCompositeIdentifier() {
        return this.entityMetamodel.getIdentifierProperty().isEmbedded();
    }

    public boolean canExtractIdOutOfEntity() {
        return this.hasIdentifierProperty() || this.hasEmbeddedCompositeIdentifier() || this.hasIdentifierMapper();
    }

    private boolean hasIdentifierMapper() {
        return this.entityMetamodel.getIdentifierProperty().hasIdentifierMapper();
    }

    public String[] getKeyColumnNames() {
        return this.getIdentifierColumnNames();
    }

    public String getName() {
        return this.getEntityName();
    }

    public boolean isCollection() {
        return false;
    }

    public boolean consumesEntityAlias() {
        return true;
    }

    public boolean consumesCollectionAlias() {
        return false;
    }

    public Type getPropertyType(String string) throws MappingException {
        return this.propertyMapping.toType(string);
    }

    public Type getType() {
        return this.entityMetamodel.getEntityType();
    }

    public boolean isSelectBeforeUpdateRequired() {
        return this.entityMetamodel.isSelectBeforeUpdate();
    }

    protected final int optimisticLockMode() {
        return this.entityMetamodel.getOptimisticLockMode();
    }

    public Object createProxy(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        return this.entityMetamodel.getTuplizer(sessionImplementor.getEntityMode()).createProxy(serializable, sessionImplementor);
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.entityMetamodel.getName() + ')';
    }

    public final String selectFragment(Joinable joinable, String string, String string2, String string3, String string4, boolean bl) {
        return this.selectFragment(string2, string3);
    }

    public boolean isInstrumented(EntityMode entityMode) {
        EntityTuplizer entityTuplizer = this.entityMetamodel.getTuplizerOrNull(entityMode);
        return entityTuplizer != null && entityTuplizer.isInstrumented();
    }

    public boolean hasInsertGeneratedProperties() {
        return this.entityMetamodel.hasInsertGeneratedValues();
    }

    public boolean hasUpdateGeneratedProperties() {
        return this.entityMetamodel.hasUpdateGeneratedValues();
    }

    public boolean isVersionPropertyGenerated() {
        return this.isVersioned() && this.getPropertyUpdateGenerationInclusions()[this.getVersionProperty()] != ValueInclusion.NONE;
    }

    public boolean isVersionPropertyInsertable() {
        return this.isVersioned() && this.getPropertyInsertability()[this.getVersionProperty()];
    }

    public void afterInitialize(Object object, boolean bl, SessionImplementor sessionImplementor) {
        this.getTuplizer(sessionImplementor).afterInitialize(object, bl, sessionImplementor);
    }

    public String[] getPropertyNames() {
        return this.entityMetamodel.getPropertyNames();
    }

    public Type[] getPropertyTypes() {
        return this.entityMetamodel.getPropertyTypes();
    }

    public boolean[] getPropertyLaziness() {
        return this.entityMetamodel.getPropertyLaziness();
    }

    public boolean[] getPropertyUpdateability() {
        return this.entityMetamodel.getPropertyUpdateability();
    }

    public boolean[] getPropertyCheckability() {
        return this.entityMetamodel.getPropertyCheckability();
    }

    public boolean[] getNonLazyPropertyUpdateability() {
        return this.entityMetamodel.getNonlazyPropertyUpdateability();
    }

    public boolean[] getPropertyInsertability() {
        return this.entityMetamodel.getPropertyInsertability();
    }

    public ValueInclusion[] getPropertyInsertGenerationInclusions() {
        return this.entityMetamodel.getPropertyInsertGenerationInclusions();
    }

    public ValueInclusion[] getPropertyUpdateGenerationInclusions() {
        return this.entityMetamodel.getPropertyUpdateGenerationInclusions();
    }

    public boolean[] getPropertyNullability() {
        return this.entityMetamodel.getPropertyNullability();
    }

    public boolean[] getPropertyVersionability() {
        return this.entityMetamodel.getPropertyVersionability();
    }

    public CascadeStyle[] getPropertyCascadeStyles() {
        return this.entityMetamodel.getCascadeStyles();
    }

    public final Class getMappedClass(EntityMode entityMode) {
        EntityTuplizer entityTuplizer = this.entityMetamodel.getTuplizerOrNull(entityMode);
        return entityTuplizer == null ? null : entityTuplizer.getMappedClass();
    }

    public boolean implementsLifecycle(EntityMode entityMode) {
        return this.getTuplizer(entityMode).isLifecycleImplementor();
    }

    public boolean implementsValidatable(EntityMode entityMode) {
        return this.getTuplizer(entityMode).isValidatableImplementor();
    }

    public Class getConcreteProxyClass(EntityMode entityMode) {
        return this.getTuplizer(entityMode).getConcreteProxyClass();
    }

    public void setPropertyValues(Object object, Object[] objectArray, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setPropertyValues(object, objectArray);
    }

    public void setPropertyValue(Object object, int n, Object object2, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setPropertyValue(object, n, object2);
    }

    public Object[] getPropertyValues(Object object, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getPropertyValues(object);
    }

    public Object getPropertyValue(Object object, int n, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getPropertyValue(object, n);
    }

    public Object getPropertyValue(Object object, String string, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getPropertyValue(object, string);
    }

    public Serializable getIdentifier(Object object, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getIdentifier(object, null);
    }

    public Serializable getIdentifier(Object object, SessionImplementor sessionImplementor) {
        return this.getTuplizer(sessionImplementor.getEntityMode()).getIdentifier(object, sessionImplementor);
    }

    public void setIdentifier(Object object, Serializable serializable, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setIdentifier(object, serializable, null);
    }

    public void setIdentifier(Object object, Serializable serializable, SessionImplementor sessionImplementor) {
        this.getTuplizer(sessionImplementor).setIdentifier(object, serializable, sessionImplementor);
    }

    public Object getVersion(Object object, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).getVersion(object);
    }

    public Object instantiate(Serializable serializable, EntityMode entityMode) throws HibernateException {
        return this.getTuplizer(entityMode).instantiate(serializable, null);
    }

    public Object instantiate(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getTuplizer(sessionImplementor).instantiate(serializable, sessionImplementor);
    }

    public boolean isInstance(Object object, EntityMode entityMode) {
        return this.getTuplizer(entityMode).isInstance(object);
    }

    public boolean hasUninitializedLazyProperties(Object object, EntityMode entityMode) {
        return this.getTuplizer(entityMode).hasUninitializedLazyProperties(object);
    }

    public void resetIdentifier(Object object, Serializable serializable, Object object2, EntityMode entityMode) {
        this.getTuplizer(entityMode).resetIdentifier(object, serializable, object2, null);
    }

    public void resetIdentifier(Object object, Serializable serializable, Object object2, SessionImplementor sessionImplementor) {
        this.getTuplizer(sessionImplementor).resetIdentifier(object, serializable, object2, sessionImplementor);
    }

    public EntityPersister getSubclassEntityPersister(Object object, SessionFactoryImplementor sessionFactoryImplementor, EntityMode entityMode) {
        if (!this.hasSubclasses()) {
            return this;
        }
        String string = this.getTuplizer(entityMode).determineConcreteSubclassEntityName(object, sessionFactoryImplementor);
        if (string == null || this.getEntityName().equals(string)) {
            return this;
        }
        return sessionFactoryImplementor.getEntityPersister(string);
    }

    public EntityMode guessEntityMode(Object object) {
        return this.entityMetamodel.guessEntityMode(object);
    }

    public boolean isMultiTable() {
        return false;
    }

    public String getTemporaryIdTableName() {
        return this.temporaryIdTableName;
    }

    public String getTemporaryIdTableDDL() {
        return this.temporaryIdTableDDL;
    }

    protected int getPropertySpan() {
        return this.entityMetamodel.getPropertySpan();
    }

    public Object[] getPropertyValuesToInsert(Object object, Map map, SessionImplementor sessionImplementor) throws HibernateException {
        return this.getTuplizer(sessionImplementor.getEntityMode()).getPropertyValuesToInsert(object, map, sessionImplementor);
    }

    public void processInsertGeneratedProperties(Serializable serializable, Object object, Object[] objectArray, SessionImplementor sessionImplementor) {
        if (!this.hasInsertGeneratedProperties()) {
            throw new AssertionFailure("no insert-generated properties");
        }
        this.processGeneratedProperties(serializable, object, objectArray, sessionImplementor, this.sqlInsertGeneratedValuesSelectString, this.getPropertyInsertGenerationInclusions());
    }

    public void processUpdateGeneratedProperties(Serializable serializable, Object object, Object[] objectArray, SessionImplementor sessionImplementor) {
        if (!this.hasUpdateGeneratedProperties()) {
            throw new AssertionFailure("no update-generated properties");
        }
        this.processGeneratedProperties(serializable, object, objectArray, sessionImplementor, this.sqlUpdateGeneratedValuesSelectString, this.getPropertyUpdateGenerationInclusions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGeneratedProperties(Serializable serializable, Object object, Object[] objectArray, SessionImplementor sessionImplementor, String string, ValueInclusion[] valueInclusionArray) {
        sessionImplementor.getBatcher().executeBatch();
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(string);
            try {
                this.getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        throw new HibernateException("Unable to locate row for retrieval of generated properties: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
                    }
                    for (int i = 0; i < this.getPropertySpan(); ++i) {
                        if (valueInclusionArray[i] == ValueInclusion.NONE) continue;
                        Object object2 = this.getPropertyTypes()[i].hydrate(resultSet, this.getPropertyAliases("", i), sessionImplementor, object);
                        objectArray[i] = this.getPropertyTypes()[i].resolve(object2, sessionImplementor, object);
                        this.setPropertyValue(object, i, objectArray[i], sessionImplementor.getEntityMode());
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "unable to select generated column values", string);
        }
    }

    public String getIdentifierPropertyName() {
        return this.entityMetamodel.getIdentifierProperty().getName();
    }

    public Type getIdentifierType() {
        return this.entityMetamodel.getIdentifierProperty().getType();
    }

    public boolean hasSubselectLoadableCollections() {
        return this.hasSubselectLoadableCollections;
    }

    public int[] getNaturalIdentifierProperties() {
        return this.entityMetamodel.getNaturalIdentifierProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Object[] getNaturalIdentifierSnapshot(Serializable serializable, SessionImplementor sessionImplementor) throws HibernateException {
        if (!this.hasNaturalIdentifier()) {
            throw new MappingException("persistent class did not define a natural-id : " + MessageHelper.infoString(this));
        }
        if (log.isTraceEnabled()) {
            log.trace("Getting current natural-id snapshot state for: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()));
        }
        int[] nArray = this.getNaturalIdentifierProperties();
        int n = nArray.length;
        boolean[] blArray = new boolean[this.getPropertySpan()];
        Type[] typeArray = new Type[n];
        for (int i = 0; i < n; ++i) {
            typeArray[i] = this.getPropertyTypes()[nArray[i]];
            blArray[nArray[i]] = true;
        }
        Select select = new Select(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            select.setComment("get current natural-id state " + this.getEntityName());
        }
        select.setSelectClause(this.concretePropertySelectFragmentSansLeadingComma(this.getRootAlias(), blArray));
        select.setFromClause(this.fromTableFragment(this.getRootAlias()) + this.fromJoinFragment(this.getRootAlias(), true, false));
        String[] stringArray = StringHelper.qualify(this.getRootAlias(), this.getIdentifierColumnNames());
        String string = new StringBuffer().append(StringHelper.join("=? and ", stringArray)).append("=?").append(this.whereJoinFragment(this.getRootAlias(), true, false)).toString();
        String string2 = select.setOuterJoins("", "").setWhereClause(string).toStatementString();
        Object[] objectArray = new Object[n];
        try {
            PreparedStatement preparedStatement = sessionImplementor.getBatcher().prepareSelectStatement(string2);
            try {
                Object[] objectArray2;
                ResultSet resultSet;
                block15: {
                    this.getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) break block15;
                    Object[] objectArray3 = null;
                    resultSet.close();
                    return objectArray3;
                }
                try {
                    EntityKey entityKey = new EntityKey(serializable, this, sessionImplementor.getEntityMode());
                    Object object = sessionImplementor.getPersistenceContext().getEntity(entityKey);
                    for (int i = 0; i < n; ++i) {
                        objectArray[i] = typeArray[i].hydrate(resultSet, this.getPropertyAliases("", nArray[i]), sessionImplementor, null);
                        if (!typeArray[i].isEntityType()) continue;
                        objectArray[i] = typeArray[i].resolve(objectArray[i], sessionImplementor, object);
                    }
                    objectArray2 = objectArray;
                }
                catch (Throwable throwable) {
                    resultSet.close();
                    throw throwable;
                }
                resultSet.close();
                return objectArray2;
            }
            finally {
                sessionImplementor.getBatcher().closeStatement(preparedStatement);
            }
        }
        catch (SQLException sQLException) {
            throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), sQLException, "could not retrieve snapshot: " + MessageHelper.infoString((EntityPersister)this, serializable, this.getFactory()), string2);
        }
    }

    protected String concretePropertySelectFragmentSansLeadingComma(String string, boolean[] blArray) {
        String string2 = this.concretePropertySelectFragment(string, blArray);
        int n = string2.indexOf(", ");
        if (n == 0) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public boolean hasNaturalIdentifier() {
        return this.entityMetamodel.hasNaturalIdentifier();
    }

    public void setPropertyValue(Object object, String string, Object object2, EntityMode entityMode) throws HibernateException {
        this.getTuplizer(entityMode).setPropertyValue(object, string, object2);
    }

    protected static interface InclusionChecker {
        public boolean includeProperty(int var1);
    }
}

