/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.Mapping;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPropertyMapping
implements PropertyMapping {
    private static final Logger log = LoggerFactory.getLogger(AbstractPropertyMapping.class);
    private final Map typesByPropertyPath = new HashMap();
    private final Map columnsByPropertyPath = new HashMap();
    private final Map columnReadersByPropertyPath = new HashMap();
    private final Map columnReaderTemplatesByPropertyPath = new HashMap();
    private final Map formulaTemplatesByPropertyPath = new HashMap();

    public String[] getIdentifierColumnNames() {
        throw new UnsupportedOperationException("one-to-one is not supported here");
    }

    public String[] getIdentifierColumnReaderTemplates() {
        throw new UnsupportedOperationException("one-to-one is not supported here");
    }

    public String[] getIdentifierColumnReaders() {
        throw new UnsupportedOperationException("one-to-one is not supported here");
    }

    protected abstract String getEntityName();

    public Type toType(String string) throws QueryException {
        Type type = (Type)this.typesByPropertyPath.get(string);
        if (type == null) {
            throw this.propertyException(string);
        }
        return type;
    }

    protected final QueryException propertyException(String string) throws QueryException {
        return new QueryException("could not resolve property: " + string + " of: " + this.getEntityName());
    }

    public String[] getColumnNames(String string) {
        String[] stringArray = (String[])this.columnsByPropertyPath.get(string);
        if (stringArray == null) {
            throw new MappingException("unknown property: " + string);
        }
        return stringArray;
    }

    public String[] toColumns(String string, String string2) throws QueryException {
        String[] stringArray = (String[])this.columnsByPropertyPath.get(string2);
        if (stringArray == null) {
            throw this.propertyException(string2);
        }
        String[] stringArray2 = (String[])this.formulaTemplatesByPropertyPath.get(string2);
        String[] stringArray3 = (String[])this.columnReaderTemplatesByPropertyPath.get(string2);
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray4[i] = stringArray3[i] == null ? StringHelper.replace(stringArray2[i], "$PlaceHolder$", string) : StringHelper.replace(stringArray3[i], "$PlaceHolder$", string);
        }
        return stringArray4;
    }

    public String[] toColumns(String string) throws QueryException {
        String[] stringArray = (String[])this.columnsByPropertyPath.get(string);
        if (stringArray == null) {
            throw this.propertyException(string);
        }
        String[] stringArray2 = (String[])this.formulaTemplatesByPropertyPath.get(string);
        String[] stringArray3 = (String[])this.columnReadersByPropertyPath.get(string);
        String[] stringArray4 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray4[i] = stringArray3[i] == null ? StringHelper.replace(stringArray2[i], "$PlaceHolder$", "") : stringArray3[i];
        }
        return stringArray4;
    }

    protected void addPropertyPath(String string, Type type, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        if (this.typesByPropertyPath.containsKey(string)) {
            if (log.isTraceEnabled()) {
                log.trace("Skipping duplicate registration of path [" + string + "], existing type = [" + this.typesByPropertyPath.get(string) + "], incoming type = [" + type + "]");
            }
            return;
        }
        this.typesByPropertyPath.put(string, type);
        this.columnsByPropertyPath.put(string, stringArray);
        this.columnReadersByPropertyPath.put(string, stringArray2);
        this.columnReaderTemplatesByPropertyPath.put(string, stringArray3);
        if (stringArray4 != null) {
            this.formulaTemplatesByPropertyPath.put(string, stringArray4);
        }
    }

    protected void initPropertyPaths(String string, Type type, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Mapping mapping) throws MappingException {
        Type type2;
        if (stringArray.length != type.getColumnSpan(mapping)) {
            throw new MappingException("broken column mapping for: " + string + " of: " + this.getEntityName());
        }
        if (type.isAssociationType()) {
            type2 = (AssociationType)type;
            if (type2.useLHSPrimaryKey()) {
                stringArray = this.getIdentifierColumnNames();
                stringArray2 = this.getIdentifierColumnReaders();
                stringArray3 = this.getIdentifierColumnReaderTemplates();
            } else {
                String string2 = type2.getLHSPropertyName();
                if (string2 != null && !string.equals(string2)) {
                    stringArray = (String[])this.columnsByPropertyPath.get(string2);
                    if (stringArray == null) {
                        return;
                    }
                    stringArray2 = (String[])this.columnReadersByPropertyPath.get(string2);
                    stringArray3 = (String[])this.columnReaderTemplatesByPropertyPath.get(string2);
                }
            }
        }
        if (string != null) {
            this.addPropertyPath(string, type, stringArray, stringArray2, stringArray3, stringArray4);
        }
        if (type.isComponentType()) {
            type2 = (CompositeType)type;
            this.initComponentPropertyPaths(string, (CompositeType)type2, stringArray, stringArray2, stringArray3, stringArray4, mapping);
            if (type2.isEmbedded()) {
                this.initComponentPropertyPaths(string == null ? null : StringHelper.qualifier(string), (CompositeType)type2, stringArray, stringArray2, stringArray3, stringArray4, mapping);
            }
        } else if (type.isEntityType()) {
            this.initIdentifierPropertyPaths(string, (EntityType)type, stringArray, stringArray2, stringArray3, mapping);
        }
    }

    protected void initIdentifierPropertyPaths(String string, EntityType entityType, String[] stringArray, String[] stringArray2, String[] stringArray3, Mapping mapping) throws MappingException {
        String string2;
        Type type = entityType.getIdentifierOrUniqueKeyType(mapping);
        String string3 = entityType.getIdentifierOrUniqueKeyPropertyName(mapping);
        boolean bl = this.hasNonIdentifierPropertyNamedId(entityType, mapping);
        if (entityType.isReferenceToPrimaryKey() && !bl) {
            string2 = AbstractPropertyMapping.extendPath(string, "id");
            this.addPropertyPath(string2, type, stringArray, stringArray2, stringArray3, null);
            this.initPropertyPaths(string2, type, stringArray, stringArray2, stringArray3, null, mapping);
        }
        if (string3 != null) {
            string2 = AbstractPropertyMapping.extendPath(string, string3);
            this.addPropertyPath(string2, type, stringArray, stringArray2, stringArray3, null);
            this.initPropertyPaths(string2, type, stringArray, stringArray2, stringArray3, null, mapping);
        }
    }

    private boolean hasNonIdentifierPropertyNamedId(EntityType entityType, Mapping mapping) {
        try {
            return mapping.getReferencedPropertyType(entityType.getAssociatedEntityName(), "id") != null;
        }
        catch (MappingException mappingException) {
            return false;
        }
    }

    protected void initComponentPropertyPaths(String string, CompositeType compositeType, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, Mapping mapping) throws MappingException {
        Type[] typeArray = compositeType.getSubtypes();
        String[] stringArray5 = compositeType.getPropertyNames();
        int n = 0;
        for (int i = 0; i < stringArray5.length; ++i) {
            String string2 = AbstractPropertyMapping.extendPath(string, stringArray5[i]);
            try {
                int n2 = typeArray[i].getColumnSpan(mapping);
                String[] stringArray6 = ArrayHelper.slice(stringArray, n, n2);
                String[] stringArray7 = ArrayHelper.slice(stringArray2, n, n2);
                String[] stringArray8 = ArrayHelper.slice(stringArray3, n, n2);
                String[] stringArray9 = stringArray4 == null ? null : ArrayHelper.slice(stringArray4, n, n2);
                this.initPropertyPaths(string2, typeArray[i], stringArray6, stringArray7, stringArray8, stringArray9, mapping);
                n += n2;
                continue;
            }
            catch (Exception exception) {
                throw new MappingException("bug in initComponentPropertyPaths", exception);
            }
        }
    }

    private static String extendPath(String string, String string2) {
        if (string == null || "".equals(string)) {
            return string2;
        }
        return StringHelper.qualify(string, string2);
    }
}

