/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.AbstractType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.EqualsHelper;

public class DiscriminatorType
extends AbstractType {
    private final Type underlyingType;
    private final Loadable persister;

    public DiscriminatorType(Type type, Loadable loadable) {
        this.underlyingType = type;
        this.persister = loadable;
    }

    public Class getReturnedClass() {
        return Class.class;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet resultSet, String[] stringArray, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        return this.nullSafeGet(resultSet, stringArray[0], sessionImplementor, object);
    }

    public Object nullSafeGet(ResultSet resultSet, String string, SessionImplementor sessionImplementor, Object object) throws HibernateException, SQLException {
        Object object2 = this.underlyingType.nullSafeGet(resultSet, string, sessionImplementor, object);
        String string2 = this.persister.getSubclassForDiscriminatorValue(object2);
        if (string2 == null) {
            throw new HibernateException("Unable to resolve discriminator value [" + object2 + "] to entity name");
        }
        if (EntityMode.POJO.equals(sessionImplementor.getEntityMode())) {
            return sessionImplementor.getEntityPersister(string2, null).getMappedClass(sessionImplementor.getEntityMode());
        }
        return string2;
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        this.nullSafeSet(preparedStatement, object, n, sessionImplementor);
    }

    public void nullSafeSet(PreparedStatement preparedStatement, Object object, int n, SessionImplementor sessionImplementor) throws HibernateException, SQLException {
        throw new UnsupportedOperationException("At the moment this type is not the one actually used to map the discriminator.");
    }

    public String toLoggableString(Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return object == null ? "[null]" : object.toString();
    }

    public Object deepCopy(Object object, EntityMode entityMode, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
        return object;
    }

    public Object replace(Object object, Object object2, SessionImplementor sessionImplementor, Object object3, Map map) throws HibernateException {
        return object;
    }

    public boolean[] toColumnNullness(Object object, Mapping mapping) {
        return object == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    public boolean isDirty(Object object, Object object2, boolean[] blArray, SessionImplementor sessionImplementor) throws HibernateException {
        return EqualsHelper.equals(object, object2);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return this.underlyingType.sqlTypes(mapping);
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.underlyingType.getColumnSpan(mapping);
    }

    public void setToXMLNode(Node node, Object object, SessionFactoryImplementor sessionFactoryImplementor) throws HibernateException {
    }

    public Object fromXMLNode(Node node, Mapping mapping) throws HibernateException {
        return null;
    }
}

