/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.engine.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.SelectFragment;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class JoinedSubclassEntityPersister
extends AbstractEntityPersister {
    private final int tableSpan;
    private final String[] tableNames;
    private final String[] naturalOrderTableNames;
    private final String[][] tableKeyColumns;
    private final String[][] tableKeyColumnReaders;
    private final String[][] tableKeyColumnReaderTemplates;
    private final String[][] naturalOrderTableKeyColumns;
    private final String[][] naturalOrderTableKeyColumnReaders;
    private final String[][] naturalOrderTableKeyColumnReaderTemplates;
    private final boolean[] naturalOrderCascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] naturalOrderPropertyTableNumbers;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final boolean[] subclassTableSequentialSelect;
    private final boolean[] subclassTableIsLazyClosure;
    private final Map subclassesByDiscriminatorValue = new HashMap();
    private final String[] discriminatorValues;
    private final String[] notNullColumnNames;
    private final int[] notNullColumnTableNumbers;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final String discriminatorSQLString;

    public JoinedSubclassEntityPersister(PersistentClass persistentClass, EntityRegionAccessStrategy entityRegionAccessStrategy, SessionFactoryImplementor sessionFactoryImplementor, Mapping mapping) throws HibernateException {
        super(persistentClass, entityRegionAccessStrategy, sessionFactoryImplementor);
        Integer n;
        Object object;
        Object object2;
        Serializable serializable;
        Serializable serializable2;
        int n2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        ArrayList<Object> arrayList;
        Object object8;
        Integer n3;
        if (persistentClass.isPolymorphic()) {
            try {
                n3 = new Integer(persistentClass.getSubclassId());
                this.discriminatorSQLString = ((Object)n3).toString();
            }
            catch (Exception exception) {
                throw new MappingException("Could not format discriminator value to SQL string", exception);
            }
        } else {
            n3 = null;
            this.discriminatorSQLString = null;
        }
        if (this.optimisticLockMode() > 0) {
            throw new MappingException("optimistic-lock=all|dirty not supported for joined-subclass mappings [" + this.getEntityName() + "]");
        }
        int n4 = this.getIdentifierColumnSpan();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        ArrayList<Boolean> arrayList6 = new ArrayList<Boolean>();
        Iterator iterator = persistentClass.getTableClosureIterator();
        Iterator iterator2 = persistentClass.getKeyClosureIterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            object8 = (KeyValue)iterator2.next();
            arrayList = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList2.add(arrayList);
            object7 = new String[n4];
            object6 = new String[n4];
            object5 = new String[n4];
            Iterator iterator3 = object8.getColumnIterator();
            for (int i = 0; i < n4; ++i) {
                object4 = (Column)iterator3.next();
                object7[i] = ((Column)object4).getQuotedName(sessionFactoryImplementor.getDialect());
                object6[i] = ((Column)object4).getReadExpr(sessionFactoryImplementor.getDialect());
                object5[i] = ((Column)object4).getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
            }
            arrayList3.add(object7);
            arrayList4.add(object6);
            arrayList5.add(object5);
            arrayList6.add(new Boolean(object8.isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete()));
        }
        int n5 = arrayList2.size();
        object8 = persistentClass.getJoinClosureIterator();
        while (object8.hasNext()) {
            arrayList = (Join)object8.next();
            object7 = ((Join)((Object)arrayList)).getTable();
            object6 = ((Table)object7).getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList2.add(object6);
            object5 = ((Join)((Object)arrayList)).getKey();
            int n6 = object5.getColumnSpan();
            String[] stringArray = new String[n6];
            object4 = new String[n6];
            object3 = new String[n6];
            Iterator iterator4 = object5.getColumnIterator();
            for (n2 = 0; n2 < n6; ++n2) {
                serializable2 = (Column)iterator4.next();
                stringArray[n2] = ((Column)serializable2).getQuotedName(sessionFactoryImplementor.getDialect());
                object4[n2] = ((Column)serializable2).getReadExpr(sessionFactoryImplementor.getDialect());
                object3[n2] = ((Column)serializable2).getTemplate(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSqlFunctionRegistry());
            }
            arrayList3.add(stringArray);
            arrayList4.add(object4);
            arrayList5.add(object3);
            arrayList6.add(new Boolean(object5.isCascadeDeleteEnabled() && sessionFactoryImplementor.getDialect().supportsCascadeDelete()));
        }
        this.naturalOrderTableNames = ArrayHelper.toStringArray(arrayList2);
        this.naturalOrderTableKeyColumns = ArrayHelper.to2DStringArray(arrayList3);
        this.naturalOrderTableKeyColumnReaders = ArrayHelper.to2DStringArray(arrayList4);
        this.naturalOrderTableKeyColumnReaderTemplates = ArrayHelper.to2DStringArray(arrayList5);
        this.naturalOrderCascadeDeleteEnabled = ArrayHelper.toBooleanArray(arrayList6);
        arrayList = new ArrayList<Object>();
        object7 = new ArrayList();
        object6 = new ArrayList();
        object5 = new ArrayList();
        arrayList3 = new ArrayList();
        iterator = persistentClass.getSubclassTableClosureIterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            ((ArrayList)object7).add(new Boolean(persistentClass.isClassOrSuperclassTable(table)));
            ((ArrayList)object6).add(Boolean.FALSE);
            ((ArrayList)object5).add(Boolean.FALSE);
            String string = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList.add(string);
            object4 = new String[n4];
            object3 = table.getPrimaryKey().getColumnIterator();
            for (int i = 0; i < n4; ++i) {
                object4[i] = ((Column)object3.next()).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            arrayList3.add(object4);
        }
        object8 = persistentClass.getSubclassJoinClosureIterator();
        while (object8.hasNext()) {
            Join join = (Join)object8.next();
            Table table = join.getTable();
            ((ArrayList)object7).add(new Boolean(persistentClass.isClassOrSuperclassTable(table)));
            ((ArrayList)object6).add(new Boolean(join.isSequentialSelect()));
            ((ArrayList)object5).add(new Boolean(join.isLazy()));
            object4 = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            arrayList.add(object4);
            object3 = new String[n4];
            Iterator iterator5 = table.getPrimaryKey().getColumnIterator();
            for (n2 = 0; n2 < n4; ++n2) {
                object3[n2] = ((Column)iterator5.next()).getQuotedName(sessionFactoryImplementor.getDialect());
            }
            arrayList3.add(object3);
        }
        String[] stringArray = ArrayHelper.toStringArray(arrayList);
        String[][] stringArray2 = ArrayHelper.to2DStringArray(arrayList3);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray((Collection)object7);
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray((Collection)object6);
        this.subclassTableIsLazyClosure = ArrayHelper.toBooleanArray((Collection)object5);
        this.constraintOrderedTableNames = new String[stringArray.length];
        this.constraintOrderedKeyColumnNames = new String[stringArray.length][];
        int n7 = 0;
        int n8 = stringArray.length - 1;
        while (n8 >= 0) {
            this.constraintOrderedTableNames[n7] = stringArray[n8];
            this.constraintOrderedKeyColumnNames[n7] = stringArray2[n8];
            --n8;
            ++n7;
        }
        this.tableSpan = this.naturalOrderTableNames.length;
        this.tableNames = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableNames, n5);
        this.tableKeyColumns = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumns, n5);
        this.tableKeyColumnReaders = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumnReaders, n5);
        this.tableKeyColumnReaderTemplates = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumnReaderTemplates, n5);
        this.subclassTableNameClosure = JoinedSubclassEntityPersister.reverse(stringArray, n5);
        this.subclassTableKeyColumnClosure = JoinedSubclassEntityPersister.reverse(stringArray2, n5);
        this.spaces = ArrayHelper.join(this.tableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        this.customSQLInsert = new String[this.tableSpan];
        this.customSQLUpdate = new String[this.tableSpan];
        this.customSQLDelete = new String[this.tableSpan];
        this.insertCallable = new boolean[this.tableSpan];
        this.updateCallable = new boolean[this.tableSpan];
        this.deleteCallable = new boolean[this.tableSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        int n9 = n5 - 1;
        for (PersistentClass persistentClass2 = persistentClass; persistentClass2 != null; persistentClass2 = persistentClass2.getSuperclass()) {
            this.customSQLInsert[n9] = persistentClass2.getCustomSQLInsert();
            this.insertCallable[n9] = this.customSQLInsert[n9] != null && persistentClass2.isCustomInsertCallable();
            this.insertResultCheckStyles[n9] = persistentClass2.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[n9], this.insertCallable[n9]) : persistentClass2.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[n9] = persistentClass2.getCustomSQLUpdate();
            this.updateCallable[n9] = this.customSQLUpdate[n9] != null && persistentClass2.isCustomUpdateCallable();
            this.updateResultCheckStyles[n9] = persistentClass2.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[n9], this.updateCallable[n9]) : persistentClass2.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[n9] = persistentClass2.getCustomSQLDelete();
            this.deleteCallable[n9] = this.customSQLDelete[n9] != null && persistentClass2.isCustomDeleteCallable();
            this.deleteResultCheckStyles[n9] = persistentClass2.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[n9], this.deleteCallable[n9]) : persistentClass2.getCustomSQLDeleteCheckStyle();
            --n9;
        }
        if (n9 != -1) {
            throw new AssertionFailure("Tablespan does not match height of joined-subclass hiearchy.");
        }
        object8 = persistentClass.getJoinClosureIterator();
        n2 = n5;
        while (object8.hasNext()) {
            serializable2 = (Join)object8.next();
            this.customSQLInsert[n2] = ((Join)serializable2).getCustomSQLInsert();
            this.insertCallable[n2] = this.customSQLInsert[n2] != null && ((Join)serializable2).isCustomInsertCallable();
            this.insertResultCheckStyles[n2] = ((Join)serializable2).getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[n2], this.insertCallable[n2]) : ((Join)serializable2).getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[n2] = ((Join)serializable2).getCustomSQLUpdate();
            this.updateCallable[n2] = this.customSQLUpdate[n2] != null && ((Join)serializable2).isCustomUpdateCallable();
            this.updateResultCheckStyles[n2] = ((Join)serializable2).getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[n2], this.updateCallable[n2]) : ((Join)serializable2).getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[n2] = ((Join)serializable2).getCustomSQLDelete();
            this.deleteCallable[n2] = this.customSQLDelete[n2] != null && ((Join)serializable2).isCustomDeleteCallable();
            this.deleteResultCheckStyles[n2] = ((Join)serializable2).getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[n2], this.deleteCallable[n2]) : ((Join)serializable2).getCustomSQLDeleteCheckStyle();
            ++n2;
        }
        int n10 = this.getPropertySpan();
        this.naturalOrderPropertyTableNumbers = new int[n10];
        this.propertyTableNumbers = new int[n10];
        Iterator iterator6 = persistentClass.getPropertyClosureIterator();
        int n11 = 0;
        while (iterator6.hasNext()) {
            serializable = (Property)iterator6.next();
            object2 = ((Property)serializable).getValue().getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            this.propertyTableNumbers[n11] = JoinedSubclassEntityPersister.getTableId((String)object2, this.tableNames);
            this.naturalOrderPropertyTableNumbers[n11] = JoinedSubclassEntityPersister.getTableId((String)object2, this.naturalOrderTableNames);
            ++n11;
        }
        serializable = new ArrayList();
        object2 = new ArrayList();
        ArrayList<Integer> arrayList7 = new ArrayList<Integer>();
        iterator6 = persistentClass.getSubclassPropertyClosureIterator();
        while (iterator6.hasNext()) {
            Property property = (Property)iterator6.next();
            Table table = property.getValue().getTable();
            object = table.getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName());
            n = new Integer(JoinedSubclassEntityPersister.getTableId((String)object, this.subclassTableNameClosure));
            arrayList7.add(n);
            Iterator iterator7 = property.getColumnIterator();
            while (iterator7.hasNext()) {
                Selectable selectable = (Selectable)iterator7.next();
                if (selectable.isFormula()) {
                    ((ArrayList)object2).add(n);
                    continue;
                }
                ((ArrayList)serializable).add(n);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray((Collection)((Object)serializable));
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(arrayList7);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray((Collection)object2);
        int n12 = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[n12];
        this.subclassClosure[n12 - 1] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            int n13;
            this.subclassesByDiscriminatorValue.put(n3, this.getEntityName());
            this.discriminatorValues = new String[n12];
            this.discriminatorValues[n12 - 1] = this.discriminatorSQLString;
            this.notNullColumnTableNumbers = new int[n12];
            this.notNullColumnTableNumbers[n12 - 1] = n13 = JoinedSubclassEntityPersister.getTableId(persistentClass.getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
            this.notNullColumnNames = new String[n12];
            this.notNullColumnNames[n12 - 1] = this.subclassTableKeyColumnClosure[n13][0];
        } else {
            this.discriminatorValues = null;
            this.notNullColumnTableNumbers = null;
            this.notNullColumnNames = null;
        }
        iterator6 = persistentClass.getSubclassIterator();
        int n14 = 0;
        while (iterator6.hasNext()) {
            object = (Subclass)iterator6.next();
            this.subclassClosure[n14] = ((PersistentClass)object).getEntityName();
            try {
                if (persistentClass.isPolymorphic()) {
                    int n15;
                    n = new Integer(((Subclass)object).getSubclassId());
                    this.subclassesByDiscriminatorValue.put(n, ((PersistentClass)object).getEntityName());
                    this.discriminatorValues[n14] = n.toString();
                    this.notNullColumnTableNumbers[n14] = n15 = JoinedSubclassEntityPersister.getTableId(((Subclass)object).getTable().getQualifiedName(sessionFactoryImplementor.getDialect(), sessionFactoryImplementor.getSettings().getDefaultCatalogName(), sessionFactoryImplementor.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
                    this.notNullColumnNames[n14] = this.subclassTableKeyColumnClosure[n15][0];
                }
            }
            catch (Exception exception) {
                throw new MappingException("Error parsing discriminator value", exception);
            }
            ++n14;
        }
        this.initLockers();
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(mapping);
    }

    protected boolean isSubclassTableSequentialSelect(int n) {
        return this.subclassTableSequentialSelect[n] && !this.isClassOrSuperclassTable[n];
    }

    public String getSubclassPropertyTableName(int n) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[n]];
    }

    public Type getDiscriminatorType() {
        return Hibernate.INTEGER;
    }

    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLString;
    }

    public String getSubclassForDiscriminatorValue(Object object) {
        return (String)this.subclassesByDiscriminatorValue.get(object);
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    protected String getTableName(int n) {
        return this.naturalOrderTableNames[n];
    }

    protected String[] getKeyColumns(int n) {
        return this.naturalOrderTableKeyColumns[n];
    }

    protected boolean isTableCascadeDeleteEnabled(int n) {
        return this.naturalOrderCascadeDeleteEnabled[n];
    }

    protected boolean isPropertyOfTable(int n, int n2) {
        return this.naturalOrderPropertyTableNumbers[n] == n2;
    }

    private static final void reverse(Object[] objectArray, int n) {
        int n2;
        Object[] objectArray2 = new Object[n];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray2[n2] = objectArray[n - n2 - 1];
        }
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = objectArray2[n2];
        }
    }

    private static final String[] reverse(String[] stringArray, int n) {
        int n2;
        int n3 = stringArray.length;
        String[] stringArray2 = new String[n3];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray2[n2] = stringArray[n - n2 - 1];
        }
        for (n2 = n; n2 < n3; ++n2) {
            stringArray2[n2] = stringArray[n2];
        }
        return stringArray2;
    }

    private static final String[][] reverse(String[][] stringArray, int n) {
        int n2;
        int n3 = stringArray.length;
        String[][] stringArray2 = new String[n3][];
        for (n2 = 0; n2 < n; ++n2) {
            stringArray2[n2] = stringArray[n - n2 - 1];
        }
        for (n2 = n; n2 < n3; ++n2) {
            stringArray2[n2] = stringArray[n2];
        }
        return stringArray2;
    }

    public String fromTableFragment(String string) {
        return this.getTableName() + ' ' + string;
    }

    public String getTableName() {
        return this.tableNames[0];
    }

    private static int getTableId(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        throw new AssertionFailure("Table " + string + " not found");
    }

    public void addDiscriminatorToSelect(SelectFragment selectFragment, String string, String string2) {
        if (this.hasSubclasses()) {
            selectFragment.setExtraSelectList(this.discriminatorFragment(string), this.getDiscriminatorAlias());
        }
    }

    private CaseFragment discriminatorFragment(String string) {
        CaseFragment caseFragment = this.getFactory().getDialect().createCaseFragment();
        for (int i = 0; i < this.discriminatorValues.length; ++i) {
            caseFragment.addWhenColumnNotNull(this.generateTableAlias(string, this.notNullColumnTableNumbers[i]), this.notNullColumnNames[i], this.discriminatorValues[i]);
        }
        return caseFragment;
    }

    public String filterFragment(String string) {
        return this.hasWhere() ? " and " + this.getSQLWhereString(this.generateFilterConditionAlias(string)) : "";
    }

    public String generateFilterConditionAlias(String string) {
        return this.generateTableAlias(string, this.tableSpan - 1);
    }

    public String[] getIdentifierColumnNames() {
        return this.tableKeyColumns[0];
    }

    public String[] getIdentifierColumnReaderTemplates() {
        return this.tableKeyColumnReaderTemplates[0];
    }

    public String[] getIdentifierColumnReaders() {
        return this.tableKeyColumnReaders[0];
    }

    public String[] toColumns(String string, String string2) throws QueryException {
        if ("class".equals(string2)) {
            return new String[]{this.discriminatorFragment(string).toFragmentString()};
        }
        return super.toColumns(string, string2);
    }

    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    protected int getSubclassPropertyTableNumber(int n) {
        return this.subclassPropertyTableNumberClosure[n];
    }

    public int getTableSpan() {
        return this.tableSpan;
    }

    public boolean isMultiTable() {
        return true;
    }

    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    protected int[] getPropertyTableNumbers() {
        return this.naturalOrderPropertyTableNumbers;
    }

    protected String[] getSubclassTableKeyColumns(int n) {
        return this.subclassTableKeyColumnClosure[n];
    }

    public String getSubclassTableName(int n) {
        return this.subclassTableNameClosure[n];
    }

    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    protected boolean isSubclassTableLazy(int n) {
        return this.subclassTableIsLazyClosure[n];
    }

    protected boolean isClassOrSuperclassTable(int n) {
        return this.isClassOrSuperclassTable[n];
    }

    public String getPropertyTableName(String string) {
        Integer n = this.getEntityMetamodel().getPropertyIndexOrNull(string);
        if (n == null) {
            return null;
        }
        return this.tableNames[this.propertyTableNumbers[n]];
    }

    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    public String getRootTableName() {
        return this.naturalOrderTableNames[0];
    }

    public String getRootTableAlias(String string) {
        return this.generateTableAlias(string, JoinedSubclassEntityPersister.getTableId(this.getRootTableName(), this.tableNames));
    }

    public Queryable.Declarer getSubclassPropertyDeclarer(String string) {
        if ("class".equals(string)) {
            return Queryable.Declarer.SUBCLASS;
        }
        return super.getSubclassPropertyDeclarer(string);
    }
}

