/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private final String queryName;
    private final EntityPersister persister;
    private static final Logger log = LoggerFactory.getLogger(NamedQueryLoader.class);

    public NamedQueryLoader(String string, EntityPersister entityPersister) {
        this.queryName = string;
        this.persister = entityPersister;
    }

    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor, LockOptions lockOptions) {
        if (lockOptions != null) {
            log.debug("Ignoring lock-options passed to named query loader");
        }
        return this.load(serializable, object, sessionImplementor);
    }

    public Object load(Serializable serializable, Object object, SessionImplementor sessionImplementor) {
        AbstractQueryImpl abstractQueryImpl;
        if (log.isDebugEnabled()) {
            log.debug("loading entity: " + this.persister.getEntityName() + " using named query: " + this.queryName);
        }
        if ((abstractQueryImpl = (AbstractQueryImpl)sessionImplementor.getNamedQuery(this.queryName)).hasNamedParameters()) {
            abstractQueryImpl.setParameter(abstractQueryImpl.getNamedParameters()[0], (Object)serializable, this.persister.getIdentifierType());
        } else {
            abstractQueryImpl.setParameter(0, (Object)serializable, this.persister.getIdentifierType());
        }
        abstractQueryImpl.setOptionalId(serializable);
        abstractQueryImpl.setOptionalEntityName(this.persister.getEntityName());
        abstractQueryImpl.setOptionalObject(object);
        abstractQueryImpl.setFlushMode(FlushMode.MANUAL);
        abstractQueryImpl.list();
        return sessionImplementor.getPersistenceContext().getEntity(new EntityKey(serializable, this.persister, sessionImplementor.getEntityMode()));
    }
}

