/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.io.Serializable;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public final class MessageHelper {
    private MessageHelper() {
    }

    public static String infoString(String string, Serializable serializable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (string == null) {
            stringBuffer.append("<null entity name>");
        } else {
            stringBuffer.append(string);
        }
        stringBuffer.append('#');
        if (serializable == null) {
            stringBuffer.append("<null>");
        } else {
            stringBuffer.append(serializable);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String infoString(EntityPersister entityPersister, Object object, SessionFactoryImplementor sessionFactoryImplementor) {
        Type type;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (entityPersister == null) {
            stringBuffer.append("<null EntityPersister>");
            type = null;
        } else {
            stringBuffer.append(entityPersister.getEntityName());
            type = entityPersister.getIdentifierType();
        }
        stringBuffer.append('#');
        if (object == null) {
            stringBuffer.append("<null>");
        } else if (type == null) {
            stringBuffer.append(object);
        } else {
            stringBuffer.append(type.toLoggableString(object, sessionFactoryImplementor));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String infoString(EntityPersister entityPersister, Object object, Type type, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (entityPersister == null) {
            stringBuffer.append("<null EntityPersister>");
        } else {
            stringBuffer.append(entityPersister.getEntityName());
        }
        stringBuffer.append('#');
        if (object == null) {
            stringBuffer.append("<null>");
        } else {
            stringBuffer.append(type.toLoggableString(object, sessionFactoryImplementor));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String infoString(EntityPersister entityPersister, Serializable[] serializableArray, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (entityPersister == null) {
            stringBuffer.append("<null EntityPersister>");
        } else {
            stringBuffer.append(entityPersister.getEntityName());
            stringBuffer.append("#<");
            for (int i = 0; i < serializableArray.length; ++i) {
                stringBuffer.append(entityPersister.getIdentifierType().toLoggableString(serializableArray[i], sessionFactoryImplementor));
                if (i >= serializableArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append('>');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String infoString(EntityPersister entityPersister) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (entityPersister == null) {
            stringBuffer.append("<null EntityPersister>");
        } else {
            stringBuffer.append(entityPersister.getEntityName());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String infoString(String string, String string2, Object object) {
        StringBuffer stringBuffer = new StringBuffer().append('[').append(string).append('.').append(string2).append('#');
        if (object == null) {
            stringBuffer.append("<null>");
        } else {
            stringBuffer.append(object);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String collectionInfoString(CollectionPersister collectionPersister, Serializable[] serializableArray, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (collectionPersister == null) {
            stringBuffer.append("<unreferenced>");
        } else {
            stringBuffer.append(collectionPersister.getRole());
            stringBuffer.append("#<");
            for (int i = 0; i < serializableArray.length; ++i) {
                stringBuffer.append(collectionPersister.getOwnerEntityPersister().getIdentifierType().toLoggableString(serializableArray[i], sessionFactoryImplementor));
                if (i >= serializableArray.length - 1) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append('>');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String collectionInfoString(CollectionPersister collectionPersister, Serializable serializable, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (collectionPersister == null) {
            stringBuffer.append("<unreferenced>");
        } else {
            stringBuffer.append(collectionPersister.getRole());
            stringBuffer.append('#');
            if (serializable == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append(collectionPersister.getOwnerEntityPersister().getIdentifierType().toLoggableString(serializable, sessionFactoryImplementor));
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String collectionInfoString(String string, Serializable serializable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        if (string == null) {
            stringBuffer.append("<unreferenced>");
        } else {
            stringBuffer.append(string);
            stringBuffer.append('#');
            if (serializable == null) {
                stringBuffer.append("<null>");
            } else {
                stringBuffer.append(serializable);
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

